<?php

/* Store registered sidebars so we can get them before wp_registered_sidebars is initialized to use them in theme options */

add_action( 'admin_init', 'herald_check_sidebars' );

if ( !function_exists( 'herald_check_sidebars' ) ):
	function herald_check_sidebars() {
		global $wp_registered_sidebars;
		if ( !empty( $wp_registered_sidebars ) ) {
			update_option( 'herald_registered_sidebars', $wp_registered_sidebars );
		}
	}
endif;


/* Change customize link to lead to theme options instead of live customizer */

add_filter( 'wp_prepare_themes_for_js', 'herald_change_customize_link' );

if ( !function_exists( 'herald_change_customize_link' ) ):
	function herald_change_customize_link( $themes ) {
		if ( array_key_exists( 'herald', $themes ) ) {
			$themes['herald']['actions']['customize'] = admin_url( 'admin.php?page=herald_options' );
		}
		return $themes;
	}
endif;


/* Change default arguments of flickr widget plugin */

add_filter( 'mks_flickr_widget_modify_defaults', 'herald_flickr_widget_defaults' );

if ( !function_exists( 'herald_flickr_widget_defaults' ) ):
	function herald_flickr_widget_defaults( $defaults ) {

		$defaults['t_width'] = 93;
		$defaults['t_height'] = 93;
		return $defaults;
	}
endif;


/* Change default arguments of author widget plugin */

add_filter( 'mks_author_widget_modify_defaults', 'herald_author_widget_defaults' );

if ( !function_exists( 'herald_author_widget_defaults' ) ):
	function herald_author_widget_defaults( $defaults ) {
		$defaults['avatar_size'] = 80;
		return $defaults;
	}
endif;


/* Change default arguments of social widget plugin */

add_filter( 'mks_social_widget_modify_defaults', 'herald_social_widget_defaults' );

if ( !function_exists( 'herald_social_widget_defaults' ) ):
	function herald_social_widget_defaults( $defaults ) {
		$defaults['size'] = 44;
		$defaults['style'] = 'circle';
		return $defaults;
	}
endif;


/* Show admin notices */

add_action( 'admin_init', 'herald_check_installation' );

if ( !function_exists( 'herald_check_installation' ) ):
	function herald_check_installation() {
		add_action( 'admin_notices', 'herald_welcome_msg', 1 );
		add_action( 'admin_notices', 'herald_update_msg', 1 );
		add_action( 'admin_notices', 'herald_required_plugins_msg', 1 );
	}
endif;


/* Show welcome message and quick tips after theme activation */
if ( !function_exists( 'herald_welcome_msg' ) ):
	function herald_welcome_msg() {

		if ( get_option( 'herald_welcome_box_displayed' ) || get_option( 'merlin_herald_completed' ) ) {
			return false;
		}
		
		update_option( 'herald_theme_version', HERALD_THEME_VERSION );
		include_once get_parent_theme_file_path( '/core/admin/welcome-panel.php' );

	}
endif;


/* Show message box after theme update */
if ( !function_exists( 'herald_update_msg' ) ):
	function herald_update_msg() {
		
		if ( !get_option( 'herald_welcome_box_displayed' ) && !get_option( 'merlin_herald_completed' ) ) {
			return false;
		}

		$prev_version = get_option( 'herald_theme_version' );
		$cur_version = HERALD_THEME_VERSION;
		if ( $prev_version === false ) { $prev_version = '0.0.0'; }
		
		if ( version_compare( $cur_version, $prev_version, '>' ) ) {
				include_once get_parent_theme_file_path( '/core/admin/update-panel.php' );
		}	
	}
endif;



/**
 * Display message if required plugins are not installed and activated
 *
 * @since  1.0
 */

if ( !function_exists( 'herald_required_plugins_msg' ) ):
	function herald_required_plugins_msg() {

		if ( !get_option( 'herald_welcome_box_displayed' ) && !get_option( 'merlin_herald_completed' ) ) {
			return false;
		}

		if ( !herald_is_redux_active() ) {
			$class = 'notice notice-error';
			$message = wp_kses_post( sprintf( __( 'Important: Redux Framework plugin is required to run your theme options panel. Please visit <a href="%s">recommended plugins page</a> to install it.', 'herald' ), admin_url( 'admin.php?page=install-required-plugins' ) ) );
			printf( '<div class="%1$s"><p>%2$s</p></div>', $class, $message );
		}

	}
endif;


/* White label WP Review plugin - remove banner from options */

add_filter( 'wp_review_remove_branding', '__return_true' );


/* Remove WP review for pages */

add_filter( 'wp_review_excluded_post_types', 'herald_wp_review_exclude_post_types' );

if ( !function_exists( 'herald_wp_review_exclude_post_types' ) ):
	function herald_wp_review_exclude_post_types( $excluded ) {
	  $excluded[] = 'page';
	  return $excluded;
	}
endif; 

/* Remove WP review notice */

remove_action('admin_notices', 'wp_review_admin_notice');


/* Remove WP review jQuery UI from admin pages */

add_action('admin_enqueue_scripts', 'herald_wp_review_exclude_admin_scripts', 99 );

if ( !function_exists( 'herald_wp_review_exclude_admin_scripts' ) ):
	function herald_wp_review_exclude_admin_scripts() {

		if( herald_is_wp_review_active() ) {
		 	wp_dequeue_style( 'plugin_name-admin-ui-css' );
		 	wp_dequeue_style( 'wp-review-admin-ui-css' );
		}
		
		wp_dequeue_style( 'jquery-ui.js' );

	}
endif;


/**
 * Check for Additional CSS in Theme Options and transfer it to Customize -> Additional CSS
 *
 * @return void
 * @since  1.0.5
 */
add_action('admin_init','herald_patch_additional_css');

if ( !function_exists( 'herald_patch_additional_css' ) ) :
	function herald_patch_additional_css() {

		$additional_css = herald_get_option( 'additional_css' );

		if ( empty( $additional_css ) ) {
			return false;
		}
		
		global $herald_settings;

		$herald_settings = get_option( 'herald_settings' ); 

		$herald_settings['additional_css'] = '';

		update_option( 'herald_settings', $herald_settings ) ;

		$customize_css = wp_get_custom_css_post();
		
		if ( !empty( $customize_css ) && !is_wp_error( $customize_css ) ) {
			$additional_css .= $customize_css->post_content;
		}

		wp_update_custom_css_post($additional_css);
	}
endif;

/**
 * Filter for social share option fields
 *
 * @param array $args - Array of default fields
 * @return array
 * @since  2.1.4
 */
add_filter( 'meks_ess_modify_options_fields', 'herald_social_share_option_fields_filter' );

if ( !function_exists( 'herald_social_share_option_fields_filter' ) ):
	function herald_social_share_option_fields_filter( $args ) {
		
		unset( $args['style'] );
		unset( $args['variant'] );
		unset( $args['color'] );
		unset( $args['location'] );
		unset( $args['post_type'] );
		unset( $args['label_share'] );

		return $args;
	}
endif;

/**
 * Patching for social share platforms for meks easy share plugin
 *
 * @return void
 * @since  2.1.4
 */
add_action('admin_init','herald_patch_social_share_platforms');

if ( !function_exists( 'herald_patch_social_share_platforms' ) ) :
	function herald_patch_social_share_platforms() {

		$social_platforms = herald_get_option( 'social_share' );

		if ( empty( $social_platforms ) ) {
			return false;
		}
		
		global $herald_settings;
		$herald_settings = get_option( 'herald_settings' ); 

		$herald_settings['social_share'] = '';
		update_option( 'herald_settings', $herald_settings ) ;
		
		$new_platforms = array();

		foreach ( $social_platforms as $platform => $value ) {
			if ( $value == '1' ) {
				$new_platforms['platforms'][] = $platform;
			}
		}

		update_option( 'meks_ess_settings', $new_platforms );

	}
endif;


/**
 * Add Meks dashboard widget
 *
 * @since  1.0
 */

add_action( 'wp_dashboard_setup', 'herald_add_dashboard_widgets' );

if ( !function_exists( 'herald_add_dashboard_widgets' ) ):
	function herald_add_dashboard_widgets() {
		add_meta_box( 'herald_dashboard_widget', 'Meks - WordPress Themes & Plugins', 'herald_dashboard_widget_cb', 'dashboard', 'side', 'high' );
	}
endif;


/**
 * Meks dashboard widget
 *
 * @since  1.0
 */
if ( !function_exists( 'herald_dashboard_widget_cb' ) ):
	function herald_dashboard_widget_cb() {

		$transient = 'herald_mksaw';
		$hide = '<style>#herald_dashboard_widget{display:none;}</style>';

		$data = get_transient( $transient );
	
		if ( $data == 'error' ) {
			echo $hide;
			return;
		}

		if ( !empty( $data ) ) {
			echo $data;
			return;
		}

		$url = 'https://demo.mekshq.com/mksaw.php';
		$args = array( 'body' => array( 'key' => md5( 'meks' ), 'theme' => 'herald' ) );
		$response = wp_remote_post( $url, $args );

		if ( is_wp_error( $response ) ) {
			set_transient( $transient, 'error', DAY_IN_SECONDS );
			echo $hide;
			return;
		}

		$json = wp_remote_retrieve_body( $response );

		if ( empty( $json ) ) {
			set_transient( $transient, 'error', DAY_IN_SECONDS );
			echo $hide;
			return;
		}

		$json = json_decode( $json );

		if ( !isset( $json->data ) ) {
			set_transient( $transient, 'error', DAY_IN_SECONDS );
			echo $hide;
			return;
		} 

		set_transient( $transient, $json->data, DAY_IN_SECONDS );
		echo $json->data;
		
	}
endif;

?>