<?php

/* Load admin scripts and styles */
add_action( 'admin_enqueue_scripts', 'herald_load_admin_scripts' );

/**
 * Load scripts and styles in admin
 *
 * It just wrapps two other separate functions for loading css and js files in admin
 *
 * @return void
 * @since  1.0
 */

function herald_load_admin_scripts() {
	herald_load_admin_css();
	herald_load_admin_js();
}


/**
 * Load admin css files
 *
 * @return void
 * @since  1.0
 */

function herald_load_admin_css() {

	global $pagenow, $typenow;


	//Load color picker for categories
	if ( in_array( $pagenow, array( 'edit-tags.php', 'term.php' ) ) && isset( $_GET['taxonomy'] ) && $_GET['taxonomy'] == 'category' ) {
		wp_enqueue_style( 'wp-color-picker' );
	}

	if ( $typenow == 'page' && ( $pagenow == 'post.php' || $pagenow == 'post-new.php' ) ) {
		wp_enqueue_style ( 'wp-jquery-ui-dialog' );
	}

	//Load small admin style tweaks
	wp_enqueue_style( 'herald-admin', get_parent_theme_file_uri( '/assets/css/admin/global.css' ), false, HERALD_THEME_VERSION, 'screen, print' );
}


/**
 * Load admin js files
 *
 * @return void
 * @since  1.0
 */

function herald_load_admin_js() {
	
	//Load global js
	wp_enqueue_script( 'herald-global', get_parent_theme_file_uri( '/assets/js/admin/global.js' ), array( 'jquery' ), HERALD_THEME_VERSION );
	
	global $pagenow, $typenow;

	//Load category js
	if ( in_array( $pagenow, array( 'edit-tags.php', 'term.php' ) ) && isset( $_GET['taxonomy'] ) && $_GET['taxonomy'] == 'category' ) {
		wp_enqueue_media();
		wp_enqueue_script( 'herald-category', get_parent_theme_file_uri( '/assets/js/admin/metaboxes-category.js' ), array( 'jquery', 'wp-color-picker' ), HERALD_THEME_VERSION );
	}

	//Load post & page js
	if ( $pagenow == 'post.php' || $pagenow == 'post-new.php' ) {
		if ( $typenow == 'post' ) {
			wp_enqueue_script( 'herald-post', get_parent_theme_file_uri( '/assets/js/admin/metaboxes-post.js' ), array( 'jquery' ), HERALD_THEME_VERSION );
		} elseif ( $typenow == 'page' ) {
			wp_enqueue_script( 'herald-page', get_parent_theme_file_uri( '/assets/js/admin/metaboxes-page.js' ), array( 'jquery', 'jquery-ui-dialog', 'jquery-ui-sortable', 'jquery-ui-autocomplete' ), HERALD_THEME_VERSION );
			wp_localize_script( 'herald-page', 'herald_js_settings', herald_get_admin_js_settings() );
		}
	}
}


/**
 * Load editor styles
 *
 * @since  1.0
 */

function herald_load_editor_styles() {

	if ( $fonts_link = herald_generate_fonts_link() ) {
		add_editor_style( $fonts_link );
	}

	add_editor_style( get_parent_theme_file_uri( '/assets/css/admin/editor-style.css' ) );

}

/**
 * Load dynamic editor styles
 *
 * @since  1.0
 */

add_action( 'enqueue_block_editor_assets', 'herald_block_editor_styles', 99 );

function herald_block_editor_styles() {
	
	wp_register_style( 'herald-editor-styles', false, HERALD_THEME_VERSION );

	wp_enqueue_style( 'herald-editor-styles');
	wp_add_inline_style( 'herald-editor-styles', herald_generate_dynamic_editor_css() );

}

?>