<?php

require_once get_parent_theme_file_path( '/inc/merlin/vendor/autoload.php' );
require_once get_parent_theme_file_path( '/inc/merlin/class-merlin.php' );

/**
 * Merlin WP configuration file.
 */

if ( ! class_exists( 'Merlin' ) ) {
	return;
}

$strings = array(
	'admin-menu'               => esc_html__( 'Herald Setup Wizard', 'herald' ),
	'title%s%s%s%s'            => esc_html__( '%s%s Themes &lsaquo; Theme Setup: %s%s', 'herald' ),
	'return-to-dashboard' 	   => esc_html__( 'Return to the dashboard', 'herald' ),
	'ignore'                   => esc_html__( 'Disable this wizard', 'herald' ),
	
	'btn-skip'                  => esc_html__( 'Skip', 'herald' ),
	'btn-next'                  => esc_html__( 'Next', 'herald' ),
	'btn-start'                 => esc_html__( 'Start', 'herald' ),
	'btn-no'                    => esc_html__( 'Cancel', 'herald' ),
	'btn-plugins-install'       => esc_html__( 'Install', 'herald' ),

	'btn-child-install'         => esc_html__( 'Install', 'herald' ),
	'btn-content-install'       => esc_html__( 'Install', 'herald' ),
	'btn-import'                => esc_html__( 'Import', 'herald' ),
	'btn-license-activate'     => esc_html__( 'Activate', 'herald' ),
	'btn-license-skip'         => esc_html__( 'Later', 'herald' ),
	
	'welcome-header%s'         => esc_html__( 'Welcome to %s', 'herald' ),
	'welcome-header-success%s' => esc_html__( 'Hi. Welcome back', 'herald' ),
	'welcome%s'                => esc_html__( 'This wizard will set up your theme, install plugins, and import content. It is optional & should take only a few minutes.', 'herald' ),
	'welcome-success%s'        => esc_html__( 'You may have already run this theme setup wizard. If you would like to proceed anyway, click on the "Start" button below.', 'herald' ),
	
	'license-header%s'         => esc_html__( 'Activate %s', 'herald' ),
	'license-header-success%s' => esc_html__( '%s is Activated', 'herald' ),
	'license%s'                => esc_html__( 'Enter your license key to enable remote updates and theme support.', 'herald' ),
	'license-label'            => esc_html__( 'License key', 'herald' ),
	'license-success%s'        => esc_html__( 'The theme is already registered, so you can go to the next step!', 'herald' ),
	'license-json-success%s'   => esc_html__( 'Your theme is activated! Remote updates and theme support are enabled.', 'herald' ),
	'license-tooltip'          => esc_html__( 'Need help?', 'herald' ),
	
	'child-header'         => esc_html__( 'Install Child Theme', 'herald' ),
	'child-header-success' => esc_html__( 'You\'re good to go!', 'herald' ),
	'child'                => esc_html__( 'Let\'s build & activate a child theme so you may easily make theme changes.', 'herald' ),
	'child-success%s'      => esc_html__( 'Your child theme has already been installed and is now activated, if it wasn\'t already.', 'herald' ),
	'child-action-link'    => esc_html__( 'Learn about child themes', 'herald' ),
	'child-json-success%s' => esc_html__( 'Awesome. Your child theme has already been installed and is now activated.', 'herald' ),
	'child-json-already%s' => esc_html__( 'Awesome. Your child theme has been created and is now activated.', 'herald' ),
	
	'plugins-header'         => esc_html__( 'Install Plugins', 'herald' ),
	'plugins-header-success' => esc_html__( 'You\'re up to speed!', 'herald' ),
	'plugins'                => esc_html__( 'Let\'s install some essential WordPress plugins to get your site up to speed.', 'herald' ),
	'plugins-success%s'      => esc_html__( 'The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.', 'herald' ),
	'plugins-action-link'    => esc_html__( 'Plugins', 'herald' ),
	
	'import-header'      => esc_html__( 'Import Content', 'herald' ),
	'import'             => esc_html__( 'Let\'s import content to your website, to help you get familiar with the theme.', 'herald' ),
	'import-action-link' => esc_html__( 'Details', 'herald' ),
	
	'ready-header'      => esc_html__( 'All done. Have fun!', 'herald' ),
	'ready%s'           => esc_html__( 'Your theme has been all set up. Enjoy your new theme by %s.', 'herald' ),
	'ready-action-link' => esc_html__( 'Extras', 'herald' ),
	'ready-big-button'  => esc_html__( 'View your website', 'herald' ),
	
	'ready-link-3' => '',
	'ready-link-2' => wp_kses( sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://mekshq.com/documentation/herald/', esc_html__( 'Theme Documentation', 'herald' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) ),
);

if(herald_is_redux_active()){
	$strings['ready-link-1'] = wp_kses( sprintf( '<a href="'.admin_url( 'admin.php?page=herald_options' ).'" target="_blank">%s</a>', esc_html__( 'Start Customizing', 'herald' ) ), array( 'a' => array( 'href' => array(), 'target' => array() ) ) );
}

/**
 * Set directory locations, text strings, and other settings for Merlin WP.
 *
 * @since 1.0
 */
$herald_wizard = new Merlin(

	// Configure Merlin with custom settings.
	$config = array(
		'directory'            => 'inc/merlin', // Location / directory where Merlin WP is placed in your theme.
		'merlin_url'           => 'herald-importer', // The wp-admin page slug where Merlin WP loads.
		'parent_slug'          => 'themes.php', // The wp-admin parent page slug for the admin menu item.
		'capability'           => 'manage_options', // The capability required for this menu to be displayed to the user.
		'child_action_btn_url' => 'https://codex.wordpress.org/child_themes', // URL for the 'child-action-link'.
		'dev_mode'             => false, // Enable development mode for testing.
		'license_step'         => false, // EDD license activation step.
		'license_required'     => false, // Require the license activation step.
		'license_help_url'     => '', // URL for the 'license-tooltip'.
		'edd_remote_api_url'   => '', // EDD_Theme_Updater_Admin remote_api_url.
		'edd_item_name'        => '', // EDD_Theme_Updater_Admin item_name.
		'edd_theme_slug'       => '', // EDD_Theme_Updater_Admin item_slug.
		'ready_big_button_url' => get_home_url(), // Link for the big button on the ready step.
	),

	// Text strings.
	$strings

);


/**
 * Prepare files to import
 *
 * @since 1.0
 */
add_filter( 'merlin_import_files', 'herald_demo_import_files' );

if(!function_exists('herald_demo_import_files')):
	function herald_demo_import_files() {
			return array(
				array(
					'import_file_name'         => 'Herald default',
					'local_import_file'        => get_parent_theme_file_path( '/inc/demos/01_default/content.xml' ),
					'local_import_widget_file' => get_parent_theme_file_path( '/inc/demos/01_default/widgets.json' ),
					'local_import_redux' => array(
						array(
							'file_path'    => get_parent_theme_file_path( '/inc/demos/01_default/options.json' ),
							'option_name' => 'herald_settings',
						)
					),
					'import_preview_image_url' => get_parent_theme_file_uri( '/screenshot.png' ),
					'import_notice'            => '',
					'preview_url'              => 'https://demo.mekshq.com/herald/',
                ),
                array(
					'import_file_name'         => 'Herald essence',
					'local_import_file'        => get_parent_theme_file_path( '/inc/demos/02_essence/content.xml' ),
					'local_import_widget_file' => get_parent_theme_file_path( '/inc/demos/02_essence/widgets.json' ),
					'local_import_redux' => array(
						array(
							'file_path'    => get_parent_theme_file_path( '/inc/demos/02_essence/options.json' ),
							'option_name' => 'herald_settings',
						)
					),
					'import_preview_image_url' => get_parent_theme_file_uri( '/screenshot.png' ),
					'import_notice'            => '',
					'preview_url'              => 'https://demo.mekshq.com/herald/',
                ),
                array(
					'import_file_name'         => 'Herald fashion',
					'local_import_file'        => get_parent_theme_file_path( '/inc/demos/03_fashion/content.xml' ),
					'local_import_widget_file' => get_parent_theme_file_path( '/inc/demos/03_fashion/widgets.json' ),
					'local_import_redux' => array(
						array(
							'file_path'    => get_parent_theme_file_path( '/inc/demos/03_fashion/options.json' ),
							'option_name' => 'herald_settings',
						)
					),
					'import_preview_image_url' => get_parent_theme_file_uri( '/screenshot.png' ),
					'import_notice'            => '',
					'preview_url'              => 'https://demo.mekshq.com/herald/',
                ),
                array(
					'import_file_name'         => 'Herald sports',
					'local_import_file'        => get_parent_theme_file_path( '/inc/demos/04_sports/content.xml' ),
					'local_import_widget_file' => get_parent_theme_file_path( '/inc/demos/04_sports/widgets.json' ),
					'local_import_redux' => array(
						array(
							'file_path'    => get_parent_theme_file_path( '/inc/demos/04_sports/options.json' ),
							'option_name' => 'herald_settings',
						)
					),
					'import_preview_image_url' => get_parent_theme_file_uri( '/screenshot.png' ),
					'import_notice'            => '',
					'preview_url'              => 'https://demo.mekshq.com/herald/',
                ),
                array(
					'import_file_name'         => 'Herald tech',
					'local_import_file'        => get_parent_theme_file_path( '/inc/demos/05_tech/content.xml' ),
					'local_import_widget_file' => get_parent_theme_file_path( '/inc/demos/05_tech/widgets.json' ),
					'local_import_redux' => array(
						array(
							'file_path'    => get_parent_theme_file_path( '/inc/demos/05_tech/options.json' ),
							'option_name' => 'herald_settings',
						)
					),
					'import_preview_image_url' => get_parent_theme_file_uri( '/screenshot.png' ),
					'import_notice'            => '',
					'preview_url'              => 'https://demo.mekshq.com/herald/',
                ),
                array(
					'import_file_name'         => 'Herald blog',
					'local_import_file'        => get_parent_theme_file_path( '/inc/demos/06_blog/content.xml' ),
					'local_import_widget_file' => get_parent_theme_file_path( '/inc/demos/06_blog/widgets.json' ),
					'local_import_redux' => array(
						array(
							'file_path'    => get_parent_theme_file_path( '/inc/demos/06_blog/options.json' ),
							'option_name' => 'herald_settings',
						)
					),
					'import_preview_image_url' => get_parent_theme_file_uri( '/screenshot.png' ),
					'import_notice'            => '',
					'preview_url'              => 'https://demo.mekshq.com/herald/',
                ),

			);
	}
endif;

/**
 * Execute custom code after the whole import has finished.
 *
 * @since 1.0
 */
add_action( 'merlin_after_all_import', 'herald_merlin_after_import_setup' );

if( !function_exists('herald_merlin_after_import_setup') ):
	function herald_merlin_after_import_setup( ) {
		
        /* Set Menus */

        $menus = array();

        $main_menu = get_term_by( 'name', 'Herald Main', 'nav_menu' );
        if ( isset( $main_menu->term_id ) ) {
            $menus['herald_main_menu'] = $main_menu->term_id;
        }

        $social_menu = get_term_by( 'name', 'Herald Social', 'nav_menu' );
        if ( isset( $social_menu->term_id ) ) {
            $menus['herald_social_menu'] = $social_menu->term_id;
        }

        $secondary_menu = get_term_by( 'name', 'Herald Secondary 1', 'nav_menu' );
        if ( isset( $secondary_menu->term_id ) ) {
            $menus['herald_secondary_menu_1'] = $secondary_menu->term_id;
        }

        if ( !empty( $menus ) ) {
            set_theme_mod( 'nav_menu_locations', $menus );
        }

        /* Set Home Page */

        $home_page_title = 'Herald Home';

        $page = get_page_by_title( $home_page_title );

        if ( isset( $page->ID ) ) {
            update_option( 'page_on_front', $page->ID );
            update_option( 'show_on_front', 'page' );
        }

	}

endif;

/**
 * Unset the default widgets
 *
 * @return array
 * @since 1.0
 */

add_action('merlin_widget_importer_before_widgets_import', 'herald_remove_widgets_before_import');

if(!function_exists('herald_remove_widgets_before_import')):
	function herald_remove_widgets_before_import() {
		delete_option( 'sidebars_widgets' );	
	}
endif;

/**
 * Unset the child theme generator step in merlin welcome panel
 *
 * @param $steps
 * @return mixed
 * @since 1.0
 */

add_filter('herald_merlin_steps', 'herald_remove_child_theme_generator_from_merlin');

if(!function_exists('herald_remove_child_theme_generator_from_merlin')):
    function herald_remove_child_theme_generator_from_merlin($steps){
        unset($steps['child']);
        return $steps;
    }
endif;


/**
 * Stop initial redirect after theme is activated
 *
 * @since 1.0
 */

remove_action( 'after_switch_theme', array( $herald_wizard, 'switch_theme' ) );
?>