<?php 

/* Font styles */
$main_font = herald_get_font_option( 'main_font' );
$h_font = herald_get_font_option( 'h_font' );


/* Font sizes */
$font_size_p = absint( herald_get_option( 'font_size_p' ) );
$font_size_excerpt_text = absint( herald_get_option( 'font_size_excerpt_text' ) );
$font_size_meta_data_smaller = absint( herald_get_option( 'font_size_meta_data_smaller' ) );
$font_size_meta_data_bigger = absint( herald_get_option( 'font_size_meta_data_bigger' ) );
$font_size_h1 = absint( herald_get_option( 'font_size_h1' ) );
$font_size_h2 = absint( herald_get_option( 'font_size_h2' ) );
$font_size_h3 = absint( herald_get_option( 'font_size_h3' ) );
$font_size_h4 = absint( herald_get_option( 'font_size_h4' ) );
$font_size_h5 = absint( herald_get_option( 'font_size_h5' ) );
$font_size_h6 = absint( herald_get_option( 'font_size_h6' ) );
$font_size_h7 = absint( herald_get_option( 'font_size_h7' ) );
$font_size_small = absint( herald_get_option( 'font_size_small' ) );

/* General styles */
$body_background = herald_get_bg_option('body_background');
$content_layout = herald_get_option('content_layout');
$color_content_bg = esc_attr(herald_get_option( 'color_content_bg' ));
$color_content_title = esc_attr(herald_get_option( 'color_content_title' ));
$color_content_txt = esc_attr(herald_get_option( 'color_content_txt' ));
$color_content_acc = esc_attr(herald_get_option( 'color_content_acc' ));
$color_content_meta = esc_attr(herald_get_option( 'color_content_meta' ));


?>

/* Font sizes */
.editor-styles-wrapper h1,
.editor-styles-wrapper.edit-post-visual-editor .editor-post-title__block .editor-post-title__input{ 
    font-size: <?php echo esc_attr( $font_size_h1 ); ?>px; 
}
.editor-styles-wrapper h2{ font-size: <?php echo esc_attr( $font_size_h2 ); ?>px; }
.editor-styles-wrapper h3{ font-size: <?php echo esc_attr( $font_size_h3 ); ?>px; }
.editor-styles-wrapper h4{ font-size: <?php echo esc_attr( $font_size_h4 ); ?>px; }
.editor-styles-wrapper h5{ font-size: <?php echo esc_attr( $font_size_h5 ); ?>px; }
.editor-styles-wrapper h6{ font-size: <?php echo esc_attr( $font_size_h6 ); ?>px; }

.edit-post-visual-editor.editor-styles-wrapper{
    font-size: <?php echo esc_attr( $font_size_p ); ?>px;
}
.edit-post-visual-editor.editor-styles-wrapper {
    background-color: <?php echo esc_attr( $color_content_bg ); ?>;
    color: <?php echo esc_attr( $color_content_txt ); ?>;
    font-family: <?php echo wp_kses_post( $main_font['font-family'] ); ?>;
    font-weight: <?php echo esc_attr( $main_font['font-weight'] ); ?>;
    <?php if ( isset( $main_font['font-style'] ) && !empty( $main_font['font-style'] ) ):?>
    font-style: <?php echo esc_attr( $main_font['font-style'] ); ?>;
    <?php endif; ?>
}


/* Typography styles */

.editor-styles-wrapper h1, 
.editor-styles-wrapper.edit-post-visual-editor .editor-post-title__block .editor-post-title__input,
.editor-styles-wrapper h2, 
.editor-styles-wrapper h3, 
.editor-styles-wrapper h4,
.editor-styles-wrapper h5,
.editor-styles-wrapper h6,
.wp-block-cover .wp-block-cover-image-text, .wp-block-cover .wp-block-cover-text, 
.wp-block-cover h2, .wp-block-cover-image .wp-block-cover-image-text, 
.wp-block-cover-image .wp-block-cover-text, .wp-block-cover-image h2{
  font-family: <?php echo wp_kses_post( $h_font['font-family'] ); ?>;
  font-weight: <?php echo esc_attr( $h_font['font-weight'] ) ?>;
  <?php if ( isset( $h_font['font-style'] ) && !empty( $h_font['font-style'] ) ):?>
  font-style: <?php echo esc_attr( $h_font['font-style'] ) ?>;
  <?php endif; ?>
}
pre {
	background: <?php echo herald_hex2rgba( $color_content_txt , 0.06); ?>;
	border: 1px solid <?php echo herald_hex2rgba( $color_content_txt , 0.2); ?>;
}
thead {
    background: <?php echo herald_hex2rgba( $color_content_txt , 0.06); ?>;
}

/* General styles */
a{
	color: <?php echo esc_attr( $color_content_acc ); ?>;
}
.editor-styles-wrapper h1, 
.editor-styles-wrapper.edit-post-visual-editor .editor-post-title__block .editor-post-title__input,
.editor-styles-wrapper h2, 
.editor-styles-wrapper h3, 
.editor-styles-wrapper h4,
.editor-styles-wrapper h5,
.editor-styles-wrapper h6,
.entry-title a {
	color: <?php echo esc_attr( $color_content_title ); ?>;
}

.wp-block-button__link,
.wp-block-search__button{
	background: <?php echo esc_attr( $color_content_acc ); ?>;
}
.wp-block-search__button{
	color: <?php echo esc_attr( $color_content_bg ); ?>;	
}
/* Table */

.editor-styles-wrapper .wp-block table.wp-block-table{
	border-color: <?php echo herald_hex2rgba($color_content_txt, 0.2); ?>;
}
.editor-styles-wrapper .wp-block-table:not(.is-style-stripes) td, 
.editor-styles-wrapper .wp-block-table:not(.is-style-stripes) th,
.wp-block-calendar tbody td,
.wp-block-calendar th,
.editor-styles-wrapper .wp-block-table:not(.is-style-stripes),
.wp-block-calendar .wp-block-calendar tr{
	border: 1px solid <?php echo herald_hex2rgba($color_content_txt, 0.1); ?>;
}

/* Blockquote */
.editor-styles-wrapper .wp-block-quote p{
    color: <?php echo esc_attr( $color_content_acc ); ?>;
}
.editor-styles-wrapper .wp-block-pullquote {
    border-top: 2px solid <?php echo esc_attr( $color_content_txt ); ?>;
    border-bottom: 2px solid <?php echo esc_attr( $color_content_txt ); ?>;
    color: <?php echo esc_attr( $color_content_txt ); ?>;
}

/* Code and preformated*/

.wp-block-code,
.editor-styles-wrapper code,
.editor-styles-wrapper pre,
.editor-styles-wrapper pre h2{
	color: <?php echo esc_attr( $color_content_txt ); ?>;
}
.wp-block-code .editor-plain-text{
  background: transparent;
}

/* Separator */
.wp-block-separator{
	border-color: <?php echo herald_hex2rgba($color_content_txt, 0.2); ?>;
	border-bottom-width: 1px;	
}
/* Content width*/

.edit-post-visual-editor .wp-block{
	max-width: 1020px;
}
.post-type-page .edit-post-visual-editor .wp-block{
	max-width: 1020px;
}
.edit-post-visual-editor .wp-block[data-align="wide"],
.post-type-page .edit-post-visual-editor .wp-block[data-align="wide"]{
	max-width: 1080px;
}
.edit-post-visual-editor .wp-block[data-align="full"],
.post-type-page .edit-post-visual-editor .wp-block[data-align="full"]{
	max-width: none;
}

.wp-block-tag-cloud a{
    background: <?php echo herald_hex2rgba( $color_content_title , 0.1); ?>;
    color: <?php echo esc_attr( $color_content_txt ); ?>;
}

.editor-styles-wrapper .wp-block-search .wp-block-search__input{
    border: 1px solid <?php echo herald_hex2rgba($color_content_txt, 0.1); ?>;
}
.editor-styles-wrapper .wp-block .wp-block-search__button{
    background: <?php echo esc_attr( $color_content_acc ); ?>;   
    color: <?php echo esc_attr( $color_content_bg ); ?>;	 
}

<?php



/* Apply uppercase options */
$uppercase = herald_get_option( 'uppercase' );
if ( !empty( $uppercase ) ) {
	foreach ( $uppercase as $text_class => $val ) {
		if ( $val ){
			echo '.editor-styles-wrapper .'. esc_attr( $text_class ) .'{text-transform: uppercase;}';
		} else {
			echo '.editor-styles-wrapper .'. esc_attr( $text_class ) .'{text-transform: none;}';
		}
	}
}



?>