<?php

$content = str_replace(']]>', ']]&gt;', apply_filters('the_content', $content));

$layout = get_post_meta( $post->ID, '_layout', true );
if(empty($layout)) {
	$layout = 'full';
	
}

$image_height = $helpme_settings['blog-single-image-height'];
$image_width = helpme_content_width($layout);

$padding = get_post_meta( $post->ID, '_padding', true );
$padding = ($padding == 'true') ? 'no-padding' : '';

$show_featured = get_post_meta( $post->ID, '_featured_image', true );
$show_featured = (isset($show_featured) && !empty($show_featured)) ? $show_featured  : 'true' ;

$position = get_post_meta( $post->ID, '_position', true );
$email = get_post_meta( $post->ID, '_email', true );
$website = get_post_meta( $post->ID, '_website', true );
$website_name = get_post_meta( $post->ID, '_website_name', true );
$facebook = get_post_meta( $post->ID, '_facebook', true );
$twitter = get_post_meta( $post->ID, '_twitter', true );
$linkedin = get_post_meta( $post->ID, '_linkedin', true );
$instagram = get_post_meta( $post->ID, '_instagram', true );
$dribbble = get_post_meta( $post->ID, '_dribbble', true );
$googleplus = get_post_meta( $post->ID, '_googleplus', true );
$pinterest = get_post_meta( $post->ID, '_pinterest', true );

get_header(); ?>

<div id="theme-page" class="helpme-blog-single">
	<?php if ( have_posts() ) while ( have_posts() ) : the_post();
		$post_type = (get_post_format( get_the_id()) == '0' || get_post_format( get_the_id()) == '') ? 'image' : get_post_format( get_the_id());
		$image_src_array = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full', true );
		if(isset($helpme_settings['blog-image-crop']) && $helpme_settings['blog-image-crop'] == 0) {
			$image_src = $image_src_array[ 0 ];
		} else {
			$image_src = bfi_thumb( $image_src_array[ 0 ], array('width' => $image_width, 'height' => $image_height, 'crop'=>true));
		}
	?>
	<div class="helpme-main-wrapper-holder">
		<div class="theme-page-wrapper <?php echo esc_attr($layout); ?>-layout helpme-grid vc_row-fluid <?php echo esc_attr($padding); ?>">
			<div class="theme-inner-wrapper">
				<div class="theme-content <?php echo esc_attr($padding); ?>" id="blog-entry-<?php the_ID(); ?>" <?php post_class(); ?> itemprop="mainContentOfPage">
					<div class="inner-content">
				
						<?php if(has_post_thumbnail()) : ?>
							<div class="featured-image">
								<a href="<?php echo esc_url($image_src_array[ 0 ]); ?>" class="helpme-lightbox"><img alt="<?php the_title(); ?>" title="<?php the_title(); ?>" src="<?php echo helpme_thumbnail_image_gen($image_src, $image_width, $image_height); ?>" height="<?php echo esc_attr($image_height); ?>" width="<?php echo esc_attr($image_width); ?>" itemprop="image" /></a>
							</div>
						<?php endif; ?>

						<div class="single-content">
							<div class="employees-top-content">
								<h5 class="employee-position"><?php echo esc_html($position) ?></h5>
								<div class="employee-email"><?php echo esc_html($email) ?></div>
								<div class="employee-website"><a href="<?php echo  esc_url($website); ?>" target="_blank"><?php echo esc_html($website_name); ?></a></div>
							</div>
							<div class="employee-desc"><?php the_content(); ?></div>
							
							<ul class="employees-social-wrap">
							
								<li><a class="employee-social-icon" href="<?php echo esc_url($facebook) ?>" target="_blank"><i class="helpme-icon-facebook"></i></a></li>
								<li><a class="employee-social-icon" href="<?php echo esc_url($twitter) ?>" target="_blank"><i class="helpme-icon-twitter"></i></a></li>
								<li><a class="employee-social-icon" href="<?php echo esc_url($linkedin) ?>" target="_blank"><i class="helpme-icon-linkedin"></i></a></li>
								<li><a class="employee-social-icon" href="<?php echo esc_url($instagram) ?>" target="_blank"><i class="helpme-icon-instagram"></i></a></li>
								<li><a class="employee-social-icon" href="<?php echo esc_url($dribbble) ?>" target="_blank"><i class="helpme-icon-dribbble"></i></a></li>
								<li><a class="employee-social-icon" href="<?php echo esc_url($googleplus) ?>" target="_blank"><i class="helpme-icon-google-plus"></i></a></li>
								<li><a class="employee-social-icon" href="<?php echo esc_url($pinterest) ?>" target="_blank"><i class="helpme-icon-pinterest"></i></a></li>
							</ul>
						</div>
						<div class="clearboth"></div>
					</div>
				</div>
			<?php endwhile; ?>
			<?php  if($layout != 'full') get_sidebar();  ?>
			<div class="clearboth"></div>

			</div>
		</div>
	</div>
</div>
<?php get_footer(); ?>
