<?php
$config  = array(
	'title' => __( 'Sharp Slider Meta Options', 'helpme' ),
	'id' => 'helpme-metaboxes-sharp',
	'pages' => array(
		'sharp'
	),
	'callback' => '',
	'context' => 'normal',
	'priority' => 'core'
);
$options = array(

	array(
		"name" => __( "Content Animation", "helpme" ),
		"subtitle" => __( "The type animation for this slide content", "helpme" ),
		"desc" => __( "Using this option you can define specific animations for the content of this slider. This option will affect custom content that you create from above WP editor or the built-in captions and buttons.", "helpme" ),
		"id" => "_animation",
		"default" => 'fade-in',
		"options" => array(
			"fade-in" => __( "Fade in", 'helpme' ),
			"slide-top" => __( 'Slide from Top', 'helpme' ),
			"slide-left" => __( 'Slide from Left', 'helpme' ),
			"slide-bottom" => __( 'Slide from Bottom', 'helpme' ),
			"slide-right" => __( 'Slide from Right', 'helpme' ),
			"scale-down" => __( 'Scale Down', 'helpme' ),
			"flip-x" => __( 'Horizontally Flip', 'helpme' ),
			"flip-y" => __( 'Vertically Flip', 'helpme' ),
		),
		"type" => "select"
	),

	array(
		"name" => __( "Slider Type", "helpme" ),
		"subtitle" => __( "Do you want to have video or Image for this slide item?", "helpme" ),
		"desc" => __( "", "helpme" ),
		"id" => "_sharp_type",
		"default" => 'image',
		"options" => array(
			"image" => __( "Image", 'helpme' ),
			"video" => __( 'Video', 'helpme' ),

		),
		"type" => "select"
	),

	array(
		"name" => __( "MP4", "helpme" ),
		"subtitle" => __( "Upload MP4 format" , "helpme" ),
		"desc" => __( "MP4 for Safari, IE9, iPhone, iPad, Android, and Windows Phone 7", "helpme" ),
		"id" => "_video_mp4",
		"default" => '',
		"preview" => false,
		"type" => 'upload'
	),

	array(
		"name" => __( "WebM", "helpme" ),
		"subtitle" => __( "Upload WebM format" , "helpme" ),
		"desc" => __( "WebM/VP8 for Firefox4, Opera, and Chrome", "helpme" ),
		"id" => "_video_webm",
		"default" => '',
		"preview" => false,
		"type" => 'upload'
	),

	array(
		"name" => __( "OGV", "helpme" ),
		"subtitle" => __( "Upload OGV format" , "helpme" ),
		"desc" => __( "Compatibility for older Firefox and Opera versions", "helpme" ),
		"id" => "_video_ogv",
		"default" => '',
		"preview" => false,
		"type" => 'upload'
	),


	array(
		"name" => __( "Video Preview Image", "helpme" ),
		"subtitle" => __( "This Image will be shown until the video load." , "helpme" ),
		"desc" => __( "If video is not played due to lack of video support the image will remain as a fallback.", "helpme" ),
		"id" => "_video_preview",
		"default" => '',
		"type" => 'upload'
	),

	array(
		"name" => __( "Upload Image", "helpme" ),
		"subtitle" => __( "Upload slideshow image. Image will fit to the container size." , "helpme" ),
		"desc" => __( "For better quality in all browsers recommded size is 1920px * 1080px.", "helpme" ),
		"id" => "_slide_image",
		"default" => '',
		"preview" => true,
		"type" => 'upload'
	),
	array(
		"name" =>__( "Cover whole background", "helpme" ),
		"subtitle" => __( "This option is only when image is uploaded.", "helpme" ),
		"desc" => __( "Scale the background image to be as large as possible so that the background area is completely covered by the background image. Some parts of the background image may not be in view within the background positioning area.", "helpme" ),
		"id" => "_cover",
		"default" => "true",
		"type" => "toggle"
	),

	array(
		"name" => __( 'background Color', 'helpme' ),
		"subtitle" => __( "You can use solid color in slide item", "helpme" ),
		"desc" => __( "Solid color backgrounds can give your slideshow a playground for your company slogans", "helpme" ),
		"id" => "_bg_color",
		"default" => "",
		"type" => "color"
	),
	array(
		"name" =>__( "Pattern Mask", "helpme" ),
		"subtitle" => __( "If you enable this option a pattern will overlay the video.", "helpme" ),
		"desc" => __( "If you are going to use text and content over the video mask will make your content more readable.", "helpme" ),
		"id" => "_pattern",
		"default" => "false",
		"type" => "toggle"
	),

	array(
		"name" => __( 'Color Overlay', 'helpme' ),
		"subtitle" => __( 'Overlay trancparency value can be set in below option.', 'helpme' ),
		"desc" => __( "This color will stay over the video or image and the final output will be a colored video.", "helpme" ),
		"id" => "_color_overlay",
		"default" => "",
		"type" => "color"
	),
	array(
		"name" => __( "Color Overlay Opacity", "helpme" ),
		"subtitle" => __( "Default : 0.3", "helpme" ),
		"desc" => __( "", "helpme" ),
		"id" => "_overlay_opacity",
		"default" => "0.3",
		"min" => "0",
		"max" => "1",
		"step" => "0.1",
		"unit" => 'alpha',
		"type" => "range"
	),


	array(
		"name" => __( "Content Align", "helpme" ),
		"subtitle" => __( "Location of caption and buttons.", "helpme" ),
		"desc" => __( "Based on your choice of the location the content will be dynamically located inside the slideshow.", "helpme" ),
		"id" => "_caption_align",
		"default" => 'left_center',
		"options" => array(
			"left_top" => __( "Left Top", 'helpme' ),
			"center_top" => __( 'Center Top', 'helpme' ),
			"right_top" => __( 'Right Top', 'helpme' ),
			"left_center" => __( 'Left Center', 'helpme' ),
			"center_center" => __( 'Center Center', 'helpme' ),
			"right_center" => __( 'Right Center', 'helpme' ),
			"left_bottom" => __( 'Left Bottom', 'helpme' ),
			"center_bottom" => __( 'Center Bottom', 'helpme' ),
			"right_bottom" => __( 'Right Bottom', 'helpme' ),

		),
		"type" => "select"
	),

	array(
		"name" => __( "Content Width", "helpme" ),
		"subtitle" => __( "You can define the content width based on percent.", "helpme" ),
		"desc" => __( "please note that this width will be defined percent width of main grid. default : 70%", "helpme" ),
		"id" => "_content_width",
		"default" => "70",
		"min" => "0",
		"max" => "100",
		"step" => "1",
		"unit" => '%',
		"type" => "range"
	),
	array(
		"name" => __( "Caption Title", "helpme" ),
		"subtitle" => __( '', 'helpme' ),
		"desc" => __( "", "helpme" ),
		"id" => "_title",
		"default" => '',
		"type" => "text"
	),
	array(
		"name" => __( "Caption Title Font Size", "helpme" ),
		"subtitle" => __( "Default : 50", "helpme" ),
		"desc" => __( "", "helpme" ),
		"id" => "_title_size",
		"default" => "50",
		"min" => "12",
		"max" => "200",
		"step" => "1",
		"unit" => 'px',
		"type" => "range"
	),
	array(
		"name" => __( "Caption Title Font Weight", "helpme" ),
		"subtitle" => __( "", "helpme" ),
		"desc" => __( "", "helpme" ),
		"id" => "_caption_title_weight",
		"default" => '300',
		"options" => array(
			"inherit" => __('Default', "helpme"),
            "600" => __('Semi Bold', "helpme"),
            "bold" => __('Bold', "helpme"),
            "bolder" => __('Bolder', "helpme"),
            "normal" => __('Normal', "helpme"),
            "300" => __('Light', "helpme")

		),
		"type" => "select"
	),

	array(
		"name" => __( "Caption Description", "helpme" ),
		"subtitle" => __( '', 'helpme' ),
		"desc" => __( "", "helpme" ),
		"id" => "_description",
		"default" => "",
		"rows" => "3",
		"type" => "textarea"
	),

	array(
		"name" => __( "Caption Skin", "helpme" ),
		"subtitle" => __( "", "helpme" ),
		"desc" => __( "", "helpme" ),
		"id" => "_caption_skin",
		"default" => 'light',
		"options" => array(
			"light" => __( "Light", 'helpme' ),
			"dark" => __( 'Dark', 'helpme' ),
			"custom" => __( 'Custom Color (Change from below option)', 'helpme' ),

		),
		"type" => "select"
	),
	array(
		"name" => __( 'Custom Caption Text Color', 'helpme' ),
		"subtitle" => __( 'This option will only work when you choose custom from "Caption Skin" option above.', 'helpme' ),
		"desc" => __( "This option will affect both caption title & description.", "helpme" ),
		"id" => "_custom_caption_color",
		"default" => "",
		"type" => "color"
	),


	array(
		"name" => __( "Button 1 Style", "helpme" ),
		"subtitle" => __( "", "helpme" ),
		"desc" => __( "", "helpme" ),
		"id" => "_btn_1_style",
		"default" => 'outline',
		'layout' => 'half',
		"options" => array(
			"outline" => __( "Outline", 'helpme' ),
			"flat" => __( 'Flat', 'helpme' ),
			"line" => __( 'Line', 'helpme' ),
			"fill" => __( 'Fill', 'helpme' ),
			"radius" => __( 'Radius', 'helpme' ),
			"fancy_link" => __( 'Fancy', 'helpme' )
		),
		"type" => "select"
	),

	array(
		"name" => __( "Button 1 Skin", "helpme" ),
		"subtitle" => __( "", "helpme" ),
		"desc" => __( "", "helpme" ),
		"id" => "_btn_1_skin",
		"default" => 'light',
		'layout' => 'half',
		"divider" => true,
		"options" => array(
			"dark" => __( "Dark", 'helpme' ),
			"light" => __( 'Light', 'helpme' ),
			"skin" => __( 'Theme Skin Color', 'helpme' ),
		),
		"type" => "select"
	),


	array(
		"name" => __( "Button 1 Text", "helpme" ),
		"subtitle" => __( '', 'helpme' ),
		"desc" => __( "", "helpme" ),
		"id" => "_btn_1_txt",
		"default" => '',
		'layout' => 'half',
		"size" => 30,
		"type" => "text"
	),

	array(
		"name" => __( "Button 1 URL", "helpme" ),
		"subtitle" => __( 'Button Link', 'helpme' ),
		"desc" => __( "including http://", "helpme" ),
		"id" => "_btn_1_url",
		"default" => '',
		'layout' => 'half',
		"size" => 30,
		"type" => "text"
	),




	array(
		"name" => __( "Button 2 Style", "helpme" ),
		"subtitle" => __( "", "helpme" ),
		"desc" => __( "", "helpme" ),
		"id" => "_btn_2_style",
		"default" => 'outline',
		'layout' => 'half',
		"options" => array(
			"outline" => __( "Outline", 'helpme' ),
			"flat" => __( 'Flat', 'helpme' ),
			"line" => __( 'Line', 'helpme' ),
			"fill" => __( 'Fill', 'helpme' ),
			"radius" => __( 'Radius', 'helpme' ),
			"fancy_link" => __( 'Fancy', 'helpme' )
		),
		"type" => "select"
	),



	array(
		"name" => __( "Button 2 Skin", "helpme" ),
		"subtitle" => __( "", "helpme" ),
		"desc" => __( "", "helpme" ),
		"id" => "_btn_2_skin",
		"default" => 'light',
		'layout' => 'half',
		"divider" => true,
		"options" => array(
			"dark" => __( "Dark", 'helpme' ),
			"light" => __( 'Light', 'helpme' ),
			"skin" => __( 'Theme Skin Color', 'helpme' ),
		),
		"type" => "select"
	),

	array(
		"name" => __( "Button 2 Text", "helpme" ),
		"subtitle" => __( '', 'helpme' ),
		"desc" => __( "", "helpme" ),
		"id" => "_btn_2_txt",
		"default" => '',
		'layout' => 'half',
		"size" => 30,
		"type" => "text"
	),



	array(
		"name" => __( "Button 2 URL", "helpme" ),
		"subtitle" => __( 'Button Link', 'helpme' ),
		"desc" => __( "including http://", "helpme" ),
		"id" => "_btn_2_url",
		"default" => '',
		'layout' => 'half',
		"size" => 30,
		"type" => "text"
	),


	array(
		"name" => __( "Transparent Header Style Skin for this Slide", "helpme" ),
		"subtitle" => __( "If this slide image or video is light color then you should choose dark otherwise light.", "helpme" ),
		"desc" => __( "", "helpme" ),
		"id" => "_sharp_header_skin",
		"default" => 'dark',
		"options" => array(
			"dark" => __( "Dark", 'helpme' ),
			"light" => __( 'Light', 'helpme' ),

		),
		"type" => "select"
	),

	array(
		"name" => __( "Hash Data Attribute?", "helpme" ),
		"subtitle" => __( 'Add an alias title for this slide (use dash instead of space)', 'helpme' ),
		"desc" => __( "Use this field if you want to navigate to an specific slide using URL hash value. You will also need to enable the 'Hash Navigation?' option from sharp slider shortcode options.", "helpme" ),
		"id" => "_hash_attribute",
		"default" => '',
		'layout' => 'half',
		"size" => 30,
		"type" => "text"
	),




);
new helpme_metaboxesGenerator( $config, $options );
