<?php

add_action('admin_menu', 'register_helpme_icon_library');

function register_helpme_icon_library() {
	add_submenu_page('tools.php','Icon Library', 'Icon Library', 'manage_options', 'icon-library', 'icon_library_submenu_page_callback');
}

function icon_library_submenu_page_callback() {

	$helpme_icons_list = array(
		"flaticon-amplified" => "e000",
		"flaticon-arrow434" => "e001",
		"flaticon-arrow435" => "e002",
		"flaticon-arrow436" => "e003",
		"flaticon-arrow437" => "e004",
		"flaticon-arrowhead4" => "e005",
		"flaticon-audio28" => "e006",
		"flaticon-battery74" => "e007",
		"flaticon-big80" => "e008",
		"flaticon-big81" => "e009",
		"flaticon-blank20" => "e00a",
		"flaticon-camera43" => "e00b",
		"flaticon-cassette7" => "e00c",
		"flaticon-cinema13" => "e00d",
		"flaticon-circular45" => "e00e",
		"flaticon-circular46" => "e00f",
		"flaticon-circular47" => "e010",
		"flaticon-circular48" => "e011",
		"flaticon-circular49" => "e012",
		"flaticon-circular50" => "e013",
		"flaticon-cloud102" => "e014",
		"flaticon-cloudy12" => "e015",
		"flaticon-coffee17" => "e016",
		"flaticon-cogwheel8" => "e017",
		"flaticon-compact8" => "e018",
		"flaticon-compass39" => "e019",
		"flaticon-connected8" => "e01a",
		"flaticon-crop2" => "e01b",
		"flaticon-cross39" => "e01c",
		"flaticon-curve19" => "e01d",
		"flaticon-diamond18" => "e01e",
		"flaticon-document58" => "e01f",
		"flaticon-dollar79" => "e020",
		"flaticon-door7" => "e021",
		"flaticon-double23" => "e022",
		"flaticon-double24" => "e023",
		"flaticon-downloading3" => "e024",
		"flaticon-drawing4" => "e025",
		"flaticon-empty20" => "e026",
		"flaticon-eyes" => "e027",
		"flaticon-fast10" => "e028",
		"flaticon-fast11" => "e029",
		"flaticon-file24" => "e02a",
		"flaticon-film24" => "e02b",
		"flaticon-fire13" => "e02c",
		"flaticon-flag26" => "e02d",
		"flaticon-flat10" => "e02e",
		"flaticon-fluff1" => "e02f",
		"flaticon-four26" => "e030",
		"flaticon-full21" => "e031",
		"flaticon-grocery10" => "e032",
		"flaticon-half11" => "e033",
		"flaticon-heart66" => "e034",
		"flaticon-home62" => "e035",
		"flaticon-huge3" => "e036",
		"flaticon-increasing5" => "e037",
		"flaticon-kings" => "e038",
		"flaticon-letter11" => "e039",
		"flaticon-light44" => "e03a",
		"flaticon-lines" => "e03b",
		"flaticon-low20" => "e03c",
		"flaticon-magnification3" => "e03d",
		"flaticon-maps5" => "e03e",
		"flaticon-mathematical3" => "e03f",
		"flaticon-microphone26" => "e040",
		"flaticon-molecular" => "e041",
		"flaticon-multiple18" => "e042",
		"flaticon-music63" => "e043",
		"flaticon-mute7" => "e044",
		"flaticon-navigation8" => "e045",
		"flaticon-newspaper8" => "e046",
		"flaticon-no16" => "e047",
		"flaticon-open89" => "e048",
		"flaticon-open90" => "e049",
		"flaticon-padlock18" => "e04a",
		"flaticon-paint26" => "e04b",
		"flaticon-paper43" => "e04c",
		"flaticon-paper44" => "e04d",
		"flaticon-personal5" => "e04e",
		"flaticon-phone51" => "e04f",
		"flaticon-picture10" => "e050",
		"flaticon-plant10" => "e051",
		"flaticon-play35" => "e052",
		"flaticon-previous6" => "e053",
		"flaticon-profile7" => "e054",
		"flaticon-public5" => "e055",
		"flaticon-rainy5" => "e056",
		"flaticon-religion1" => "e057",
		"flaticon-rewind22" => "e058",
		"flaticon-rotating10" => "e059",
		"flaticon-rotating9" => "e05a",
		"flaticon-round30" => "e05b",
		"flaticon-round31" => "e05c",
		"flaticon-rounded25" => "e05d",
		"flaticon-rounded26" => "e05e",
		"flaticon-royalty" => "e05f",
		"flaticon-scissors14" => "e060",
		"flaticon-shopping63" => "e061",
		"flaticon-signal21" => "e062",
		"flaticon-simple47" => "e063",
		"flaticon-small139" => "e064",
		"flaticon-snowflake3" => "e065",
		"flaticon-speech54" => "e066",
		"flaticon-spring11" => "e067",
		"flaticon-square51" => "e068",
		"flaticon-square52" => "e069",
		"flaticon-square53" => "e06a",
		"flaticon-square54" => "e06b",
		"flaticon-square55" => "e06c",
		"flaticon-square56" => "e06d",
		"flaticon-square57" => "e06e",
		"flaticon-stop20" => "e06f",
		"flaticon-sun30" => "e070",
		"flaticon-syncing" => "e071",
		"flaticon-telephone63" => "e072",
		"flaticon-trash27" => "e073",
		"flaticon-triangle14" => "e074",
		"flaticon-tshirt14" => "e075",
		"flaticon-umbrella14" => "e076",
		"flaticon-user73" => "e077",
		"flaticon-wide6" => "e078",
		"flaticon-world29" => "e079",
		"li-web" => "e600",
		"li-volume" => "e601",
		"li-vinyl-disk" => "e602",
		"li-view" => "e603",
		"li-video" => "e604",
		"li-users" => "e605",
		"li-user" => "e606",
		"li-unlock" => "e607",
		"li-umbrella" => "e608",
		"li-tshirt" => "e609",
		"li-truck" => "e60a",
		"li-tool" => "e60b",
		"li-toilet-paper" => "e60c",
		"li-ticket" => "e60d",
		"li-target" => "e60e",
		"li-tablet" => "e60f",
		"li-sun" => "e610",
		"li-star" => "e611",
		"li-smile" => "e612",
		"li-shop" => "e613",
		"li-shield" => "e614",
		"li-settings" => "e615",
		"li-scissor" => "e616",
		"li-safe" => "e617",
		"li-rocket" => "e618",
		"li-refresh" => "e619",
		"li-posion" => "e61a",
		"li-portfolio" => "e61b",
		"li-pinmap" => "e61c",
		"li-pill" => "e61d",
		"li-photo" => "e61e",
		"li-phone" => "e61f",
		"li-pencil" => "e620",
		"li-paper-plane" => "e621",
		"li-notepad" => "e622",
		"li-notebook" => "e623",
		"li-news" => "e624",
		"li-net" => "e625",
		"li-music" => "e626",
		"li-mortarboard" => "e627",
		"li-monitor" => "e628",
		"li-money" => "e629",
		"li-micro" => "e62a",
		"li-message" => "e62b",
		"li-map" => "e62c",
		"li-mail" => "e62d",
		"li-magnet" => "e62e",
		"li-love" => "e62f",
		"li-loupe" => "e630",
		"li-lock" => "e631",
		"li-link" => "e632",
		"li-like" => "e633",
		"li-light" => "e634",
		"li-leaf" => "e635",
		"li-lamp" => "e636",
		"li-lab" => "e637",
		"li-key" => "e638",
		"li-joy" => "e639",
		"li-inbox" => "e63a",
		"li-ice" => "e63b",
		"li-host" => "e63c",
		"li-help" => "e63d",
		"li-headphones" => "e63e",
		"li-graph" => "e63f",
		"li-garbage" => "e640",
		"li-game-pad" => "e641",
		"li-food" => "e642",
		"li-flag" => "e643",
		"li-file" => "e644",
		"li-expand" => "e645",
		"li-drop" => "e646",
		"li-cup" => "e647",
		"li-copy" => "e648",
		"li-config" => "e649",
		"li-compass" => "e64a",
		"li-comments" => "e64b",
		"li-coffee" => "e64c",
		"li-cloud" => "e64d",
		"li-clock" => "e64e",
		"li-clip" => "e64f",
		"li-cinema" => "e650",
		"li-check" => "e651",
		"li-cd" => "e652",
		"li-cassette" => "e653",
		"li-cart" => "e654",
		"li-camera" => "e655",
		"li-call" => "e656",
		"li-calendar" => "e657",
		"li-calculator" => "e658",
		"li-brush" => "e659",
		"li-browser" => "e65a",
		"li-book" => "e65b",
		"li-bicycle" => "e65c",
		"li-bell" => "e65d",
		"li-battery" => "e65e",
		"li-bag" => "e65f",
		"li-attention" => "e660",
		"li-atom" => "e661",
		"li-apeaker" => "e662",
		"li-alarm" => "e663",
		"theme-icon-topnav" => "e66e",
		"theme-icon-rightsidebar" => "e66f",
		"theme-icon-leftsidebar" => "e66b",
		"theme-icon-dashboard-o" => "e671",
		"theme-icon-bottomnav" => "e672",
		"theme-icon-boxed" => "e66b",
		"theme-icon-wide" => "e66a",
		"theme-icon-singlepage" => "e66c",
		"theme-icon-multipage" => "e66d",
		"theme-icon-woman-bag" => "e600",
		"theme-icon-voicemessage" => "e601",
		"theme-icon-trashcan" => "e602",
		"theme-icon-thermostat" => "e603",
		"theme-icon-tag" => "e604",
		"theme-icon-sitemap" => "e605",
		"theme-icon-shirt" => "e606",
		"theme-icon-printer" => "e607",
		"theme-icon-video" => "e608",
		"theme-icon-user" => "e609",
		"theme-icon-top-small" => "e60a",
		"theme-icon-top-bigger" => "e60b",
		"theme-icon-top-big" => "e60c",
		"theme-icon-tick" => "e60d",
		"theme-icon-tick2" => "e004",
		"theme-icon-plus" => "e007",
		"theme-icon-play" => "e008",
		"theme-icon-pause" => "e009",
		"theme-icon-magnifier" => "e00a",
		"theme-icon-dashboard2" => "e00c",
		"theme-icon-close" => "e00d",
		"theme-icon-cart2" => "e00e",
		"theme-icon-burgerwide" => "e00f",
		"theme-icon-burger" => "e010",
		"theme-icon-text" => "e60e",
		"theme-icon-star" => "e60f",
		"theme-icon-search" => "e630",
		"theme-icon-quote" => "e631",
		"theme-icon-prev-small" => "e632",
		"theme-icon-prev-big" => "e633",
		"theme-icon-portfolio" => "e634",
		"theme-icon-plus" => "e635",
		"theme-icon-phone" => "e636",
		"theme-icon-permalink" => "e637",
		"theme-icon-pause" => "e638",
		"theme-icon-office" => "e639",
		"theme-icon-next-small" => "e63a",
		"theme-icon-next-bigger" => "e63b",
		"theme-icon-next-big" => "e63c",
		"theme-icon-love" => "e644",
		"theme-icon-prev-bigger" => "e645",
		"theme-icon-image" => "e646",
		"theme-icon-home" => "e648",
		"theme-icon-gallery" => "e649",
		"theme-icon-fax" => "e64a",
		"theme-icon-email" => "e64b",
		"theme-icon-comment" => "e64c",
		"theme-icon-cellphone" => "e64d",
		"theme-icon-cart" => "e64e",
		"theme-icon-cancel" => "e64f",
		"theme-icon-bottom-small" => "e650",
		"theme-icon-bottom-bigger" => "e651",
		"theme-icon-bottom-big" => "e652",
		"theme-icon-blog" => "e653",
		"theme-icon-blog-share" => "e654",
		"theme-icon-macbookair" => "e655",
		"theme-icon-macbook" => "e656",
		"theme-icon-layers" => "e657",
		"theme-icon-lab" => "e658",
		"theme-icon-ipad" => "e659",
		"theme-icon-hamburger" => "e65a",
		"theme-icon-folder-2" => "e65b",
		"theme-icon-file" => "e65c",
		"theme-icon-crop" => "e65d",
		"theme-icon-commandconsole" => "e65e",
		"theme-icon-chergerfull" => "e65f",
		"theme-icon-chargerhalf" => "e660",
		"theme-icon-chargerblank" => "e661",
		"theme-icon-cassette" => "e662",
		"theme-icon-card" => "e663",
		"theme-icon-card-2" => "e664",
		"theme-icon-camera" => "e665",
		"theme-icon-calendar" => "e666",
		"theme-icon-accordion" => "e667",
		"theme-icon-whatsapp" => "e000",
		"theme-icon-weibo" => "e001",
		"theme-icon-wechat" => "e002",
		"theme-icon-vk" => "e003",
		"theme-icon-renren" => "e005",
		"theme-icon-qzone" => "e006",
		"theme-icon-imdb" => "e00b",
		"theme-icon-behance" => "e011",
		"icon-glass" => "f000",
		"icon-music" => "f001",
		"icon-search" => "f002",
		"icon-envelope-o" => "f003",
		"icon-heart" => "f004",
		"icon-star" => "f005",
		"icon-star-o" => "f006",
		"icon-user" => "f007",
		"icon-film" => "f008",
		"icon-th-large" => "f009",
		"icon-th" => "f00a",
		"icon-th-list" => "f00b",
		"icon-check" => "f00c",
		"icon-remove" => "f00d",
		"icon-close" => "f00d",
		"icon-times" => "f00d",
		"icon-search-plus" => "f00e",
		"icon-search-minus" => "f010",
		"icon-power-off" => "f011",
		"icon-signal" => "f012",
		"icon-gear" => "f013",
		"icon-cog" => "f013",
		"icon-trash-o" => "f014",
		"icon-home" => "f015",
		"icon-file-o" => "f016",
		"icon-clock-o" => "f017",
		"icon-road" => "f018",
		"icon-download" => "f019",
		"icon-arrow-circle-o-down" => "f01a",
		"icon-arrow-circle-o-up" => "f01b",
		"icon-inbox" => "f01c",
		"icon-play-circle-o" => "f01d",
		"icon-rotate-right" => "f01e",
		"icon-repeat" => "f01e",
		"icon-refresh" => "f021",
		"icon-list-alt" => "f022",
		"icon-lock" => "f023",
		"icon-flag" => "f024",
		"icon-headphones" => "f025",
		"icon-volume-off" => "f026",
		"icon-volume-down" => "f027",
		"icon-volume-up" => "f028",
		"icon-qrcode" => "f029",
		"icon-barcode" => "f02a",
		"icon-tag" => "f02b",
		"icon-tags" => "f02c",
		"icon-book" => "f02d",
		"icon-bookmark" => "f02e",
		"icon-print" => "f02f",
		"icon-camera" => "f030",
		"icon-font" => "f031",
		"icon-bold" => "f032",
		"icon-italic" => "f033",
		"icon-text-height" => "f034",
		"icon-text-width" => "f035",
		"icon-align-left" => "f036",
		"icon-align-center" => "f037",
		"icon-align-right" => "f038",
		"icon-align-justify" => "f039",
		"icon-list" => "f03a",
		"icon-dedent" => "f03b",
		"icon-outdent" => "f03b",
		"icon-indent" => "f03c",
		"icon-video-camera" => "f03d",
		"icon-photo" => "f03e",
		"icon-image" => "f03e",
		"icon-picture-o" => "f03e",
		"icon-pencil" => "f040",
		"icon-map-marker" => "f041",
		"icon-adjust" => "f042",
		"icon-tint" => "f043",
		"icon-edit" => "f044",
		"icon-pencil-square-o" => "f044",
		"icon-share-square-o" => "f045",
		"icon-check-square-o" => "f046",
		"icon-arrows" => "f047",
		"icon-step-backward" => "f048",
		"icon-fast-backward" => "f049",
		"icon-backward" => "f04a",
		"icon-play" => "f04b",
		"icon-pause" => "f04c",
		"icon-stop" => "f04d",
		"icon-forward" => "f04e",
		"icon-fast-forward" => "f050",
		"icon-step-forward" => "f051",
		"icon-eject" => "f052",
		"icon-chevron-left" => "f053",
		"icon-chevron-right" => "f054",
		"icon-plus-circle" => "f055",
		"icon-minus-circle" => "f056",
		"icon-times-circle" => "f057",
		"icon-check-circle" => "f058",
		"icon-question-circle" => "f059",
		"icon-info-circle" => "f05a",
		"icon-crosshairs" => "f05b",
		"icon-times-circle-o" => "f05c",
		"icon-check-circle-o" => "f05d",
		"icon-ban" => "f05e",
		"icon-arrow-left" => "f060",
		"icon-arrow-right" => "f061",
		"icon-arrow-up" => "f062",
		"icon-arrow-down" => "f063",
		"icon-mail-forward" => "f064",
		"icon-share" => "f064",
		"icon-expand" => "f065",
		"icon-compress" => "f066",
		"icon-plus" => "f067",
		"icon-minus" => "f068",
		"icon-asterisk" => "f069",
		"icon-exclamation-circle" => "f06a",
		"icon-gift" => "f06b",
		"icon-leaf" => "f06c",
		"icon-fire" => "f06d",
		"icon-eye" => "f06e",
		"icon-eye-slash" => "f070",
		"icon-warning" => "f071",
		"icon-exclamation-triangle" => "f071",
		"icon-plane" => "f072",
		"icon-calendar" => "f073",
		"icon-random" => "f074",
		"icon-comment" => "f075",
		"icon-magnet" => "f076",
		"icon-chevron-up" => "f077",
		"icon-chevron-down" => "f078",
		"icon-retweet" => "f079",
		"icon-shopping-cart" => "f07a",
		"icon-folder" => "f07b",
		"icon-folder-open" => "f07c",
		"icon-arrows-v" => "f07d",
		"icon-arrows-h" => "f07e",
		"icon-bar-chart-o" => "f080",
		"icon-bar-chart" => "f080",
		"icon-twitter-square" => "f081",
		"icon-facebook-square" => "f082",
		"icon-camera-retro" => "f083",
		"icon-key" => "f084",
		"icon-gears" => "f085",
		"icon-cogs" => "f085",
		"icon-comments" => "f086",
		"icon-thumbs-o-up" => "f087",
		"icon-thumbs-o-down" => "f088",
		"icon-star-half" => "f089",
		"icon-heart-o" => "f08a",
		"icon-sign-out" => "f08b",
		"icon-linkedin-square" => "f08c",
		"icon-thumb-tack" => "f08d",
		"icon-external-link" => "f08e",
		"icon-sign-in" => "f090",
		"icon-trophy" => "f091",
		"icon-github-square" => "f092",
		"icon-upload" => "f093",
		"icon-lemon-o" => "f094",
		"icon-phone" => "f095",
		"icon-square-o" => "f096",
		"icon-bookmark-o" => "f097",
		"icon-phone-square" => "f098",
		"icon-twitter" => "f099",
		"icon-facebook" => "f09a",
		"icon-github" => "f09b",
		"icon-unlock" => "f09c",
		"icon-credit-card" => "f09d",
		"icon-rss" => "f09e",
		"icon-hdd-o" => "f0a0",
		"icon-bullhorn" => "f0a1",
		"icon-bell" => "f0f3",
		"icon-certificate" => "f0a3",
		"icon-hand-o-right" => "f0a4",
		"icon-hand-o-left" => "f0a5",
		"icon-hand-o-up" => "f0a6",
		"icon-hand-o-down" => "f0a7",
		"icon-arrow-circle-left" => "f0a8",
		"icon-arrow-circle-right" => "f0a9",
		"icon-arrow-circle-up" => "f0aa",
		"icon-arrow-circle-down" => "f0ab",
		"icon-globe" => "f0ac",
		"icon-wrench" => "f0ad",
		"icon-tasks" => "f0ae",
		"icon-filter" => "f0b0",
		"icon-briefcase" => "f0b1",
		"icon-arrows-alt" => "f0b2",
		"icon-group" => "f0c0",
		"icon-users" => "f0c0",
		"icon-chain" => "f0c1",
		"icon-link" => "f0c1",
		"icon-cloud" => "f0c2",
		"icon-flask" => "f0c3",
		"icon-cut" => "f0c4",
		"icon-scissors" => "f0c4",
		"icon-copy" => "f0c5",
		"icon-files-o" => "f0c5",
		"icon-paperclip" => "f0c6",
		"icon-save" => "f0c7",
		"icon-floppy-o" => "f0c7",
		"icon-square" => "f0c8",
		"icon-navicon" => "f0c9",
		"icon-reorder" => "f0c9",
		"icon-bars" => "f0c9",
		"icon-list-ul" => "f0ca",
		"icon-list-ol" => "f0cb",
		"icon-strikethrough" => "f0cc",
		"icon-underline" => "f0cd",
		"icon-table" => "f0ce",
		"icon-magic" => "f0d0",
		"icon-truck" => "f0d1",
		"icon-pinterest" => "f0d2",
		"icon-pinterest-square" => "f0d3",
		"icon-google-plus-square" => "f0d4",
		"icon-google-plus" => "f0d5",
		"icon-money" => "f0d6",
		"icon-caret-down" => "f0d7",
		"icon-caret-up" => "f0d8",
		"icon-caret-left" => "f0d9",
		"icon-caret-right" => "f0da",
		"icon-columns" => "f0db",
		"icon-unsorted" => "f0dc",
		"icon-sort" => "f0dc",
		"icon-sort-down" => "f0dd",
		"icon-sort-desc" => "f0dd",
		"icon-sort-up" => "f0de",
		"icon-sort-asc" => "f0de",
		"icon-envelope" => "f0e0",
		"icon-linkedin" => "f0e1",
		"icon-rotate-left" => "f0e2",
		"icon-undo" => "f0e2",
		"icon-legal" => "f0e3",
		"icon-gavel" => "f0e3",
		"icon-dashboard" => "f0e4",
		"icon-tachometer" => "f0e4",
		"icon-comment-o" => "f0e5",
		"icon-comments-o" => "f0e6",
		"icon-flash" => "f0e7",
		"icon-bolt" => "f0e7",
		"icon-sitemap" => "f0e8",
		"icon-umbrella" => "f0e9",
		"icon-paste" => "f0ea",
		"icon-clipboard" => "f0ea",
		"icon-lightbulb-o" => "f0eb",
		"icon-exchange" => "f0ec",
		"icon-cloud-download" => "f0ed",
		"icon-cloud-upload" => "f0ee",
		"icon-user-md" => "f0f0",
		"icon-stethoscope" => "f0f1",
		"icon-suitcase" => "f0f2",
		"icon-bell-o" => "f0a2",
		"icon-coffee" => "f0f4",
		"icon-cutlery" => "f0f5",
		"icon-file-text-o" => "f0f6",
		"icon-building-o" => "f0f7",
		"icon-hospital-o" => "f0f8",
		"icon-ambulance" => "f0f9",
		"icon-medkit" => "f0fa",
		"icon-fighter-jet" => "f0fb",
		"icon-beer" => "f0fc",
		"icon-h-square" => "f0fd",
		"icon-plus-square" => "f0fe",
		"icon-angle-double-left" => "f100",
		"icon-angle-double-right" => "f101",
		"icon-angle-double-up" => "f102",
		"icon-angle-double-down" => "f103",
		"icon-angle-left" => "f104",
		"icon-angle-right" => "f105",
		"icon-angle-up" => "f106",
		"icon-angle-down" => "f107",
		"icon-desktop" => "f108",
		"icon-laptop" => "f109",
		"icon-tablet" => "f10a",
		"icon-mobile-phone" => "f10b",
		"icon-mobile" => "f10b",
		"icon-circle-o" => "f10c",
		"icon-quote-left" => "f10d",
		"icon-quote-right" => "f10e",
		"icon-spinner" => "f110",
		"icon-circle" => "f111",
		"icon-mail-reply" => "f112",
		"icon-reply" => "f112",
		"icon-github-alt" => "f113",
		"icon-folder-o" => "f114",
		"icon-folder-open-o" => "f115",
		"icon-smile-o" => "f118",
		"icon-frown-o" => "f119",
		"icon-meh-o" => "f11a",
		"icon-gamepad" => "f11b",
		"icon-keyboard-o" => "f11c",
		"icon-flag-o" => "f11d",
		"icon-flag-checkered" => "f11e",
		"icon-terminal" => "f120",
		"icon-code" => "f121",
		"icon-mail-reply-all" => "f122",
		"icon-reply-all" => "f122",
		"icon-star-half-empty" => "f123",
		"icon-star-half-full" => "f123",
		"icon-star-half-o" => "f123",
		"icon-location-arrow" => "f124",
		"icon-crop" => "f125",
		"icon-code-fork" => "f126",
		"icon-unlink" => "f127",
		"icon-chain-broken" => "f127",
		"icon-question" => "f128",
		"icon-info" => "f129",
		"icon-exclamation" => "f12a",
		"icon-superscript" => "f12b",
		"icon-subscript" => "f12c",
		"icon-eraser" => "f12d",
		"icon-puzzle-piece" => "f12e",
		"icon-microphone" => "f130",
		"icon-microphone-slash" => "f131",
		"icon-shield" => "f132",
		"icon-calendar-o" => "f133",
		"icon-fire-extinguisher" => "f134",
		"icon-rocket" => "f135",
		"icon-maxcdn" => "f136",
		"icon-chevron-circle-left" => "f137",
		"icon-chevron-circle-right" => "f138",
		"icon-chevron-circle-up" => "f139",
		"icon-chevron-circle-down" => "f13a",
		"icon-html5" => "f13b",
		"icon-css3" => "f13c",
		"icon-anchor" => "f13d",
		"icon-unlock-alt" => "f13e",
		"icon-bullseye" => "f140",
		"icon-ellipsis-h" => "f141",
		"icon-ellipsis-v" => "f142",
		"icon-rss-square" => "f143",
		"icon-play-circle" => "f144",
		"icon-ticket" => "f145",
		"icon-minus-square" => "f146",
		"icon-minus-square-o" => "f147",
		"icon-level-up" => "f148",
		"icon-level-down" => "f149",
		"icon-check-square" => "f14a",
		"icon-pencil-square" => "f14b",
		"icon-external-link-square" => "f14c",
		"icon-share-square" => "f14d",
		"icon-compass" => "f14e",
		"icon-toggle-down" => "f150",
		"icon-caret-square-o-down" => "f150",
		"icon-toggle-up" => "f151",
		"icon-caret-square-o-up" => "f151",
		"icon-toggle-right" => "f152",
		"icon-caret-square-o-right" => "f152",
		"icon-euro" => "f153",
		"icon-eur" => "f153",
		"icon-gbp" => "f154",
		"icon-dollar" => "f155",
		"icon-usd" => "f155",
		"icon-rupee" => "f156",
		"icon-inr" => "f156",
		"icon-cny" => "f157",
		"icon-rmb" => "f157",
		"icon-yen" => "f157",
		"icon-jpy" => "f157",
		"icon-ruble" => "f158",
		"icon-rouble" => "f158",
		"icon-rub" => "f158",
		"icon-won" => "f159",
		"icon-krw" => "f159",
		"icon-bitcoin" => "f15a",
		"icon-btc" => "f15a",
		"icon-file" => "f15b",
		"icon-file-text" => "f15c",
		"icon-sort-alpha-asc" => "f15d",
		"icon-sort-alpha-desc" => "f15e",
		"icon-sort-amount-asc" => "f160",
		"icon-sort-amount-desc" => "f161",
		"icon-sort-numeric-asc" => "f162",
		"icon-sort-numeric-desc" => "f163",
		"icon-thumbs-up" => "f164",
		"icon-thumbs-down" => "f165",
		"icon-youtube-square" => "f166",
		"icon-youtube" => "f167",
		"icon-xing" => "f168",
		"icon-xing-square" => "f169",
		"icon-youtube-play" => "f16a",
		"icon-dropbox" => "f16b",
		"icon-stack-overflow" => "f16c",
		"icon-instagram" => "f16d",
		"icon-flickr" => "f16e",
		"icon-adn" => "f170",
		"icon-bitbucket" => "f171",
		"icon-bitbucket-square" => "f172",
		"icon-tumblr" => "f173",
		"icon-tumblr-square" => "f174",
		"icon-long-arrow-down" => "f175",
		"icon-long-arrow-up" => "f176",
		"icon-long-arrow-left" => "f177",
		"icon-long-arrow-right" => "f178",
		"icon-apple" => "f179",
		"icon-windows" => "f17a",
		"icon-android" => "f17b",
		"icon-linux" => "f17c",
		"icon-dribbble" => "f17d",
		"icon-skype" => "f17e",
		"icon-foursquare" => "f180",
		"icon-trello" => "f181",
		"icon-female" => "f182",
		"icon-male" => "f183",
		"icon-gittip" => "f184",
		"icon-sun-o" => "f185",
		"icon-moon-o" => "f186",
		"icon-archive" => "f187",
		"icon-bug" => "f188",
		"icon-vk" => "f189",
		"icon-weibo" => "f18a",
		"icon-renren" => "f18b",
		"icon-pagelines" => "f18c",
		"icon-stack-exchange" => "f18d",
		"icon-arrow-circle-o-right" => "f18e",
		"icon-arrow-circle-o-left" => "f190",
		"icon-toggle-left" => "f191",
		"icon-caret-square-o-left" => "f191",
		"icon-dot-circle-o" => "f192",
		"icon-wheelchair" => "f193",
		"icon-vimeo-square" => "f194",
		"icon-turkish-lira" => "f195",
		"icon-try" => "f195",
		"icon-plus-square-o" => "f196",
		"icon-space-shuttle" => "f197",
		"icon-slack" => "f198",
		"icon-envelope-square" => "f199",
		"icon-wordpress" => "f19a",
		"icon-openid" => "f19b",
		"icon-institution" => "f19c",
		"icon-bank" => "f19c",
		"icon-university" => "f19c",
		"icon-mortar-board" => "f19d",
		"icon-graduation-cap" => "f19d",
		"icon-yahoo" => "f19e",
		"icon-google" => "f1a0",
		"icon-reddit" => "f1a1",
		"icon-reddit-square" => "f1a2",
		"icon-stumbleupon-circle" => "f1a3",
		"icon-stumbleupon" => "f1a4",
		"icon-delicious" => "f1a5",
		"icon-digg" => "f1a6",
		"icon-pied-piper" => "f1a7",
		"icon-pied-piper-alt" => "f1a8",
		"icon-drupal" => "f1a9",
		"icon-joomla" => "f1aa",
		"icon-language" => "f1ab",
		"icon-fax" => "f1ac",
		"icon-building" => "f1ad",
		"icon-child" => "f1ae",
		"icon-paw" => "f1b0",
		"icon-spoon" => "f1b1",
		"icon-cube" => "f1b2",
		"icon-cubes" => "f1b3",
		"icon-behance" => "f1b4",
		"icon-behance-square" => "f1b5",
		"icon-steam" => "f1b6",
		"icon-steam-square" => "f1b7",
		"icon-recycle" => "f1b8",
		"icon-automobile" => "f1b9",
		"icon-car" => "f1b9",
		"icon-cab" => "f1ba",
		"icon-taxi" => "f1ba",
		"icon-tree" => "f1bb",
		"icon-spotify" => "f1bc",
		"icon-deviantart" => "f1bd",
		"icon-soundcloud" => "f1be",
		"icon-database" => "f1c0",
		"icon-file-pdf-o" => "f1c1",
		"icon-file-word-o" => "f1c2",
		"icon-file-excel-o" => "f1c3",
		"icon-file-powerpoint-o" => "f1c4",
		"icon-file-photo-o" => "f1c5",
		"icon-file-picture-o" => "f1c5",
		"icon-file-image-o" => "f1c5",
		"icon-file-zip-o" => "f1c6",
		"icon-file-archive-o" => "f1c6",
		"icon-file-sound-o" => "f1c7",
		"icon-file-audio-o" => "f1c7",
		"icon-file-movie-o" => "f1c8",
		"icon-file-video-o" => "f1c8",
		"icon-file-code-o" => "f1c9",
		"icon-vine" => "f1ca",
		"icon-codepen" => "f1cb",
		"icon-jsfiddle" => "f1cc",
		"icon-life-bouy" => "f1cd",
		"icon-life-buoy" => "f1cd",
		"icon-life-saver" => "f1cd",
		"icon-support" => "f1cd",
		"icon-life-ring" => "f1cd",
		"icon-circle-o-notch" => "f1ce",
		"icon-ra" => "f1d1",
		"icon-rebel" => "f1d1",
		"icon-ge" => "f1d1",
		"icon-empire" => "f1d1",
		"icon-git-square" => "f1d2",
		"icon-git" => "f1d3",
		"icon-hacker-news" => "f1d4",
		"icon-tencent-weibo" => "f1d5",
		"icon-qq" => "f1d6",
		"icon-wechat" => "f1d7",
		"icon-weixin" => "f1d7",
		"icon-send" => "f1d8",
		"icon-paper-plane" => "f1d8",
		"icon-send-o" => "f1d9",
		"icon-paper-plane-o" => "f1d9",
		"icon-history" => "f1da",
		"icon-circle-thin" => "f1db",
		"icon-header" => "f1dc",
		"icon-paragraph" => "f1dd",
		"icon-sliders" => "f1de",
		"icon-share-alt" => "f1e0",
		"icon-share-alt-square" => "f1e1",
		"icon-bomb" => "f1e2",
		"icon-soccer-ball-o" => "f1e3",
		"icon-futbol-o" => "f1e3",
		"icon-tty" => "f1e4",
		"icon-binoculars" => "f1e5",
		"icon-plug" => "f1e6",
		"icon-slideshare" => "f1e7",
		"icon-twitch" => "f1e8",
		"icon-yelp" => "f1e9",
		"icon-newspaper-o" => "f1ea",
		"icon-wifi" => "f1eb",
		"icon-calculator" => "f1ec",
		"icon-paypal" => "f1ed",
		"icon-google-wallet" => "f1ee",
		"icon-cc-visa" => "f1f0",
		"icon-cc-mastercard" => "f1f1",
		"icon-cc-discover" => "f1f2",
		"icon-cc-amex" => "f1f3",
		"icon-cc-paypal" => "f1f4",
		"icon-cc-stripe" => "f1f5",
		"icon-bell-slash" => "f1f6",
		"icon-bell-slash-o" => "f1f7",
		"icon-trash" => "f1f8",
		"icon-copyright" => "f1f9",
		"icon-at" => "f1fa",
		"icon-eyedropper" => "f1fb",
		"icon-paint-brush" => "f1fc",
		"icon-birthday-cake" => "f1fd",
		"icon-area-chart" => "f1fe",
		"icon-pie-chart" => "f200",
		"icon-line-chart" => "f201",
		"icon-lastfm" => "f202",
		"icon-lastfm-square" => "f203",
		"icon-toggle-off" => "f204",
		"icon-toggle-on" => "f205",
		"icon-bicycle" => "f206",
		"icon-bus" => "f207",
		"icon-ioxhost" => "f208",
		"icon-angellist" => "f209",
		"icon-cc" => "f20a",
		"icon-shekel" => "f20b",
		"icon-sheqel" => "f20b",
		"icon-ils" => "f20b",
		"icon-meanpath" => "f20c",
	);

	echo '<div class="wrap icon-library-page">';
	echo '<h2>' . esc_html__('Theme Icon Library', 'helpme') . '</h2>';
	echo '<p>' . esc_html__('Search and find your desired icon and paste its <strong>class name</strong> to the <strong>text field</strong> provided in shortcode options. You will need character code for custom list shortcode!', 'helpme') . '</p>';

	echo '<input autocomplete="off" size="60" placeholder="Type a keyword to find your icon... " type="text" class="icon-filter" value="" name="icon-filter-by-name" />';

	echo '<div class="helpme-font-icons-wrapper">';

	echo '<ul id="icon-lists">';
	foreach ($helpme_icons_list as $key => $value) {
		echo '<li>';
		echo '<ul class="icon-box">';
		echo '<li class="medium"><i class="helpme-' . $key . '" ></i></li>';
		echo '<li class="class-name" title="Class name"><span title="Copy and paste this into icon font shortcode">Class Name:</span>helpme-' . $key . '</li>';
		echo '<li class="character-code" title="Character code"><span>Character Code:</span>' . $value . '</li>';
		echo '</ul>';
		echo '</li>';
	}
	echo '</ul>';
	echo '</div>';

}

function helpme_enqueue_icon_lib() {
	$theme_data = wp_get_theme();
	wp_enqueue_style('helpme-icon-libs', HELPME_THEME_ADMIN_ASSETS_URI . '/css/icon-library.css', false, $theme_data['Version'], 'all');
	wp_enqueue_script('icon-libs-filter', HELPME_THEME_ADMIN_ASSETS_URI . '/js/icon-libs-filter.js', array(
		'jquery',
	), $theme_data['Version'], true);
	wp_enqueue_style('pe-line-icons', HELPME_THEME_STYLES . '/pe-line-icons.css', false, $theme_data['Version'], 'all');
	wp_enqueue_style('helpme-fontawesome', HELPME_THEME_STYLES . '/font-awesome.css', false, $theme_data['Version'], 'all');
	wp_enqueue_style('designsvilla-icons', HELPME_THEME_STYLES . '/designsvilla-icons.css', false, $theme_data['Version'], 'all');
	wp_enqueue_style('flaticon', HELPME_THEME_STYLES . '/flaticon.css', false, $theme_data['Version'], 'all');
}
if (helpme_theme_is_icon_library()) {
	add_action('admin_init', 'helpme_enqueue_icon_lib');
}
