<?php
global $helas_loop;

$layout = isset($helas_loop['loop_layout']) ? $helas_loop['loop_layout'] : 'grid';
$style = isset($helas_loop['loop_style']) ? $helas_loop['loop_style'] : 1;
$responsive_column = isset($helas_loop['responsive_column']) ? $helas_loop['responsive_column'] : array('xlg'=> 1, 'lg'=> 1,'md'=> 1,'sm'=> 1,'xs'=> 1);
$slider_configs = isset($helas_loop['slider_configs']) ? $helas_loop['slider_configs'] : '';
$item_space = isset($helas_loop['item_space']) ? $helas_loop['item_space'] : '30';

$loopCssClass = array('la-loop','showposts-loop');
$loopCssClass[] = "$layout-$style";
$loopCssClass[] = 'showposts-' . $layout;

$loopCssClass[] = 'grid-items';
$loopCssClass[] = 'grid-space-'. $item_space;

if(!empty($slider_configs)){
    $loopCssClass[] = 'js-el la-slick-slider';
}else{
    foreach( $responsive_column as $screen => $value ){
        $loopCssClass[]  =  sprintf('%s-grid-%s-items', $screen, $value);
    }
}

printf(
    '<div class="%1$s"%2$s>',
    esc_attr(implode(' ', $loopCssClass)),
    (!empty($slider_configs) ? ' data-la_component="AutoCarousel" ' . $slider_configs : '')
);