<?php
global $helas_loop;
$thumbnail_size = !empty($helas_loop['image_size']) ? $helas_loop['image_size'] : 'thumbnail';
$title_tag      = !empty($helas_loop['title_tag']) ? $helas_loop['title_tag'] : 'h3';
$show_excerpt   = ( isset($helas_loop['excerpt_length']) && 0 < absint($helas_loop['excerpt_length']) ) ? true : false;
$style          = isset($helas_loop['loop_style']) ? $helas_loop['loop_style'] : 1;

$post_class     = array('loop-item','grid-item','blog_item');
$post_class[]   = ( $show_excerpt ? 'show' : 'hide' ) .  '-excerpt';

$show_featured_image = true;

if($show_featured_image){
    $post_class[] = 'show-featured-image';
    if(!has_post_thumbnail()){
        $post_class[] = 'no-featured-image';
    }
}else{
    $post_class[] = 'hide-featured-image';
}

?>
<article <?php post_class($post_class); ?>>
    <div class="blog_item--inner item-inner">
        <div class="blog_item--inner2 item-inner-wrap">
            <div class="thumb-overlay" style="<?php
            if(has_post_thumbnail()){
                printf('background-image:url(%s)', esc_attr(get_the_post_thumbnail_url( get_the_ID(), 'full' ) ) );
            }
            ?>"></div>
            <div class="blog_item--info clearfix">
                <?php
                helas_entry_meta_item_category_list('<div class="blog_item--category-link">', '</div>', '');
                ?>
                <header class="blog_item--title entry-header">
                    <?php the_title( sprintf( '<%s class="entry-title"><a href="%s">',$title_tag, esc_url( get_the_permalink() ) ), sprintf('</a></%s>', $title_tag) ); ?>
                </header>
                <div class="blog_item--meta entry-meta clearfix"><?php
                    helas_entry_meta_item_author();
                    helas_entry_meta_item_postdate();
                    ?></div><!-- .entry-meta -->
                <div class="blog_item--excerpt entry-excerpt">
                    <?php the_excerpt(); ?>
                </div>
                <footer class="blog_item--meta-footer clearfix">
                    <a class="btn btn-readmore" href="<?php the_permalink();?>"><?php echo esc_html_x('Read more', 'front-view', 'helas'); ?></a>
                </footer>
            </div>
        </div>
    </div>
</article>