<?php
global $helas_loop;
$loop_id            = isset($helas_loop['loop_id']) ? $helas_loop['loop_id'] : uniqid('la-show-portfolios-');
$layout             = isset($helas_loop['loop_layout']) ? $helas_loop['loop_layout'] : 'grid';
$style              = isset($helas_loop['loop_style']) ? $helas_loop['loop_style'] : 1;
$item_space         = isset($helas_loop['item_space']) ? $helas_loop['item_space'] : 0;
$responsive_column  = isset($helas_loop['responsive_column']) ? $helas_loop['responsive_column'] : array('xlg'=> 1, 'lg'=> 1,'md'=> 1,'sm'=> 1,'xs'=> 1);
$slider_configs     = isset($helas_loop['slider_configs']) ? $helas_loop['slider_configs'] : '';

$loopCssClass = array('la-loop','portfolios-loop');
$loopCssClass[] = 'pf-style-' . $style;
$loopCssClass[] = 'pf-' . $layout;
$loopCssClass[] = 'grid-space-'. $item_space;

if(!empty($slider_configs)){
    $loopCssClass[] = 'js-el la-slick-slider';
}else{
    $loopCssClass[] = 'grid-items';
    foreach( $responsive_column as $screen => $value ){
        $loopCssClass[]  =  sprintf('%s-grid-%s-items', $screen, $value);
    }
}

printf(
    '<div class="%1$s"%2$s>',
    esc_attr(implode(' ', $loopCssClass)),
    (!empty($slider_configs) ? ' data-la_component="AutoCarousel" ' . $slider_configs : '')
);