<?php
global $helas_loop;

$tmp = $helas_loop;

$loop_layout = Helas()->settings->get('portfolio_display_type', 'grid');
$loop_style = Helas()->settings->get('portfolio_display_style', '1');

$helas_loop['loop_layout'] = $loop_layout;
$helas_loop['loop_style'] = $loop_style;
$helas_loop['responsive_column'] = Helas()->settings->get('portfolio_column', array('xlg'=> 1, 'lg'=> 1,'md'=> 1,'sm'=> 1,'xs'=> 1));
$helas_loop['image_size'] = Helas_Helper::get_image_size_from_string(Helas()->settings->get('portfolio_thumbnail_size', 'full'),'full');
$helas_loop['title_tag'] = 'h4';
$helas_loop['excerpt_length'] = 15;
$helas_loop['item_gap'] = (int) Helas()->settings->get('portfolio_item_space', 0);

echo '<div id="archive_portfolio_listing" class="la-portfolio-listing">';

if( have_posts() ){

    get_template_part("templates/portfolios/{$loop_layout}/start", $loop_style);

    while( have_posts() ){

        the_post();

        get_template_part("templates/portfolios/{$loop_layout}/loop", $loop_style);

    }

    get_template_part("templates/portfolios/{$loop_layout}/end", $loop_style);

}

echo '</div>';
/**
 * Display pagination and reset loop
 */

helas_the_pagination();

wp_reset_postdata();

$helas_loop = $tmp;