<?php

global $helas_loop;

$blog_design            = isset($helas_loop['blog_design']) ? $helas_loop['blog_design'] : 'grid';
$title_tag              = 'h2';
$show_featured_image    = (Helas()->settings->get('featured_images_blog') == 'on') ? true : false;
$show_format_content    = false;
$tmp_img_size           = Helas_Helper::get_image_size_from_string(Helas()->settings->get('blog_thumbnail_size', 'full'), 'full');
$content_display_type   = ( Helas()->settings->get('blog_content_display', 'excerpt') == 'excerpt') ? 'excerpt' : 'full';
$post_class             = array('loop-item','grid-item', 'blog_item');

$style                  = str_replace('grid_', '', $blog_design);

if($show_featured_image){
    $show_format_content    = (Helas()->settings->get('format_content_blog') == 'on') ? true : false;
}

if($show_featured_image){
    $post_class[] = 'show-featured-image';
    if(!has_post_thumbnail()){
        $post_class[] = 'no-featured-image';
    }
}else{
    $post_class[] = 'hide-featured-image';
}
if($show_format_content){
    $post_class[] = 'show-format-content';
}else{
    $post_class[] = 'hide-format-content';
}
if($content_display_type != 'full' && !Helas()->settings->get('blog_excerpt_length')){
    $post_class[] = 'hide-excerpt';
}

$thumbnail_size = $tmp_img_size;

$loop_index = isset($helas_loop['loop_index']) ? $helas_loop['loop_index'] : 0;
$loop_index++;
$helas_loop['loop_index'] = $loop_index;


$thumbnail_size = apply_filters('helas/filter/blog/post_thumbnail', $thumbnail_size, $helas_loop);

if($style == '10'){
?>
    <article <?php post_class($post_class); ?>>
        <div class="blog_item--inner item-inner">
            <div class="blog_item--inner2 item-inner-wrap">
                <div class="thumb-overlay" style="<?php
                if($show_featured_image && has_post_thumbnail()){
                    printf('background-image:url(%s)', esc_attr(get_the_post_thumbnail_url( get_the_ID(), 'full' ) ) );
                }
                ?>"></div>
                <div class="blog_item--info clearfix">
                    <?php
                    helas_entry_meta_item_category_list('<div class="blog_item--category-link">', '</div>', '');
                    ?>
                    <header class="blog_item--title entry-header">
                        <?php the_title( sprintf( '<%s class="entry-title"><a href="%s">',$title_tag, esc_url( get_the_permalink() ) ), sprintf('</a></%s>', $title_tag) ); ?>
                    </header>
                    <div class="blog_item--meta entry-meta clearfix"><?php
                        helas_entry_meta_item_author();
                        helas_entry_meta_item_postdate();
                        ?></div><!-- .entry-meta -->
                    <div class="blog_item--excerpt entry-excerpt">
                        <?php the_excerpt(); ?>
                    </div>
                    <footer class="blog_item--meta-footer clearfix">
                        <a class="btn btn-readmore" href="<?php the_permalink();?>"><?php echo esc_html_x('Read more', 'front-view', 'helas'); ?></a>
                    </footer>
                </div>
            </div>
        </div>
    </article>
<?php
}
else{
?>
<article <?php post_class($post_class); ?>>
    <div class="blog_item--inner item-inner">
        <div class="blog_item--inner2 item-inner-wrap">
            <?php
            if($show_featured_image){
                $flag_format_content = false;
                if($show_format_content){
                    switch(get_post_format()){
                        case 'link':
                            $link = Helas()->settings->get_post_meta( get_the_ID(), 'format_link' );
                            if(!empty($link)){
                                printf(
                                    '<div class="blog_item--thumbnail format-link">%2$s<div class="format-content">%1$s</div><a class="post-link-overlay" href="%1$s"></a></div>',
                                    esc_url($link),
                                    (has_post_thumbnail() ? Helas()->images->get_post_thumbnail(get_the_ID(), $thumbnail_size) : '')
                                );
                                $flag_format_content = true;
                            }
                            break;
                        case 'quote':
                            $quote_content = Helas()->settings->get_post_meta(get_the_ID(), 'format_quote_content');
                            $quote_author = Helas()->settings->get_post_meta(get_the_ID(), 'format_quote_author');
                            $quote_background = Helas()->settings->get_post_meta(get_the_ID(), 'format_quote_background');
                            $quote_color = Helas()->settings->get_post_meta(get_the_ID(), 'format_quote_color');
                            if(!empty($quote_content)){
                                $quote_content = '<p class="format-quote-content">'. $quote_content .'</p>';
                                if(!empty($quote_author)){
                                    $quote_content .= '<span class="quote-author">'. $quote_author .'</span>';
                                }
                                $styles = array();
                                $styles[] = 'background-color:' . $quote_background;
                                $styles[] = 'color:' . $quote_color;
                                if(has_post_thumbnail()){
                                    $styles[] = 'background-image: url(' . get_the_post_thumbnail_url(get_the_ID(), 'full') . ')';
                                }
                                printf(
                                    '<div class="blog_item--thumbnail format-quote"><div class="fq-wrapper" style="%3$s">%4$s<div class="format-content">%1$s</div><a class="post-link-overlay" href="%2$s"></a></div></div>',
                                    $quote_content,
                                    get_the_permalink(),
                                    esc_attr( implode(';', $styles) ),
                                    (has_post_thumbnail() ? Helas()->images->get_post_thumbnail(get_the_ID(), $thumbnail_size) : '')
                                );
                                $flag_format_content = true;
                            }

                            break;

                        case 'gallery':
                            $ids = Helas()->settings->get_post_meta(get_the_ID(), 'format_gallery');
                            $ids = explode(',', $ids);
                            $ids = array_map('trim', $ids);
                            $ids = array_map('absint', $ids);
                            $__tmp = '';

                            if(has_post_thumbnail()){
                                $__tmp .= sprintf('<div><a href="%1$s">%2$s</a></div>',
                                    get_the_permalink(),
                                    Helas()->images->get_post_thumbnail(get_the_ID(), $thumbnail_size )
                                );
                            }

                            if(!empty( $ids )){
                                foreach($ids as $image_id){
                                    $__tmp .= sprintf('<div><a href="%1$s">%2$s</a></div>',
                                        get_the_permalink(),
                                        Helas()->images->get_attachment_image( $image_id, $thumbnail_size)
                                    );
                                }
                            }

                            if(!empty($__tmp)){
                                printf(
                                    '<div class="blog_item--thumbnail format-gallery"><div data-la_component="AutoCarousel" class="js-el la-slick-slider" data-slider_config="%1$s">%2$s</div></div>',
                                    esc_attr(json_encode(array(
                                        'slidesToShow' => 1,
                                        'slidesToScroll' => 1,
                                        'dots' => false,
                                        'arrows' => true,
                                        'speed' => 300,
                                        'autoplay' => false,
                                        'fade' => true,
                                        'prevArrow'=> '<button type="button" class="slick-prev"><i class="fa fa-angle-left"></i></button>',
                                        'nextArrow'=> '<button type="button" class="slick-next"><i class="fa fa-angle-right"></i></button>'
                                    ))),
                                    $__tmp
                                );
                                $flag_format_content = true;
                            }
                            break;

                    }
                }
                if(!$flag_format_content && has_post_thumbnail()){ ?>
                    <div class="blog_item--thumbnail blog_item--thumbnail-with-effect">
                        <a href="<?php the_permalink();?>">
                            <?php Helas()->images->the_post_thumbnail(get_the_ID(), $thumbnail_size); ?>
                            <span class="pf-icon pf-icon-<?php echo get_post_format() ? get_post_format() : 'standard' ?>"></span>
                            <div class="item--overlay"></div>
                        </a>
                    </div>
                    <?php
                }
            }
            ?>
            <div class="blog_item--info clearfix">
                <?php
                if( $style == 2 || $style == 7) {
                    helas_entry_meta_item_category_list('<div class="blog_item--category-link">', '</div>', '');
                }
                ?>
                <header class="blog_item--title entry-header">
                    <?php the_title( sprintf( '<%s class="entry-title"><a href="%s">',$title_tag, esc_url( get_the_permalink() ) ), sprintf('</a></%s>', $title_tag) ); ?>
                </header>
                <div class="blog_item--meta entry-meta clearfix"><?php
                    if($style == 3){
                        helas_entry_meta_item_postdate();
                    }
                    helas_entry_meta_item_author();

                    if($style != 3){
                        helas_entry_meta_item_postdate();
                    }

                    if( $style == 1 || $style == 5 || $style == 9 || $style == 6 ) {
                        helas_entry_meta_item_category_list('<div class="blog_item--category-link">','</div>','');
                    }
                    ?></div><!-- .entry-meta -->
                <?php

                if($content_display_type != 'full'){
                    if( Helas()->settings->get('blog_excerpt_length') ){
                        echo '<div class="blog_item--excerpt entry-excerpt">';
                        the_excerpt();
                        echo '</div>';
                    }
                }
                else{
                    echo '<div class="blog_item--excerpt entry-content">';
                    the_content( esc_html_x( 'Continue reading', 'front-view', 'helas' ) );
                    wp_link_pages( array(
                        'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html_x( 'Pages:', 'front-view', 'helas' ) . '</span>',
                        'after'       => '</div>',
                        'link_before' => '<span>',
                        'link_after'  => '</span>',
                        'pagelink'    => '<span class="screen-reader-text">' . esc_html_x( 'Page', 'front-view', 'helas' ) . ' </span>%',
                        'separator'   => '<span class="screen-reader-text">, </span>',
                    ) );
                    echo '</div>';
                }
                ?>
                <?php if($content_display_type != 'full' && Helas()->settings->get('blog_excerpt_length') ) :?>
                    <footer class="blog_item--meta-footer clearfix">
                        <a class="btn btn-readmore" href="<?php the_permalink();?>"><?php echo esc_html_x('Read more', 'front-view', 'helas'); ?></a>
                        <?php if( in_array($style, array(2,3,7)) ) :?>
                            <div class="la-sharing-posts">
                                <span><i class="fa fa-share-alt"></i><span><?php echo esc_html_x('Share post', 'front-view', 'helas'); ?></span></span>
                                <?php helas_social_sharing(get_the_permalink(), get_the_title(), (has_post_thumbnail() ? get_the_post_thumbnail_url(get_the_ID(), 'full') : '')); ?>
                            </div>
                            <?php
                            if( $style != 3 ){
                                helas_get_favorite_link();
                                helas_entry_meta_item_comment_post_link_with_icon();
                            }
                            ?>
                        <?php endif; ?>
                    </footer>
                <?php endif; ?>
            </div>
        </div>
    </div>
</article>
<?php
}