<?php
add_action( 'tgmpa_register', 'helas_register_required_plugins' );

if(!function_exists('helas_register_required_plugins')){

	function helas_register_required_plugins() {

        $initial_required = array(
            'lastudio-core' => array(
                'source'    => 'https://la-studioweb.com/file-resouces/helas/plugins/lastudio-core/3.1.6/lastudio-core.zip',
                'version'   => '3.1.6'
            ),
            'helas-demo-data' => array(
                'source'    => 'https://la-studioweb.com/file-resouces/helas/plugins/helas-demo-data/1.0.0/helas-demo-data.zip',
                'version'   => '1.0.0'
            ),
            'revslider' => array(
                'source'    => 'https://la-studioweb.com/file-resouces/shared/plugins/revslider/6.0.6/revslider.zip',
                'version'   => '6.0.6'
            ),
            'js_composer' => array(
                'source'    => 'https://la-studioweb.com/file-resouces/shared/plugins/js_composer/6.0.5/js_composer.zip',
                'version'   => '6.0.5'
            )
        );

        $from_option = get_option('helas_required_plugins_list', $initial_required);

		$plugins = array();

		$plugins[] = array(
			'name'					=> esc_html_x('WPBakery Visual Composer', 'admin-view', 'helas'),
			'slug'					=> 'js_composer',
            'source'				=> isset($from_option['js_composer'], $from_option['js_composer']['source']) ? $from_option['js_composer']['source'] : $initial_required['js_composer']['source'],
            'required'				=> true,
            'version'				=> isset($from_option['js_composer'], $from_option['js_composer']['version']) ? $from_option['js_composer']['version'] : $initial_required['js_composer']['version']
		);

		$plugins[] = array(
			'name'					=> esc_html_x('LA Studio Core', 'admin-view', 'helas'),
			'slug'					=> 'lastudio-core',
            'source'				=> isset($from_option['lastudio-core'], $from_option['lastudio-core']['source']) ? $from_option['lastudio-core']['source'] : $initial_required['lastudio-core']['source'],
            'required'				=> true,
            'version'				=> isset($from_option['lastudio-core'], $from_option['lastudio-core']['version']) ? $from_option['lastudio-core']['version'] : $initial_required['lastudio-core']['version']
		);

		$plugins[] = array(
			'name'					=> esc_html_x('Helas Package Demo Data', 'admin-view', 'helas'),
			'slug'					=> 'helas-demo-data',
            'source'				=> isset($from_option['helas-demo-data'], $from_option['helas-demo-data']['source']) ? $from_option['helas-demo-data']['source'] : $initial_required['helas-demo-data']['source'],
            'required'				=> true,
            'version'				=> isset($from_option['helas-demo-data'], $from_option['helas-demo-data']['version']) ? $from_option['helas-demo-data']['version'] : $initial_required['helas-demo-data']['version']
		);

		$plugins[] = array(
			'name'     				=> esc_html_x('WooCommerce', 'admin-view', 'helas'),
			'slug'     				=> 'woocommerce',
			'version'				=> '3.6.5',
			'required' 				=> false
		);

		$plugins[] = array(
			'name'					=> esc_html_x('Slider Revolution', 'admin-view', 'helas'),
			'slug'					=> 'revslider',
            'source'				=> isset($from_option['revslider'], $from_option['revslider']['source']) ? $from_option['revslider']['source'] : $initial_required['revslider']['source'],
            'required'				=> false,
            'version'				=> isset($from_option['revslider'], $from_option['revslider']['version']) ? $from_option['revslider']['version'] : $initial_required['revslider']['version']
		);

		$plugins[] = array(
			'name'     				=> esc_html_x('Envato Market', 'admin-view', 'helas'),
			'slug'     				=> 'envato-market',
			'source'   				=> 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
			'required' 				=> false,
			'version' 				=> '2.0.1'
		);

		$plugins[] = array(
			'name' 					=> esc_html_x('Contact Form 7', 'admin-view', 'helas'),
			'slug' 					=> 'contact-form-7',
			'required' 				=> false
		);

		$plugins[] = array(
			'name' 					=> esc_html_x('Easy Forms for MailChimp by YIKES', 'admin-view', 'helas'),
			'slug' 					=> 'yikes-inc-easy-mailchimp-extender',
			'required' 				=> false
		);

		$config = array(
			'id'           				=> 'helas',
			'default_path' 				=> '',
			'menu'         				=> 'tgmpa-install-plugins',
			'has_notices'  				=> true,
			'dismissable'  				=> true,
			'dismiss_msg'  				=> '',
			'is_automatic' 				=> false,
			'message'      				=> ''
		);

		tgmpa( $plugins, $config );

	}

}