<?php

/**
 * Require plugins vendor
 */

require_once get_template_directory() . '/plugins/tgm-plugin-activation/class-tgm-plugin-activation.php';
require_once get_template_directory() . '/plugins/plugins.php';

/**
 * Include the main class.
 */

include_once get_template_directory() . '/framework/classes/class-core.php';


Helas::$template_dir_path   = get_template_directory();
Helas::$template_dir_url    = get_template_directory_uri();
Helas::$stylesheet_dir_path = get_stylesheet_directory();
Helas::$stylesheet_dir_url  = get_stylesheet_directory_uri();

/**
 * Include the autoloader.
 */
include_once Helas::$template_dir_path . '/framework/classes/class-autoload.php';

new Helas_Autoload();

/**
 * load functions for later usage
 */

require_once Helas::$template_dir_path . '/framework/functions/functions.php';

new Helas_Multilingual();

if(!function_exists('helas_init_options')){
    function helas_init_options(){
        Helas::$options = Helas_Options::get_instance();
    }
    helas_init_options();
}

if(!function_exists('Helas')){
    function Helas(){
        return Helas::get_instance();
    }
}

new Helas_Scripts();

new Helas_Admin();

new Helas_WooCommerce();

new Helas_WooCommerce_Wishlist();

new Helas_WooCommerce_Compare();

Helas_Visual_Composer::get_instance();

/**
 * Set the $content_width global.
 */
global $content_width;
if ( ! is_admin() ) {
    if ( ! isset( $content_width ) || empty( $content_width ) ) {
        $content_width = (int) Helas()->layout->get_content_width();
    }
}

require_once Helas::$template_dir_path . '/framework/functions/extra-functions.php';

require_once Helas::$template_dir_path . '/framework/functions/update.php';