<?php

/**
 * This function allow get property of `woocommerce_loop` inside the loop
 * @since 1.0.1
 * @param string $prop Prop to get.
 * @param string $default Default if the prop does not exist.
 * @return mixed
 */

if(!function_exists('helas_get_wc_loop_prop')){
    function helas_get_wc_loop_prop( $prop, $default = ''){
        return isset( $GLOBALS['woocommerce_loop'], $GLOBALS['woocommerce_loop'][ $prop ] ) ? $GLOBALS['woocommerce_loop'][ $prop ] : $default;
    }
}

/**
 * This function allow set property of `woocommerce_loop`
 * @since 1.0.1
 * @param string $prop Prop to set.
 * @param string $value Value to set.
 */

if(!function_exists('helas_set_wc_loop_prop')){
    function helas_set_wc_loop_prop( $prop, $value = ''){
        if(isset($GLOBALS['woocommerce_loop'])){
            $GLOBALS['woocommerce_loop'][ $prop ] = $value;
        }
    }
}

/**
 * This function allow get property of `helas_loop` inside the loop
 * @since 1.0.1
 * @param string $prop Prop to get.
 * @param string $default Default if the prop does not exist.
 * @return mixed
 */

if(!function_exists('helas_get_theme_loop_prop')){
    function helas_get_theme_loop_prop( $prop, $default = ''){
        return isset( $GLOBALS['helas_loop'], $GLOBALS['helas_loop'][ $prop ] ) ? $GLOBALS['helas_loop'][ $prop ] : $default;
    }
}

remove_filter( 'woocommerce_product_loop_start', 'woocommerce_maybe_show_product_subcategories' );


if(!function_exists('helas_override_yikes_mailchimp_page_data')){
    function helas_override_yikes_mailchimp_page_data($page_data, $form_id){
        $new_data = new stdClass();
        if(isset($page_data->ID)){
            $new_data->ID = $page_data->ID;
        }
        return $new_data;
    }
    add_filter('yikes-mailchimp-page-data', 'helas_override_yikes_mailchimp_page_data', 10, 2);
}

if( !function_exists('helas_allow_shortcode_text_in_component_text') ) {
    function helas_allow_shortcode_text_in_component_text( $text ){
        return do_shortcode($text);
    }
    add_filter('helas/filter/component/text', 'helas_allow_shortcode_text_in_component_text');
}

if(!function_exists('helas_add_ajax_cart_btn_into_single_product')){
    function helas_add_ajax_cart_btn_into_single_product(){
        global $product;
        if($product->is_type('simple')){
            echo '<div class="wrap-single-addcart hidden">';
            woocommerce_template_loop_add_to_cart();
            echo '</div>';
        }
    }
    add_action('woocommerce_after_add_to_cart_button', 'helas_add_ajax_cart_btn_into_single_product');
}

if ( ! function_exists( 'woocommerce_template_loop_product_title' ) ) {
    function woocommerce_template_loop_product_title() {
        the_title( sprintf( '<h3 class="product_item--title"><a href="%s">', esc_url( get_the_permalink() ) ), '</a></h3>' );
    }
}

if(!function_exists('helas_override_woothumbnail_size')){
    function helas_override_woothumbnail_size( $size ) {
        if(!function_exists('wc_get_theme_support')){
            return $size;
        }
        $size['width'] = absint( wc_get_theme_support( 'gallery_thumbnail_image_width', 100 ) );
        $cropping      = get_option( 'woocommerce_thumbnail_cropping', '1:1' );

        if ( 'uncropped' === $cropping ) {
            $size['height'] = '';
            $size['crop']   = 0;
        }
        elseif ( 'custom' === $cropping ) {
            $width          = max( 1, get_option( 'woocommerce_thumbnail_cropping_custom_width', '4' ) );
            $height         = max( 1, get_option( 'woocommerce_thumbnail_cropping_custom_height', '3' ) );
            $size['height'] = absint( round( ( $size['width'] / $width ) * $height ) );
            $size['crop']   = 1;
        }
        else {
            $cropping_split = explode( ':', $cropping );
            $width          = max( 1, current( $cropping_split ) );
            $height         = max( 1, end( $cropping_split ) );
            $size['height'] = absint( round( ( $size['width'] / $width ) * $height ) );
            $size['crop']   = 1;
        }

        return $size;
    }
    add_filter('woocommerce_get_image_size_gallery_thumbnail', 'helas_override_woothumbnail_size');
}

if(!function_exists('helas_override_filter_woocommerce_format_content')){
    function helas_override_filter_woocommerce_format_content( $format, $raw_string ){
        $format = preg_replace("~(?:\[/?)[^/\]]+/?\]~s", '', $raw_string);
        return apply_filters( 'woocommerce_short_description', $format );
    }
    add_filter('woocommerce_format_content', 'helas_override_filter_woocommerce_format_content', 99, 2);
}

if(!function_exists('helas_wc_product_loop')){
    function helas_wc_product_loop(){
        if(!function_exists('WC')){
            return false;
        }
        return have_posts() || 'products' !== woocommerce_get_loop_display_mode();
    }
}