<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
    exit( 'Direct script access denied.' );
}

class Helas_Admin {

    public function __construct(){
        $this->init_page_options();
        $this->init_meta_box();
        $this->init_shortcode_manager();
        Helas_MegaMenu_Init::get_instance();
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts') );
        add_action( 'customize_register', array( $this, 'override_customize_control') );
        add_action( 'registered_post_type', array( $this, 'remove_revslider_metabox') );
        add_action( 'admin_init', array( $this, 'admin_init' ) );
        add_action( 'admin_menu', array( $this, 'admin_menu') );

        add_filter('lastudio/filter/framework/field/icon/json', array( $this, 'add_icon_to_fw'));
    }

    public function admin_scripts(){
        wp_enqueue_style('helas-admin-css', Helas::$template_dir_url. '/assets/admin/css/admin.css');
        wp_enqueue_script('helas-admin-theme', Helas::$template_dir_url . '/assets/admin/js/admin.js', array( 'jquery'), false, true );
        $asset_font_without_domain = apply_filters('helas/filter/assets_font_url', helas_get_relative_url(untrailingslashit(get_template_directory_uri())));
        wp_add_inline_style(
            "helas-admin-css",
            "@font-face{
                font-family: 'dl-icon';
                src: url('{$asset_font_without_domain}/assets/fonts/dl-icon.eot');
                src: url('{$asset_font_without_domain}/assets/fonts/dl-icon.eot') format('embedded-opentype'),
                     url('{$asset_font_without_domain}/assets/fonts/dl-icon.woff') format('woff'),
                     url('{$asset_font_without_domain}/assets/fonts/dl-icon.ttf') format('truetype'),
                     url('{$asset_font_without_domain}/assets/fonts/dl-icon.svg') format('svg');
                font-weight:normal;
                font-style:normal
            }"
        );
    }

    public function add_icon_to_fw( $icon_path ) {
        $icon_path[] = Helas::$template_dir_path . '/assets/fonts/dl-icon.json';
        return $icon_path;
    }

    public function init_page_options(){
        $options = !empty(Helas()->options()->sections) ? Helas()->options()->sections : array();
        if(class_exists('LaStudio_Options')) {
            $settings = array(
                'menu_title' => esc_html_x('Theme Options', 'admin-view', 'helas'),
                'menu_type' => 'theme',
                'menu_slug' => 'theme_options',
                'ajax_save' => false,
                'show_reset_all' => true,
                'disable_header' => false,
                'framework_title' => esc_html_x('Helas', 'admin-view', 'helas')
            );
            if(!empty($options)){
                LaStudio_Options::instance( $settings, $options, Helas::get_option_name());
            }
        }
        if(class_exists('LaStudio_Customize') && function_exists('la_convert_option_to_customize')){
            if(!empty($options)){
                $customize_options = la_convert_option_to_customize($options);
                LaStudio_Customize::instance( $customize_options, Helas::get_option_name());
            }
        }
    }

    public function init_meta_box(){


        $default_metabox_opts = !empty(Helas()->options()->metabox_sections) ? Helas()->options()->metabox_sections : array();

        if(!class_exists('LaStudio_Metabox')){
            return;
        }
        if(empty($default_metabox_opts)){
            return;
        }

        $metaboxes = array();
        $taxonomy_metaboxes = array();

        /**
         * Pages
         */
        $metaboxes[] = array(
            'id'        => Helas::get_original_option_name(),
            'title'     => esc_html_x('Page Options', 'admin-view', 'helas'),
            'post_type' => 'page',
            'context'   => 'normal',
            'priority'  => 'high',
            'sections'  => Helas()->options()->get_metabox_by_sections(array(
                'layout',
                'header',
                'page_title_bar',
                'footer',
                'additional',
                'fullpage'
            ))
        );

        /**
         * Post
         */
        $metaboxes[] = array(
            'id'        => Helas::get_original_option_name(),
            'title'     => esc_html_x('Post Options', 'admin-view', 'helas'),
            'post_type' => 'post',
            'context'   => 'normal',
            'priority'  => 'high',
            'sections'  => Helas()->options()->get_metabox_by_sections(array(
                'post',
                'layout',
                'header',
                'page_title_bar',
                'footer',
                'additional'
            ))
        );

        /**
         * Product
         */
        $metaboxes[] = array(
            'id'        => Helas::get_original_option_name(),
            'title'     => esc_html_x('Product View Options', 'admin-view', 'helas'),
            'post_type' => 'product',
            'context'   => 'normal',
            'priority'  => 'default',
            'sections'  => Helas()->options()->get_metabox_by_sections(array(
                //'product',
                'layout',
                'header',
                'page_title_bar',
                'footer',
                'additional'
            ))
        );

        /**
         * Portfolio
         */
        $metaboxes[] = array(
            'id'        => Helas::get_original_option_name(),
            'title'     => esc_html_x('Portfolio Options', 'admin-view', 'helas'),
            'post_type' => 'la_portfolio',
            'context'   => 'normal',
            'priority'  => 'high',
            'sections'  => Helas()->options()->get_metabox_by_sections(array(
                'layout',
                'header',
                'page_title_bar',
                'footer',
                'additional'
            ))
        );

        /**
         * Testimonial
         */
        $metaboxes[] = array(
            'id'        => Helas::get_original_option_name(),
            'title'     => esc_html_x('Testimonial Information', 'admin-view', 'helas'),
            'post_type' => 'la_testimonial',
            'context'   => 'normal',
            'priority'  => 'high',
            'sections'  => Helas()->options()->get_metabox_by_sections(array(
                'testimonial'
            ))
        );

        /**
         * Member
         */
        $metaboxes[] = array(
            'id'        => Helas::get_original_option_name(),
            'title'     => esc_html_x('Page Options', 'admin-view', 'helas'),
            'post_type' => 'la_team_member',
            'context'   => 'normal',
            'priority'  => 'high',
            'sections'  => Helas()->options()->get_metabox_by_sections(array(
                'member',
                'layout',
                'header',
                'page_title_bar',
                'footer',
                'additional'
            ))
        );

        /**
         * Product Category
         */
        $taxonomy_metaboxes[] = array(
            'id'        => Helas::get_original_option_name(),
            'title'     => esc_html_x('Product Category Options', 'admin-view', 'helas'),
            'taxonomy' => 'product_cat',
            'sections'  => Helas()->options()->get_metabox_by_sections(array(
                'layout',
                'header',
                'page_title_bar',
                'footer',
                'additional'
            ))
        );

        /**
         * Category
         */
        $taxonomy_metaboxes[] = array(
            'id'        => Helas::get_original_option_name(),
            'title'     => esc_html_x('Category Options', 'admin-view', 'helas'),
            'taxonomy' => 'category',
            'sections'  => Helas()->options()->get_metabox_by_sections(array(
                'layout',
                'header',
                'page_title_bar',
                'footer',
                'additional'
            ))
        );
        LaStudio_Metabox::instance($metaboxes);
        LaStudio_Taxonomy::instance($taxonomy_metaboxes);
    }

    public function init_shortcode_manager(){
        if(class_exists('LaStudio_Shortcode_Manager')){
            $options       = array();
            $options[]     = array(
                'title'      => esc_html_x('La Shortcodes', 'admin-view', 'helas'),
                'shortcodes' => array(
                    array(
                        'name'      => 'la_text',
                        'title'     => esc_html_x('Custom Text', 'admin-view', 'helas'),
                        'fields'    => array(
                            array(
                                'id'    => 'color',
                                'type'  => 'color_picker',
                                'title' => esc_html_x('Color', 'admin-view', 'helas')
                            ),
                            array(
                                'id'        => 'font_size',
                                'type'      => 'responsive',
                                'title'     => esc_html_x('Font Size', 'admin-view', 'helas'),
                                'desc'      => esc_html_x('Enter the font size (ie 20px )', 'admin-view', 'helas')
                            ),
                            array(
                                'id'        => 'line_height',
                                'type'      => 'responsive',
                                'title'     => esc_html_x('Line Height', 'admin-view', 'helas'),
                                'desc'      => esc_html_x('Enter the line height (ie 20px )', 'admin-view', 'helas')
                            ),
                            array(
                                'id'    => 'el_class',
                                'type'  => 'text',
                                'title' => esc_html_x('Extra Class Name', 'admin-view', 'helas')
                            ),
                            array(
                                'id'    => 'content',
                                'type'  => 'textarea',
                                'title' => esc_html_x('Content', 'admin-view', 'helas')
                            )
                        )
                    ),
                    array(
                        'name'      => 'la_btn',
                        'title'     => esc_html_x('Button', 'admin-view', 'helas'),
                        'fields'    => array(
                            array(
                                'id'    => 'title',
                                'type'  => 'text',
                                'title' => esc_html_x('Text', 'admin-view', 'helas'),
                                'default' => esc_html_x('Text on the button', 'admin-view', 'helas')
                            ),
                            array(
                                'id'        => 'link',
                                'type'      => 'fieldset',
                                'title'     => esc_html_x('URL (Link)', 'admin-view', 'helas'),
                                'desc'      => esc_html_x('Add link to button.', 'admin-view', 'helas'),
                                'before'    => '<div data-parent-atts="1" data-atts="link" data-atts-separator="|">',
                                'after'     => '</div>',
                                'fields'    => array(
                                    array(
                                        'id'    => 'url',
                                        'type'  => 'text',
                                        'title' => esc_html_x('URL', 'admin-view', 'helas'),
                                        'default' => '#',
                                        'attributes' => array(
                                            'data-child-atts' => 'url'
                                        )
                                    ),
                                    array(
                                        'id'    => 'title',
                                        'type'  => 'text',
                                        'title' => esc_html_x('Link Text', 'admin-view', 'helas'),
                                        'attributes' => array(
                                            'data-child-atts' => 'title'
                                        )
                                    ),
                                    array(
                                        'id'        => 'target',
                                        'type'      => 'radio',
                                        'default'   => '_self',
                                        'class'     => 'la-radio-style',
                                        'title'     => esc_html_x('Open link in a new tab', 'admin-view', 'helas'),
                                        'options'   => array(
                                            '_self' => esc_html_x('No', 'admin-view', 'helas'),
                                            '_blank' => esc_html_x('Yes', 'admin-view', 'helas')
                                        ),
                                        'attributes' => array(
                                            'data-child-atts' => 'target',
                                            'data-check' => 'yes'
                                        )
                                    ),
                                ),
                            ),

                            array(
                                'id'    => 'style',
                                'type'  => 'select',
                                'title' => esc_html_x('Style', 'admin-view', 'helas'),
                                'desc'  => esc_html_x('Select button display style.', 'admin-view', 'helas'),
                                'options'        => array(
                                    'flat'          => esc_html_x('Flat', 'admin-view', 'helas'),
                                    'outline'       => esc_html_x('Outline', 'admin-view', 'helas'),
                                ),
                                'default' => 'flat'
                            ),
                            array(
                                'id'    => 'border_width',
                                'type'  => 'select',
                                'title' => esc_html_x('Border width', 'admin-view', 'helas'),
                                'desc'  => esc_html_x('Select border width.', 'admin-view', 'helas'),
                                'options'        => array(
                                    '0'       => esc_html_x('None', 'admin-view', 'helas'),
                                    '1'       => esc_html_x('1px', 'admin-view', 'helas'),
                                    '2'       => esc_html_x('2px', 'admin-view', 'helas'),
                                    '3'       => esc_html_x('3px', 'admin-view', 'helas')
                                ),
                                'default' => 'square'
                            ),
                            array(
                                'id'    => 'shape',
                                'type'  => 'select',
                                'title' => esc_html_x('Shape', 'admin-view', 'helas'),
                                'desc'  => esc_html_x('Select button shape.', 'admin-view', 'helas'),
                                'options'        => array(
                                    'rounded'   => esc_html_x('Rounded', 'admin-view', 'helas'),
                                    'square'    => esc_html_x('Square', 'admin-view', 'helas'),
                                    'round'     => esc_html_x('Round', 'admin-view', 'helas')
                                ),
                                'default' => 'square'
                            ),
                            array(
                                'id'    => 'color',
                                'type'  => 'select',
                                'title' => esc_html_x('Color', 'admin-view', 'helas'),
                                'desc'  => esc_html_x('Select button color.', 'admin-view', 'helas'),
                                'options'        => array(
                                    'black'      => esc_html_x('Black', 'admin-view', 'helas'),
                                    'primary'    => esc_html_x('Primary', 'admin-view', 'helas'),
                                    'white'      => esc_html_x('White', 'admin-view', 'helas'),
                                    'white2'     => esc_html_x('White2', 'admin-view', 'helas'),
                                    'gray'       => esc_html_x('Gray', 'admin-view', 'helas'),
                                ),
                                'default' => 'black'
                            ),
                            array(
                                'id'    => 'size',
                                'type'  => 'select',
                                'title' => esc_html_x('Size', 'admin-view', 'helas'),
                                'desc'  => esc_html_x('Select button display size.', 'admin-view', 'helas'),
                                'options'        => array(
                                    'md'    => esc_html_x('Normal', 'admin-view', 'helas'),
                                    'lg'    => esc_html_x('Large', 'admin-view', 'helas'),
                                    'sm'    => esc_html_x('Small', 'admin-view', 'helas'),
                                    'xs'    => esc_html_x('Mini', 'admin-view', 'helas')
                                ),
                                'default' => 'md'
                            ),
                            array(
                                'id'    => 'align',
                                'type'  => 'select',
                                'title' => esc_html_x('Alignment', 'admin-view', 'helas'),
                                'desc'  => esc_html_x('Select button alignment.', 'admin-view', 'helas'),
                                'options'        => array(
                                    'inline'    => esc_html_x('Inline', 'admin-view', 'helas'),
                                    'left'      => esc_html_x('Left', 'admin-view', 'helas'),
                                    'right'     => esc_html_x('Right', 'admin-view', 'helas'),
                                    'center'    => esc_html_x('Center', 'admin-view', 'helas')
                                ),
                                'default' => 'left'
                            ),
                            array(
                                'id'    => 'el_class',
                                'type'  => 'text',
                                'title' => esc_html_x('Extra Class Name', 'admin-view', 'helas'),
                                'desc' => esc_html_x('Style particular content element differently - add a class name and refer to it in custom CSS.', 'admin-view', 'helas')
                            )
                        )
                    ),
                    array(
                        'name'      => 'la_dropcap',
                        'title'     => esc_html_x('DropCap', 'admin-view', 'helas'),
                        'fields'    => array(
                            array(
                                'id'    => 'style',
                                'type'  => 'select',
                                'title' => esc_html_x('Design', 'admin-view', 'helas'),
                                'options'        => array(
                                    '1'          => esc_html_x('Style 1', 'admin-view', 'helas')
                                )
                            ),
                            array(
                                'id'    => 'color',
                                'type'  => 'color_picker',
                                'title' => esc_html_x('Text Color', 'admin-view', 'helas')
                            ),
                            array(
                                'id'    => 'content',
                                'type'  => 'text',
                                'title' => esc_html_x('Content', 'admin-view', 'helas')
                            )
                        )
                    ),
                    array(
                        'name'      => 'la_quote',
                        'title'     => esc_html_x('Custom Quote', 'admin-view', 'helas'),
                        'fields'    => array(
                            array(
                                'id'    => 'style',
                                'type'  => 'select',
                                'title' => esc_html_x('Design', 'admin-view', 'helas'),
                                'options'        => array(
                                    '1'          => esc_html_x('Style 1', 'admin-view', 'helas'),
                                    '2'          => esc_html_x('Style 2', 'admin-view', 'helas'),
                                    '3'          => esc_html_x('Style 3', 'admin-view', 'helas')
                                )
                            ),
                            array(
                                'id'    => 'author',
                                'type'  => 'text',
                                'title' => esc_html_x('Source Name', 'admin-view', 'helas')
                            ),
                            array(
                                'id'    => 'link',
                                'type'  => 'text',
                                'title' => esc_html_x('Source Link', 'admin-view', 'helas')
                            ),
                            array(
                                'id'    => 'content',
                                'type'  => 'textarea',
                                'title' => esc_html_x('Content', 'admin-view', 'helas')
                            )
                        )
                    ),
                    array(
                        'name'          => 'la_icon_list',
                        'title'         => esc_html_x('Icon List', 'admin-view', 'helas'),
                        'view'          => 'clone',
                        'clone_id'      => 'la_icon_list_item',
                        'clone_title'   => esc_html_x('Add New', 'admin-view', 'helas'),
                        'fields'        => array(
                            array(
                                'id'        => 'el_class',
                                'type'      => 'text',
                                'title'     => esc_html_x('Extra Class', 'admin-view', 'helas'),
                                'desc'      => esc_html_x('Style particular content element differently - add a class name and refer to it in custom CSS.', 'admin-view', 'helas'),
                            )
                        ),
                        'clone_fields'  => array(
                            array(
                                'id'        => 'icon',
                                'type'      => 'icon',
                                'default'   => 'fa fa-check',
                                'title'     => esc_html_x('Icon', 'admin-view', 'helas')
                            ),
                            array(
                                'id'        => 'icon_color',
                                'type'      => 'color_picker',
                                'title'     => esc_html_x('Icon Color', 'admin-view', 'helas')
                            ),
                            array(
                                'id'        => 'content',
                                'type'      => 'textarea',
                                'title'     => esc_html_x('Content', 'admin-view', 'helas')
                            ),
                            array(
                                'id'        => 'el_class',
                                'type'      => 'text',
                                'title'     => esc_html_x('Extra Class', 'admin-view', 'helas'),
                                'desc'     => esc_html_x('Style particular content element differently - add a class name and refer to it in custom CSS.', 'admin-view', 'helas'),
                            )
                        )
                    ),
                )
            );
            LaStudio_Shortcode_Manager::instance( $options );
        }
    }

    public function remove_revslider_metabox($post_type){
        add_action('do_meta_boxes', function () use ($post_type) {
            remove_meta_box('mymetabox_revslider_0', $post_type, 'normal');
        });
    }

    public function admin_menu(){
        /*
         * @Todo remove the submenu items
         * @Example: Custom Header,Custom Background
         * We need use global variable `$submenu`
         */

    }

    public function override_customize_control( $wp_customize ) {
        $wp_customize->remove_section('colors');
        $wp_customize->remove_section('header_image');
        $wp_customize->remove_section('background_image');
        $wp_customize->remove_control('display_header_text');
        $wp_customize->remove_control('site_icon');
    }


    public function admin_init(){
        add_filter('tiny_mce_before_init', array( $this, 'add_control_to_tinymce'));
        add_filter('mce_buttons_2', array( $this, 'add_button_to_tinymce'));
    }

    public function add_button_to_tinymce($buttons){
        array_unshift($buttons, 'styleselect');
        return $buttons;
    }

    public function add_control_to_tinymce($settings){
        $style_formats = array(
            array(
                'title' => esc_html_x('Styled Subtitle', 'admin-view', 'helas'),
                'inline' => 'small',
                'classes' => 'small'
            ),
            array(
                'title' => esc_html_x('Title H1', 'admin-view', 'helas'),
                'block' => 'div',
                'classes' => 'h1'
            ),
            array(
                'title' => esc_html_x('Title H2', 'admin-view', 'helas'),
                'block' => 'div',
                'classes' => 'h2'
            ),
            array(
                'title' => esc_html_x('Title H3', 'admin-view', 'helas'),
                'block' => 'div',
                'classes' => 'h3'
            ),
            array(
                'title' => esc_html_x('Title H4', 'admin-view', 'helas'),
                'block' => 'div',
                'classes' => 'h4'
            ),
            array(
                'title' => esc_html_x('Title H5', 'admin-view', 'helas'),
                'block' => 'div',
                'classes' => 'h5'
            ),
            array(
                'title' => esc_html_x('Title H6', 'admin-view', 'helas'),
                'block' => 'div',
                'classes' => 'h6'
            ),
            array(
                'title' => esc_html_x('Light Title', 'admin-view', 'helas'),
                'inline' => 'span',
                'classes' => 'light'
            ),
            array(
                'title' => esc_html_x('Highlight Font', 'admin-view', 'helas'),
                'inline' => 'span',
                'classes' => 'highlight-font-family'
            )
        );
        $settings['wordpress_adv_hidden'] = false;
        $settings['style_formats'] = json_encode($style_formats);
        return $settings;
    }
}