<?php get_header(); ?>
<?php do_action( 'helas/action/before_render_main' ); ?>
<div id="main" class="site-main">
    <div class="container">
        <div class="row">
            <main id="site-content" class="<?php echo esc_attr(Helas()->layout->get_main_content_css_class('col-xs-12 site-content'))?>">
                <div class="site-content-inner">

                    <?php do_action( 'helas/action/before_render_main_inner' );?>

                    <div class="page-content">
                        <?php
                        $content_404 = Helas()->settings->get('404_page_content');
                        if(!empty($content_404)) : ?>
                            <div class="customerdefine-404-content">
                                <?php echo Helas_Helper::remove_js_autop($content_404); ?>
                            </div>
                        <?php else : ?>
                            <div class="default-404-content">
                                <div class="row">
                                    <div class="col-md-6 col-md-push-6">
                                        <div class="bg-404">
                                            <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/404.png') ?>" alt="<?php echo esc_attr_x('404 Not Found', 'front-view', 'helas'); ?>"/>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-md-pull-6">
                                        <h5 class="three-font-family"><?php echo esc_html_x('Whoops!', 'front-end', 'helas') ?></h5>
                                        <h6 class="three-font-family"><?php echo esc_html_x('Page cannot be found !', 'front-end', 'helas') ?></h6>
                                        <p><?php echo esc_html_x('It looks like nothing was found at this location. Maybe try a search?', 'front-end', 'helas')?></p>
                                        <p class="btn-wrapper"><a class="btn text-uppercase btn-style-outline btn-color-gray" href="<?php echo esc_url(home_url('/')) ?>"><?php echo esc_html_x('Back to home', 'front-view','helas')?></a></p>
                                    </div>
                                </div>

                            </div>
                        <?php
                            endif;
                        ?>
                    </div>

                    <?php do_action( 'helas/action/after_render_main_inner' );?>
                </div>
            </main>
            <!-- #site-content -->
            <?php get_sidebar();?>
        </div>
    </div>
</div>
<!-- .site-main -->
<?php do_action( 'helas/action/after_render_main' ); ?>
<?php get_footer();?>