<?php
/**
 * @cmsmasters_package 	Heavy
 * @cmsmasters_version 	1.0.0
 */


global $product; 

if ( ! is_a( $product, 'WC_Product' ) ) {
	return;
}

?>
<li>
	<?php do_action( 'woocommerce_widget_product_item_start', $args ); ?>
	
	<a href="<?php print esc_url( $product->get_permalink() ); ?>">
		<?php echo heavy_return_content( $product->get_image() ); ?>
		<span class="product-title"><?php echo wp_kses_post( $product->get_name() ); ?></span>
	</a>
	<?php if ( ! empty( $show_rating ) ) : ?>
		<?php heavy_woocommerce_rating('cmsmasters_theme_icon_star_empty', 'cmsmasters_theme_icon_star_full'); ?>
	<?php endif;
	
	echo heavy_return_content( $product->get_price_html() );

	do_action( 'woocommerce_widget_product_item_end', $args ); ?>
</li>