<?php
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version 	1.0.0
 * 
 * WooCommerce Fonts Rules
 * Created by CMSMasters
 * 
 */


function heavy_woocommerce_fonts($custom_css) {
	$cmsmasters_option = heavy_get_global_options();
	
	
	$custom_css .= "
/***************** Start WooCommerce Font Styles ******************/

	/* Start Content Font */
	.cmsmasters_product .price,
	.cmsmasters_single_product .price, 
	.cmsmasters_single_product .woocommerce-grouped-product-list-item__price, 
	.widget_shopping_cart .total,
	.widget_shopping_cart .total strong,
	.cmsmasters_dynamic_cart .widget_shopping_cart_content .total,
	.cmsmasters_dynamic_cart .widget_shopping_cart_content .total strong,
	.calculated_shipping table .shipping th,
	ul.order_details strong {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_content_font_google_font']) . $cmsmasters_option['heavy' . '_content_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_content_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_content_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_content_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_content_font_font_style'] . ";
	}
	
	.shop_attributes, 
	.cmsmasters_woo_comments .cmsmasters_comment_item .cmsmasters_comment_item_content > p, 
	.cmsmasters_single_product .product_meta > span a, 
	.cmsmasters_single_product .product_meta > span {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] + 1) . "px;
	}
	
	.cmsmasters_dynamic_cart .widget_shopping_cart_content .cart_list .quantity {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] - 1) . "px;
	}
	
	.widget_shopping_cart .cart_list .quantity,
	.widget > .product_list_widget .amount {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_content_font_line_height'] - 2) . "px;
	}
	
	.cmsmasters_product .price del {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] - 2) . "px;
	}
	
	@media only screen and (min-width: 601px) and (max-width: 768px) {
		.cmsmasters_product .price del {
			font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] - 3) . "px;
		}
	}
	
	.widget > .product_list_widget del .amount,
	.cmsmasters_woo_comments .commentlist .cmsmasters_comment_item_date {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] - 3) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_content_font_line_height'] - 2) . "px;
	}
	
	.widget > .product_list_widget del {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] - 4) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_content_font_line_height'] - 4) . "px;
	}
	
	.cmsmasters_product .price {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] + 4) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_content_font_line_height'] + 6) . "px;
	}
	
	@media only screen and (min-width: 601px) and (max-width: 768px) {
		.cmsmasters_product .price {
			font-size:" . $cmsmasters_option['heavy' . '_content_font_font_size'] . "px;
			line-height:" . ((int) $cmsmasters_option['heavy' . '_content_font_line_height'] + 2) . "px;
		}
	}
	
	.cmsmasters_single_product .price del,
	.cmsmasters_single_product .woocommerce-grouped-product-list-item__price del {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] + 4) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_content_font_line_height'] + 8) . "px;
	}
	
	.cmsmasters_single_product .price,
	.cmsmasters_single_product .woocommerce-grouped-product-list-item__price,
	.cmsmasters_single_product .woocommerce-grouped-product-list-item__price ins {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] + 10) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_content_font_line_height'] + 10) . "px;
		text-decoration:none;
	}
	
	.shop_table.order_details .order_item strong {
		font-weight:" . $cmsmasters_option['heavy' . '_content_font_font_weight'] . ";
	}
	/* Finish Content Font */
	
	
	/* Start Link Font */
	.woocommerce-MyAccount-navigation ul > li.is-active a {
		text-decoration:" . $cmsmasters_option['heavy' . '_link_hover_decoration'] . ";
	}
	/* Finish Link Font */
	
	
	/* Start H1 Font */
	/* Finish H1 Font */
	
	
	/* Start H2 Font */
	/* Finish H2 Font */
	
	
	/* Start H3 Font */
	.cmsmasters_single_product .product_title,
	.woocommerce-page.woocommerce-order-received .woocommerce > h2 {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h3_font_google_font']) . $cmsmasters_option['heavy' . '_h3_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_h3_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_h3_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_h3_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h3_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_h3_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_h3_font_text_decoration'] . ";
	}
	/* Finish H3 Font */
	
	
	/* Start H4 Font */
	.product .related > h2, 
	.woocommerce-MyAccount-navigation fieldset legend, 
	.cmsmasters_woo_comments .post_comments_title,
	.cart-collaterals h2,
	.woocommerce-billing-fields > h3,
	.woocommerce-shipping-fields > h3,
	.checkout > h3,
	.woocommerce-page.woocommerce-order-received .woocommerce > h3 {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h4_font_google_font']) . $cmsmasters_option['heavy' . '_h4_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_h4_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_h4_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_h4_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h4_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_h4_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_h4_font_text_decoration'] . ";
	}
	
	.checkout > h3,
	.woocommerce-billing-fields > h3,
	.woocommerce-shipping-fields > h3,
	.cart-collaterals h2 {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h4_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_h4_font_line_height'] - 2) . "px;
	}
	
	/* Finish H4 Font */
	
	
	/* Start H5 Font */
	.widget_layered_nav ul li, 
	.widget_layered_nav ul li a, 
	.widget_rating_filter ul li,
	.widget_rating_filter ul li a,
	.widget_layered_nav_filters ul li, 
	.widget_layered_nav_filters ul li a,
	.widget_product_categories ul li, 
	.widget_product_categories ul li a, 
	.cmsmasters_product .button,
	.cmsmasters_products .product.product-category .woocommerce-loop-category__title, 
	.shop_table.woocommerce-checkout-review-order-table td strong, 
	.shop_table.woocommerce-checkout-review-order-table thead th, 
	.shop_table.woocommerce-checkout-review-order-table tfoot .order-total, 
	.shop_table.shop_table_responsive thead th,
	.cart_totals table th, 
	.cart_totals table .cart-subtotal .amount, 
	.cart_totals table .order-total .amount, 
	ul.order_details {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h5_font_google_font']) . $cmsmasters_option['heavy' . '_h5_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_h5_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_h5_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_h5_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h5_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_h5_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_h5_font_text_decoration'] . ";
	}
	
	.widget_layered_nav ul li, 
	.widget_layered_nav ul li a, 
	.widget_rating_filter ul li,
	.widget_rating_filter ul li a,
	.widget_layered_nav_filters ul li, 
	.widget_layered_nav_filters ul li a,
	.widget_product_categories ul li, 
	.widget_product_categories ul li a {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h5_font_font_size'] - 1) . "px;
	}
	
	.product.product-category .woocommerce-loop-category__title,
	.cmsmasters_product .cmsmasters_product_title,
	.cmsmasters_product .cmsmasters_product_title a {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h5_font_font_size'] + 2) . "px;
	}
	/* Finish H5 Font */
	
	
	/* Start H6 Font */
	.onsale,
	.out-of-stock,
	.stock,
	.shop_table.shop_table_responsive .product-name a,
	.cart_totals table th
	.widget > .product_list_widget a, 
	.widget_shopping_cart .cart_list a,
	.widget_products .product_list_widget li > a,
	.woocommerce-billing-fields label, 
	.woocommerce-shipping-fields label, 
	.cmsmasters_single_product .onsale, 
	.cmsmasters_single_product .out-of-stock, 
	.cmsmasters_single_product .stock,
	.woocommerce-checkout-payment .payment_methods label,
	.cmsmasters_added_product_info .cmsmasters_added_product_info_text, 
	.cmsmasters_dynamic_cart .widget_shopping_cart_content .cart_list a,
	.cmsmasters_woo_wrap_result .woocommerce-result-count {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h6_font_google_font']) . $cmsmasters_option['heavy' . '_h6_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_h6_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_h6_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_h6_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h6_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_h6_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_h6_font_text_decoration'] . ";
	}
	
	.cmsmasters_dynamic_cart .widget_shopping_cart_content .cart_list a,
	.woocommerce-shipping-fields label, 
	.woocommerce-billing-fields label {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h6_font_font_size'] - 1) . "px;
	}
	
	
	.shop_table.shop_table_responsive .product-name a {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h6_font_font_size'] + 1) . "px;
	}
	
	.onsale, 
	.out-of-stock, 
	.stock {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h6_font_font_size'] - 1) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_h6_font_line_height'] - 2) . "px;
	}
	
	.woocommerce-checkout-payment .payment_methods label {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h6_font_font_size'] - 1) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_h6_font_line_height'] - 2) . "px;
	}
	
	.cmsmasters_woo_comments .commentlist .cmsmasters_comment_item_date {
		text-transform:" . $cmsmasters_option['heavy' . '_h6_font_text_transform'] . ";
	}
	/* Finish H6 Font */
	
	
	/* Start Button Font */
	.cmsmasters_product .button {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_button_font_google_font']) . $cmsmasters_option['heavy' . '_button_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_button_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_button_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_button_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_button_font_font_style'] . ";
	}
	
	.widget_price_filter .price_slider_amount .button {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_button_font_font_size'] - 1) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_button_font_line_height'] - 3) . "px;
	}
	
	.cmsmasters_dynamic_cart .buttons a,
	.widget_shopping_cart .buttons .button {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_button_font_font_size'] - 1) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_button_font_line_height'] - 7) . "px;
	}
	/* Finish Button Font */
	
	
	/* Start Text Fields Font */
	body .select2-dropdown {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_input_font_google_font']) . $cmsmasters_option['heavy' . '_input_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_input_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_input_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_input_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_input_font_font_style'] . ";
	}
	
	.cmsmasters_single_product .cart .quantity input:not([type=button]):not([type=checkbox]):not([type=file]):not([type=hidden]):not([type=image]):not([type=radio]):not([type=reset]):not([type=submit]):not([type=color]):not([type=range]) {
		height:" . $cmsmasters_option['heavy' . '_input_font_line_height'] . "px;
	}
	/* Finish Text Fields Font */
	
	
	/* Start Small Text Font */
	/* Finish Small Text Font */

/***************** Finish WooCommerce Font Styles ******************/

";
	
	
	return $custom_css;
}

add_filter('heavy_theme_fonts_filter', 'heavy_woocommerce_fonts');

