<?php
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version 	1.0.0
 * 
 * WooCommerce Colors Rules
 * Created by CMSMasters
 * 
 */


function heavy_woocommerce_colors($custom_css) {
	$cmsmasters_option = heavy_get_global_options();
	
	
	$cmsmasters_color_schemes = cmsmasters_color_schemes_list();
	
	
	foreach ($cmsmasters_color_schemes as $scheme => $title) {
		$rule = (($scheme != 'default') ? "html .cmsmasters_color_scheme_{$scheme} " : '');
		
		
		$custom_css .= "
/***************** Start {$title} WooCommerce Color Scheme Rules ******************/

	/* Start Main Content Font Color */
	{$rule}.select2-container .select2-choice, 
	{$rule}.select2-container.select2-drop-above .select2-choice, 
	{$rule}.select2-container.select2-container-active .select2-choice, 
	{$rule}.select2-container.select2-container-active.select2-drop-above .select2-choice, 
	{$rule}.select2-drop.select2-drop-active, 
	{$rule}.select2-drop.select2-drop-above.select2-drop-active,
	{$rule}body .select2-container .select2-selection--single .select2-selection__rendered, 
	{$rule}.cmsmasters_product .cmsmasters_product_add_inner .button:hover,
	{$rule}.shop_table.woocommerce-checkout-review-order-table *,
	{$rule}ul.order_details strong,
	{$rule}.shop_table.order_details a:not(.button),
	{$rule}.widget_rating_filter ul li,
	{$rule}.widget_rating_filter ul li a,
	{$rule}.widget_product_categories ul li,
	{$rule}.widget_product_categories ul li a {
		" . cmsmasters_color_css('color', $cmsmasters_option['heavy' . '_' . $scheme . '_color']) . "
	}
	
	{$rule}.cmsmasters_product .cmsmasters_product_add_inner .button:hover {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['heavy' . '_' . $scheme . '_color']) . "
	}
	/* Finish Main Content Font Color */
	
	
	/* Start Primary Color */
	{$rule}.required,
	{$rule}.widget_layered_nav ul li a:hover,
	{$rule}.widget_layered_nav ul li.chosen a,
	{$rule}.widget_layered_nav_filters ul li a:hover,
	{$rule}.widget_layered_nav_filters ul li.chosen a,
	{$rule}.cmsmasters_product .price ins,
	{$rule}.cmsmasters_single_product .price ins,
	{$rule}.cmsmasters_single_product .woocommerce-grouped-product-list-item__price ins,
	{$rule}#page .remove:hover,
	{$rule}.cmsmasters_product .cmsmasters_product_cat a:hover, 
	{$rule}.cmsmasters_star_rating .cmsmasters_star_color_wrap,
	{$rule}.comment-form-rating .stars > span a:hover,
	{$rule}.comment-form-rating .stars > span a.active,
	{$rule}.cmsmasters_single_product .product_meta a:hover,
	{$rule}.cart_totals table .cart-subtotal .amount,
	{$rule}.cart_totals table .order-total .amount,
	{$rule}.shop_table.shop_table_responsive a:not(.button):hover,
	{$rule}.shop_table.shop_table_responsive td.product-subtotal,
	{$rule}.calculated_shipping .shop_table.shop_table_responsive a:not(.button),
	{$rule}.shop_table.woocommerce-checkout-review-order-table .order-total th,
	{$rule}.shop_table.woocommerce-checkout-review-order-table .order-total td,
	{$rule}.shop_table.woocommerce-checkout-review-order-table .order-total td *,
	{$rule}.shop_table.order_details tfoot tr:last-child th,
	{$rule}.shop_table.order_details tfoot tr:last-child td,
	{$rule}.cmsmasters_product .cmsmasters_product_add_inner .button,
	{$rule}.widget_shopping_cart .total .amount,
	{$rule}.widget_shopping_cart .cart_list a:hover,
	{$rule}.widget_shopping_cart .buttons > a:first-child:hover,
	{$rule}.widget_product_tag_cloud a:hover,
	{$rule}.widget_price_filter .price_slider_amount .price_label > span,
	{$rule}.widget_product_categories ul li a:hover,
	{$rule}.widget_rating_filter ul li a:hover,
	{$rule}.cmsmasters_products .product.product-category h2:hover, 
	{$rule}.cmsmasters_products .product.product-category h2 mark, 
	{$rule}.widget_product_categories ul li.current-cat a,
	{$rule}.widget_product_categories ul li a:hover:before,
	{$rule}.widget > .product_list_widget a:hover, 
	{$rule}.woocommerce-store-notice .woocommerce-store-notice__dismiss-link {
		" . cmsmasters_color_css('color', $cmsmasters_option['heavy' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.input-checkbox + label:after,
	{$rule}.input-radio + label:after,
	{$rule}input.shipping_method + label:after,
	{$rule}.woocommerce-store-notice, 
	{$rule}.widget_shopping_cart .buttons > a:first-child,
	{$rule}.select2-drop .select2-results .select2-highlighted {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['heavy' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}#page .widget_shopping_cart .cart_list .remove {
		background-color:rgba(" . cmsmasters_color2rgb($cmsmasters_option['heavy' . '_' . $scheme . '_link']) . ", .7);
	}
	
	{$rule}.select2-container.select2-container-active .select2-choice, 
	{$rule}.select2-container.select2-container-active.select2-drop-above .select2-choice, 
	{$rule}.select2-drop.select2-drop-active, 
	{$rule}.select2-drop.select2-drop-above.select2-drop-active,
	{$rule}body .select2-container.select2-container--open .select2-selection--single,
	{$rule}body .select2-container.select2-container--focus .select2-selection--single, 
	{$rule}.cart_totals table button,
	{$rule}.wc-proceed-to-checkout .button {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['heavy' . '_' . $scheme . '_link']) . "
	}
	/* Finish Primary Color */
	
	
	/* Start Highlight Color */
	{$rule}.woocommerce-MyAccount-navigation ul > li.is-active a,
	{$rule}.cmsmasters_product .price,
	{$rule}.cmsmasters_product .price del,
	{$rule}.cmsmasters_single_product .price,
	{$rule}.cmsmasters_single_product .price del,
	{$rule}.cmsmasters_single_product .woocommerce-grouped-product-list-item__price,
	{$rule}.cmsmasters_single_product .woocommerce-grouped-product-list-item__price del,
	{$rule}.woocommerce-billing-fields label,
	{$rule}.woocommerce-shipping-fields label,
	{$rule}.calculated_shipping .shop_table .shipping > td > p,
	{$rule}.calculated_shipping .shop_table.shop_table_responsive .shipping th,
	{$rule}.cmsmasters_product .cmsmasters_product_cat a {
		" . cmsmasters_color_css('color', $cmsmasters_option['heavy' . '_' . $scheme . '_hover']) . "
	}
	
	{$rule}.link_hover_color {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['heavy' . '_' . $scheme . '_hover']) . "
	}
	/* Finish Highlight Color */
	
	
	/* Start Headings Color */
	{$rule}.cmsmasters_woo_wrap_result .woocommerce-result-count,
	{$rule}.widget_layered_nav ul li,
	{$rule}.widget_layered_nav ul li a,
	{$rule}.widget_layered_nav_filters ul li,
	{$rule}.widget_layered_nav_filters ul li a,
	{$rule}.onsale,
	{$rule}.out-of-stock,
	{$rule}.stock,
	{$rule}#page .remove,
	{$rule}.woocommerce-info,
	{$rule}.woocommerce-message,
	{$rule}.woocommerce-error li,
	{$rule}.cmsmasters_single_product .product_meta a,
	{$rule}.woocommerce-message,
	{$rule}.woocommerce-info,
	{$rule}.woocommerce-error,
	{$rule}.shop_table.shop_table_responsive thead th,
	{$rule}.shop_table.shop_table_responsive .product-price,
	{$rule}.shop_table.shop_table_responsive .product-quantity input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]),
	{$rule}.shop_table.shop_table_responsive a:not(.button),
	{$rule}.calculated_shipping .shop_table.shop_table_responsive a:not(.button):hover,
	{$rule}.calculated_shipping .shop_table.shop_table_responsive th,
	{$rule}.shop_table.woocommerce-checkout-review-order-table thead *,
	{$rule}.shop_table.woocommerce-checkout-review-order-table .cart-subtotal th,
	{$rule}.shop_table.woocommerce-checkout-review-order-table .cart-subtotal td,
	{$rule}.shop_table.woocommerce-checkout-review-order-table .cart-subtotal td *,
	{$rule}ul.order_details,
	{$rule}.shop_table.order_details thead tr,
	{$rule}.shop_table.order_details tfoot tr:first-child th,
	{$rule}.shop_table.order_details tfoot tr:first-child td,
	{$rule}.widget_shopping_cart .cart_list a,
	{$rule}.widget_product_tag_cloud a, 
	{$rule}.widget_shopping_cart .total,
	{$rule}.widget_price_filter .price_slider_amount .price_label,
	{$rule}.widget > .product_list_widget a,
	{$rule}.widget > .product_list_widget li > .amount,
	{$rule}.widget > .product_list_widget ins .amount {
		" . cmsmasters_color_css('color', $cmsmasters_option['heavy' . '_' . $scheme . '_heading']) . "
	}
	
	{$rule}.widget_price_filter .ui-slider-handle {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['heavy' . '_' . $scheme . '_heading']) . "
	}
	/* Finish Headings Color */
	
	
	/* Start Main Background Color */
	{$rule}.woocommerce-store-notice,
	{$rule}.woocommerce-store-notice p a, 
	{$rule}.woocommerce-store-notice p a:hover, 
	{$rule}.widget_shopping_cart .buttons a,
	{$rule}.widget_shopping_cart .buttons a:hover,
	{$rule}.select2-drop .select2-results .select2-highlighted,
	{$rule}#page .widget_shopping_cart .cart_list .remove {
		" . cmsmasters_color_css('color', $cmsmasters_option['heavy' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}#page .remove,
	{$rule}.input-checkbox + label:before,
	{$rule}.input-radio + label:before,
	{$rule}input.shipping_method + label:before,
	{$rule}body .select2-container .select2-selection--single, 
	{$rule}.cmsmasters_product .cmsmasters_product_add_wrap, 
	{$rule}.cmsmasters_product .cmsmasters_product_add_inner .button, 
	{$rule}.select2-container .select2-choice,
	{$rule}.select2-container.select2-drop-above .select2-choice, 
	{$rule}.select2-container.select2-container-active .select2-choice, 
	{$rule}.select2-container.select2-container-active.select2-drop-above .select2-choice,
	{$rule}.woocommerce-store-notice .woocommerce-store-notice__dismiss-link, 
	{$rule}.select2-drop .select2-results,
	{$rule}.select2-drop.select2-drop-active,
	{$rule}.select2-drop.select2-drop-above.select2-drop-active,
	{$rule}.woocommerce-checkout-payment {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['heavy' . '_' . $scheme . '_bg']) . "
	}
	/* Finish Main Background Color */
	
	
	/* Start Alternate Background Color */
	
	{$rule}.onsale,
	{$rule}.out-of-stock,
	{$rule}.stock,
	{$rule}.woocommerce-info,
	{$rule}.woocommerce-message,
	{$rule}.woocommerce-error,
	{$rule}.shop_table.shop_table_responsive thead th,
	{$rule}.shop_table.shop_table_responsive .actions,
	{$rule}.calculated_shipping .shop_table.shop_table_responsive .cart-subtotal,
	{$rule}.calculated_shipping .shop_table.shop_table_responsive .order-total,
	{$rule}.shop_table.woocommerce-checkout-review-order-table thead th,
	{$rule}.shop_table.woocommerce-checkout-review-order-table .order-total,
	{$rule}.shop_table.woocommerce-checkout-review-order-table .cart-subtotal th,
	{$rule}.shop_table.woocommerce-checkout-review-order-table .cart-subtotal td,
	{$rule}.woocommerce-checkout-payment .payment_methods .payment_box,
	{$rule}ul.order_details li,
	{$rule}.shop_table.order_details thead tr,
	{$rule}.shop_table.order_details tfoot tr:first-child th,
	{$rule}.shop_table.order_details tfoot tr:first-child td,
	{$rule}.shop_table.order_details tfoot tr:last-child th,
	{$rule}.shop_table.order_details tfoot tr:last-child td {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['heavy' . '_' . $scheme . '_alternate']) . "
	}
	
	{$rule}.woocommerce-checkout-payment .payment_methods .payment_box:after {
		" . cmsmasters_color_css('border-bottom-color', $cmsmasters_option['heavy' . '_' . $scheme . '_alternate']) . "
	}
	/* Finish Alternate Background Color */
	
	
	/* Start Borders Color */
	{$rule}.cmsmasters_product .cmsmasters_product_add_inner .button,
	{$rule}.cmsmasters_star_rating .cmsmasters_star_trans_wrap,
	{$rule}.comment-form-rating .stars > span {
		" . cmsmasters_color_css('color', $cmsmasters_option['heavy' . '_' . $scheme . '_border']) . "
	}
	
	{$rule}div.products:before,
	{$rule}.widget_price_filter .price_slider {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['heavy' . '_' . $scheme . '_border']) . "
	}
	
	{$rule}#page .remove,
	{$rule}.select2-container .select2-choice,
	{$rule}.select2-container.select2-drop-above .select2-choice,
	{$rule}.input-checkbox + label:before,
	{$rule}.input-radio + label:before,
	{$rule}input.shipping_method + label:before,
	{$rule}.cmsmasters_product,
	{$rule}.shop_attributes tr,
	{$rule}.shop_table,
	{$rule}.shop_table tr,
	{$rule}.shop_table th,
	{$rule}.shop_table td,
	{$rule}.woocommerce-message,
	{$rule}.woocommerce-info,
	{$rule}.woocommerce-error,
	{$rule}.woocommerce-checkout-payment,
	{$rule}.woocommerce-checkout-payment .payment_methods .payment_box,
	{$rule}ul.order_details,
	{$rule}ul.order_details li,
	{$rule}ul.order_details strong,
	{$rule}.select2-container--default .select2-selection--single,
	{$rule}.cmsmasters_product .cmsmasters_product_add_inner .button,
	{$rule}body .select2-dropdown,
	{$rule}body .select2-container--open .select2-dropdown,
	{$rule}body .select2-container .select2-selection--single {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['heavy' . '_' . $scheme . '_border']) . "
	}
	
	{$rule}.woocommerce-checkout-payment .payment_methods .payment_box:before {
		" . cmsmasters_color_css('border-bottom-color', $cmsmasters_option['heavy' . '_' . $scheme . '_border']) . "
	}
	/* Finish Borders Color */
	
	/* Start Secondary Color */	
	
	/* Finish Secondary Color */

/***************** Finish {$title} WooCommerce Color Scheme Rules ******************/

";
	}
	
	
	return $custom_css;
}

add_filter('heavy_theme_colors_secondary_filter', 'heavy_woocommerce_colors');

