<?php 
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version		1.0.0
 * 
 * Theme Settings Defaults
 * Created by CMSMasters
 * 
 */


/* Theme Settings General Default Values */
if (!function_exists('heavy_settings_general_defaults')) {

function heavy_settings_general_defaults($id = false) {
	$settings = array( 
		'general' => array( 
			'heavy' . '_theme_layout' => 			'liquid', 
			'heavy' . '_logo_type' => 			'image', 
			'heavy' . '_logo_url' => 				'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo.png', 
			'heavy' . '_logo_url_retina' => 		'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_retina.png', 
			'heavy' . '_logo_title' => 			get_bloginfo('name') ? get_bloginfo('name') : 'Heavy', 
			'heavy' . '_logo_subtitle' => 		'', 
			'heavy' . '_logo_custom_color' => 	0, 
			'heavy' . '_logo_title_color' => 		'', 
			'heavy' . '_logo_subtitle_color' => 	'' 
		), 
		'bg' => array( 
			'heavy' . '_bg_col' => 			'#ffffff', 
			'heavy' . '_bg_img_enable' => 	0, 
			'heavy' . '_bg_img' => 			'', 
			'heavy' . '_bg_rep' => 			'no-repeat', 
			'heavy' . '_bg_pos' => 			'top center', 
			'heavy' . '_bg_att' => 			'scroll', 
			'heavy' . '_bg_size' => 			'cover' 
		), 
		'header' => array( 
			'heavy' . '_fixed_header' => 					1, 
			'heavy' . '_header_overlaps' => 				1, 
			'heavy' . '_header_top_line' => 				0, 
			'heavy' . '_header_top_height' => 			'34', 
			'heavy' . '_header_top_line_short_info' => 	'', 
			'heavy' . '_header_top_line_add_cont' => 		'nav', 
			'heavy' . '_header_top_line_social' => 		'1', 
			'heavy' . '_header_styles' => 				'l_nav', 
			'heavy' . '_header_mid_height' => 			'150', 
			'heavy' . '_header_bot_height' => 			'65', 
			'heavy' . '_header_search' => 				1, 
			'heavy' . '_header_add_cont' => 				'social', 
			'heavy' . '_header_add_cont_cust_html' => 	'',
			'heavy' . '_woocommerce_cart_dropdown' => 	0
		), 
		'content' => array( 
			'heavy' . '_layout' => 					'r_sidebar', 
			'heavy' . '_archives_layout' => 			'r_sidebar', 
			'heavy' . '_search_layout' => 			'r_sidebar', 
			'heavy' . '_other_layout' => 				'r_sidebar', 
			'heavy' . '_heading_alignment' => 		'left', 
			'heavy' . '_heading_scheme' => 			'default', 
			'heavy' . '_heading_bg_image_enable' => 	0, 
			'heavy' . '_heading_bg_image' => 			'', 
			'heavy' . '_heading_bg_repeat' => 		'no-repeat', 
			'heavy' . '_heading_bg_attachment' => 	'scroll', 
			'heavy' . '_heading_bg_size' => 			'cover', 
			'heavy' . '_heading_bg_color' => 			'#f9f9f9', 
			'heavy' . '_heading_height' => 			'210', 
			'heavy' . '_breadcrumbs' => 				1, 
			'heavy' . '_bottom_scheme' => 			'first', 
			'heavy' . '_bottom_sidebar' => 			1, 
			'heavy' . '_bottom_sidebar_layout' => 	'14141414' 
		), 
		'footer' => array( 
			'heavy' . '_footer_scheme' => 				'footer', 
			'heavy' . '_footer_type' => 					'default', 
			'heavy' . '_footer_additional_content' => 	'nav', 
			'heavy' . '_footer_logo' => 					0, 
			'heavy' . '_footer_logo_url' => 				'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_footer.png', 
			'heavy' . '_footer_logo_url_retina' => 		'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_footer_retina.png', 
			'heavy' . '_footer_nav' => 					1, 
			'heavy' . '_footer_social' => 				1, 
			'heavy' . '_footer_html' => 					'', 
			'heavy' . '_footer_copyright' => 			'This is a sample website - cmsmasters' . ' &copy; ' . date('Y') . ' / ' . esc_html__('All Rights Reserved', 'heavy') 
		) 
	);
	
	
	if ($id) {
		return $settings[$id];
	} else {
		return $settings;
	}
}

}



/* Theme Settings Fonts Default Values */
if (!function_exists('heavy_settings_font_defaults')) {

function heavy_settings_font_defaults($id = false) {
	$settings = array( 
		'content' => array( 
			'heavy' . '_content_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Heebo:400,500', 
				'font_size' => 			'16', 
				'line_height' => 		'24', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal' 
			) 
		), 
		'link' => array( 
			'heavy' . '_link_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Heebo:400,500', 
				'font_size' => 			'16', 
				'line_height' => 		'24', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none', 
				'text_decoration' => 	'underline' 
			), 
			'heavy' . '_link_hover_decoration' => 	'underline' 
		), 
		'nav' => array( 
			'heavy' . '_nav_title_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Work+Sans:400,500,600,700', 
				'font_size' => 			'19', 
				'line_height' => 		'30', 
				'font_weight' => 		'500', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none' 
			), 
			'heavy' . '_nav_dropdown_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Heebo:400,500', 
				'font_size' => 			'16', 
				'line_height' => 		'22', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none' 
			) 
		), 
		'heading' => array( 
			'heavy' . '_h1_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Work+Sans:400,500,600,700', 
				'font_size' => 			'40', 
				'line_height' => 		'50', 
				'font_weight' => 		'500', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none', 
				'text_decoration' => 	'none' 
			), 
			'heavy' . '_h2_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Work+Sans:400,500,600,700', 
				'font_size' => 			'32', 
				'line_height' => 		'40', 
				'font_weight' => 		'500', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none', 
				'text_decoration' => 	'none' 
			), 
			'heavy' . '_h3_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Work+Sans:400,500,600,700', 
				'font_size' => 			'28', 
				'line_height' => 		'32', 
				'font_weight' => 		'500', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none', 
				'text_decoration' => 	'none' 
			), 
			'heavy' . '_h4_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Work+Sans:400,500,600,700', 
				'font_size' => 			'24', 
				'line_height' => 		'30', 
				'font_weight' => 		'500', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none', 
				'text_decoration' => 	'none' 
			), 
			'heavy' . '_h5_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Work+Sans:400,500,600,700', 
				'font_size' => 			'20', 
				'line_height' => 		'26', 
				'font_weight' => 		'500', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none', 
				'text_decoration' => 	'none' 
			), 
			'heavy' . '_h6_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Work+Sans:400,500,600,700', 
				'font_size' => 			'16', 
				'line_height' => 		'20', 
				'font_weight' => 		'500', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none', 
				'text_decoration' => 	'none' 
			) 
		), 
		'other' => array( 
			'heavy' . '_button_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Work+Sans:400,500,600,700', 
				'font_size' => 			'18', 
				'line_height' => 		'60', 
				'font_weight' => 		'500', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none' 
			), 
			'heavy' . '_small_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Heebo:400,500', 
				'font_size' => 			'14', 
				'line_height' => 		'24', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal', 
				'text_transform' => 	'none' 
			), 
			'heavy' . '_input_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Heebo:400,500', 
				'font_size' => 			'16', 
				'line_height' => 		'48', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal' 
			), 
			'heavy' . '_quote_font' => array( 
				'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif", 
				'google_font' => 		'Work+Sans:400,500,600,700', 
				'font_size' => 			'24', 
				'line_height' => 		'38', 
				'font_weight' => 		'normal', 
				'font_style' => 		'normal' 
			) 
		), 
		'google' => array( 
			'heavy' . '_google_web_fonts' => array( 
				'Heebo:400,500|Heebo',
				'Work+Sans:400,500,600,700|Work Sans'
			) 
		) 
	);
	
	
	if ($id) {
		return $settings[$id];
	} else {
		return $settings;
	}
}

}



// WP Color Picker Palettes
if (!function_exists('cmsmasters_color_picker_palettes')) {

function cmsmasters_color_picker_palettes() {
	$palettes = array( 
		'#7f7f7f', 
		'#ef3016', 
		'#aaaaaa', 
		'#2e2e2e', 
		'#f9f9f9', 
		'#ffffff', 
		'#d8d8d8', 
		'#ef3016'
	);
	
	
	return $palettes;
}

}



// Theme Settings Color Schemes Default Colors
if (!function_exists('heavy_color_schemes_defaults')) {

function heavy_color_schemes_defaults($id = false) {
	$settings = array( 
		'default' => array( // content default color scheme
			'color' => 		'#7f7f7f', 
			'link' => 		'#ef3016', 
			'hover' => 		'#aaaaaa', 
			'heading' => 	'#2e2e2e', 
			'bg' => 		'#f9f9f9', 
			'alternate' => 	'#ffffff', 
			'border' => 	'#d8d8d8', 
			'secondary' =>	'#ef3016'
		), 
		'header' => array( // Header color scheme
			'mid_color' => 		'#7f7f7f', 
			'mid_link' => 		'#2e2e2e', 
			'mid_hover' => 		'#ef3016', 
			'mid_bg' => 		'#f9f9f9', 
			'mid_bg_scroll' => 	'#f9f9f9', 
			'mid_border' => 	'#d8d8d8', 
			'bot_color' => 		'#7f7f7f', 
			'bot_link' => 		'#2e2e2e', 
			'bot_hover' => 		'#ef3016', 
			'bot_bg' => 		'#f9f9f9', 
			'bot_bg_scroll' => 	'#f9f9f9', 
			'bot_border' => 	'#d8d8d8' 
		), 
		'navigation' => array( // Navigation color scheme
			'title_link' => 			'#2e2e2e', 
			'title_link_hover' => 		'#ef3016', 
			'title_link_current' => 	'#ef3016', 
			'title_link_subtitle' => 	'#aaaaaa', 
			'title_link_bg' => 			'rgba(255,255,255,0)', 
			'title_link_bg_hover' => 	'rgba(255,255,255,0)', 
			'title_link_bg_current' => 	'rgba(255,255,255,0)', 
			'title_link_border' => 		'rgba(255,255,255,0)', 
			'dropdown_text' => 			'#7f7f7f', 
			'dropdown_bg' => 			'#ffffff', 
			'dropdown_border' => 		'#d8d8d8', 
			'dropdown_link' => 			'#7f7f7f', 
			'dropdown_link_hover' => 	'#2e2e2e', 
			'dropdown_link_subtitle' => '#7f7f7f', 
			'dropdown_link_highlight' => 'rgba(255,255,255,0)', 
			'dropdown_link_border' => 	'rgba(255,255,255,0)' 
		), 
		'header_top' => array( // Header Top color scheme
			'color' => 					'#2e2e2e', 
			'link' => 					'#2e2e2e', 
			'hover' => 					'#aaaaaa', 
			'bg' => 					'#f9f9f9', 
			'border' => 				'#d8d8d8', 
			'title_link' => 			'#2e2e2e', 
			'title_link_hover' => 		'#aaaaaa', 
			'title_link_bg' => 			'rgba(255,255,255,0)', 
			'title_link_bg_hover' => 	'rgba(255,255,255,0)', 
			'title_link_border' => 		'rgba(255,255,255,0)', 
			'dropdown_bg' => 			'#2e2e2e', 
			'dropdown_border' => 		'rgba(255,255,255,0)', 
			'dropdown_link' => 			'#aaaaaa', 
			'dropdown_link_hover' => 	'#ffffff', 
			'dropdown_link_highlight' => 'rgba(255,255,255,0)', 
			'dropdown_link_border' => 	'rgba(255,255,255,0)' 
		), 
		'footer' => array( // Footer color scheme
			'color' => 		'#7f7f7f', 
			'link' => 		'#2e2e2e', 
			'hover' => 		'#ef3016', 
			'heading' => 	'#2e2e2e', 
			'bg' => 		'#f9f9f9', 
			'alternate' => 	'#ffffff', 
			'border' => 	'#e0e0e0', 
			'secondary' =>	'#ef3016'
		), 
		'first' => array( // custom color scheme 1
			'color' => 		'#7f7f7f', 
			'link' => 		'#7f7f7f', 
			'hover' => 		'#ef3016', 
			'heading' => 	'#2e2e2e', 
			'bg' => 		'#f9f9f9', 
			'alternate' => 	'#ffffff', 
			'border' => 	'#d8d8d8', 
			'secondary' =>	'#ef3016'
		), 
		'second' => array( // custom color scheme 2
			'color' => 		'#ffffff', 
			'link' => 		'#ffffff', 
			'hover' => 		'#aaaaaa', 
			'heading' => 	'#2e2e2e', 
			'bg' => 		'#ef3016', 
			'alternate' => 	'#ffffff', 
			'border' => 	'rgba(255,255,255,0.30)', 
			'secondary' =>	'#ef3016'
		), 
		'third' => array( // custom color scheme 3
			'color' => 		'rgba(255,255,255,0.7)', 
			'link' => 		'#ffffff', 
			'hover' => 		'#aaaaaa', 
			'heading' => 	'#2e2e2e', 
			'bg' => 		'#e1ad3c', 
			'alternate' => 	'#ffffff', 
			'border' => 	'rgba(255,255,255,0.3)', 
			'secondary' =>	'#ef3016'
		), 
		'fourth' => array( // custom color scheme 4
			'color' => 		'rgba(127,127,127,0.7)', 
			'link' => 		'#ef3016', 
			'hover' => 		'#aaaaaa', 
			'heading' => 	'#2e2e2e', 
			'bg' => 		'#ffffff', 
			'alternate' => 	'#ffffff', 
			'border' => 	'#d8d8d8', 
			'secondary' =>	'#ef3016'
		) 
	);
	
	
	if ($id) {
		return $settings[$id];
	} else {
		return $settings;
	}
}

}



// Theme Settings Elements Default Values
if (!function_exists('heavy_settings_element_defaults')) {

function heavy_settings_element_defaults($id = false) {
	$settings = array( 
		'sidebar' => array( 
			'heavy' . '_sidebar' => 	'' 
		), 
		'icon' => array( 
			'heavy' . '_social_icons' => array( 
				'cmsmasters-icon-facebook-circled|#|' . esc_html__('Facebook', 'heavy') . '|false||', 
				'cmsmasters-icon-linkedin-circled|#|' . esc_html__('Linkedin', 'heavy') . '|false||', 
				'cmsmasters-icon-skype-circled|#|' . esc_html__('Skype', 'heavy') . '|false||', 
				'cmsmasters-icon-twitter-circled|#|' . esc_html__('Twitter', 'heavy') . '|false||', 
				'cmsmasters-icon-vimeo-circled|#|' . esc_html__('YouTube', 'heavy') . '|false||'  
			) 
		), 
		'lightbox' => array( 
			'heavy' . '_ilightbox_skin' => 					'dark', 
			'heavy' . '_ilightbox_path' => 					'vertical', 
			'heavy' . '_ilightbox_infinite' => 				0, 
			'heavy' . '_ilightbox_aspect_ratio' => 			1, 
			'heavy' . '_ilightbox_mobile_optimizer' => 		1, 
			'heavy' . '_ilightbox_max_scale' => 				1, 
			'heavy' . '_ilightbox_min_scale' => 				0.2, 
			'heavy' . '_ilightbox_inner_toolbar' => 			0, 
			'heavy' . '_ilightbox_smart_recognition' => 		0, 
			'heavy' . '_ilightbox_fullscreen_one_slide' => 	0, 
			'heavy' . '_ilightbox_fullscreen_viewport' => 	'center', 
			'heavy' . '_ilightbox_controls_toolbar' => 		1, 
			'heavy' . '_ilightbox_controls_arrows' => 		0, 
			'heavy' . '_ilightbox_controls_fullscreen' => 	1, 
			'heavy' . '_ilightbox_controls_thumbnail' => 	1, 
			'heavy' . '_ilightbox_controls_keyboard' => 		1, 
			'heavy' . '_ilightbox_controls_mousewheel' => 	1, 
			'heavy' . '_ilightbox_controls_swipe' => 		1, 
			'heavy' . '_ilightbox_controls_slideshow' => 	0 
		), 
		'sitemap' => array( 
			'heavy' . '_sitemap_nav' => 			1, 
			'heavy' . '_sitemap_categs' => 		1, 
			'heavy' . '_sitemap_tags' => 		1, 
			'heavy' . '_sitemap_month' => 		1, 
			'heavy' . '_sitemap_pj_categs' => 	1, 
			'heavy' . '_sitemap_pj_tags' => 		1 
		), 
		'error' => array( 
			'heavy' . '_error_color' => 				'#2e2e2e', 
			'heavy' . '_error_bg_color' => 			'rgba(255,255,255,0)', 
			'heavy' . '_error_bg_img_enable' => 		0, 
			'heavy' . '_error_bg_image' => 			'', 
			'heavy' . '_error_bg_rep' => 			'no-repeat', 
			'heavy' . '_error_bg_pos' => 			'top center', 
			'heavy' . '_error_bg_att' => 			'scroll', 
			'heavy' . '_error_bg_size' => 			'cover', 
			'heavy' . '_error_search' => 			1, 
			'heavy' . '_error_sitemap_button' => 	0, 
			'heavy' . '_error_sitemap_link' => 		'' 
		), 
		'code' => array( 
			'heavy' . '_custom_css' => 			'', 
			'heavy' . '_custom_js' => 			'', 
			'heavy' . '_gmap_api_key' => 		'', 
			'heavy' . '_api_key' => 				'', 
			'heavy' . '_api_secret' => 			'', 
			'heavy' . '_access_token' => 		'', 
			'heavy' . '_access_token_secret' => 	'' 
		), 
		'recaptcha' => array( 
			'heavy' . '_recaptcha_public_key' => 	'', 
			'heavy' . '_recaptcha_private_key' => 	'' 
		) 
	);
	
	
	if ($id) {
		return $settings[$id];
	} else {
		return $settings;
	}
}

}



// Theme Settings Single Posts Default Values
if (!function_exists('heavy_settings_single_defaults')) {

function heavy_settings_single_defaults($id = false) {
	$settings = array( 
		'post' => array( 
			'heavy' . '_blog_post_layout' => 			'r_sidebar', 
			'heavy' . '_blog_post_title' => 			1, 
			'heavy' . '_blog_post_date' => 			1, 
			'heavy' . '_blog_post_cat' => 			1, 
			'heavy' . '_blog_post_author' => 			1, 
			'heavy' . '_blog_post_comment' => 		1, 
			'heavy' . '_blog_post_tag' => 			1, 
			'heavy' . '_blog_post_like' => 			1, 
			'heavy' . '_blog_post_nav_box' => 		1, 
			'heavy' . '_blog_post_nav_order_cat' => 	0, 
			'heavy' . '_blog_post_share_box' => 		1, 
			'heavy' . '_blog_post_author_box' => 		1, 
			'heavy' . '_blog_more_posts_box' => 		'popular', 
			'heavy' . '_blog_more_posts_count' => 	'3', 
			'heavy' . '_blog_more_posts_pause' => 	'5' 
		), 
		'project' => array( 
			'heavy' . '_portfolio_project_title' => 			1, 
			'heavy' . '_portfolio_project_details_title' => 	esc_html__('Project details', 'heavy'), 
			'heavy' . '_portfolio_project_date' => 			1, 
			'heavy' . '_portfolio_project_cat' => 			1, 
			'heavy' . '_portfolio_project_author' => 		0, 
			'heavy' . '_portfolio_project_comment' => 		0, 
			'heavy' . '_portfolio_project_tag' => 			0, 
			'heavy' . '_portfolio_project_like' => 			0, 
			'heavy' . '_portfolio_project_link' => 			0, 
			'heavy' . '_portfolio_project_share_box' => 		1, 
			'heavy' . '_portfolio_project_nav_box' => 		1, 
			'heavy' . '_portfolio_project_nav_order_cat' => 	0, 
			'heavy' . '_portfolio_project_author_box' => 		1, 
			'heavy' . '_portfolio_more_projects_box' => 		'popular', 
			'heavy' . '_portfolio_more_projects_count' => 	'4', 
			'heavy' . '_portfolio_more_projects_pause' => 	'5', 
			'heavy' . '_portfolio_project_slug' => 			'project', 
			'heavy' . '_portfolio_pj_categs_slug' => 		'pj-categs', 
			'heavy' . '_portfolio_pj_tags_slug' => 			'pj-tags' 
		), 
		'profile' => array( 
			'heavy' . '_profile_post_title' => 			1, 
			'heavy' . '_profile_post_details_title' => 	esc_html__('Profile details', 'heavy'), 
			'heavy' . '_profile_post_cat' => 				1, 
			'heavy' . '_profile_post_comment' => 			1, 
			'heavy' . '_profile_post_like' => 			1, 
			'heavy' . '_profile_post_nav_box' => 			1, 
			'heavy' . '_profile_post_nav_order_cat' => 	0, 
			'heavy' . '_profile_post_share_box' => 		1, 
			'heavy' . '_profile_post_slug' => 			'profile', 
			'heavy' . '_profile_pl_categs_slug' => 		'pl-categs' 
		) 
	);
	
	
	if ($id) {
		return $settings[$id];
	} else {
		return $settings;
	}
}

}



/* Project Puzzle Proportion */
if (!function_exists('heavy_project_puzzle_proportion')) {

function heavy_project_puzzle_proportion() {
	return 0.7245;
}

}



/* Project Puzzle Proportion */
if (!function_exists('heavy_project_puzzle_large_gar_parameters')) {

function heavy_project_puzzle_large_gar_parameters() {
	$parameter = array ( 
		'container_width' 		=> 1160, 
		'bottomStaticPadding' 	=> 2 
	);
	
	
	return $parameter;
}

}



/* Theme Image Thumbnails Size */
if (!function_exists('heavy_get_image_thumbnail_list')) {

function heavy_get_image_thumbnail_list() {
	$list = array( 
		'cmsmasters-small-thumb' => array( 
			'width' => 		90, 
			'height' => 	90, 
			'crop' => 		true 
		), 
		'cmsmasters-square-thumb' => array( 
			'width' => 		300, 
			'height' => 	300, 
			'crop' => 		true, 
			'title' => 		esc_attr__('Square', 'heavy') 
		), 
		'cmsmasters-blog-masonry-thumb' => array( 
			'width' => 		580, 
			'height' => 	370, 
			'crop' => 		true, 
			'title' => 		esc_attr__('Masonry Blog', 'heavy') 
		), 
		'cmsmasters-project-thumb' => array( 
			'width' => 		400, 
			'height' => 	544, 
			'crop' => 		true, 
			'title' => 		esc_attr__('Project', 'heavy') 
		), 
		'cmsmasters-project-masonry-thumb' => array( 
			'width' => 		580, 
			'height' => 	9999, 
			'title' => 		esc_attr__('Masonry Project', 'heavy') 
		), 
		'post-thumbnail' => array( 
			'width' => 		860, 
			'height' => 	530, 
			'crop' => 		true, 
			'title' => 		esc_attr__('Featured', 'heavy') 
		), 
		'cmsmasters-masonry-thumb' => array( 
			'width' => 		860, 
			'height' => 	9999, 
			'title' => 		esc_attr__('Masonry', 'heavy') 
		), 
		'cmsmasters-full-thumb' => array( 
			'width' => 		1160, 
			'height' => 	600, 
			'crop' => 		true, 
			'title' => 		esc_attr__('Full', 'heavy') 
		), 
		'cmsmasters-project-full-thumb' => array( 
			'width' => 		1160, 
			'height' => 	650, 
			'crop' => 		true, 
			'title' => 		esc_attr__('Project Full', 'heavy') 
		), 
		'cmsmasters-full-masonry-thumb' => array( 
			'width' => 		1160, 
			'height' => 	9999, 
			'title' => 		esc_attr__('Masonry Full', 'heavy') 
		) 
	);
	
	
	return $list;
}

}



/* Project Post Type Registration Rename */
if (!function_exists('heavy_project_labels')) {

function heavy_project_labels() {
	return array( 
		'name' => 					esc_html__('Projects', 'heavy'), 
		'singular_name' => 			esc_html__('Project', 'heavy'), 
		'menu_name' => 				esc_html__('Projects', 'heavy'), 
		'all_items' => 				esc_html__('All Projects', 'heavy'), 
		'add_new' => 				esc_html__('Add New', 'heavy'), 
		'add_new_item' => 			esc_html__('Add New Project', 'heavy'), 
		'edit_item' => 				esc_html__('Edit Project', 'heavy'), 
		'new_item' => 				esc_html__('New Project', 'heavy'), 
		'view_item' => 				esc_html__('View Project', 'heavy'), 
		'search_items' => 			esc_html__('Search Projects', 'heavy'), 
		'not_found' => 				esc_html__('No projects found', 'heavy'), 
		'not_found_in_trash' => 	esc_html__('No projects found in Trash', 'heavy') 
	);
}

}

// add_filter('cmsmasters_project_labels_filter', 'heavy_project_labels');


if (!function_exists('heavy_pj_categs_labels')) {

function heavy_pj_categs_labels() {
	return array( 
		'name' => 					esc_html__('Project Categories', 'heavy'), 
		'singular_name' => 			esc_html__('Project Category', 'heavy') 
	);
}

}

// add_filter('cmsmasters_pj_categs_labels_filter', 'heavy_pj_categs_labels');


if (!function_exists('heavy_pj_tags_labels')) {

function heavy_pj_tags_labels() {
	return array( 
		'name' => 					esc_html__('Project Tags', 'heavy'), 
		'singular_name' => 			esc_html__('Project Tag', 'heavy') 
	);
}

}

// add_filter('cmsmasters_pj_tags_labels_filter', 'heavy_pj_tags_labels');



/* Profile Post Type Registration Rename */
if (!function_exists('heavy_profile_labels')) {

function heavy_profile_labels() {
	return array( 
		'name' => 					esc_html__('Profiles', 'heavy'), 
		'singular_name' => 			esc_html__('Profiles', 'heavy'), 
		'menu_name' => 				esc_html__('Profiles', 'heavy'), 
		'all_items' => 				esc_html__('All Profiles', 'heavy'), 
		'add_new' => 				esc_html__('Add New', 'heavy'), 
		'add_new_item' => 			esc_html__('Add New Profile', 'heavy'), 
		'edit_item' => 				esc_html__('Edit Profile', 'heavy'), 
		'new_item' => 				esc_html__('New Profile', 'heavy'), 
		'view_item' => 				esc_html__('View Profile', 'heavy'), 
		'search_items' => 			esc_html__('Search Profiles', 'heavy'), 
		'not_found' => 				esc_html__('No Profiles found', 'heavy'), 
		'not_found_in_trash' => 	esc_html__('No Profiles found in Trash', 'heavy') 
	);
}

}

// add_filter('cmsmasters_profile_labels_filter', 'heavy_profile_labels');


if (!function_exists('heavy_pl_categs_labels')) {

function heavy_pl_categs_labels() {
	return array( 
		'name' => 					esc_html__('Profile Categories', 'heavy'), 
		'singular_name' => 			esc_html__('Profile Category', 'heavy') 
	);
}

}

// add_filter('cmsmasters_pl_categs_labels_filter', 'heavy_pl_categs_labels');

