<?php
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version		1.0.0
 * 
 * Posts Slider Post Template
 * Created by CMSMasters
 * 
 */


$cmsmasters_metadata = explode(',', $cmsmasters_post_metadata);


$title = in_array('title', $cmsmasters_metadata) ? true : false;
$excerpt = (in_array('excerpt', $cmsmasters_metadata) && heavy_slider_post_check_exc_cont('post')) ? true : false;
$date = in_array('date', $cmsmasters_metadata) ? true : false;
$categories = (get_the_category() && (in_array('categories', $cmsmasters_metadata))) ? true : false;
$author = in_array('author', $cmsmasters_metadata) ? true : false;
$comments = (comments_open() && (in_array('comments', $cmsmasters_metadata))) ? true : false;
$likes = in_array('likes', $cmsmasters_metadata) ? true : false;
$more = in_array('more', $cmsmasters_metadata) ? true : false;


$cmsmasters_post_format = get_post_format();

?>
<!-- Start Posts Slider Post Article -->
<article id="post-<?php the_ID(); ?>" <?php post_class('cmsmasters_slider_post'); ?>>
	<div class="cmsmasters_slider_post_outer">
	<?php
		if ($date || $title || $excerpt || $more || $author || $categories || $likes || $comments) {
			echo '<div class="cmsmasters_slider_post_inner">';
				
				$categories ? heavy_get_slider_post_category(get_the_ID(), 'category', 'post') : '';
				
				$title ? heavy_slider_post_heading(get_the_ID(), 'post', 'h4') : '';
				
				
				if ($author || $comments) {
					echo '<div class="cmsmasters_slider_post_cont_info entry-meta">';
					
						$author ? heavy_get_slider_post_author('post') : '';
						
						$comments ? heavy_get_slider_post_comments('post') : '';
						
					echo '</div>';
				}
				
				
				echo '<div class="cmsmasters_slider_post_img_wrap">';
				
					heavy_thumb_rollover(get_the_ID(), 'cmsmasters-blog-masonry-thumb', false, true, false, false, false, false, false, false, true, false, false);
					
				echo '</div>';
				
				
				$excerpt ? heavy_slider_post_exc_cont('post') : '';
				
				
				if ($more) {
					echo '<div class="cmsmasters_post_read_more_wrap">';
					
						$more ? heavy_slider_post_more(get_the_ID()) : '';
						
					echo '</div>';
				}
				
				
				if ($date || $likes) {
					echo '<footer class="cmsmasters_slider_post_footer entry-meta">';
						
						$date ? heavy_get_slider_post_date('post') : '';
						
						$likes ? heavy_slider_post_like('post') : '';
						
					echo '</footer>';
				}
				
			echo '</div>';
		}
	?>
	</div>
</article>
<!-- Finish Posts Slider Post Article -->

