<?php
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version 	1.0.0
 * 
 * Theme Fonts Rules
 * Created by CMSMasters
 * 
 */


function heavy_theme_fonts() {
	$cmsmasters_option = heavy_get_global_options();
	
	
	$custom_css = "/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version 	1.0.0
 * 
 * Theme Fonts Rules
 * Created by CMSMasters
 * 
 */


/***************** Start Theme Font Styles ******************/

	/* Start Content Font */
	body,
	.mid_nav a .nav_subtitle,
	.bot_nav a .nav_subtitle,
	.mid_nav a .nav_tag, 
	.bot_nav a .nav_tag, 
	.footer_copyright,
	.footer_copyright a,
	.cmsmasters_twitter_wrap .published, 
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tab.tab_comments li,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tab.tab_comments li p,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tab.tab_comments li .cmsmasters_comments_post_title small,
	.cmsmasters_quotes .cmsmasters_quote_subtitle,
	.cmsmasters_open_project .project_details_item_desc .cmsmasters_project_category a, 
	.cmsmasters_project_puzzle .cmsmasters_project_cont_info *, 
	.cmsmasters_slider_post .cmsmasters_slider_post_category *, 
	.cmsmasters_slider_project .cmsmasters_slider_project_cont_info *, 
	.cmsmasters_project_grid .cmsmasters_project_cont_info *,
	.cmsmasters_post_default .cmsmasters_post_info,
	.cmsmasters_post_default .cmsmasters_post_info a {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_content_font_google_font']) . $cmsmasters_option['heavy' . '_content_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_content_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_content_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_content_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_content_font_font_style'] . ";
		text-decoration:none;
	}
	
	.widget_custom_twitter_entries .tweet_time, 
	.cmsmasters_open_project .project_details_item_desc .cmsmastersLike:before,
	.cmsmasters_open_project .project_features_item_desc .cmsmastersLike:before,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tab.tab_comments li,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tab.tab_comments li p {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] - 2) . "px;
	}
	
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tab.tab_comments li .cmsmasters_comments_post_title small {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] - 3) . "px;
	}
	
	.mid_nav a .nav_tag, 
	.bot_nav a .nav_tag, 
	.mid_nav a .nav_subtitle,
	.bot_nav a .nav_subtitle {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] - 3) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_content_font_line_height'] - 4) . "px;
	}
	
	.mid_nav a .nav_subtitle,
	.bot_nav a .nav_subtitle {
		text-transform:none;
	}
	
	.cmsmasters_icon_list_items li:before {
		line-height:" . $cmsmasters_option['heavy' . '_content_font_line_height'] . "px;
	}
	
	@media only screen and (max-width: 540px) {
		.cmsmasters_project_puzzle .cmsmasters_project_cont_info,
		.cmsmasters_project_puzzle .cmsmasters_project_cont_info a {
			font-size:" . ((int) $cmsmasters_option['heavy' . '_content_font_font_size'] - 2) . "px;
		}
	}
	/* Finish Content Font */


	/* Start Link Font */
	a,
	.subpage_nav > span,
	.subpage_nav > a {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_link_font_google_font']) . $cmsmasters_option['heavy' . '_link_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_link_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_link_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_link_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_link_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_link_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_link_font_text_decoration'] . ";
	}
	
	.cmsmasters_wrap_pagination ul li .page-numbers,
	.cmsmasters_comment_item .cmsmasters_comment_item_avatar a {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_link_font_font_size'] - 1) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_link_font_line_height'] - 2) . "px;
	}
	
	a:hover,
	.share_posts a,
	.about_author .about_author_inner .about_author_cont a {
		text-decoration:" . $cmsmasters_option['heavy' . '_link_hover_decoration'] . ";
	}
	/* Finish Link Font */


	/* Start Navigation Title Font */
	.navigation > li > a {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_nav_title_font_google_font']) . $cmsmasters_option['heavy' . '_nav_title_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_nav_title_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_nav_title_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_nav_title_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_nav_title_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_nav_title_font_text_transform'] . ";
	}
	
	.mid_nav div.menu-item-mega-container > ul > li > a,
	.bot_nav div.menu-item-mega-container > ul > li > a {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_nav_title_font_google_font']) . $cmsmasters_option['heavy' . '_nav_title_font_system_font'] . ";
		font-size:" . ((int)$cmsmasters_option['heavy' . '_nav_title_font_font_size'] - 2) . "px;
		line-height:" . $cmsmasters_option['heavy' . '_nav_title_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_nav_title_font_font_weight'] . ";
	}
	
	.header_top .meta_wrap * {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_nav_title_font_font_size'] - 1) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_nav_title_font_line_height'] - 2) . "px;
	}
	
	.header_top .meta_wrap > *:before {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_nav_title_font_font_size'] + 2) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_nav_title_font_line_height'] - 2) . "px;
	}
	
	@media only screen and (max-width: 1024px) {
		#header .navigation .cmsmasters_resp_nav_toggle {
			font-size:" . ((int) $cmsmasters_option['heavy' . '_nav_title_font_font_size'] + 6) . "px;
		}
	}
	
	.mid_nav div.menu-item-mega-container > ul > li > a,
	.bot_nav div.menu-item-mega-container > ul > li > a {
		text-transform:" . $cmsmasters_option['heavy' . '_nav_title_font_text_transform'] . ";
	}
	/* Finish Navigation Title Font */


	/* Start Navigation Dropdown Font */
	.navigation ul li a,
	.top_line_nav li > a {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_nav_dropdown_font_google_font']) . $cmsmasters_option['heavy' . '_nav_dropdown_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_nav_dropdown_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_nav_dropdown_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_nav_dropdown_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_nav_dropdown_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_nav_dropdown_font_text_transform'] . ";
	}
	
	.top_line_nav li > a {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_nav_dropdown_font_font_size'] - 1) . "px;
	}
	
	.top_line_nav li li > a {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_nav_dropdown_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_nav_dropdown_font_line_height'] - 2) . "px;
	}
	
	@media only screen and (min-width: 1025px) and (max-width: 1279px) {
		.navigation ul li a {
			font-size:" . ((int) $cmsmasters_option['heavy' . '_nav_dropdown_font_font_size'] - 1) . "px;
		}
	}
	/* Finish Navigation Dropdown Font */


	/* Start H1 Font */
	h1,
	h1 a,
	.logo .title,
	.cmsmasters_pricing_table .cmsmasters_price_wrap,
	.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter.counter_has_icon_or_image .cmsmasters_counter_inner .cmsmasters_counter_counter_wrap, 
	.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner .cmsmasters_counter_counter_wrap {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h1_font_google_font']) . $cmsmasters_option['heavy' . '_h1_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_h1_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_h1_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_h1_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h1_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_h1_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_h1_font_text_decoration'] . ";
	}
	
	h1 a:hover {
		text-decoration:" . $cmsmasters_option['heavy' . '_h1_font_text_decoration'] . ";
	}
	
	@media only screen and (min-width: 1280px) {
		.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner .cmsmasters_counter_counter_wrap {
			font-size:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] + 10) . "px;
			line-height:" . ((int) $cmsmasters_option['heavy' . '_h1_font_line_height'] + 16) . "px;
		}
		
		.cmsmasters_counters.counters_type_vertical .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner .cmsmasters_counter_counter_wrap {
			font-size:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] + 20) . "px;
			line-height:" . ((int) $cmsmasters_option['heavy' . '_h1_font_line_height'] + 16) . "px;
		}
	}
	
	.cmsmasters_dropcap {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h1_font_google_font']) . $cmsmasters_option['heavy' . '_h1_font_system_font'] . ";
		font-weight:" . $cmsmasters_option['heavy' . '_h1_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h1_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_h1_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_h1_font_text_decoration'] . ";
	}
	
	.cmsmasters_icon_list_items.cmsmasters_icon_list_icon_type_number .cmsmasters_icon_list_item .cmsmasters_icon_list_icon:before,
	.cmsmasters_icon_box.box_icon_type_number:before,
	.cmsmasters_icon_box.cmsmasters_icon_heading_left.box_icon_type_number .icon_box_heading:before {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h1_font_google_font']) . $cmsmasters_option['heavy' . '_h1_font_system_font'] . ";
		font-weight:" . $cmsmasters_option['heavy' . '_h1_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h1_font_font_style'] . ";
	}
	
	.cmsmasters_quotes_slider .cmsmasters_quote_content,
	.cmsmasters_open_profile .cmsmasters_profile_header .cmsmasters_profile_title {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] - 4) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_h1_font_line_height'] - 10) . "px;
	}
	
	.cmsmasters_dropcap.type1 {
		font-size:44px; /* static */
	}
	
	.cmsmasters_dropcap.type2 {
		font-size:22px; /* static */
	}
	
	.headline_outer .headline_inner .headline_icon:before {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] + 5) . "px;
	}
	
	.headline_outer .headline_inner.align_center .headline_icon:before {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h1_font_line_height'] + 15) . "px;
	}
	
	.headline_outer .headline_inner.align_left .headline_icon {
		padding-left:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] + 25) . "px;
	}
	
	.headline_outer .headline_inner.align_right .headline_icon {
		padding-right:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] + 25) . "px;
	}
	
	.headline_outer .headline_inner.align_center .headline_icon {
		padding-top:" . ((int) $cmsmasters_option['heavy' . '_h1_font_line_height'] + 15) . "px;
	}
	
	.widget_tag_cloud a {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h1_font_google_font']) . $cmsmasters_option['heavy' . '_h1_font_system_font'] . ";
	}
	
	@media only screen and (max-width: 768px) {
		.headline_outer .headline_inner.align_left .headline_icon {
			padding-top:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] + 15) . "px;
		}
		
		.headline_outer .headline_inner.align_right .headline_icon {
			padding-top:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] + 15) . "px;
		}
	}
	/* Finish H1 Font */


	/* Start H2 Font */
	h2,
	h2 a,
	.cmsmasters_stats.stats_mode_circles .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_inner .cmsmasters_stat_counter_wrap,
	.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > a,
	.cmsmasters_post_default .cmsmasters_post_cont_info > a,
	.cmsmasters_post_default .cmsmasters_post_cont_info > a abbr {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h2_font_google_font']) . $cmsmasters_option['heavy' . '_h2_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_h2_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_h2_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_h2_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h2_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_h2_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_h2_font_text_decoration'] . ";
	}
	
	h2 a:hover {
		text-decoration:" . $cmsmasters_option['heavy' . '_h2_font_text_decoration'] . ";
	}
	
	.cmsmasters_stats.stats_mode_circles .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_inner .cmsmasters_stat_counter_wrap {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h2_font_font_size'] - 4) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_h2_font_line_height'] - 14) . "px;
	}
	
	@media only screen and (max-width: 600px) {
		.cmsmasters_post_default .cmsmasters_post_title,
		.cmsmasters_post_default .cmsmasters_post_title a,
		.cmsmasters_post_default .cmsmasters_post_cont_info > a,
		.cmsmasters_post_default .cmsmasters_post_cont_info > a abbr {
			font-size:" . ((int)$cmsmasters_option['heavy' . '_h2_font_font_size'] - 6) . "px;
			line-height:" . ((int)$cmsmasters_option['heavy' . '_h2_font_line_height'] - 6) . "px;
		}
	}
	/* Finish H2 Font */


	/* Start H3 Font */
	h3,
	h3 a,
	.cmsmasters_search > .about_author .about_author_cont_title,
	.cmsmasters_archive > .about_author .about_author_cont_title {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h3_font_google_font']) . $cmsmasters_option['heavy' . '_h3_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_h3_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_h3_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_h3_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h3_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_h3_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_h3_font_text_decoration'] . ";
	}
	
	h3 a:hover {
		text-decoration:" . $cmsmasters_option['heavy' . '_h3_font_text_decoration'] . ";
	}
	/* Finish H3 Font */


	/* Start H4 Font */
	h4, 
	h4 a,
	.cmsmasters_twitter_wrap .cmsmasters_twitter_item_content, 
	.cmsmasters_twitter_wrap .cmsmasters_twitter_item_content a, 
	.comment-respond .comment-reply-title, 
	.widget_custom_popular_projects_entries .cmsmasters_slider_project_inner .cmsmasters_slider_project_title,
	.widget_custom_popular_projects_entries .cmsmasters_slider_project_inner .cmsmasters_slider_project_title a,
	.widget_custom_latest_projects_entries .cmsmasters_slider_project_inner .cmsmasters_slider_project_title,
	.widget_custom_latest_projects_entries .cmsmasters_slider_project_inner .cmsmasters_slider_project_title a,
	.cmsmasters_stats.stats_mode_bars .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_inner .cmsmasters_stat_counter_wrap, 
	.cmsmasters_sitemap_wrap .cmsmasters_sitemap > li > ul > li > a, 
	.cmsmasters_sitemap_wrap .cmsmasters_sitemap_category > li > a,
	.cmsmasters_open_profile .profile_details_title,
	.cmsmasters_open_profile .profile_features_title,
	.cmsmasters_open_profile .profile_social_icons_title {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h4_font_google_font']) . $cmsmasters_option['heavy' . '_h4_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_h4_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_h4_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_h4_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h4_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_h4_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_h4_font_text_decoration'] . ";
	}
	
	h4 a:hover {
		text-decoration:" . $cmsmasters_option['heavy' . '_h4_font_text_decoration'] . ";
	}
	
	@media only screen and (min-width: 1025px) and (max-width: 1280px) {
		.cmsmasters_counters.counters_type_horizontal .cmsmasters_counter_wrap .cmsmasters_counter.counter_has_icon_or_image .cmsmasters_counter_inner .cmsmasters_counter_counter_wrap {
			font-size:" . $cmsmasters_option['heavy' . '_h4_font_font_size'] . "px;
			line-height:" . $cmsmasters_option['heavy' . '_h4_font_line_height'] . "px;
		}
	}
	
	@media only screen and (max-width: 950px) {
		.cmsmasters_project_grid .cmsmasters_project_title,
		.cmsmasters_project_grid .cmsmasters_project_title a {
			font-size:" . ((int)$cmsmasters_option['heavy' . '_h4_font_font_size'] - 6) . "px;
			line-height:" . ((int)$cmsmasters_option['heavy' . '_h4_font_line_height'] - 6) . "px;
		}
	}
	/* Finish H4 Font */


	/* Start H5 Font */
	h5,
	h5 a,
	.widgettitle,
	.widgettitle a,
	.recent-posts-widget-with-thumbnails ul li a,
	.comment-respond .comment-reply-title a, 
	.cmsmasters_comment_item .cmsmasters_comment_item_title,
	.cmsmasters_comment_item .cmsmasters_comment_item_title a,
	.cmsmasters_stats.stats_type_vertical .cmsmasters_stat_wrap .cmsmasters_stat_title, 
	.cmsmasters_stats.stats_mode_bars .cmsmasters_stat_wrap .cmsmasters_stat_counter_wrap, 
	.cmsmasters_stats.stats_mode_circles .cmsmasters_stat_wrap .cmsmasters_stat .cmsmasters_stat_inner .cmsmasters_stat_counter_wrap .cmsmasters_stat_units, 
	.cmsmasters_stats.stats_type_horizontal .cmsmasters_stat_wrap .cmsmasters_stat_title,
	.cmsmasters_tabs .cmsmasters_tabs_list_item a,
	.cmsmasters_toggles .cmsmasters_toggle_title a, 
	.cmsmasters_archive_type .cmsmasters_archive_item_type,
	.cmsmasters_pricing_table .cmsmasters_period,
	.cmsmasters_counters .cmsmasters_counter_wrap .cmsmasters_counter .cmsmasters_counter_inner .cmsmasters_counter_title,
	.post_nav > span a,
	.project_navi a {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h5_font_google_font']) . $cmsmasters_option['heavy' . '_h5_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_h5_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_h5_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_h5_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h5_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_h5_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_h5_font_text_decoration'] . ";
	}
	
	h5 a:hover {
		text-decoration:" . $cmsmasters_option['heavy' . '_h5_font_text_decoration'] . ";
	}
	
	.cmsmasters_pricing_table .cmsmasters_period {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h5_font_font_size'] - 4) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_h5_font_line_height'] - 4) . "px;
	}
	
	.post_nav > span a,
	.cmsmasters_comment_item .cmsmasters_comment_item_cont_info,
	.cmsmasters_comment_item .cmsmasters_comment_item_title,
	.cmsmasters_comment_item .cmsmasters_comment_item_title a {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h5_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_h5_font_line_height'] - 4) . "px;
	}
	
	.widget_rss ul li * {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h5_font_google_font']) . $cmsmasters_option['heavy' . '_h5_font_system_font'] . ";
	}
	
	@media only screen and (max-width: 540px) {
		.cmsmasters_project_puzzle .cmsmasters_project_header .cmsmasters_project_title,
		.cmsmasters_project_puzzle .cmsmasters_project_header .cmsmasters_project_title a {
			font-size:" . ((int) $cmsmasters_option['heavy' . '_h5_font_font_size'] - 4) . "px;
			line-height:" . ((int) $cmsmasters_option['heavy' . '_h5_font_line_height'] - 4) . "px;
		}
	}
	/* Finish H5 Font */


	/* Start H6 Font */
	h6,
	h6 a,
	.widget_recent_comments ul li a,
	.widget_recent_entries ul li a,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_lpr_tabs_cont > a,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tab.tab_comments li .cmsmasters_comments_post_title a,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tabs_list .cmsmasters_tabs_list_item a, 
	.cmsmasters_breadcrumbs .cmsmasters_breadcrumbs_inner *,
	.cmsmasters_img .cmsmasters_img_caption,
	.footer_nav > li > a,
	.cmsmasters_table caption,
	.cmsmasters_items_filter_wrap .cmsmasters_items_filter_but,
	.cmsmasters_items_filter_wrap .cmsmasters_items_sort_but,
	.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list,
	.cmsmasters_items_filter_wrap .cmsmasters_items_filter_list li a,
	.widget_custom_contact_form_entries .cmsmasters-form-builder *,
	.widget_custom_contact_info_entries div *,
	.widget_custom_contact_info_entries span *,
	.widget_nav_menu .menu a,
	.widget_pages ul li a {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h6_font_google_font']) . $cmsmasters_option['heavy' . '_h6_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_h6_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_h6_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_h6_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h6_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_h6_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_h6_font_text_decoration'] . ";
	}
	
	h6 a:hover {
		text-decoration:" . $cmsmasters_option['heavy' . '_h6_font_text_decoration'] . ";
	}
	
	.cmsmasters-form-builder label,
	.cmsmasters_breadcrumbs .cmsmasters_breadcrumbs_inner *,
	.wpcf7-form p {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_h6_font_google_font']) . $cmsmasters_option['heavy' . '_h6_font_system_font'] . ";
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h6_font_font_size'] - 1) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_h6_font_line_height'] - 1) . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_h6_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_h6_font_font_style'] . ";
		text-decoration:" . $cmsmasters_option['heavy' . '_h6_font_text_decoration'] . ";
	}
	
	.widget_recent_entries ul li span {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h6_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_h6_font_font_size'] - 2) . "px;
	}

	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_lpr_tabs_cont .published {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_h6_font_font_size'] - 3) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_h6_font_font_size'] - 3) . "px;
	}
	
	@media only screen and (min-width: 951px) and (max-width: 1279px) {
		.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tabs_list .cmsmasters_tabs_list_item a,
		.widget_custom_contact_info_entries div *, 
		.widget_custom_contact_info_entries span * {
			font-size:" . ((int) $cmsmasters_option['heavy' . '_h6_font_font_size'] - 3) . "px;
		}
	}
	/* Finish H6 Font */


	/* Start Button Font */
	.cmsmasters_button, 
	.button, 
	input[type=submit], 
	input[type=button], 
	button,
	.cmsmasters_post_default .cmsmasters_post_read_more,
	.cmsmasters_post_masonry .cmsmasters_post_read_more,
	.cmsmasters_post_timeline .cmsmasters_post_read_more,
	.cmsmasters_slider_post .cmsmasters_slider_post_read_more, 
	.widget_custom_contact_form_entries .cmsmasters-form-builder .button,
	.widget_custom_contact_form_entries .cmsmasters-form-builder .button *,
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tabs_list_item a {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_button_font_google_font']) . $cmsmasters_option['heavy' . '_button_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_button_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_button_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_button_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_button_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_button_font_text_transform'] . ";
		text-decoration:none;
	}
	
	.cmsmasters_button:hover, 
	.button:hover, 
	input[type=submit]:hover, 
	input[type=button]:hover, 
	button:hover {
		text-decoration:none;
	}
	
	.cmsmasters_slider_post .cmsmasters_slider_post_read_more {
		line-height:" . $cmsmasters_option['heavy' . '_content_font_line_height'] . "px;
	}
	
	.gform_wrapper .gform_footer input.button, 
	.gform_wrapper .gform_footer input[type=submit] {
		font-size:" . $cmsmasters_option['heavy' . '_button_font_font_size'] . "px !important;
	}
	
	.widget_custom_posts_tabs_entries .cmsmasters_tabs .cmsmasters_tabs_list_item a {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_button_font_font_size'] - 1) . "px;
	}
	
	.widget_custom_contact_form_entries .cmsmasters-form-builder .button,
	.widget_custom_contact_form_entries .cmsmasters-form-builder .button * {
		line-height:" . ((int) $cmsmasters_option['heavy' . '_button_font_line_height'] - 4) . "px;
	}
	
	.cmsmasters-form-builder .form_info .cmsmasters_submit_wrap:after {
		font-size:" . $cmsmasters_option['heavy' . '_button_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_button_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_button_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_button_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_button_font_text_transform'] . ";
	}
	
	.cmsmasters_pricing_table .cmsmasters_button:not(.cmsmasters_but_clear_styles),
	.cmsmasters_slider_post .cmsmasters_slider_post_read_more, 
	.cmsmasters_post_default .cmsmasters_post_read_more,
	.cmsmasters_post_masonry .cmsmasters_post_read_more,
	.cmsmasters_button.cmsmasters_but_icon {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_button_font_font_size'] - 6) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_button_font_font_size'] + 12) . "px;
		font-weight:" . ((int) $cmsmasters_option['heavy' . '_button_font_font_weight'] + 100) . ";
		text-transform:uppercase;
		letter-spacing: 0.3em;
	}
	
	.cmsmasters_button.cmsmasters_but_icon_dark_bg, 
	.cmsmasters_button.cmsmasters_but_icon_light_bg, 
	.cmsmasters_button.cmsmasters_but_icon_divider, 
	.cmsmasters_button.cmsmasters_but_icon_inverse {
		padding-left:" . ((int) $cmsmasters_option['heavy' . '_button_font_line_height'] + 20) . "px;
	}
	
	.cmsmasters_button.cmsmasters_but_icon_dark_bg:before, 
	.cmsmasters_button.cmsmasters_but_icon_light_bg:before, 
	.cmsmasters_button.cmsmasters_but_icon_divider:before, 
	.cmsmasters_button.cmsmasters_but_icon_inverse:before, 
	.cmsmasters_button.cmsmasters_but_icon_dark_bg:after, 
	.cmsmasters_button.cmsmasters_but_icon_light_bg:after, 
	.cmsmasters_button.cmsmasters_but_icon_divider:after, 
	.cmsmasters_button.cmsmasters_but_icon_inverse:after {
		width:" . $cmsmasters_option['heavy' . '_button_font_line_height'] . "px;
	}
	/* Finish Button Font */


	/* Start Small Text Font */
	small, 
	#wp-calendar *,
	.subpage_nav > strong,
	.about_author .about_author_cont a,
	form .formError .formErrorContent,
	.recent-posts-widget-with-thumbnails ul li .rpwwt-post-author,
	.recent-posts-widget-with-thumbnails ul li .rpwwt-post-categories a,
	.recent-posts-widget-with-thumbnails ul li .rpwwt-post-date,
	.widget_recent_comments ul li,
	.cmsmasters_quotes .cmsmasters_quote_site,
	.cmsmasters_quotes .cmsmasters_quote_site a,
	.cmsmasters_slider_post .cmsmasters_slider_post_cont_info *, 
	.cmsmasters_open_post .cmsmasters_post_cont_info *,
	.cmsmasters_open_post .cmsmasters_post_footer *,
	.cmsmasters_post_default .cmsmasters_post_cont_info *,
	.cmsmasters_post_masonry .cmsmasters_post_cont_info *,
	.cmsmasters_post_timeline .cmsmasters_post_cont_info *,
	.cmsmasters_open_project .project_details_item_desc .cmsmasters_project_date,
	.cmsmasters_comment_item .cmsmasters_comment_item_date, 
	.cmsmasters_twitter_wrap .published, 
	.cmsmasters_archive_type .cmsmasters_archive_item_info .cmsmasters_archive_item_user_name,
	.cmsmasters_archive_type .cmsmasters_archive_item_info .cmsmasters_archive_item_user_name a,
	.cmsmasters_archive_type .cmsmasters_archive_item_info .cmsmasters_archive_item_category,
	.cmsmasters_archive_type .cmsmasters_archive_item_info .cmsmasters_archive_item_category a,
	.cmsmasters_archive_type .cmsmasters_archive_item_info .cmsmasters_archive_item_date_wrap, 
	.cmsmasters_slider_post .cmsmasters_slider_post_date, 
	.cmsmasters_single_slider .cmsmasters_post_date, 
	.cmsmasters_post_masonry .cmsmasters_post_info,
	.cmsmasters_open_post .cmsmasters_post_tags,
	.cmsmasters_open_post .cmsmasters_post_tags a,
	.cmsmasters_post_timeline .cmsmasters_post_info {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_small_font_google_font']) . $cmsmasters_option['heavy' . '_small_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_small_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_small_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_small_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_small_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['heavy' . '_small_font_text_transform'] . ";
		text-decoration:none;
	}
	
	.cmsmasters-form-builder small,
	.wpcf7-form small {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_small_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_small_font_line_height'] - 2) . "px;
	}
	
	.recent-posts-widget-with-thumbnails ul li .rpwwt-post-date {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_small_font_font_size'] - 1) . "px;
	}
	
	.recent-posts-widget-with-thumbnails ul li .rpwwt-post-author,
	.recent-posts-widget-with-thumbnails ul li .rpwwt-post-categories a {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_small_font_font_size'] + 1) . "px;
	}
	
	.cmsmasters_post_timeline .cmsmasters_post_info {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_small_font_font_size'] + 2) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_small_font_line_height'] + 2). "px;
		font-weight:400;
	}
	
	.cmsmasters_archive_type .cmsmasters_archive_item_info .cmsmasters_archive_item_date_wrap, 
	.cmsmasters_slider_post .cmsmasters_slider_post_date, 
	.cmsmasters_post_masonry .cmsmasters_post_info {
		line-height:" . $cmsmasters_option['heavy' . '_content_font_line_height'] . "px;
	}
	
	.gform_wrapper .description, 
	.gform_wrapper .gfield_description, 
	.gform_wrapper .gsection_description, 
	.gform_wrapper .instruction {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_small_font_google_font']) . $cmsmasters_option['heavy' . '_small_font_system_font'] . " !important;
		font-size:" . $cmsmasters_option['heavy' . '_small_font_font_size'] . "px !important;
		line-height:" . $cmsmasters_option['heavy' . '_small_font_line_height'] . "px !important;
	}
	/* Finish Small Text Font */


	/* Start Text Fields Font */
	input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]),
	textarea,
	select,
	option {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_input_font_google_font']) . $cmsmasters_option['heavy' . '_input_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_input_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_input_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_input_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_input_font_font_style'] . ";
	}
	
	textarea {
		background-size:100% " . ((int)$cmsmasters_option['heavy' . '_input_font_line_height'] + 1) . "px;
		min-height:" . ((int)$cmsmasters_option['heavy' . '_input_font_line_height'] + 1) . "px;
		height:" . ((int)$cmsmasters_option['heavy' . '_input_font_line_height'] + 1) . "px;
	}
	
	textarea:focus,
	textarea.area_opened {
		min-height:" . ((int) $cmsmasters_option['heavy' . '_input_font_line_height'] * 5) . "px;
	}
	
	.cmsmasters_header_search_form input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]) {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_input_font_google_font']) . $cmsmasters_option['heavy' . '_input_font_system_font'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_input_font_font_style'] . ";
	}
	
	.gform_wrapper input:not([type=submit]):not([type=button]):not([type=radio]):not([type=checkbox]),
	.gform_wrapper textarea, 
	.gform_wrapper select {
		font-size:" . $cmsmasters_option['heavy' . '_input_font_font_size'] . "px !important;
	}
	
	#page input[type=number] {
		font-size:" . ((int) $cmsmasters_option['heavy' . '_input_font_font_size'] + 1) . "px;
	}
	
	/* Finish Text Fields Font */


	/* Start Blockquote Font */
	blockquote,
	.cmsmasters_quotes_slider .cmsmasters_quote_content {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_quote_font_google_font']) . $cmsmasters_option['heavy' . '_quote_font_system_font'] . ";
		font-size:" . $cmsmasters_option['heavy' . '_quote_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['heavy' . '_quote_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['heavy' . '_quote_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_quote_font_font_style'] . ";
	}
	
	q {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_quote_font_google_font']) . $cmsmasters_option['heavy' . '_quote_font_system_font'] . ";
		font-weight:" . $cmsmasters_option['heavy' . '_quote_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['heavy' . '_quote_font_font_style'] . ";
	}
	
	.cmsmasters_quotes_grid .cmsmasters_quote_content {
		font-family:" . heavy_get_google_font($cmsmasters_option['heavy' . '_quote_font_google_font']) . $cmsmasters_option['heavy' . '_quote_font_system_font'] . ";
		font-size:" . ((int) $cmsmasters_option['heavy' . '_quote_font_font_size'] - 8) . "px;
		line-height:" . ((int) $cmsmasters_option['heavy' . '_quote_font_line_height'] - 6)  . "px;
		font-weight: 500;
	}
	
	@media only screen and (max-width: 768px) {
		.cmsmasters_quotes_slider .cmsmasters_quote_content {
			font-size:" . ((int) $cmsmasters_option['heavy' . '_quote_font_font_size'] - 6) . "px;
			line-height:" . ((int) $cmsmasters_option['heavy' . '_quote_font_line_height'] - 6)  . "px;
		}
	}
	/* Finish Blockquote Font */

/***************** Finish Theme Font Styles ******************/


";

if ($cmsmasters_option['heavy' . '_h1_font_font_size'] > 49) {
	$custom_css .= "
		@media only screen and (max-width: 950px) {
			h1,
			h1 a {
				font-size:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] - 14) . "px;
				line-height:" . ((int) $cmsmasters_option['heavy' . '_h1_font_line_height'] - 14) . "px;
			}
		}
		
		@media only screen and (max-width: 768px) {
			h1,
			h1 a {
				font-size:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] - 18) . "px;
				line-height:" . ((int) $cmsmasters_option['heavy' . '_h1_font_line_height'] - 18) . "px;
			}
		}
		
		@media only screen and (max-width: 600px) {
			h1,
			h1 a {
				font-size:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] - 22) . "px;
				line-height:" . ((int) $cmsmasters_option['heavy' . '_h1_font_line_height'] - 22) . "px;
			}
		}
		
		@media only screen and (max-width: 540px) {
			h1,
			h1 a {
				font-size:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] - 26) . "px;
				line-height:" . ((int) $cmsmasters_option['heavy' . '_h1_font_line_height'] - 26) . "px;
			}
		}
		
		@media only screen and (max-width: 320px) {
			h1,
			h1 a {
				font-size:" . ((int) $cmsmasters_option['heavy' . '_h1_font_font_size'] - 30) . "px;
				line-height:" . ((int) $cmsmasters_option['heavy' . '_h1_font_line_height'] - 30) . "px;
			}
		}
	";
} else {
	$custom_css .= "
		@media only screen and (max-width: 950px) {
			h1,
			h1 a {
				font-size:36px;
				line-height:40px;
			}
		}
		
		@media only screen and (max-width: 767px) {
			h1,
			h1 a {
				font-size:32px;
				line-height:38px;
			}
		}
		
		@media only screen and (max-width: 600px) {
			h1,
			h1 a {
				font-size:28px;
				line-height:34px;
			}
		}
		
		@media only screen and (max-width: 540px) {
			h1,
			h1 a {
				font-size:24px;
				line-height:30px;
			}
		}
		
		@media only screen and (max-width: 320px) {
			h1,
			h1 a {
				font-size:20px;
				line-height:26px;
			}
		}
	";
}
	
	
	return apply_filters('heavy_theme_fonts_filter', $custom_css);
}

