<?php
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version 	1.0.0
 * 
 * Content Composer Tabs Shortcode
 * Created by CMSMasters
 * 
 */


extract(shortcode_atts($new_atts, $atts));


if ($form_id == '') {
	return '';
}


$out = '<div class="cmsmasters_mailpoet' . 
(($classes != '') ? ' ' . esc_attr($classes) : '') . 
'"' . 
(($animation != '') ? ' data-animation="' . esc_attr($animation) . '"' : '') . 
(($animation != '' && $animation_delay != '') ? ' data-delay="' . esc_attr($animation_delay) . '"' : '') . 
'>';


if (class_exists('\MailPoet\Config\Initializer')) {
	$model_forms = new \MailPoet\Models\Form();
	
	$form_data = $model_forms::findOne($form_id);
	
	
	if (isset($form_data->body)) {
		$form_data = maybe_unserialize($form_data->orm->body);
	} else {
		$form_data = array();
	}
	
	
	if (
		count($form_data) == 3 && 
		(
			(
				isset($form_data['block-1']) && 
				$form_data['block-1']['type'] == 'text' && 
				$form_data['block-2']['type'] == 'text' && 
				$form_data['block-2']['type'] == 'submit'
			) || (
				isset($form_data[0]) && 
				$form_data[0]['type'] == 'text' && 
				$form_data[1]['type'] == 'text' && 
				$form_data[1]['type'] == 'submit'
			)
		)
	) {
		$out .= '<div class="cmsmasters_mailpoet_form">' . 
			do_shortcode('[mailpoet_form id="' . $form_id . '"]') . 
		'</div>';
	} else {
		$out .= do_shortcode('[mailpoet_form id="' . $form_id . '"]');
	}
}


$out .= '</div>';


echo heavy_return_content($out);