<?php
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version 	1.0.0
 * 
 * Content Composer Sc Name Shortcode
 * Created by CMSMasters
 * 
 */

/* 
	1. Create a separate file for each of the shortcodes that need to be edited. 
	2. Contents of this file will be used to substitute the corresponding code in the shortcodes.php file of the Composer Plugin.
	3. echo $out variable must contain all the shortcode front-end content
*/


extract(shortcode_atts($new_atts, $atts));
	
	
$unique_id = $shortcode_id;


$shortcode_styles = "\n" . 
	'#cmsmasters_divider_' . esc_attr($unique_id) . ' { ' . 
		"\n\t" . 'border-bottom-width:' . (($dottedrow == 'true') ? '0' : esc_attr($height)) . 'px; ' . 
		"\n\t" . 'border-bottom-style:' . esc_attr($style) . '; ' . 
		(($dottedrow == 'true') ? "\n\t" . 'height:' . esc_attr($dottedwidth) . 'px; ' : '' ) . 
		"\n\t" . 'margin-top:' . esc_attr($margin_top) . 'px; ' . 
		"\n\t" . 'margin-bottom:' . esc_attr($margin_bottom) . 'px; ' . 
		(($color != '') ? "\n\t" . cmsmasters_color_css('border-bottom-color', $color) : '') . 
		(($dottedrow == 'true' && $color != '') ? "\n\t" . cmsmasters_color_css('background-color', $dottedcolor) : '') . 
	"\n" . '} ' . 
	
	'#cmsmasters_divider_' . esc_attr($unique_id) . ':before { ' . 
		(($dottedrow == 'true' && $color != '') ?  "\n\t" . 'background-image:linear-gradient(90deg, ' . $color . ' 5px, transparent 0);' : '') .
	"\n" . '} ' . 
	
	'#cmsmasters_divider_' . esc_attr($unique_id) . ':after { ' . 
		(($dottedrow == 'true' && $color != '') ?  "\n\t" . 'background-image:linear-gradient(0, ' . $color . ' 5px, transparent 0);' : '') .
	"\n" . '} ' . 
"\n";



if ($resp_vert_mar == 'true') {
	if ($margin_top_large != '') {
		$shortcode_styles .= "
		@media only screen and (min-width: 1280px) {
			#cmsmasters_divider_" . esc_attr($unique_id) . " {
				margin-top: " . esc_attr($margin_top_large) . "px;
			}
		}
		";
	}
	
	if ($margin_bottom_large != '') {
		$shortcode_styles .= "
		@media only screen and (min-width: 1280px) {
			#cmsmasters_divider_" . esc_attr($unique_id) . " {
				margin-bottom: " . esc_attr($margin_bottom_large) . "px;
			}
		}
		";
	}
	
	if ($margin_top_laptop != '') {
		$shortcode_styles .= "
		@media only screen and (max-width: 1024px) {
			#cmsmasters_divider_" . esc_attr($unique_id) . " {
				margin-top: " . esc_attr($margin_top_laptop) . "px;
			}
		}
		";
	}
	
	if ($margin_bottom_laptop != '') {
		$shortcode_styles .= "
		@media only screen and (max-width: 1024px) {
			#cmsmasters_divider_" . esc_attr($unique_id) . " {
				margin-bottom: " . esc_attr($margin_bottom_laptop) . "px;
			}
		}
		";
	}
	
	if ($margin_top_tablet != '') {
		$shortcode_styles .= "
		@media only screen and (max-width: 768px) {
			#cmsmasters_divider_" . esc_attr($unique_id) . " {
				margin-top: " . esc_attr($margin_top_tablet) . "px;
			}
		}
		";
	}
	
	if ($margin_bottom_tablet != '') {
		$shortcode_styles .= "
		@media only screen and (max-width: 768px) {
			#cmsmasters_divider_" . esc_attr($unique_id) . " {
				margin-bottom: " . esc_attr($margin_bottom_tablet) . "px;
			}
		}
		";
	}
	
	if ($margin_top_mobile_h != '') {
		$shortcode_styles .= "
		@media only screen and (max-width: 540px) {
			#cmsmasters_divider_" . esc_attr($unique_id) . " {
				margin-top: " . esc_attr($margin_top_mobile_h) . "px;
			}
		}
		";
	}
	
	if ($margin_bottom_mobile_h != '') {
		$shortcode_styles .= "
		@media only screen and (max-width: 540px) {
			#cmsmasters_divider_" . esc_attr($unique_id) . " {
				margin-bottom: " . esc_attr($margin_bottom_mobile_h) . "px;
			}
		}
		";
	}
	
	if ($margin_top_mobile_v != '') {
		$shortcode_styles .= "
		@media only screen and (max-width: 320px) {
			#cmsmasters_divider_" . esc_attr($unique_id) . " {
				margin-top: " . esc_attr($margin_top_mobile_v) . "px;
			}
		}
		";
	}
	
	if ($margin_bottom_mobile_v != '') {
		$shortcode_styles .= "
		@media only screen and (max-width: 320px) {
			#cmsmasters_divider_" . esc_attr($unique_id) . " {
				margin-bottom: " . esc_attr($margin_bottom_mobile_v) . "px;
			}
		}
		";
	}
}


$out = $this->cmsmasters_generate_front_css($shortcode_styles);


$out .= '<div id="cmsmasters_divider_' . esc_attr($unique_id) . '" class="' . 
(($height < 1) ? 'cl' : 'cmsmasters_divider' . (($dottedrow == 'true') ? ' cmsmasters_dotted_row' : '') . ' cmsmasters_divider_width_' . esc_attr($width) . ' cmsmasters_divider_pos_' . esc_attr($position)) . 
(($classes != '') ? ' ' . esc_attr($classes) : '') . 
'"></div>';


echo heavy_return_content($out);
