<?php
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version 	1.0.0
 * 
 * Theme Content Composer Functions
 * Created by CMSMasters
 * 
 */


/* Register JS Scripts */
function heavy_theme_register_c_c_scripts() {
	global $pagenow;
	
	
	if ( 
		$pagenow == 'post-new.php' || 
		($pagenow == 'post.php' && isset($_GET['post']) && get_post_type($_GET['post']) != 'attachment') 
	) {
		wp_enqueue_script('heavy-composer-shortcodes-extend', get_template_directory_uri() . '/theme-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/cmsmasters-c-c/js/cmsmasters-c-c-theme-extend.js', array('cmsmasters_composer_shortcodes_js'), '1.0.0', true);
		
		wp_localize_script('heavy-composer-shortcodes-extend', 'cmsmasters_theme_shortcodes', array( 
			'cmsmasters_post_slider_choice_more' => 				esc_attr__('Read More', 'heavy'), 
			'cmsmasters_portfolio_choice_more' => 					esc_attr__('Read More', 'heavy'), 
			'cmsmasters_divider_field_title' => 					esc_attr__('Dotted Divider Rows', 'heavy'),
			'cmsmasters_divider_field_descr' => 					esc_attr__('Enables dotted divider width several rows', 'heavy'),
			'cmsmasters_divider_field_enable' => 					esc_attr__('Enable', 'heavy'),
			'cmsmasters_divider_width' => 							esc_attr__('Dottes Divider Height', 'heavy'),
			'cmsmasters_divider_dotted_color_title' => 				esc_attr__('Dottes Divider Color', 'heavy'),
			'cmsmasters_divider_dotted_color_descr' => 				esc_attr__('Choose your custom dottes divider color', 'heavy'),
			'cmsmasters_but_icon' => 								esc_attr__('Button with colored icon', 'heavy'),
			'cmsmasters_but_icon_right' => 							esc_attr__('Button with icon on right corner', 'heavy'),
			'cmsmasters_button_icon_right_fullwidth_title' => 		esc_attr__('Button Fullwidth', 'heavy'),
			'cmsmasters_button_icon_right_fullwidth_descr' => 		esc_attr__('Choose to do button fullwidth', 'heavy'),
			'cmsmasters_button_icon_font_size_title' => 			esc_attr__('Button Icon Font Size', 'heavy'),
			'cmsmasters_button_icon_font_size_descr' => 			esc_attr__('Choose to do equal icon font size as button line height', 'heavy'),
			'cmsmasters_button_icon_color_title' => 				esc_attr__('Button Icon Color', 'heavy'),
			'cmsmasters_button_icon_color_descr' => 				esc_attr__('Choose your custom button icon color', 'heavy'),
			'cmsmasters_button_icon_color_hover_title' => 			esc_attr__('Button Icon Hover Color', 'heavy'),
			'cmsmasters_button_icon_color_hover_descr' => 			esc_attr__('Choose your custom button icon color on hover', 'heavy'),
			'button_field_margin_large_descr' => 					esc_attr__('Enter margin for devices with min-width 1280px and above', 'heavy'),
			'featured_text_field_padding_large_descr' => 			esc_attr__('Enter paddings for devices with min-width 1280px and above', 'heavy'),
			'featured_field_padding_top_large_descr' => 			esc_attr__('Enter top padding for devices with min-width 1280px and above', 'heavy'),
			'featured_field_padding_bottom_large_descr' => 			esc_attr__('Enter paddings for devices with min-width 1280px and above', 'heavy'),
			'featured_field_text_width_large_descr' => 				esc_attr__('Choose text block width (percentage) for devices with min-width 1280px and above', 'heavy'),
			'column_field_padding_large_descr' => 					esc_attr__('Enter paddings for devices with min-width 1280px and above', 'heavy'),
			'row_field_padding_top_large_descr' => 					esc_attr__('Enter top padding for devices with min-width 1280px and above', 'heavy'),
			'row_field_padding_bottom_large_descr' => 				esc_attr__('Enter bottom padding for devices with min-width 1280px and above', 'heavy'),
			'row_field_margin_top_large_descr' =>					esc_attr__('Enter top margin for devices with min-width 1280px and above', 'heavy'),
			'row_field_margin_bottom_large_descr' => 				esc_attr__('Enter bottom margin for devices with min-width 1280px and above', 'heavy')
		));
	}
}

add_action('admin_enqueue_scripts', 'heavy_theme_register_c_c_scripts');


// Posts Slider Shortcode Attributes Filter
add_filter('cmsmasters_divider_atts_filter', 'cmsmasters_divider_atts');

function cmsmasters_divider_atts() {
	return array( 
		'shortcode_id' => 			'', 
		'width' => 					'short', 
		'height' => 				'1', 
		'style' => 					'solid', 
		'dottedrow' => 				'', 
		'dottedwidth' => 			'20', 
		'dottedcolor' => 			'', 
		'position' => 				'center', 
		'color' => 					'', 
		'margin_top' => 			'0', 
		'margin_bottom' => 			'0', 
		'resp_vert_mar' => 			'', 
		'margin_top_large' => 		'', 
		'margin_bottom_large' => 	'', 
		'margin_top_laptop' => 		'', 
		'margin_bottom_laptop' => 	'', 
		'margin_top_tablet' => 		'', 
		'margin_bottom_tablet' => 	'', 
		'margin_top_mobile_h' => 	'', 
		'margin_bottom_mobile_h' => '', 
		'margin_top_mobile_v' => 	'', 
		'margin_bottom_mobile_v' => '', 
		'classes' => 				'' 
	);
} 


// Button Shortcode Attributes Filter
add_filter('cmsmasters_button_atts_filter', 'cmsmasters_button_atts');

function cmsmasters_button_atts() {
	return array( 
		'shortcode_id' => 					'', 
		'button_title' => 					'', 
		'button_link' => 					'#', 
		'button_target' => 					'', 
		'button_text_align' => 				'center', 
		'button_style' => 					'', 
		'button_font_family' => 			'', 
		'button_font_size' => 				'', 
		'button_line_height' => 			'', 
		'button_font_weight' => 			'', 
		'button_font_style' => 				'', 
		'button_text_transform' => 			'', 
		'button_padding_hor' => 			'', 
		'button_icon_right_fullwidth' => 	'', 
		'button_margins' => 				'', 
		'button_resp_mar' => 				'', 
		'button_margin_large' => 			'', 
		'button_margin_laptop' => 			'', 
		'button_margin_tablet' => 			'', 
		'button_margin_mobile_h' => 		'', 
		'button_margin_mobile_v' => 		'', 
		'button_border_width' => 			'', 
		'button_border_style' => 			'', 
		'button_border_radius' => 			'', 
		'button_bg_color' => 				'', 
		'button_text_color' => 				'', 
		'button_border_color' => 			'', 
		'button_bg_color_h' => 				'', 
		'button_text_color_h' => 			'', 
		'button_border_color_h' => 			'', 
		'button_icon' => 					'', 
		'button_icon_font_size' => 			'', 
		'button_icon_color' => 				'', 
		'button_icon_color_hover' =>		'', 
		'animation' => 						'', 
		'animation_delay' => 				'', 
		'classes' => 						'' 
	);
}


// Button Shortcode Attributes Filter
add_filter('cmsmasters_featured_block_atts_filter', 'cmsmasters_featured_block_atts');

function cmsmasters_featured_block_atts() {
	return array( 
		'shortcode_id' => 					'', 
		'text_width' => 					'100', 
		'text_position' => 					'center', 
		'text_padding' => 					'', 
		'resp_text_padding' => 				'', 
		'padding_text_large' => 			'', 
		'padding_text_laptop' => 			'', 
		'padding_text_tablet' => 			'', 
		'padding_text_mobile_h' => 			'', 
		'padding_text_mobile_v' => 			'', 
		'text_align' => 					'left', 
		'block_link' => 					'', 
		'block_link_target' => 				'', 
		'color_overlay' => 					'', 
		'fb_bg_color' => 					'', 
		'bg_img' => 						'', 
		'bg_position' => 					'', 
		'bg_repeat' => 						'', 
		'bg_attachment' => 					'', 
		'bg_size' => 						'', 
		'top_padding' => 					'', 
		'bottom_padding' => 				'', 
		'resp_vert_pad' => 					'', 
		'padding_top_large' => 				'', 
		'padding_bottom_large' => 			'',
		'text_width_large' =>               '',
		'padding_top_laptop' => 			'', 
		'padding_bottom_laptop' => 			'',
		'text_width_laptop' =>              '',
		'padding_top_tablet' => 			'', 
		'padding_bottom_tablet' => 			'',
		'text_width_tablet' =>              '',
		'padding_top_mobile_h' => 			'', 
		'padding_bottom_mobile_h' =>		'',
		'text_width_mobile_h' =>            '',
		'padding_top_mobile_v' => 			'', 
		'padding_bottom_mobile_v' => 		'',
		'text_width_mobile_v' =>            '',
		'border_width' => 					'', 
		'border_style' => 					'', 
		'border_color' => 					'', 
		'border_radius' => 					'', 
		'box_shadow' => 					'', 
		'animation' => 						'', 
		'animation_delay' => 				'', 
		'classes' => 						'' 
	);
}


add_filter('cmsmasters_responsive_large_dimension_filter', 'cmsmasters_responsive_large_dimension_filter_custom');

function cmsmasters_responsive_large_dimension_filter_custom() {
	return '1280';
}