<?php 
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version		1.0.0
 * 
 * Theme Admin Settings
 * Created by CMSMasters
 * 
 */


 /* General Settings */
function heavy_theme_options_general_fields($options, $tab) {
	$new_options = array();
	
	$defaults = heavy_settings_general_defaults();
	
	if ($tab == 'footer') {
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_bg_image_enable', 
			'title' => esc_html__('Footer Background Image Visibility by Default', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => 0 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_bg_image', 
			'title' => esc_html__('Footer Background Image by Default', 'heavy'), 
			'desc' => esc_html__('Choose your footer background image by default.', 'heavy'), 
			'type' => 'upload', 
			'std' => '', 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_bg_repeat', 
			'title' => esc_html__('Footer Background Repeat by Default', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'no-repeat', 
			'choices' => array( 
				esc_html__('No Repeat', 'heavy') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'heavy') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'heavy') . '|repeat-y', 
				esc_html__('Repeat', 'heavy') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_bg_pos', 
			'title' => esc_html__('Background Position', 'heavy'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => 'top center', 
			'choices' => array( 
				esc_html__('Top Left', 'heavy') . '|top left', 
				esc_html__('Top Center', 'heavy') . '|top center', 
				esc_html__('Top Right', 'heavy') . '|top right', 
				esc_html__('Center Left', 'heavy') . '|center left', 
				esc_html__('Center Center', 'heavy') . '|center center', 
				esc_html__('Center Right', 'heavy') . '|center right', 
				esc_html__('Bottom Left', 'heavy') . '|bottom left', 
				esc_html__('Bottom Center', 'heavy') . '|bottom center', 
				esc_html__('Bottom Right', 'heavy') . '|bottom right' 
			) 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_bg_attachment', 
			'title' => esc_html__('Footer Background Attachment by Default', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'fixed', 
			'choices' => array( 
				esc_html__('Scroll', 'heavy') . '|scroll', 
				esc_html__('Fixed', 'heavy') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_bg_size', 
			'title' => esc_html__('Footer Background Size by Default', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => 'cover', 
			'choices' => array( 
				esc_html__('Auto', 'heavy') . '|auto', 
				esc_html__('Cover', 'heavy') . '|cover', 
				esc_html__('Contain', 'heavy') . '|contain' 
			) 
		);
	}
	
	if ($tab == 'header') {
		foreach ($options as $option) {
			if ($option['id'] == 'heavy_header_top_line_add_cont') {
				$option['choices'] = array( 
					esc_html__('None', 'heavy') . '|none', 
					esc_html__('Top Line Navigation (will be shown if set in Appearance - Menus tab)', 'heavy') . '|nav', 
					esc_html__('Header Custom HTML', 'heavy') . '|cust_html'
				);
				
				$new_options[] = $option;
				
				$new_options[] = array( 
					'section' => 'header_section', 
					'id' => 'heavy_header_top_line_social', 
					'title' => esc_html__('Top Line Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'heavy'), 
					'desc' => 'enable', 
					'type' => 'checkbox', 
					'std' => $defaults[$tab]['heavy' . '_header_styles'] 
				);
			} else {
				$new_options[] = $option;
			}
		}
		
		$options = $new_options;
	}
	
	return $options;
}

add_filter('cmsmasters_options_general_fields_filter', 'heavy_theme_options_general_fields', 10, 2);


/* Color Settings */
function heavy_theme_options_color_fields($options, $tab) {
	$defaults = heavy_color_schemes_defaults();
	
	
	if ($tab != 'header' && $tab != 'navigation' && $tab != 'header_top') {
		$options[] = array( 
			'section' => $tab . '_section', 
			'id' => 'heavy' . '_' . $tab . '_secondary', 
			'title' => esc_html__('Secondary Color', 'heavy'), 
			'desc' => esc_html__('Secondary color for some elements', 'heavy'), 
			'type' => 'rgba', 
			'std' => (isset($defaults[$tab])) ? $defaults[$tab]['secondary'] : $defaults['default']['secondary'] 
		);
	}
	
	
	return $options;
}

add_filter('cmsmasters_options_color_fields_filter', 'heavy_theme_options_color_fields', 10, 2);