<?php 
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version		1.0.0
 * 
 * Admin Panel Post, Project, Profile Settings
 * Created by CMSMasters
 * 
 */


function heavy_options_single_tabs() {
	$tabs = array();
	
	
	$tabs['post'] = esc_attr__('Post', 'heavy');
	
	if (CMSMASTERS_PROJECT_COMPATIBLE && class_exists('Cmsmasters_Projects')) {
		$tabs['project'] = esc_attr__('Project', 'heavy');
	}
	
	if (CMSMASTERS_PROFILE_COMPATIBLE && class_exists('Cmsmasters_Profiles')) {
		$tabs['profile'] = esc_attr__('Profile', 'heavy');
	}
	
	
	return apply_filters('cmsmasters_options_single_tabs_filter', $tabs);
}


function heavy_options_single_sections() {
	$tab = heavy_get_the_tab();
	
	
	switch ($tab) {
	case 'post':
		$sections = array();
		
		$sections['post_section'] = esc_attr__('Blog Post Options', 'heavy');
		
		
		break;
	case 'project':
		$sections = array();
		
		$sections['project_section'] = esc_attr__('Portfolio Project Options', 'heavy');
		
		
		break;
	case 'profile':
		$sections = array();
		
		$sections['profile_section'] = esc_attr__('Person Block Profile Options', 'heavy');
		
		
		break;
	default:
		$sections = array();
		
		
		break;
	}
	
	
	return apply_filters('cmsmasters_options_single_sections_filter', $sections, $tab);
} 


function heavy_options_single_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = heavy_get_the_tab();
	}
	
	
	$options = array();
	
	
	$defaults = heavy_settings_single_defaults();
	
	
	switch ($tab) {
	case 'post':
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_post_layout', 
			'title' => esc_html__('Layout Type', 'heavy'), 
			'desc' => '', 
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['heavy' . '_blog_post_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_post_title', 
			'title' => esc_html__('Post Title', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_blog_post_title'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_post_date', 
			'title' => esc_html__('Post Date', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_blog_post_date'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_post_cat', 
			'title' => esc_html__('Post Categories', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_blog_post_cat'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_post_author', 
			'title' => esc_html__('Post Author', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_blog_post_author'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_post_comment', 
			'title' => esc_html__('Post Comments', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_blog_post_comment'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_post_tag', 
			'title' => esc_html__('Post Tags', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_blog_post_tag'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_post_like', 
			'title' => esc_html__('Post Likes', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_blog_post_like'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_post_nav_box', 
			'title' => esc_html__('Posts Navigation Box', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_blog_post_nav_box'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_post_nav_order_cat', 
			'title' => esc_html__('Posts Navigation Order by Category', 'heavy'), 
			'desc' => esc_html__('enable', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_blog_post_nav_order_cat'] 
		);
		
		if (class_exists('Cmsmasters_Content_Composer')) {
			$options[] = array( 
				'section' => 'post_section', 
				'id' => 'heavy' . '_blog_post_share_box', 
				'title' => esc_html__('Sharing Box', 'heavy'), 
				'desc' => esc_html__('show', 'heavy'), 
				'type' => 'checkbox', 
				'std' => $defaults[$tab]['heavy' . '_blog_post_share_box'] 
			);
		}
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_post_author_box', 
			'title' => esc_html__('About Author Box', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_blog_post_author_box'] 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_more_posts_box', 
			'title' => esc_html__('More Posts Box', 'heavy'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['heavy' . '_blog_more_posts_box'], 
			'choices' => array( 
				esc_html__('Show Related Posts', 'heavy') . '|related', 
				esc_html__('Show Popular Posts', 'heavy') . '|popular', 
				esc_html__('Show Recent Posts', 'heavy') . '|recent', 
				esc_html__('Hide More Posts Box', 'heavy') . '|hide' 
			) 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_more_posts_count', 
			'title' => esc_html__('More Posts Box Items Number', 'heavy'), 
			'desc' => esc_html__('posts', 'heavy'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['heavy' . '_blog_more_posts_count'], 
			'min' => '2', 
			'max' => '20' 
		);
		
		$options[] = array( 
			'section' => 'post_section', 
			'id' => 'heavy' . '_blog_more_posts_pause', 
			'title' => esc_html__('More Posts Slider Pause Time', 'heavy'), 
			'desc' => esc_html__("in seconds, if '0' - autoslide disabled", 'heavy'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['heavy' . '_blog_more_posts_pause'], 
			'min' => '0', 
			'max' => '20' 
		);
		
		
		break;
	case 'project':
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_title', 
			'title' => esc_html__('Project Title', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_title'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_details_title', 
			'title' => esc_html__('Project Details Title', 'heavy'), 
			'desc' => esc_html__('Enter a project details block title', 'heavy'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_details_title'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_date', 
			'title' => esc_html__('Project Date', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_date'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_cat', 
			'title' => esc_html__('Project Categories', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_cat'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_author', 
			'title' => esc_html__('Project Author', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_author'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_comment', 
			'title' => esc_html__('Project Comments', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_comment'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_tag', 
			'title' => esc_html__('Project Tags', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_tag'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_like', 
			'title' => esc_html__('Project Likes', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_like'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_link', 
			'title' => esc_html__('Project Link', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_link'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_share_box', 
			'title' => esc_html__('Sharing Box', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_share_box'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_nav_box', 
			'title' => esc_html__('Projects Navigation Box', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_nav_box'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_nav_order_cat', 
			'title' => esc_html__('Projects Navigation Order by Category', 'heavy'), 
			'desc' => esc_html__('enable', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_nav_order_cat'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_author_box', 
			'title' => esc_html__('About Author Box', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_author_box'] 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_more_projects_box', 
			'title' => esc_html__('More Projects Box', 'heavy'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_more_projects_box'], 
			'choices' => array( 
				esc_html__('Show Related Projects', 'heavy') . '|related', 
				esc_html__('Show Popular Projects', 'heavy') . '|popular', 
				esc_html__('Show Recent Projects', 'heavy') . '|recent', 
				esc_html__('Hide More Projects Box', 'heavy') . '|hide' 
			) 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_more_projects_count', 
			'title' => esc_html__('More Projects Box Items Number', 'heavy'), 
			'desc' => esc_html__('projects', 'heavy'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_more_projects_count'], 
			'min' => '2', 
			'max' => '20' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_more_projects_pause', 
			'title' => esc_html__('More Projects Slider Pause Time', 'heavy'), 
			'desc' => esc_html__("in seconds, if '0' - autoslide disabled", 'heavy'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_more_projects_pause'], 
			'min' => '0', 
			'max' => '20' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_project_slug', 
			'title' => esc_html__('Project Slug', 'heavy'), 
			'desc' => esc_html__('Enter a page slug that should be used for your projects single item', 'heavy'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_project_slug'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_pj_categs_slug', 
			'title' => esc_html__('Project Categories Slug', 'heavy'), 
			'desc' => esc_html__('Enter page slug that should be used on projects categories archive page', 'heavy'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_pj_categs_slug'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'project_section', 
			'id' => 'heavy' . '_portfolio_pj_tags_slug', 
			'title' => esc_html__('Project Tags Slug', 'heavy'), 
			'desc' => esc_html__('Enter page slug that should be used on projects tags archive page', 'heavy'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_portfolio_pj_tags_slug'], 
			'class' => '' 
		);
		
		
		break;
	case 'profile':
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'heavy' . '_profile_post_title', 
			'title' => esc_html__('Profile Title', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_profile_post_title'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'heavy' . '_profile_post_details_title', 
			'title' => esc_html__('Profile Details Title', 'heavy'), 
			'desc' => esc_html__('Enter a profile details block title', 'heavy'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_profile_post_details_title'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'heavy' . '_profile_post_cat', 
			'title' => esc_html__('Profile Categories', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_profile_post_cat'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'heavy' . '_profile_post_comment', 
			'title' => esc_html__('Profile Comments', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_profile_post_comment'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'heavy' . '_profile_post_like', 
			'title' => esc_html__('Profile Likes', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_profile_post_like'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'heavy' . '_profile_post_nav_box', 
			'title' => esc_html__('Profiles Navigation Box', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_profile_post_nav_box'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'heavy' . '_profile_post_nav_order_cat', 
			'title' => esc_html__('Profiles Navigation Order by Category', 'heavy'), 
			'desc' => esc_html__('enable', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_profile_post_nav_order_cat'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'heavy' . '_profile_post_share_box', 
			'title' => esc_html__('Sharing Box', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_profile_post_share_box'] 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'heavy' . '_profile_post_slug', 
			'title' => esc_html__('Profile Slug', 'heavy'), 
			'desc' => esc_html__('Enter a page slug that should be used for your profiles single item', 'heavy'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_profile_post_slug'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'profile_section', 
			'id' => 'heavy' . '_profile_pl_categs_slug', 
			'title' => esc_html__('Profile Categories Slug', 'heavy'), 
			'desc' => esc_html__('Enter page slug that should be used on profiles categories archive page', 'heavy'), 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_profile_pl_categs_slug'], 
			'class' => '' 
		);
		
		
		break;
	}
	
	
	return apply_filters('cmsmasters_options_single_fields_filter', $options, $tab);
}

