<?php 
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version 	1.0.0
 * 
 * Admin Panel General Options
 * Created by CMSMasters
 * 
 */


function heavy_options_general_tabs() {
	$cmsmasters_option = heavy_get_global_options();
	
	$tabs = array();
	
	$tabs['general'] = esc_attr__('General', 'heavy');
	
	if ($cmsmasters_option['heavy' . '_theme_layout'] === 'boxed') {
		$tabs['bg'] = esc_attr__('Background', 'heavy');
	}
	
	if (CMSMASTERS_THEME_STYLE_COMPATIBILITY) {
		$tabs['theme_style'] = esc_attr__('Theme Style', 'heavy');
	}
	
	$tabs['header'] = esc_attr__('Header', 'heavy');
	$tabs['content'] = esc_attr__('Content', 'heavy');
	$tabs['footer'] = esc_attr__('Footer', 'heavy');
	
	return apply_filters('cmsmasters_options_general_tabs_filter', $tabs);
}


function heavy_options_general_sections() {
	$tab = heavy_get_the_tab();
	
	switch ($tab) {
	case 'general':
		$sections = array();
		
		$sections['general_section'] = esc_attr__('General Options', 'heavy');
		
		break;
	case 'bg':
		$sections = array();
		
		$sections['bg_section'] = esc_attr__('Background Options', 'heavy');
		
		break;
	case 'theme_style':
		$sections = array();
		
		$sections['theme_style_section'] = esc_attr__('Theme Design Style', 'heavy');
		
		break;
	case 'header':
		$sections = array();
		
		$sections['header_section'] = esc_attr__('Header Options', 'heavy');
		
		break;
	case 'content':
		$sections = array();
		
		$sections['content_section'] = esc_attr__('Content Options', 'heavy');
		
		break;
	case 'footer':
		$sections = array();
		
		$sections['footer_section'] = esc_attr__('Footer Options', 'heavy');
		
		break;
	default:
		$sections = array();
		
		
		break;
	}
	
	return apply_filters('cmsmasters_options_general_sections_filter', $sections, $tab);
} 


function heavy_options_general_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = heavy_get_the_tab();
	}
	
	$options = array();
	
	
	$defaults = heavy_settings_general_defaults();
	
	
	switch ($tab) {
	case 'general':
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'heavy' . '_theme_layout', 
			'title' => esc_html__('Theme Layout', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_theme_layout'], 
			'choices' => array( 
				esc_html__('Liquid', 'heavy') . '|liquid', 
				esc_html__('Boxed', 'heavy') . '|boxed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'heavy' . '_logo_type', 
			'title' => esc_html__('Logo Type', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_logo_type'], 
			'choices' => array( 
				esc_html__('Image', 'heavy') . '|image', 
				esc_html__('Text', 'heavy') . '|text' 
			) 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'heavy' . '_logo_url', 
			'title' => esc_html__('Logo Image', 'heavy'), 
			'desc' => esc_html__('Choose your website logo image.', 'heavy'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['heavy' . '_logo_url'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'heavy' . '_logo_url_retina', 
			'title' => esc_html__('Retina Logo Image', 'heavy'), 
			'desc' => esc_html__('Choose logo image for retina displays. Logo for Retina displays should be twice the size of the default one.', 'heavy'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['heavy' . '_logo_url_retina'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'heavy' . '_logo_title', 
			'title' => esc_html__('Logo Title', 'heavy'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_logo_title'], 
			'class' => 'nohtml' 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'heavy' . '_logo_subtitle', 
			'title' => esc_html__('Logo Subtitle', 'heavy'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_logo_subtitle'], 
			'class' => 'nohtml' 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'heavy' . '_logo_custom_color', 
			'title' => esc_html__('Custom Text Colors', 'heavy'), 
			'desc' => esc_html__('enable', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_logo_custom_color'] 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'heavy' . '_logo_title_color', 
			'title' => esc_html__('Logo Title Color', 'heavy'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => $defaults[$tab]['heavy' . '_logo_title_color'] 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'heavy' . '_logo_subtitle_color', 
			'title' => esc_html__('Logo Subtitle Color', 'heavy'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => $defaults[$tab]['heavy' . '_logo_subtitle_color'] 
		);
		
		break;
	case 'bg':
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'heavy' . '_bg_col', 
			'title' => esc_html__('Background Color', 'heavy'), 
			'desc' => '', 
			'type' => 'color', 
			'std' => $defaults[$tab]['heavy' . '_bg_col'] 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'heavy' . '_bg_img_enable', 
			'title' => esc_html__('Background Image Visibility', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_bg_img_enable'] 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'heavy' . '_bg_img', 
			'title' => esc_html__('Background Image', 'heavy'), 
			'desc' => esc_html__('Choose your custom website background image url.', 'heavy'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['heavy' . '_bg_img'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'heavy' . '_bg_rep', 
			'title' => esc_html__('Background Repeat', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_bg_rep'], 
			'choices' => array( 
				esc_html__('No Repeat', 'heavy') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'heavy') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'heavy') . '|repeat-y', 
				esc_html__('Repeat', 'heavy') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'heavy' . '_bg_pos', 
			'title' => esc_html__('Background Position', 'heavy'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['heavy' . '_bg_pos'], 
			'choices' => array( 
				esc_html__('Top Left', 'heavy') . '|top left', 
				esc_html__('Top Center', 'heavy') . '|top center', 
				esc_html__('Top Right', 'heavy') . '|top right', 
				esc_html__('Center Left', 'heavy') . '|center left', 
				esc_html__('Center Center', 'heavy') . '|center center', 
				esc_html__('Center Right', 'heavy') . '|center right', 
				esc_html__('Bottom Left', 'heavy') . '|bottom left', 
				esc_html__('Bottom Center', 'heavy') . '|bottom center', 
				esc_html__('Bottom Right', 'heavy') . '|bottom right' 
			) 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'heavy' . '_bg_att', 
			'title' => esc_html__('Background Attachment', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_bg_att'], 
			'choices' => array( 
				esc_html__('Scroll', 'heavy') . '|scroll', 
				esc_html__('Fixed', 'heavy') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'heavy' . '_bg_size', 
			'title' => esc_html__('Background Size', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_bg_size'], 
			'choices' => array( 
				esc_html__('Auto', 'heavy') . '|auto', 
				esc_html__('Cover', 'heavy') . '|cover', 
				esc_html__('Contain', 'heavy') . '|contain' 
			) 
		);
		
		break;
	case 'theme_style':
		$options[] = array( 
			'section' => 'theme_style_section', 
			'id' => 'heavy' . '_theme_style', 
			'title' => esc_html__('Choose Theme Style', 'heavy'), 
			'desc' => '', 
			'type' => 'select_theme_style', 
			'std' => '', 
			'choices' => heavy_all_theme_styles() 
		);
		
		break;
	case 'header':
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'heavy' . '_fixed_header', 
			'title' => esc_html__('Fixed Header', 'heavy'), 
			'desc' => esc_html__('enable', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_fixed_header'] 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'heavy' . '_header_overlaps', 
			'title' => esc_html__('Header Overlaps Content by Default', 'heavy'), 
			'desc' => esc_html__('enable', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_header_overlaps'] 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'heavy' . '_header_top_line', 
			'title' => esc_html__('Top Line', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_header_top_line'] 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'heavy' . '_header_top_height', 
			'title' => esc_html__('Top Height', 'heavy'), 
			'desc' => esc_html__('pixels', 'heavy'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['heavy' . '_header_top_height'], 
			'min' => '10' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'heavy' . '_header_top_line_short_info', 
			'title' => esc_html__('Top Short Info', 'heavy'), 
			'desc' => '<strong>' . esc_html__('HTML tags are allowed!', 'heavy') . '</strong>', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['heavy' . '_header_top_line_short_info'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'heavy' . '_header_top_line_add_cont', 
			'title' => esc_html__('Top Additional Content', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_header_top_line_add_cont'], 
			'choices' => array( 
				esc_html__('None', 'heavy') . '|none', 
				esc_html__('Top Line Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'heavy') . '|social', 
				esc_html__('Top Line Navigation (will be shown if set in Appearance - Menus tab)', 'heavy') . '|nav' 
			) 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'heavy' . '_header_styles', 
			'title' => esc_html__('Header Styles', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_header_styles'], 
			'choices' => array( 
				esc_html__('Default Style', 'heavy') . '|default', 
				esc_html__('Compact Style Left Navigation', 'heavy') . '|l_nav', 
				esc_html__('Compact Style Right Navigation', 'heavy') . '|r_nav', 
				esc_html__('Compact Style Center Navigation', 'heavy') . '|c_nav'
			) 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'heavy' . '_header_mid_height', 
			'title' => esc_html__('Header Middle Height', 'heavy'), 
			'desc' => esc_html__('pixels', 'heavy'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['heavy' . '_header_mid_height'], 
			'min' => '40' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'heavy' . '_header_bot_height', 
			'title' => esc_html__('Header Bottom Height', 'heavy'), 
			'desc' => esc_html__('pixels', 'heavy'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['heavy' . '_header_bot_height'], 
			'min' => '20' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'heavy' . '_header_search', 
			'title' => esc_html__('Header Search', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_header_search'] 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'heavy' . '_header_add_cont', 
			'title' => esc_html__('Header Additional Content', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_header_add_cont'], 
			'choices' => array( 
				esc_html__('None', 'heavy') . '|none', 
				esc_html__('Header Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'heavy') . '|social', 
				esc_html__('Header Custom HTML', 'heavy') . '|cust_html' 
			) 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'heavy' . '_header_add_cont_cust_html', 
			'title' => esc_html__('Header Custom HTML', 'heavy'), 
			'desc' => '<strong>' . esc_html__('HTML tags are allowed!', 'heavy') . '</strong>', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['heavy' . '_header_add_cont_cust_html'], 
			'class' => '' 
		);
		
		break;
	case 'content':
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_layout', 
			'title' => esc_html__('Layout Type by Default', 'heavy'), 
			'desc' => esc_html__('Choosing layout with a sidebar please make sure to add widgets to the Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'heavy'), 
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['heavy' . '_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_archives_layout', 
			'title' => esc_html__('Archives Layout Type', 'heavy'), 
			'desc' => esc_html__('Choosing layout with a sidebar please make sure to add widgets to the Archive Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'heavy'), 
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['heavy' . '_archives_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_search_layout', 
			'title' => esc_html__('Search Layout Type', 'heavy'), 
			'desc' => esc_html__('Choosing layout with a sidebar please make sure to add widgets to the Search Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'heavy'), 
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['heavy' . '_search_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_other_layout', 
			'title' => esc_html__('Other Layout Type', 'heavy'), 
			'desc' => esc_html__('Layout for pages of non-listed types. Choosing layout with a sidebar please make sure to add widgets to the Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'heavy'), 
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['heavy' . '_other_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'heavy') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_heading_alignment', 
			'title' => esc_html__('Heading Alignment by Default', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_heading_alignment'], 
			'choices' => array( 
				esc_html__('Left', 'heavy') . '|left', 
				esc_html__('Right', 'heavy') . '|right', 
				esc_html__('Center', 'heavy') . '|center' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_heading_scheme', 
			'title' => esc_html__('Heading Color Scheme by Default', 'heavy'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => $defaults[$tab]['heavy' . '_heading_scheme'], 
			'choices' => cmsmasters_color_schemes_list() 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_heading_bg_image_enable', 
			'title' => esc_html__('Heading Background Image Visibility by Default', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_heading_bg_image_enable'] 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_heading_bg_image', 
			'title' => esc_html__('Heading Background Image by Default', 'heavy'), 
			'desc' => esc_html__('Choose your custom heading background image by default.', 'heavy'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['heavy' . '_heading_bg_image'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_heading_bg_repeat', 
			'title' => esc_html__('Heading Background Repeat by Default', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_heading_bg_repeat'], 
			'choices' => array( 
				esc_html__('No Repeat', 'heavy') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'heavy') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'heavy') . '|repeat-y', 
				esc_html__('Repeat', 'heavy') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_heading_bg_attachment', 
			'title' => esc_html__('Heading Background Attachment by Default', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_heading_bg_attachment'], 
			'choices' => array( 
				esc_html__('Scroll', 'heavy') . '|scroll', 
				esc_html__('Fixed', 'heavy') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_heading_bg_size', 
			'title' => esc_html__('Heading Background Size by Default', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_heading_bg_size'], 
			'choices' => array( 
				esc_html__('Auto', 'heavy') . '|auto', 
				esc_html__('Cover', 'heavy') . '|cover', 
				esc_html__('Contain', 'heavy') . '|contain' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_heading_bg_color', 
			'title' => esc_html__('Heading Background Color Overlay by Default', 'heavy'), 
			'desc' => '',  
			'type' => 'rgba', 
			'std' => $defaults[$tab]['heavy' . '_heading_bg_color'] 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_heading_height', 
			'title' => esc_html__('Heading Height by Default', 'heavy'), 
			'desc' => esc_html__('pixels', 'heavy'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['heavy' . '_heading_height'], 
			'min' => '0' 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_breadcrumbs', 
			'title' => esc_html__('Breadcrumbs Visibility by Default', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_breadcrumbs'] 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_bottom_scheme', 
			'title' => esc_html__('Bottom Color Scheme', 'heavy'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => $defaults[$tab]['heavy' . '_bottom_scheme'], 
			'choices' => cmsmasters_color_schemes_list() 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_bottom_sidebar', 
			'title' => esc_html__('Bottom Sidebar Visibility by Default', 'heavy'), 
			'desc' => esc_html__('show', 'heavy') . '<br><br>' . esc_html__('Please make sure to add widgets in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_bottom_sidebar'] 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_bottom_sidebar_layout', 
			'title' => esc_html__('Bottom Sidebar Layout by Default', 'heavy'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['heavy' . '_bottom_sidebar_layout'], 
			'choices' => array( 
				'1/1|11', 
				'1/2 + 1/2|1212', 
				'1/3 + 2/3|1323', 
				'2/3 + 1/3|2313', 
				'1/4 + 3/4|1434', 
				'3/4 + 1/4|3414', 
				'1/3 + 1/3 + 1/3|131313', 
				'1/2 + 1/4 + 1/4|121414', 
				'1/4 + 1/2 + 1/4|141214', 
				'1/4 + 1/4 + 1/2|141412', 
				'1/4 + 1/4 + 1/4 + 1/4|14141414' 
			) 
		);
		
		break;
	case 'footer':
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_scheme', 
			'title' => esc_html__('Footer Color Scheme', 'heavy'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => $defaults[$tab]['heavy' . '_footer_scheme'], 
			'choices' => cmsmasters_color_schemes_list() 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_type', 
			'title' => esc_html__('Footer Type', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_footer_type'], 
			'choices' => array( 
				esc_html__('Default', 'heavy') . '|default', 
				esc_html__('Small', 'heavy') . '|small' 
			) 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_additional_content', 
			'title' => esc_html__('Footer Additional Content', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_footer_additional_content'], 
			'choices' => array( 
				esc_html__('None', 'heavy') . '|none', 
				esc_html__('Footer Navigation (will be shown if set in Appearance - Menus tab)', 'heavy') . '|nav', 
				esc_html__('Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'heavy') . '|social', 
				esc_html__('Custom HTML', 'heavy') . '|text' 
			) 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_logo', 
			'title' => esc_html__('Footer Logo', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_footer_logo'] 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_logo_url', 
			'title' => esc_html__('Footer Logo', 'heavy'), 
			'desc' => esc_html__('Choose your website footer logo image.', 'heavy'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['heavy' . '_footer_logo_url'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_logo_url_retina', 
			'title' => esc_html__('Footer Logo for Retina', 'heavy'), 
			'desc' => esc_html__('Choose your website footer logo image for retina.', 'heavy'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['heavy' . '_footer_logo_url_retina'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_nav', 
			'title' => esc_html__('Footer Navigation', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_footer_nav'] 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_social', 
			'title' => esc_html__('Footer Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_footer_social'] 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_html', 
			'title' => esc_html__('Footer Custom HTML', 'heavy'), 
			'desc' => '<strong>' . esc_html__('HTML tags are allowed!', 'heavy') . '</strong>', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['heavy' . '_footer_html'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'heavy' . '_footer_copyright', 
			'title' => esc_html__('Copyright Text', 'heavy'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_footer_copyright'], 
			'class' => '' 
		);
		
		break;
	}
	
	return apply_filters('cmsmasters_options_general_fields_filter', $options, $tab);
}

