<?php 
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version		1.0.0
 * 
 * Admin Panel Fonts Options
 * Created by CMSMasters
 * 
 */


function heavy_options_font_tabs() {
	$tabs = array();
	
	$tabs['content'] = esc_attr__('Content', 'heavy');
	$tabs['link'] = esc_attr__('Links', 'heavy');
	$tabs['nav'] = esc_attr__('Navigation', 'heavy');
	$tabs['heading'] = esc_attr__('Heading', 'heavy');
	$tabs['other'] = esc_attr__('Other', 'heavy');
	$tabs['google'] = esc_attr__('Google Fonts', 'heavy');
	
	return apply_filters('cmsmasters_options_font_tabs_filter', $tabs);
}


function heavy_options_font_sections() {
	$tab = heavy_get_the_tab();
	
	switch ($tab) {
	case 'content':
		$sections = array();
		
		$sections['content_section'] = esc_html__('Content Font Options', 'heavy');
		
		break;
	case 'link':
		$sections = array();
		
		$sections['link_section'] = esc_html__('Links Font Options', 'heavy');
		
		break;
	case 'nav':
		$sections = array();
		
		$sections['nav_section'] = esc_html__('Navigation Font Options', 'heavy');
		
		break;
	case 'heading':
		$sections = array();
		
		$sections['heading_section'] = esc_html__('Headings Font Options', 'heavy');
		
		break;
	case 'other':
		$sections = array();
		
		$sections['other_section'] = esc_html__('Other Fonts Options', 'heavy');
		
		break;
	case 'google':
		$sections = array();
		
		$sections['google_section'] = esc_html__('Serving Google Fonts from CDN', 'heavy');
		
		break;
	default:
		$sections = array();
		
		
		break;
	}
	
	return apply_filters('cmsmasters_options_font_sections_filter', $sections, $tab);
} 


function heavy_options_font_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = heavy_get_the_tab();
	}
	
	
	$options = array();
	
	
	$defaults = heavy_settings_font_defaults();
	
	
	switch ($tab) {
	case 'content':
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'heavy' . '_content_font', 
			'title' => esc_html__('Main Content Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_content_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style' 
			) 
		);
		
		break;
	case 'link':
		$options[] = array( 
			'section' => 'link_section', 
			'id' => 'heavy' . '_link_font', 
			'title' => esc_html__('Links Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_link_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'link_section', 
			'id' => 'heavy' . '_link_hover_decoration', 
			'title' => esc_html__('Links Hover Text Decoration', 'heavy'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => $defaults[$tab]['heavy' . '_link_hover_decoration'], 
			'choices' => heavy_text_decoration_list() 
		);
		
		break;
	case 'nav':
		$options[] = array( 
			'section' => 'nav_section', 
			'id' => 'heavy' . '_nav_title_font', 
			'title' => esc_html__('Navigation Title Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_nav_title_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform' 
			) 
		);
		
		$options[] = array( 
			'section' => 'nav_section', 
			'id' => 'heavy' . '_nav_dropdown_font', 
			'title' => esc_html__('Navigation Dropdown Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_nav_dropdown_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform' 
			) 
		);
		
		break;
	case 'heading':
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'heavy' . '_h1_font', 
			'title' => esc_html__('H1 Tag Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_h1_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'heavy' . '_h2_font', 
			'title' => esc_html__('H2 Tag Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_h2_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'heavy' . '_h3_font', 
			'title' => esc_html__('H3 Tag Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_h3_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'heavy' . '_h4_font', 
			'title' => esc_html__('H4 Tag Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_h4_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'heavy' . '_h5_font', 
			'title' => esc_html__('H5 Tag Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_h5_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'heavy' . '_h6_font', 
			'title' => esc_html__('H6 Tag Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_h6_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		break;
	case 'other':
		$options[] = array( 
			'section' => 'other_section', 
			'id' => 'heavy' . '_button_font', 
			'title' => esc_html__('Button Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_button_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform' 
			) 
		);
		
		$options[] = array( 
			'section' => 'other_section', 
			'id' => 'heavy' . '_small_font', 
			'title' => esc_html__('Small Tag Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_small_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform' 
			) 
		);
		
		$options[] = array( 
			'section' => 'other_section', 
			'id' => 'heavy' . '_input_font', 
			'title' => esc_html__('Text Fields Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_input_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style' 
			) 
		);
		
		$options[] = array( 
			'section' => 'other_section', 
			'id' => 'heavy' . '_quote_font', 
			'title' => esc_html__('Blockquote Font', 'heavy'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['heavy' . '_quote_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style' 
			) 
		);
		
		break;
	case 'google':
		$options[] = array( 
			'section' => 'google_section', 
			'id' => 'heavy' . '_google_web_fonts', 
			'title' => esc_html__('Google Fonts', 'heavy'), 
			'desc' => '', 
			'type' => 'google_web_fonts', 
			'std' => $defaults[$tab]['heavy' . '_google_web_fonts'] 
		);
		
		$options[] = array( 
			'section' => 'google_section', 
			'id' => 'heavy' . '_google_web_fonts_subset', 
			'title' => esc_html__('Google Fonts Subset', 'heavy'), 
			'desc' => '', 
			'type' => 'select_multiple', 
			'std' => '', 
			'choices' => array( 
				esc_html__('Latin Extended', 'heavy') . '|' . 'latin-ext', 
				esc_html__('Arabic', 'heavy') . '|' . 'arabic', 
				esc_html__('Cyrillic', 'heavy') . '|' . 'cyrillic', 
				esc_html__('Cyrillic Extended', 'heavy') . '|' . 'cyrillic-ext', 
				esc_html__('Greek', 'heavy') . '|' . 'greek', 
				esc_html__('Greek Extended', 'heavy') . '|' . 'greek-ext', 
				esc_html__('Vietnamese', 'heavy') . '|' . 'vietnamese', 
				esc_html__('Japanese', 'heavy') . '|' . 'japanese', 
				esc_html__('Korean', 'heavy') . '|' . 'korean', 
				esc_html__('Thai', 'heavy') . '|' . 'thai', 
				esc_html__('Bengali', 'heavy') . '|' . 'bengali', 
				esc_html__('Devanagari', 'heavy') . '|' . 'devanagari', 
				esc_html__('Gujarati', 'heavy') . '|' . 'gujarati', 
				esc_html__('Gurmukhi', 'heavy') . '|' . 'gurmukhi', 
				esc_html__('Hebrew', 'heavy') . '|' . 'hebrew', 
				esc_html__('Kannada', 'heavy') . '|' . 'kannada', 
				esc_html__('Khmer', 'heavy') . '|' . 'khmer', 
				esc_html__('Malayalam', 'heavy') . '|' . 'malayalam', 
				esc_html__('Myanmar', 'heavy') . '|' . 'myanmar', 
				esc_html__('Oriya', 'heavy') . '|' . 'oriya', 
				esc_html__('Sinhala', 'heavy') . '|' . 'sinhala', 
				esc_html__('Tamil', 'heavy') . '|' . 'tamil', 
				esc_html__('Telugu', 'heavy') . '|' . 'telugu' 
			) 
		);
		
		break;
	}
	
	return apply_filters('cmsmasters_options_font_fields_filter', $options, $tab);	
}

