<?php 
/**
 * @package 	WordPress
 * @subpackage 	Heavy
 * @version 	1.0.0
 * 
 * Admin Panel Element Options
 * Created by CMSMasters
 * 
 */


function heavy_options_element_tabs() {
	$tabs = array();
	
	$tabs['sidebar'] = esc_attr__('Sidebars', 'heavy');
	
	if (class_exists('Cmsmasters_Content_Composer')) {
		$tabs['icon'] = esc_attr__('Social Icons', 'heavy');
	}
	
	$tabs['lightbox'] = esc_attr__('Lightbox', 'heavy');
	$tabs['sitemap'] = esc_attr__('Sitemap', 'heavy');
	$tabs['error'] = esc_attr__('404', 'heavy');
	$tabs['code'] = esc_attr__('Custom Codes', 'heavy');
	
	if (class_exists('Cmsmasters_Form_Builder')) {
		$tabs['recaptcha'] = esc_attr__('reCAPTCHA', 'heavy');
	}
	
	return apply_filters('cmsmasters_options_element_tabs_filter', $tabs);
}


function heavy_options_element_sections() {
	$tab = heavy_get_the_tab();
	
	switch ($tab) {
	case 'sidebar':
		$sections = array();
		
		$sections['sidebar_section'] = esc_attr__('Custom Sidebars', 'heavy');
		
		break;
	case 'icon':
		$sections = array();
		
		$sections['icon_section'] = esc_attr__('Social Icons', 'heavy');
		
		break;
	case 'lightbox':
		$sections = array();
		
		$sections['lightbox_section'] = esc_attr__('Theme Lightbox Options', 'heavy');
		
		break;
	case 'sitemap':
		$sections = array();
		
		$sections['sitemap_section'] = esc_attr__('Sitemap Page Options', 'heavy');
		
		break;
	case 'error':
		$sections = array();
		
		$sections['error_section'] = esc_attr__('404 Error Page Options', 'heavy');
		
		break;
	case 'code':
		$sections = array();
		
		$sections['code_section'] = esc_attr__('Custom Codes', 'heavy');
		
		break;
	case 'recaptcha':
		$sections = array();
		
		$sections['recaptcha_section'] = esc_attr__('Form Builder Plugin reCAPTCHA Keys', 'heavy');
		
		break;
	default:
		$sections = array();
		
		
		break;
	}
	
	return apply_filters('cmsmasters_options_element_sections_filter', $sections, $tab);	
} 


function heavy_options_element_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = heavy_get_the_tab();
	}
	
	
	$options = array();
	
	
	$defaults = heavy_settings_element_defaults();
	
	
	switch ($tab) {
	case 'sidebar':
		$options[] = array( 
			'section' => 'sidebar_section', 
			'id' => 'heavy' . '_sidebar', 
			'title' => esc_html__('Custom Sidebars', 'heavy'), 
			'desc' => '', 
			'type' => 'sidebar', 
			'std' => $defaults[$tab]['heavy' . '_sidebar'] 
		);
		
		break;
	case 'icon':
		$options[] = array( 
			'section' => 'icon_section', 
			'id' => 'heavy' . '_social_icons', 
			'title' => esc_html__('Social Icons', 'heavy'), 
			'desc' => '', 
			'type' => 'social', 
			'std' => $defaults[$tab]['heavy' . '_social_icons'] 
		);
		
		break;
	case 'lightbox':
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_skin', 
			'title' => esc_html__('Skin', 'heavy'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_skin'], 
			'choices' => array( 
				esc_html__('Dark', 'heavy') . '|dark', 
				esc_html__('Light', 'heavy') . '|light', 
				esc_html__('Mac', 'heavy') . '|mac', 
				esc_html__('Metro Black', 'heavy') . '|metro-black', 
				esc_html__('Metro White', 'heavy') . '|metro-white', 
				esc_html__('Parade', 'heavy') . '|parade', 
				esc_html__('Smooth', 'heavy') . '|smooth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_path', 
			'title' => esc_html__('Path', 'heavy'), 
			'desc' => esc_html__('Sets path for switching windows', 'heavy'), 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_path'], 
			'choices' => array( 
				esc_html__('Vertical', 'heavy') . '|vertical', 
				esc_html__('Horizontal', 'heavy') . '|horizontal' 
			) 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_infinite', 
			'title' => esc_html__('Infinite', 'heavy'), 
			'desc' => esc_html__('Sets the ability to infinite the group', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_infinite'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_aspect_ratio', 
			'title' => esc_html__('Keep Aspect Ratio', 'heavy'), 
			'desc' => esc_html__('Sets the resizing method used to keep aspect ratio within the viewport', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_aspect_ratio'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_mobile_optimizer', 
			'title' => esc_html__('Mobile Optimizer', 'heavy'), 
			'desc' => esc_html__('Make lightboxes optimized for giving better experience with mobile devices', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_mobile_optimizer'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_max_scale', 
			'title' => esc_html__('Max Scale', 'heavy'), 
			'desc' => esc_html__('Sets the maximum viewport scale of the content', 'heavy'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_max_scale'], 
			'min' => 0.1, 
			'max' => 2, 
			'step' => 0.05 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_min_scale', 
			'title' => esc_html__('Min Scale', 'heavy'), 
			'desc' => esc_html__('Sets the minimum viewport scale of the content', 'heavy'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_min_scale'], 
			'min' => 0.1, 
			'max' => 2, 
			'step' => 0.05 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_inner_toolbar', 
			'title' => esc_html__('Inner Toolbar', 'heavy'), 
			'desc' => esc_html__('Bring buttons into windows, or let them be over the overlay', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_inner_toolbar'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_smart_recognition', 
			'title' => esc_html__('Smart Recognition', 'heavy'), 
			'desc' => esc_html__('Sets content auto recognize from web pages', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_smart_recognition'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_fullscreen_one_slide', 
			'title' => esc_html__('Fullscreen One Slide', 'heavy'), 
			'desc' => esc_html__('Decide to fullscreen only one slide or hole gallery the fullscreen mode', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_fullscreen_one_slide'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_fullscreen_viewport', 
			'title' => esc_html__('Fullscreen Viewport', 'heavy'), 
			'desc' => esc_html__('Sets the resizing method used to fit content within the fullscreen mode', 'heavy'), 
			'type' => 'select', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_fullscreen_viewport'], 
			'choices' => array( 
				esc_html__('Center', 'heavy') . '|center', 
				esc_html__('Fit', 'heavy') . '|fit', 
				esc_html__('Fill', 'heavy') . '|fill', 
				esc_html__('Stretch', 'heavy') . '|stretch' 
			) 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_controls_toolbar', 
			'title' => esc_html__('Toolbar Controls', 'heavy'), 
			'desc' => esc_html__('Sets buttons be available or not', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_controls_toolbar'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_controls_arrows', 
			'title' => esc_html__('Arrow Controls', 'heavy'), 
			'desc' => esc_html__('Enable the arrow buttons', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_controls_arrows'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_controls_fullscreen', 
			'title' => esc_html__('Fullscreen Controls', 'heavy'), 
			'desc' => esc_html__('Sets the fullscreen button', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_controls_fullscreen'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_controls_thumbnail', 
			'title' => esc_html__('Thumbnails Controls', 'heavy'), 
			'desc' => esc_html__('Sets the thumbnail navigation', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_controls_thumbnail'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_controls_keyboard', 
			'title' => esc_html__('Keyboard Controls', 'heavy'), 
			'desc' => esc_html__('Sets the keyboard navigation', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_controls_keyboard'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_controls_mousewheel', 
			'title' => esc_html__('Mouse Wheel Controls', 'heavy'), 
			'desc' => esc_html__('Sets the mousewheel navigation', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_controls_mousewheel'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_controls_swipe', 
			'title' => esc_html__('Swipe Controls', 'heavy'), 
			'desc' => esc_html__('Sets the swipe navigation', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_controls_swipe'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'heavy' . '_ilightbox_controls_slideshow', 
			'title' => esc_html__('Slideshow Controls', 'heavy'), 
			'desc' => esc_html__('Enable the slideshow feature and button', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_ilightbox_controls_slideshow'] 
		);
		
		break;
	case 'sitemap':
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'heavy' . '_sitemap_nav', 
			'title' => esc_html__('Website Pages', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_sitemap_nav'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'heavy' . '_sitemap_categs', 
			'title' => esc_html__('Blog Archives by Categories', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_sitemap_categs'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'heavy' . '_sitemap_tags', 
			'title' => esc_html__('Blog Archives by Tags', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_sitemap_tags'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'heavy' . '_sitemap_month', 
			'title' => esc_html__('Blog Archives by Month', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_sitemap_month'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'heavy' . '_sitemap_pj_categs', 
			'title' => esc_html__('Portfolio Archives by Categories', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_sitemap_pj_categs'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'heavy' . '_sitemap_pj_tags', 
			'title' => esc_html__('Portfolio Archives by Tags', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_sitemap_pj_tags'] 
		);
		
		break;
	case 'error':
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'heavy' . '_error_color', 
			'title' => esc_html__('Text Color', 'heavy'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => $defaults[$tab]['heavy' . '_error_color'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'heavy' . '_error_bg_color', 
			'title' => esc_html__('Background Color', 'heavy'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => $defaults[$tab]['heavy' . '_error_bg_color'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'heavy' . '_error_bg_img_enable', 
			'title' => esc_html__('Background Image Visibility', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_error_bg_img_enable'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'heavy' . '_error_bg_image', 
			'title' => esc_html__('Background Image', 'heavy'), 
			'desc' => esc_html__('Choose your custom error page background image.', 'heavy'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['heavy' . '_error_bg_image'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'heavy' . '_error_bg_rep', 
			'title' => esc_html__('Background Repeat', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_error_bg_rep'], 
			'choices' => array( 
				esc_html__('No Repeat', 'heavy') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'heavy') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'heavy') . '|repeat-y', 
				esc_html__('Repeat', 'heavy') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'heavy' . '_error_bg_pos', 
			'title' => esc_html__('Background Position', 'heavy'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['heavy' . '_error_bg_pos'], 
			'choices' => array( 
				esc_html__('Top Left', 'heavy') . '|top left', 
				esc_html__('Top Center', 'heavy') . '|top center', 
				esc_html__('Top Right', 'heavy') . '|top right', 
				esc_html__('Center Left', 'heavy') . '|center left', 
				esc_html__('Center Center', 'heavy') . '|center center', 
				esc_html__('Center Right', 'heavy') . '|center right', 
				esc_html__('Bottom Left', 'heavy') . '|bottom left', 
				esc_html__('Bottom Center', 'heavy') . '|bottom center', 
				esc_html__('Bottom Right', 'heavy') . '|bottom right' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'heavy' . '_error_bg_att', 
			'title' => esc_html__('Background Attachment', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_error_bg_att'], 
			'choices' => array( 
				esc_html__('Scroll', 'heavy') . '|scroll', 
				esc_html__('Fixed', 'heavy') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'heavy' . '_error_bg_size', 
			'title' => esc_html__('Background Size', 'heavy'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['heavy' . '_error_bg_size'], 
			'choices' => array( 
				esc_html__('Auto', 'heavy') . '|auto', 
				esc_html__('Cover', 'heavy') . '|cover', 
				esc_html__('Contain', 'heavy') . '|contain' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'heavy' . '_error_search', 
			'title' => esc_html__('Search Line', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_error_search'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'heavy' . '_error_sitemap_button', 
			'title' => esc_html__('Sitemap Button', 'heavy'), 
			'desc' => esc_html__('show', 'heavy'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['heavy' . '_error_sitemap_button'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'heavy' . '_error_sitemap_link', 
			'title' => esc_html__('Sitemap Page URL', 'heavy'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_error_sitemap_link'], 
			'class' => '' 
		);
		
		break;
	case 'code':
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'heavy' . '_custom_css', 
			'title' => esc_html__('Custom CSS', 'heavy'), 
			'desc' => '', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['heavy' . '_custom_css'], 
			'class' => 'allowlinebreaks' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'heavy' . '_custom_js', 
			'title' => esc_html__('Custom JavaScript', 'heavy'), 
			'desc' => '', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['heavy' . '_custom_js'], 
			'class' => 'allowlinebreaks' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'heavy' . '_gmap_api_key', 
			'title' => esc_html__('Google Maps API key', 'heavy'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_gmap_api_key'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'heavy' . '_api_key', 
			'title' => esc_html__('Twitter API key', 'heavy'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_api_key'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'heavy' . '_api_secret', 
			'title' => esc_html__('Twitter API secret', 'heavy'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_api_secret'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'heavy' . '_access_token', 
			'title' => esc_html__('Twitter Access token', 'heavy'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_access_token'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'heavy' . '_access_token_secret', 
			'title' => esc_html__('Twitter Access token secret', 'heavy'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_access_token_secret'], 
			'class' => '' 
		);
		
		break;
	case 'recaptcha':
		$options[] = array( 
			'section' => 'recaptcha_section', 
			'id' => 'heavy' . '_recaptcha_public_key', 
			'title' => esc_html__('reCAPTCHA Public Key', 'heavy'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_recaptcha_public_key'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'recaptcha_section', 
			'id' => 'heavy' . '_recaptcha_private_key', 
			'title' => esc_html__('reCAPTCHA Private Key', 'heavy'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['heavy' . '_recaptcha_private_key'], 
			'class' => '' 
		);
		
		break;
	}
	
	return apply_filters('cmsmasters_options_element_fields_filter', $options, $tab);	
}

