<?php

if ( ! function_exists( 'healthfirst_load_page_mobile_header' ) ) {
	/**
	 * Function which loads page template module
	 */
	function healthfirst_load_page_mobile_header() {
		// Include mobile header template
		echo apply_filters( 'healthfirst_filter_mobile_header_template', healthfirst_get_template_part( 'mobile-header', 'templates/mobile-header' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}

	add_action( 'healthfirst_action_page_header_template', 'healthfirst_load_page_mobile_header' );
}

if ( ! function_exists( 'healthfirst_register_mobile_navigation_menus' ) ) {
	/**
	 * Function which registers navigation menus
	 */
	function healthfirst_register_mobile_navigation_menus() {
		$navigation_menus = apply_filters( 'healthfirst_filter_register_mobile_navigation_menus', array( 'mobile-navigation' => esc_html__( 'Mobile Navigation', 'healthfirst' ) ) );

		if ( ! empty( $navigation_menus ) ) {
			register_nav_menus( $navigation_menus );
		}
	}

	add_action( 'healthfirst_action_after_include_modules', 'healthfirst_register_mobile_navigation_menus' );
}
