<?php if ( isset( $enable_filter ) && 'yes' === $enable_filter ) {

	$filter_items = healthfirst_get_filter_items( $params );
	?>
	<div class="qodef-m-filter">
		<?php if ( ! empty( $filter_items ) ) { ?>
			<div class="qodef-m-filter-items">
				<?php if ( ! empty ( $hide_show_all ) && 'yes' !== $hide_show_all ) { ?>
					<a class="qodef-m-filter-item qodef--active" href="#" data-taxonomy="<?php echo esc_attr( $taxonomy_filter ); ?>" data-filter="*">
						<span class="qodef-m-filter-item-name"><?php esc_html_e( 'Show All', 'healthfirst' ); ?></span>
					</a>
				<?php } ?>
				<?php
				$counter = 0;
				foreach ( $filter_items as $item ) {
					$filter_value = is_numeric( $item->slug ) ? $item->term_id : $item->slug;

					if ( ! empty ( $hide_show_all ) && 'yes' === $hide_show_all && 0 === $counter ) {
						$item_classes = 'qodef-m-filter-item qodef--init-active';
					} else {
						$item_classes = 'qodef-m-filter-item';
					}
					?>
					<a class="<?php echo esc_attr( $item_classes ); ?>" href="#" data-taxonomy="<?php echo esc_attr( $taxonomy_filter ); ?>" data-filter="<?php echo esc_attr( $filter_value ); ?>">
						<span class="qodef-m-filter-item-name"><?php echo esc_html( $item->name ); ?></span>
					</a>
				<?php
					$counter++;
				}
				?>
			</div>
		<?php } ?>
	</div>
<?php } ?>
