<?php

if ( ! function_exists( 'healthfirst_include_comments_in_templates' ) ) {
	/**
	 * Function which includes comments templates on pages/posts
	 */
	function healthfirst_include_comments_in_templates() {

		// Include comments template
		comments_template();
	}

	add_action( 'healthfirst_action_after_page_content', 'healthfirst_include_comments_in_templates', 100 ); // permission 100 is set to comments template be at the last place
	add_action( 'healthfirst_action_after_blog_post_item', 'healthfirst_include_comments_in_templates', 100 );
}

if ( ! function_exists( 'healthfirst_is_page_comments_enabled' ) ) {
	/**
	 * Function that check is module enabled
	 */
	function healthfirst_is_page_comments_enabled() {
		return apply_filters( 'healthfirst_filter_enable_page_comments', true );
	}
}

if ( ! function_exists( 'healthfirst_load_page_comments' ) ) {
	/**
	 * Function which loads page template module
	 */
	function healthfirst_load_page_comments() {

		if ( healthfirst_is_page_comments_enabled() ) {
			healthfirst_template_part( 'comments', 'templates/comments' );
		}
	}

	add_action( 'healthfirst_action_page_comments_template', 'healthfirst_load_page_comments' );
}

if ( ! function_exists( 'healthfirst_get_comments_list_template' ) ) {
	/**
	 * Function which modify default WordPress comments list template
	 *
	 * @param object $comment
	 * @param array $args
	 * @param int $depth
	 *
	 * @return string that contains comments list html
	 */
	function healthfirst_get_comments_list_template( $comment, $args, $depth ) {
		global $post;

		$classes = array();

		$is_author_comment = $post->post_author === $comment->user_id;
		if ( $is_author_comment ) {
			$classes[] = 'qodef-comment--author';
		}

		$is_specific_comment = 'pingback' === $comment->comment_type || 'trackback' === $comment->comment_type;
		if ( $is_specific_comment ) {
			$classes[] = 'qodef-comment--no-avatar';
			$classes[] = 'qodef-comment--' . esc_attr( $comment->comment_type );
		}
		?>
		<li class="qodef-comment-item qodef-e <?php echo esc_attr( implode( ' ', $classes ) ); ?>">
			<div id="comment-<?php comment_ID(); ?>" class="qodef-e-inner">
				<?php if ( ! $is_specific_comment ) { ?>
					<div class="qodef-e-image"><?php echo get_avatar( $comment, 60 ); ?></div>
				<?php } ?>
				<div class="qodef-e-content">
					<h6 class="qodef-e-title vcard"><?php echo sprintf( '<span class="fn">%s%s</span>', esc_attr( $is_specific_comment ) ? sprintf( '%s: ', esc_attr( ucwords( $comment->comment_type ) ) ) : '', get_comment_author_link() ); ?></h6>
					<div class="qodef-e-date commentmetadata">
						<a href="<?php echo esc_url( get_comment_link( $comment, $args ) ); ?>"><?php comment_time( get_option( 'date_format' ) ); ?></a>
					</div>
					<?php if ( ! $is_specific_comment ) { ?>
						<div class="qodef-e-text"><?php comment_text( $comment ); ?></div>
					<?php } ?>
					<div class="qodef-e-links">
						<?php
						comment_reply_link(
							array_merge(
								$args,
								array(
									'reply_text' => esc_html__( 'Reply', 'healthfirst' ),
									'depth'      => $depth,
									'max_depth'  => $args['max_depth'],
									'before'        => '<span class="qodef-comment-reply-link-holder">',
									'after'         => '<span class="qodef-m-zigzag-link"><svg xmlns="http://www.w3.org/2000/svg" width="496.46" height="5.5" viewBox="0 0 496.46 5.5"><g><g><g><path d="M1.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M49.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.16-4,5.3,4,5.1-4,4.89,4" transform="translate(-0.3 0)"/></g><g><path d="M98.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M146.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.15-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/></g><g><path d="M195.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M243.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.15-4,5.31,4,5.1-4,4.89,4" transform="translate(-0.3 0)"/></g><g><path d="M292.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M340.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.15-4,5.31,4,5.1-4,4.89,4" transform="translate(-0.3 0)"/></g><g><path d="M389.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M437.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.15-4,5.31,4,5.1-4,4.89,4" transform="translate(-0.3 0)"/></g></g><path d="M486.05,4.75l5.31-4,4.65,4" transform="translate(-0.3 0)"/></g></svg></span></span>',
								)
							)
						);

						edit_comment_link( esc_html__( 'Edit', 'healthfirst' ), '<span class="qodef-comment-edit-link-holder">', '<span class="qodef-m-zigzag-link"><svg xmlns="http://www.w3.org/2000/svg" width="496.46" height="5.5" viewBox="0 0 496.46 5.5"><g><g><g><path d="M1.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M49.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.16-4,5.3,4,5.1-4,4.89,4" transform="translate(-0.3 0)"/></g><g><path d="M98.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M146.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.15-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/></g><g><path d="M195.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M243.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.15-4,5.31,4,5.1-4,4.89,4" transform="translate(-0.3 0)"/></g><g><path d="M292.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M340.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.15-4,5.31,4,5.1-4,4.89,4" transform="translate(-0.3 0)"/></g><g><path d="M389.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M437.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.15-4,5.31,4,5.1-4,4.89,4" transform="translate(-0.3 0)"/></g></g><path d="M486.05,4.75l5.31-4,4.65,4" transform="translate(-0.3 0)"/></g></svg></span></span>' );
						?>
					</div>
				</div>
			</div>
		<?php //li tag will be closed by WordPress after looping through child elements ?>
		<?php
	}
}

if ( ! function_exists( 'healthfirst_modify_cancel_comment_reply_link' ) ) {
	/**
	 * Function which addes zigzag underline for comment reply link
	 */
	function healthfirst_modify_cancel_comment_reply_link( $formatted_link, $link, $text ) {
		return '<span class="qodef-comment-cancel-reply-link-holder">' . $formatted_link . '<span class="qodef-m-zigzag-link"><svg xmlns="http://www.w3.org/2000/svg" width="496.46" height="5.5" viewBox="0 0 496.46 5.5"><g><g><g><path d="M1.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M49.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.16-4,5.3,4,5.1-4,4.89,4" transform="translate(-0.3 0)"/></g><g><path d="M98.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M146.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.15-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/></g><g><path d="M195.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M243.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.15-4,5.31,4,5.1-4,4.89,4" transform="translate(-0.3 0)"/></g><g><path d="M292.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M340.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.15-4,5.31,4,5.1-4,4.89,4" transform="translate(-0.3 0)"/></g><g><path d="M389.05,4.75l5.31-4,4.65,4,4.34-4,4.34,4,5.44-4,4,4,5.16-4,5.31,4,5.1-4,4.88,4" transform="translate(-0.3 0)"/><path d="M437.57,4.75l5.32-4,4.65,4,4.34-4,4.33,4,5.44-4,4,4,5.15-4,5.31,4,5.1-4,4.89,4" transform="translate(-0.3 0)"/></g></g><path d="M486.05,4.75l5.31-4,4.65,4" transform="translate(-0.3 0)"/></g></svg></span></span>';
	};

	// add the filter
	add_filter( 'cancel_comment_reply_link', 'healthfirst_modify_cancel_comment_reply_link', 10, 3 );
}

if ( ! function_exists( 'healthfirst_get_comment_form_args' ) ) {
	/**
	 * Function that define new comment form args in order to override default WordPress comment form
	 *
	 * @param array $attr - additional array which override default values
	 *
	 * @return array
	 */
	function healthfirst_get_comment_form_args( $attr = array() ) {
		$qodef_commenter            = wp_get_current_commenter();
		$qodef_required_attr        = get_option( 'require_name_email' ) ? ' required="required"' : '';
		$qodef_required_label       = get_option( 'require_name_email' ) ? '*' : '';
		$qodef_required_class = get_option( 'require_name_email' ) ? 'qodef-required' : 'qodef-not-required';

		$comment_placeholder = isset( $attr['comment_placeholder'] ) && ! empty( $attr['comment_placeholder'] ) ? esc_attr( $attr['comment_placeholder'] ) : esc_attr__( 'Your Comment', 'healthfirst' );

		$args = array(
			'title_reply_before' => '<h4 id="reply-title" class="comment-reply-title">',
			'title_reply_after'  => '</h4>',
			'comment_field'      => '<p class="comment-form-comment"><label for="comment" class="qodef-required">' . $comment_placeholder . '</label>
                                    <textarea id="comment" name="comment" cols="45" rows="5" maxlength="65525" required="required"></textarea>
                                    </p>',
			'fields'             => array(
				'author' => '<div class="qodef-grid qodef-layout--columns qodef-col-num--2"><div class="qodef-grid-inner"><div class="qodef-grid-item"><p class="comment-form-author"><label for="author" class="' . esc_attr($qodef_required_class) . '">' . esc_attr__( 'Your Name', 'healthfirst' ) . '</label>
                            <input id="author" name="author" type="text" value="' . esc_attr( $qodef_commenter['comment_author'] ) . '" size="30" maxlength="245" ' . $qodef_required_attr . ' />
                            </p></div>',
				'email'  => '<div class="qodef-grid-item"><p class="comment-form-email"><label for="email" class="' . esc_attr($qodef_required_class) . '">' . esc_attr__( 'Your Email', 'healthfirst' ) . '</label>
                            <input id="email" name="email" type="text" value="' . esc_attr( $qodef_commenter['comment_author_email'] ) . '" size="30" maxlength="100" aria-describedby="email-notes" ' . $qodef_required_attr . ' />
                            </p></div></div></div>',
				'url'    => '<p class="comment-form-url"><label for="url">' . esc_attr__( 'Website', 'healthfirst' ) . '</label>
                            <input id="url" name="url" type="text" value="' . esc_attr( $qodef_commenter['comment_author_url'] ) . '" size="30" maxlength="200" />
                            </p>',
			),
			'submit_button'      => '<button name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s"><span class="qodef-m-text">%4$s</span></button>',
			'class_submit'       => 'qodef-button qodef-layout--filled',
			'class_form'         => 'qodef-comment-form',
		);

		return apply_filters( 'healthfirst_filter_comment_form_args', $args );
	}
}
