<?php
$additional_info_enabled  = healthfirst_get_post_value_through_levels( 'qodef_blog_list_enable_additional_info' ) !== 'no';
?>

<article <?php post_class( 'qodef-blog-item qodef-e' ); ?>>
	<div class="qodef-e-inner">
		<?php
		// Include post media
		healthfirst_template_part( 'blog', 'templates/parts/post-info/media' );
		?>
		<div class="qodef-e-content">
			<div class="qodef-e-info qodef-info--top">
				<?php
				// Include post category info
				healthfirst_template_part( 'blog', 'templates/parts/post-info/category' );

				// Include post date info
				healthfirst_template_part( 'blog', 'templates/parts/post-info/date' );

				// Include post comments info
				healthfirst_template_part( 'blog', 'templates/parts/post-info/comments' );

				// Include post comments info
				healthfirst_template_part( 'blog', 'templates/parts/post-info/time-reading' );
				?>
			</div>
			<div class="qodef-e-text">
				<?php
				// Include post title
				healthfirst_template_part( 'blog', 'templates/parts/post-info/title', '', array( 'title_tag' => 'h4' ) );

				// Include post excerpt
				healthfirst_template_part( 'blog', 'templates/parts/post-info/excerpt' );

				// Hook to include additional content after blog single content
				do_action( 'healthfirst_action_after_blog_single_content' );
				?>
			</div>
			<div class="qodef-e-info qodef-info--bottom">
				<div class="qodef-e-info-left">
					<?php
					// Include post read more
					healthfirst_template_part( 'blog', 'templates/parts/post-info/read-more' );
					?>
				</div>
				<div class="qodef-e-info-right">
					<?php
					if ( $additional_info_enabled ) {
						// Include post author info
						healthfirst_template_part( 'blog', 'templates/parts/post-info/tags' );

						// Include post author info
						//healthfirst_template_part( 'blog', 'templates/parts/post-info/author' );
					}
					?>
				</div>
			</div>
		</div>
	</div>
</article>
