<?php
    $heacool_options = heacool_options();
    $base_header = isset($heacool_options['heacool_base_header'])? $heacool_options['heacool_base_header'] : 0;

    $base_header_class = 'header-code-one';
    if($base_header == '1') :
        $base_header_class = '';
    endif;
?>
<header class="<?php echo esc_attr($base_header_class); ?>">
    <div class="top_header">
        <div class="container">
            <div class="row">
                <?php
                   if (isset($heacool_options['heacool-display-header-left']) && $heacool_options['heacool-display-header-left']) { ?>
                    <div class="col-lg-4 col-md-4 contc">
                        <ul class="cnt_hed">
                        <?php
                              if (isset($heacool_options['heacool-header-left-text']) && $heacool_options['heacool-header-left-text']) { ?>
                            <li>
                                <div class="head-info">
                                    <span class="hd_is map">
                                        <svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                             width="97.713px" height="97.713px" viewBox="0 0 97.713 97.713" xml:space="preserve">
                                            <g>
                                                <path d="M48.855,0C29.021,0,12.883,16.138,12.883,35.974c0,5.174,1.059,10.114,3.146,14.684
                                                      c8.994,19.681,26.238,40.46,31.31,46.359c0.38,0.441,0.934,0.695,1.517,0.695s1.137-0.254,1.517-0.695
                                                      c5.07-5.898,22.314-26.676,31.311-46.359c2.088-4.57,3.146-9.51,3.146-14.684C84.828,16.138,68.69,0,48.855,0z M48.855,54.659
                                                      c-10.303,0-18.686-8.383-18.686-18.686c0-10.304,8.383-18.687,18.686-18.687s18.686,8.383,18.686,18.687
                                                      C67.542,46.276,59.159,54.659,48.855,54.659z"/>
                                            </g>
                                        </svg>
                                    </span>
                                    <div class="cnt-info">
                                          <?php
                                            echo wp_kses_post($heacool_options['heacool-header-left-text']);
                                            ?>

                                    </div>
                                </div><!--head-info end-->
                            </li>
                             <?php
                          }
                        ?>
                    <?php
                       if (isset($heacool_options['heacool-header-left-text-1']) && $heacool_options['heacool-header-left-text-1']) { ?>
                            <li>
                                <div class="head-info">
                                    <span class="hd_is time">
                                        <svg version="1.1" id="Capa_1239" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                                             width="97.16px" height="97.16px" viewBox="0 0 97.16 97.16" xml:space="preserve"
                                             >
                                            <g>
                                                <g>
                                                    <path d="M48.58,0C21.793,0,0,21.793,0,48.58s21.793,48.58,48.58,48.58s48.58-21.793,48.58-48.58S75.367,0,48.58,0z M48.58,86.823
                                                          c-21.087,0-38.244-17.155-38.244-38.243S27.493,10.337,48.58,10.337S86.824,27.492,86.824,48.58S69.667,86.823,48.58,86.823z"/>
                                                    <path d="M73.898,47.08H52.066V20.83c0-2.209-1.791-4-4-4c-2.209,0-4,1.791-4,4v30.25c0,2.209,1.791,4,4,4h25.832
                                                          c2.209,0,4-1.791,4-4S76.107,47.08,73.898,47.08z"/>
                                                </g>
                                            </g>
                                        </svg>
                                    </span>
                                    <div class="cnt-info">
                                        <?php
                                           echo wp_kses_post($heacool_options['heacool-header-left-text-1']);
                                        ?>
                                    </div>
                                </div><!--head-info end-->
                            </li>
                             <?php
                  }
                ?>
                        </ul>
                        <div class="clearfix"></div>
                    </div>
                <?php
                  }
                ?>
                <div class="col-lg-4 col-md-5">
                  <?php
                    if (function_exists('get_custom_logo') && has_custom_logo()) {
                        $output = get_custom_logo();
                        if (empty($output)) {
                            ?>
                             <div class="logo">
                            <a href="<?php echo esc_url(home_url('/')) ?>">
                                <img src="<?php echo esc_url(HEACOOL_IMG_URL . 'logo2.png') ?>" alt="<?php esc_html_e('Logo', 'heacool'); ?>">
                            </a>
                            </div><!--logo end-->

                            <?php
                        } else {
                            $heacool_custom_logo_id = get_theme_mod('custom_logo');
                            $heacool_logo_image = wp_get_attachment_image_src($heacool_custom_logo_id, 'full');
                            ?>
                            <div class="logo">
                            <a href="<?php echo esc_url(home_url('/')) ?>">
                                <img src="<?php echo esc_url($heacool_logo_image[0]) ?>" alt="<?php esc_html_e('Logo', 'heacool'); ?>">
                            </a>
                            </div><!--logo end-->
                            <?php
                        }
                    } else {
                        ?>
                        <div class="logo">
                            <a href="<?php echo esc_url(home_url('/')) ?>">
                                <img src="<?php echo esc_url(HEACOOL_IMG_URL . 'logo2.png') ?>" alt="<?php esc_html_e('Logo', 'heacool'); ?>">
                            </a>
                            </div><!--logo end-->
                        <?php
                    }
                    ?>
                </div>
                <div class="col-lg-4 col-md-3 contc">
                    <?php if (isset($heacool_options['heacool-display-header-contact-text']) && $heacool_options['heacool-display-header-contact-text']) { ?>
                    <div class="emg-sec">
                            <?php
                            if (isset($heacool_options['heacool-header-contact-text']) && $heacool_options['heacool-header-contact-text']) {
                                echo wp_kses_post($heacool_options['heacool-header-contact-text']);
                            }
                            ?>
                    </div><!--emg-sec end-->
                     <?php } ?>
                    <?php if (isset($heacool_options['heacool-display-header-social']) && $heacool_options['heacool-display-header-social']) { ?>
                        <ul class="social_links">
                            <?php
                            if (isset($heacool_options['heacool-header-facebook']) && !empty($heacool_options['heacool-header-facebook'])) {
                                ?>
                                <li>
                                    <a href="<?php echo esc_url($heacool_options['heacool-header-facebook']) ?>" target="_blank"><i class="fa fa-facebook"></i>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php
                            if (isset($heacool_options['heacool-header-twitter']) && !empty($heacool_options['heacool-header-twitter'])) {
                                ?>
                                <li>
                                    <a href="<?php echo esc_url($heacool_options['heacool-header-twitter']) ?>" target="_blank"><i class="fa fa-twitter"></i>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php
                            if (isset($heacool_options['heacool-header-instagram']) && !empty($heacool_options['heacool-header-instagram'])) {
                                ?>
                                <li>
                                    <a href="<?php echo esc_url($heacool_options['heacool-header-instagram']) ?>" target="_blank"><i class="fa fa-instagram"></i>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php
                            if (isset($heacool_options['heacool-header-google-plus']) && !empty($heacool_options['heacool-header-google-plus'])) {
                                ?>
                                <li>
                                    <a href="<?php echo esc_url($heacool_options['heacool-header-google-plus']) ?>" target="_blank"><i class="fa fa-google-plus"></i>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php
                            if (isset($heacool_options['heacool-header-linkedin']) && !empty($heacool_options['heacool-header-linkedin'])) {
                                ?>
                                <li>
                                    <a href="<?php echo esc_url($heacool_options['heacool-header-linkedin']) ?>" target="_blank"><i class="fa fa-linkedin"></i>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php
                            if (isset($heacool_options['heacool-header-tumblr']) && !empty($heacool_options['heacool-header-tumblr'])) {
                                ?>
                                <li>
                                    <a href="<?php echo esc_url($heacool_options['heacool-header-tumblr']) ?>" target="_blank"><i class="fa fa-tumblr"></i>
                                    </a>
                                </li>
                            <?php } ?>
                            <?php
                            if (isset($heacool_options['heacool-header-youtube']) && !empty($heacool_options['heacool-header-youtube'])) {
                                ?>
                                <li>
                                    <a href="<?php echo esc_url($heacool_options['heacool-header-youtube']) ?>" target="_blank"><i class="fa fa-youtube"></i>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul><!--social_links end-->
                    <?php } ?>
                </div>
                <a href="<?php echo esc_url('#')?>" class="menu_btn">
                    <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                         viewBox="0 0 512 512"  xml:space="preserve">
                        <g>
                            <g>
                                <path d="M491.318,235.318H20.682C9.26,235.318,0,244.577,0,256s9.26,20.682,20.682,20.682h470.636
                                      c11.423,0,20.682-9.259,20.682-20.682C512,244.578,502.741,235.318,491.318,235.318z"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M491.318,78.439H20.682C9.26,78.439,0,87.699,0,99.121c0,11.422,9.26,20.682,20.682,20.682h470.636
                                      c11.423,0,20.682-9.26,20.682-20.682C512,87.699,502.741,78.439,491.318,78.439z"/>
                            </g>
                        </g>
                        <g>
                            <g>
                                <path d="M491.318,392.197H20.682C9.26,392.197,0,401.456,0,412.879s9.26,20.682,20.682,20.682h470.636
                                      c11.423,0,20.682-9.259,20.682-20.682S502.741,392.197,491.318,392.197z"/>
                            </g>
                        </g>
                    </svg>
                </a>
            </div>
        </div>
        <?php
        if (isset($heacool_options['heacool-popup-contact']) && !empty($heacool_options['heacool-popup-contact'])) {
            get_template_part('template-parts/header/popup-contact');
        }
        ?>
    </div><!--top_header end-->
     <?php
        if (isset($heacool_options['heacool-popup-contact']) && !empty($heacool_options['heacool-popup-contact'])) {
            ?>

    <div class="angle_top">
        <div class="container">
            <a href="<?php echo esc_url('#')?>" class="remove_top_bar"><i class="fa fa-angle-up"></i></a>
            <div class="apt_btn">
                <a href="<?php echo esc_url('#')?>" class="appointment_btn apt_form_btn"><?php echo esc_html__('Appointment', 'heacool'); ?>
                    <span class="apt-icon">
                        <svg version="1.1" id="Capa_13488" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="488.152px" height="488.152px" viewBox="0 0 488.152 488.152" xml:space="preserve">
                            <g>
                                <g>
                                    <path d="M177.854,269.311c0-6.115-4.96-11.069-11.08-11.069h-38.665c-6.113,0-11.074,4.954-11.074,11.069v38.66
                                          c0,6.123,4.961,11.079,11.074,11.079h38.665c6.12,0,11.08-4.956,11.08-11.079V269.311L177.854,269.311z"></path>
                                    <path d="M274.483,269.311c0-6.115-4.961-11.069-11.069-11.069h-38.67c-6.113,0-11.074,4.954-11.074,11.069v38.66
                                          c0,6.123,4.961,11.079,11.074,11.079h38.67c6.108,0,11.069-4.956,11.069-11.079V269.311z"></path>
                                    <path d="M371.117,269.311c0-6.115-4.961-11.069-11.074-11.069h-38.665c-6.12,0-11.08,4.954-11.08,11.069v38.66
                                          c0,6.123,4.96,11.079,11.08,11.079h38.665c6.113,0,11.074-4.956,11.074-11.079V269.311z"></path>
                                    <path d="M177.854,365.95c0-6.125-4.96-11.075-11.08-11.075h-38.665c-6.113,0-11.074,4.95-11.074,11.075v38.653
                                          c0,6.119,4.961,11.074,11.074,11.074h38.665c6.12,0,11.08-4.956,11.08-11.074V365.95L177.854,365.95z"></path>
                                    <path d="M274.483,365.95c0-6.125-4.961-11.075-11.069-11.075h-38.67c-6.113,0-11.074,4.95-11.074,11.075v38.653
                                          c0,6.119,4.961,11.074,11.074,11.074h38.67c6.108,0,11.069-4.956,11.069-11.074V365.95z"></path>
                                    <path d="M371.117,365.95c0-6.125-4.961-11.075-11.069-11.075h-38.67c-6.12,0-11.08,4.95-11.08,11.075v38.653
                                          c0,6.119,4.96,11.074,11.08,11.074h38.67c6.108,0,11.069-4.956,11.069-11.074V365.95L371.117,365.95z"></path>
                                    <path d="M440.254,54.354v59.05c0,26.69-21.652,48.198-48.338,48.198h-30.493c-26.688,0-48.627-21.508-48.627-48.198V54.142
                                          h-137.44v59.262c0,26.69-21.938,48.198-48.622,48.198H96.235c-26.685,0-48.336-21.508-48.336-48.198v-59.05
                                          C24.576,55.057,5.411,74.356,5.411,98.077v346.061c0,24.167,19.588,44.015,43.755,44.015h389.82
                                          c24.131,0,43.755-19.889,43.755-44.015V98.077C482.741,74.356,463.577,55.057,440.254,54.354z M426.091,422.588
                                          c0,10.444-8.468,18.917-18.916,18.917H80.144c-10.448,0-18.916-8.473-18.916-18.917V243.835c0-10.448,8.467-18.921,18.916-18.921
                                          h327.03c10.448,0,18.916,8.473,18.916,18.921L426.091,422.588L426.091,422.588z"></path>
                                    <path d="M96.128,129.945h30.162c9.155,0,16.578-7.412,16.578-16.567V16.573C142.868,7.417,135.445,0,126.29,0H96.128
                                          C86.972,0,79.55,7.417,79.55,16.573v96.805C79.55,122.533,86.972,129.945,96.128,129.945z"></path>
                                    <path d="M361.035,129.945h30.162c9.149,0,16.572-7.412,16.572-16.567V16.573C407.77,7.417,400.347,0,391.197,0h-30.162
                                          c-9.154,0-16.577,7.417-16.577,16.573v96.805C344.458,122.533,351.881,129.945,361.035,129.945z"></path>
                                </g>
                            </g>
                        </svg>
                    </span>
                </a>
            </div><!--apt_btn end-->
        </div>
    </div>

            <?php
        }
      ?>

    <div class="responsive_header">
        <div class="container">
            <?php
                    if (function_exists('get_custom_logo') && has_custom_logo()) {
                        $output = get_custom_logo();
                        if (empty($output)) {
                            ?>
                             <div class="responsive_logo">
                            <a href="<?php echo esc_url(home_url('/')) ?>">
                                <img src="<?php echo esc_url(HEACOOL_IMG_URL . 'logo2.png') ?>" alt="<?php esc_html_e('Logo', 'heacool'); ?>">
                            </a>
                            </div><!--logo end-->
                            <?php
                        } else {
                            $heacool_custom_logo_id = get_theme_mod('custom_logo');
                            $heacool_logo_image = wp_get_attachment_image_src($heacool_custom_logo_id, 'full');
                            ?>
                            <div class="responsive_logo">
                            <a href="<?php echo esc_url(home_url('/')) ?>">
                                <img src="<?php echo esc_url($heacool_logo_image[0]) ?>" alt="<?php esc_html_e('Logo', 'heacool'); ?>">
                            </a>
                            </div><!--logo end-->

                            <?php
                        }
                    } else {
                        ?>
                        <div class="responsive_logo">
                            <a href="<?php echo esc_url(home_url('/')) ?>">
                                <img src="<?php echo esc_url(HEACOOL_IMG_URL . 'logo2.png') ?>" alt="<?php esc_html_e('Logo', 'heacool'); ?>">
                            </a>
                            </div><!--logo end-->
                        <?php
                    }
                    ?>

                    <?php
                    if (isset($heacool_options['heacool-popup-contact']) && !empty($heacool_options['heacool-popup-contact'])) {
                        ?>
                <div class="apt_btn">
                <a href="<?php echo esc_url('#')?>" class="appointment_btn apt_form_btn">
                    <span class="apt-icon">
                        <svg version="1.1" id="Capa_1666" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="488.152px" height="488.152px" viewBox="0 0 488.152 488.152" xml:space="preserve">
                            <g>
                                <g>
                                    <path d="M177.854,269.311c0-6.115-4.96-11.069-11.08-11.069h-38.665c-6.113,0-11.074,4.954-11.074,11.069v38.66
                                          c0,6.123,4.961,11.079,11.074,11.079h38.665c6.12,0,11.08-4.956,11.08-11.079V269.311L177.854,269.311z"></path>
                                    <path d="M274.483,269.311c0-6.115-4.961-11.069-11.069-11.069h-38.67c-6.113,0-11.074,4.954-11.074,11.069v38.66
                                          c0,6.123,4.961,11.079,11.074,11.079h38.67c6.108,0,11.069-4.956,11.069-11.079V269.311z"></path>
                                    <path d="M371.117,269.311c0-6.115-4.961-11.069-11.074-11.069h-38.665c-6.12,0-11.08,4.954-11.08,11.069v38.66
                                          c0,6.123,4.96,11.079,11.08,11.079h38.665c6.113,0,11.074-4.956,11.074-11.079V269.311z"></path>
                                    <path d="M177.854,365.95c0-6.125-4.96-11.075-11.08-11.075h-38.665c-6.113,0-11.074,4.95-11.074,11.075v38.653
                                          c0,6.119,4.961,11.074,11.074,11.074h38.665c6.12,0,11.08-4.956,11.08-11.074V365.95L177.854,365.95z"></path>
                                    <path d="M274.483,365.95c0-6.125-4.961-11.075-11.069-11.075h-38.67c-6.113,0-11.074,4.95-11.074,11.075v38.653
                                          c0,6.119,4.961,11.074,11.074,11.074h38.67c6.108,0,11.069-4.956,11.069-11.074V365.95z"></path>
                                    <path d="M371.117,365.95c0-6.125-4.961-11.075-11.069-11.075h-38.67c-6.12,0-11.08,4.95-11.08,11.075v38.653
                                          c0,6.119,4.96,11.074,11.08,11.074h38.67c6.108,0,11.069-4.956,11.069-11.074V365.95L371.117,365.95z"></path>
                                    <path d="M440.254,54.354v59.05c0,26.69-21.652,48.198-48.338,48.198h-30.493c-26.688,0-48.627-21.508-48.627-48.198V54.142
                                          h-137.44v59.262c0,26.69-21.938,48.198-48.622,48.198H96.235c-26.685,0-48.336-21.508-48.336-48.198v-59.05
                                          C24.576,55.057,5.411,74.356,5.411,98.077v346.061c0,24.167,19.588,44.015,43.755,44.015h389.82
                                          c24.131,0,43.755-19.889,43.755-44.015V98.077C482.741,74.356,463.577,55.057,440.254,54.354z M426.091,422.588
                                          c0,10.444-8.468,18.917-18.916,18.917H80.144c-10.448,0-18.916-8.473-18.916-18.917V243.835c0-10.448,8.467-18.921,18.916-18.921
                                          h327.03c10.448,0,18.916,8.473,18.916,18.921L426.091,422.588L426.091,422.588z"></path>
                                    <path d="M96.128,129.945h30.162c9.155,0,16.578-7.412,16.578-16.567V16.573C142.868,7.417,135.445,0,126.29,0H96.128
                                          C86.972,0,79.55,7.417,79.55,16.573v96.805C79.55,122.533,86.972,129.945,96.128,129.945z"></path>
                                    <path d="M361.035,129.945h30.162c9.149,0,16.572-7.412,16.572-16.567V16.573C407.77,7.417,400.347,0,391.197,0h-30.162
                                          c-9.154,0-16.577,7.417-16.577,16.573v96.805C344.458,122.533,351.881,129.945,361.035,129.945z"></path>
                                </g>
                            </g>
                        </svg>
                    </span>
                </a>
                <a href="<?php echo esc_url('#')?>" class="contact_popup_btn"><span class="icon-text"><?php echo esc_html__('Contact Us', 'heacool'); ?></span> 
                    <span class="apt-icon">
                        <svg version="1.1" id="Capa_2" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="20px" height="20px" viewBox="0 0 550.795 550.795" xml:space="preserve">
                            <g>
                                <g>
                                    <path d="M501.613,491.782c12.381,0,23.109-4.088,32.229-12.16L377.793,323.567c-3.744,2.681-7.373,5.288-10.801,7.767
                                          c-11.678,8.604-21.156,15.318-28.434,20.129c-7.277,4.822-16.959,9.737-29.045,14.755c-12.094,5.024-23.361,7.528-33.813,7.528
                                          h-0.306h-0.306c-10.453,0-21.72-2.503-33.813-7.528c-12.093-5.018-21.775-9.933-29.045-14.755
                                          c-7.277-4.811-16.75-11.524-28.434-20.129c-3.256-2.387-6.867-5.006-10.771-7.809L16.946,479.622
                                          c9.119,8.072,19.854,12.16,32.234,12.16H501.613z"></path>
                                    <path d="M31.047,225.299C19.37,217.514,9.015,208.598,0,198.555V435.98l137.541-137.541
                                          C110.025,279.229,74.572,254.877,31.047,225.299z"></path>
                                    <path d="M520.059,225.299c-41.865,28.336-77.447,52.73-106.75,73.195l137.486,137.492V198.555
                                          C541.98,208.396,531.736,217.306,520.059,225.299z"></path>
                                    <path d="M501.613,59.013H49.181c-15.784,0-27.919,5.33-36.42,15.979C4.253,85.646,0.006,98.97,0.006,114.949
                                          c0,12.907,5.636,26.892,16.903,41.959c11.267,15.061,23.256,26.891,35.961,35.496c6.965,4.921,27.969,19.523,63.012,43.801
                                          c18.917,13.109,35.368,24.535,49.505,34.395c12.05,8.396,22.442,15.667,31.022,21.701c0.985,0.691,2.534,1.799,4.59,3.269
                                          c2.215,1.591,5.018,3.61,8.476,6.107c6.659,4.816,12.191,8.709,16.597,11.683c4.4,2.975,9.731,6.298,15.985,9.988
                                          c6.249,3.685,12.143,6.456,17.675,8.299c5.533,1.842,10.655,2.766,15.367,2.766h0.306h0.306c4.711,0,9.834-0.924,15.368-2.766
                                          c5.531-1.843,11.42-4.608,17.674-8.299c6.248-3.69,11.572-7.02,15.986-9.988c4.406-2.974,9.938-6.866,16.598-11.683
                                          c3.451-2.497,6.254-4.517,8.469-6.102c2.057-1.476,3.605-2.577,4.596-3.274c6.684-4.651,17.1-11.892,31.104-21.616
                                          c25.482-17.705,63.01-43.764,112.742-78.281c14.957-10.447,27.453-23.054,37.496-37.803c10.025-14.749,15.051-30.22,15.051-46.408
                                          c0-13.525-4.873-25.098-14.598-34.737C526.461,63.829,514.932,59.013,501.613,59.013z"></path>
                                </g>
                            </g>
                        </svg>
                    </span>
                </a>
                <a href="<?php echo esc_url('#')?>" class="direction_map_btn"><span class="icon-text"><?php echo esc_html__('Get Directions', 'heacool'); ?></span> 
                    <span class="apt-icon">
                        <svg version="1.1" id="Capa_39601" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="20px" height="22px" viewBox="0 0 97.713 97.713" xml:space="preserve">
                            <g>
                                <path d="M48.855,0C29.021,0,12.883,16.138,12.883,35.974c0,5.174,1.059,10.114,3.146,14.684
                                      c8.994,19.681,26.238,40.46,31.31,46.359c0.38,0.441,0.934,0.695,1.517,0.695s1.137-0.254,1.517-0.695
                                      c5.07-5.898,22.314-26.676,31.311-46.359c2.088-4.57,3.146-9.51,3.146-14.684C84.828,16.138,68.69,0,48.855,0z M48.855,54.659
                                      c-10.303,0-18.686-8.383-18.686-18.686c0-10.304,8.383-18.687,18.686-18.687s18.686,8.383,18.686,18.687
                                      C67.542,46.276,59.159,54.659,48.855,54.659z"></path>
                            </g>
                        </svg>
                    </span>
                </a>
            </div><!--apt_btn end-->

                        <?php
                    }
                    ?>

            
            <a href="<?php echo esc_url('#')?>" class="menu_btn">
                <svg version="1.1" id="Layer_2" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                     viewBox="0 0 512 512"  xml:space="preserve">
                    <g>
                        <g>
                            <path d="M491.318,235.318H20.682C9.26,235.318,0,244.577,0,256s9.26,20.682,20.682,20.682h470.636
                                  c11.423,0,20.682-9.259,20.682-20.682C512,244.578,502.741,235.318,491.318,235.318z"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M491.318,78.439H20.682C9.26,78.439,0,87.699,0,99.121c0,11.422,9.26,20.682,20.682,20.682h470.636
                                  c11.423,0,20.682-9.26,20.682-20.682C512,87.699,502.741,78.439,491.318,78.439z"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M491.318,392.197H20.682C9.26,392.197,0,401.456,0,412.879s9.26,20.682,20.682,20.682h470.636
                                  c11.423,0,20.682-9.259,20.682-20.682S502.741,392.197,491.318,392.197z"/>
                        </g>
                    </g>
                </svg>
            </a>

            <?php 
            if (isset($heacool_options['heacool-header-menu-search']) && !empty($heacool_options['heacool-header-menu-search'])) {  ?>
            <div class="search_icon">
                <svg version="1.1" id="Capa_4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                     width="28.931px" height="28.932px" viewBox="0 0 28.931 28.932" xml:space="preserve">
                    <g>
                        <path d="M28.344,25.518l-6.114-6.115c1.486-2.067,2.303-4.537,2.303-7.137c0-3.275-1.275-6.355-3.594-8.672
                              C18.625,1.278,15.543,0,12.266,0C8.99,0,5.909,1.275,3.593,3.594C1.277,5.909,0.001,8.99,0.001,12.266
                              c0,3.276,1.275,6.356,3.592,8.674c2.316,2.316,5.396,3.594,8.673,3.594c2.599,0,5.067-0.813,7.136-2.303l6.114,6.115
                              c0.392,0.391,0.902,0.586,1.414,0.586c0.513,0,1.024-0.195,1.414-0.586C29.125,27.564,29.125,26.299,28.344,25.518z M6.422,18.111
                              c-1.562-1.562-2.421-3.639-2.421-5.846S4.86,7.983,6.422,6.421c1.561-1.562,3.636-2.422,5.844-2.422s4.284,0.86,5.845,2.422
                              c1.562,1.562,2.422,3.638,2.422,5.845s-0.859,4.283-2.422,5.846c-1.562,1.562-3.636,2.42-5.845,2.42S7.981,19.672,6.422,18.111z"/>
                    </g>
                </svg>
                <?php
                echo heacool_heaer_search_form();
                ?>
            </div>
            <?php
              }
            ?>
        </div>
    </div><!--responsive_header end-->
    <div class="navigations">
        <div class="container">
            <nav>
                <?php
                if (has_nav_menu('primary-menu')) {
                    wp_nav_menu(
                            array(
                                'theme_location' => 'primary-menu',
                                'menu_class' => '',
                                'container' => 'ul',
                            )
                    );
                } else {
                    wp_nav_menu(
                            array(
                                'menu_class' => '',
                                'container' => 'ul',
                            )
                    );
                }
                ?>
            </nav>
            <a href="<?php echo esc_url('#')?>" class="menu_btn">
                <svg version="1.1" id="Layer_3" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                     viewBox="0 0 512 512"  xml:space="preserve">
                    <g>
                        <g>
                            <path d="M491.318,235.318H20.682C9.26,235.318,0,244.577,0,256s9.26,20.682,20.682,20.682h470.636
                                  c11.423,0,20.682-9.259,20.682-20.682C512,244.578,502.741,235.318,491.318,235.318z"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M491.318,78.439H20.682C9.26,78.439,0,87.699,0,99.121c0,11.422,9.26,20.682,20.682,20.682h470.636
                                  c11.423,0,20.682-9.26,20.682-20.682C512,87.699,502.741,78.439,491.318,78.439z"/>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path d="M491.318,392.197H20.682C9.26,392.197,0,401.456,0,412.879s9.26,20.682,20.682,20.682h470.636
                                  c11.423,0,20.682-9.259,20.682-20.682S502.741,392.197,491.318,392.197z"/>
                        </g>
                    </g>
                </svg>
            </a>
            <?php 
            if (isset($heacool_options['heacool-header-menu-search']) && !empty($heacool_options['heacool-header-menu-search'])) {  ?>
            <div class="search_icon">
                <svg version="1.1" id="Capa_349" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                     width="28.931px" height="28.932px" viewBox="0 0 28.931 28.932" xml:space="preserve">
                    <g>
                        <path d="M28.344,25.518l-6.114-6.115c1.486-2.067,2.303-4.537,2.303-7.137c0-3.275-1.275-6.355-3.594-8.672
                              C18.625,1.278,15.543,0,12.266,0C8.99,0,5.909,1.275,3.593,3.594C1.277,5.909,0.001,8.99,0.001,12.266
                              c0,3.276,1.275,6.356,3.592,8.674c2.316,2.316,5.396,3.594,8.673,3.594c2.599,0,5.067-0.813,7.136-2.303l6.114,6.115
                              c0.392,0.391,0.902,0.586,1.414,0.586c0.513,0,1.024-0.195,1.414-0.586C29.125,27.564,29.125,26.299,28.344,25.518z M6.422,18.111
                              c-1.562-1.562-2.421-3.639-2.421-5.846S4.86,7.983,6.422,6.421c1.561-1.562,3.636-2.422,5.844-2.422s4.284,0.86,5.845,2.422
                              c1.562,1.562,2.422,3.638,2.422,5.845s-0.859,4.283-2.422,5.846c-1.562,1.562-3.636,2.42-5.845,2.42S7.981,19.672,6.422,18.111z"/>
                    </g>
                </svg>
                <?php
                echo heacool_heaer_search_form_2();
                ?>
            </div>
            <?php
              }
            ?>
        </div>
    </div>
</header><!--header end-->

<div class="responsive-header">
    <div class="container">
                     <?php
                    if (function_exists('get_custom_logo') && has_custom_logo()) {
                        $output = get_custom_logo();
                        if (empty($output)) {
                            ?>
                             <div class="responsive_hd_logo">
                            <a href="<?php echo esc_url(home_url('/')) ?>">
                                <img src="<?php echo esc_url(HEACOOL_IMG_URL . 'logo2.png') ?>" alt="<?php esc_html_e('Logo', 'heacool'); ?>">
                            </a>
                            </div><!--logo end-->

                            <?php
                        } else {
                            $heacool_custom_logo_id = get_theme_mod('custom_logo');
                            $heacool_logo_image = wp_get_attachment_image_src($heacool_custom_logo_id, 'full');
                            ?>
                            <div class="responsive_hd_logo">
                            <a href="<?php echo esc_url(home_url('/')) ?>">
                                <img src="<?php echo esc_url($heacool_logo_image[0]) ?>" alt="<?php esc_html_e('Logo', 'heacool'); ?>">
                            </a>
                            </div><!--logo end-->

                            <?php
                        }
                    } else {
                        ?>
                        <div class="responsive_hd_logo">
                            <a href="<?php echo esc_url(home_url('/')) ?>">
                                <img src="<?php echo esc_url(HEACOOL_IMG_URL . 'logo2.png') ?>" alt="<?php esc_html_e('Logo', 'heacool'); ?>">
                            </a>
                            </div><!--logo end-->
                        <?php
                    }
                    ?>

        <div class="responsive_header_navigations">
            <nav>
                <?php
                if (has_nav_menu('primary-menu')) {
                    wp_nav_menu(
                            array(
                                'theme_location' => 'primary-menu',
                                'menu_class' => '',
                                'container' => 'ul'
                            )
                    );
                } else {
                    wp_nav_menu(
                            array(
                                'menu_class' => '',
                                'container' => 'ul'
                            )
                    );
                }
                ?>
            </nav>
        </div><!--responsive_header_navigations end-->
        <a href="<?php echo esc_url('#')?>" class="menu_btn">
            <svg version="1.1" id="Layer_4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                 viewBox="0 0 512 512"  xml:space="preserve">
                <g>
                    <g>
                        <path d="M491.318,235.318H20.682C9.26,235.318,0,244.577,0,256s9.26,20.682,20.682,20.682h470.636
                              c11.423,0,20.682-9.259,20.682-20.682C512,244.578,502.741,235.318,491.318,235.318z"/>
                    </g>
                </g>
                <g>
                    <g>
                        <path d="M491.318,78.439H20.682C9.26,78.439,0,87.699,0,99.121c0,11.422,9.26,20.682,20.682,20.682h470.636
                              c11.423,0,20.682-9.26,20.682-20.682C512,87.699,502.741,78.439,491.318,78.439z"/>
                    </g>
                </g>
                <g>
                    <g>
                        <path d="M491.318,392.197H20.682C9.26,392.197,0,401.456,0,412.879s9.26,20.682,20.682,20.682h470.636
                              c11.423,0,20.682-9.259,20.682-20.682S502.741,392.197,491.318,392.197z"/>
                    </g>
                </g>
            </svg>
        </a>
        <div class="clearfix"></div>
    </div>
</div><!--responsive-header end-->

<div class="responsive-menu">
    <a href="<?php echo esc_url('#')?>" class="close-mobile-menu">
        <img src="<?php echo esc_url(HEACOOL_IMG_URL); ?>/close.png" alt="<?php esc_attr_e('close', 'heacool'); ?>">
    </a>
    <?php
    if (has_nav_menu('primary-menu')) {
        wp_nav_menu(
                array(
                    'theme_location' => 'primary-menu',
                    'menu_class' => '',
                    'container' => 'ul'
                )
        );
    } else {
        wp_nav_menu(
                array(
                    'menu_class' => '',
                    'container' => 'ul'
                )
        );
    }
    ?>
</div><!--responsive-menu end-->