<?php
/**
 * The template for displaying pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other "pages" on your WordPress site will use a different template.
 *
 * @package WordPress
 * @subpackage heacool
 * @since heacool 1.0
 */

get_header();
$heacool_options = heacool_options();
if (isset($heacool_options['heacool-page-style']) && $heacool_options['heacool-page-style'] ==!'') { ?>
    <div class="page-content">
        <div class="container">
            <div class="blog-page">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                            while (have_posts()) :
                                the_post();
                                get_template_part('template-parts/single/content', get_post_format());
                            // If comments are open or we have at least one comment, load up the comment template.
                            if (comments_open() || get_comments_number()) :
                                comments_template();
                            endif;
                            endwhile; // End of the loop.
                        ?>
                    </div>
                </div>
            </div>
        </div>  
    </div><!--page-content end-->
<?php
}else{
 ?>
    <div class="vustom-page-title">
        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
    </div>
	<div class="page-content have-vustom-page-title">
        <div class="container">
		<?php
		// Start the loop.
		while ( have_posts() ) : the_post();
			// Include the page content template.
			get_template_part( 'template-parts/content', 'page' );
			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;
		// End the loop.
		endwhile;
		?>
    	</div><!-- .container -->
	</div><!-- #page-content -->
<?php
}
 get_footer();