<?php
/**
 * Custom template tags for this theme
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package heacool
 */
if ( ! function_exists( 'heacool_posted_on' ) ) :

	/**
	 * Prints HTML with meta information for the current post-date/time.
	 */
	function heacool_posted_on() {
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
			$time_string = '<time class="updated" datetime="%3$s">%4$s</time>';
		}
		$time_string = sprintf(
			$time_string,
			esc_attr( get_the_date( DATE_W3C ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( DATE_W3C ) ),
			esc_html( get_the_modified_date() )
		);
		$posted_on   = sprintf(
			/* translators: %s: post date. */
			esc_html( '%s' ),
			'<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">' . $time_string . '</a>'
		);
			echo '<span class="posted-on">' . $posted_on . '</span>'; // WPCS: XSS OK.
	}

	endif;

if ( ! function_exists( 'heacool_posted_by' ) ) :

	/**
	 * Prints HTML with meta information for the current author.
	 */
	function heacool_posted_by() {
		$byline = sprintf(
		/* translators: %s: post author. */
			esc_html_x( 'by %s', 'post author', 'heacool' ),
			'<a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( ucfirst( get_the_author() ) ) . '</a>'
		);

			echo ' ' . $byline; // WPCS: XSS OK.
	}

	endif;


if ( ! function_exists( 'heacool_posted_author' ) ) :

	/**
	 * Prints HTML with meta information for the current author.
	 */
	function heacool_posted_author() {
		$byline = sprintf(
		/* translators: %s: post author. */
			esc_html_x( '%s', 'post author', 'heacool' ),
			'<a class="main-color-font" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( ucfirst( get_the_author() ) ) . '</a>'
		);

		echo ' ' . $byline; // WPCS: XSS OK.
	}

	endif;


if ( ! function_exists( 'heacool_comments_count' ) ) :

	/**
	 * Displays an optional post thumbnail.
	 *
	 * Wraps the post thumbnail in an anchor element on index views, or a div
	 * element when on single views.
	 */
	function heacool_comments_count() {

		if ( get_comments_number( get_the_ID() ) > 1 ) {
			$comments_count = sprintf( '%s', get_comments_number( get_the_ID() ) . esc_html__( ' Comments', 'heacool' ) );
		} else {
			$comments_count = sprintf( '%s', get_comments_number( get_the_ID() ) . esc_html__( ' Comment', 'heacool' ) );
		}
		echo wp_kses_post( $comments_count );
	}

endif;

if ( ! function_exists( 'heacool_post_meta' ) ) :

	/**
	 * Displays an optional post thumbnail.
	 *
	 * Wraps the post thumbnail in an anchor element on index views, or a div
	 * element when on single views.
	 */
	function heacool_post_meta() {
		?>
	<ul class="meta">
		<li>
			<span><?php echo esc_html__( 'Posted by:', 'heacool' ); ?></span> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" class="admin"><?php echo esc_html( ucfirst( get_the_author() ) ); ?></a>  
		</li>
		<li><a href="<?php echo esc_url( the_permalink() ); ?>">
		<?php
		if ( get_comments_number( get_the_ID() ) > 1 ) {
			$comments_count = sprintf( '%s', get_comments_number( get_the_ID() ) . esc_html__( ' Comments', 'heacool' ) );
		} else {
			$comments_count = sprintf( '%s', get_comments_number( get_the_ID() ) . esc_html__( ' Comment', 'heacool' ) );
		}
		echo wp_kses_post( $comments_count );
		?>
		</a></li>
	</ul><!--meta end-->
		<?php
	}

endif;


if ( ! function_exists( 'heacool_post_tags' ) ) :

	/**
	 * Displays an optional post thumbnail.
	 *
	 * Wraps the post thumbnail in an anchor element on index views, or a div
	 * element when on single views.
	 */
	function heacool_post_tags() {
		/* translators: used between list items, there is a space after the comma */
		$tags_list = get_the_tag_list( '<ul class="tagz-list"><li>', '</li><li>', '</li></ul>' );
		if ( $tags_list ) {
			printf( '' . esc_html( '%1$s' ) . '', $tags_list ); // WPCS: XSS OK.
		}
	}

	endif;

if ( ! function_exists( 'heacool_comments' ) ) {

	function heacool_comments( $comment, $args, $depth ) {
		extract( $args, EXTR_SKIP );
		$args['reply_text'] = esc_html__( 'Reply', 'heacool' );
		?>
			<li id="comment-<?php comment_ID(); ?>">
				<div class="coment">
				<?php
				$heacool_avatar = get_avatar( $comment );
				if ( $heacool_avatar ) {
					?>
						<div class="coment-img">
						<?php print get_avatar( $comment, 83, null, null, array( 'class' => array() ) ); ?>
						</div>
						<?php } ?>

						<div class="coment-info">
							<h5 class="coment-info-title"><?php echo esc_html__( 'Posted by:', 'heacool' ); ?> <a href="#"> <?php echo get_comment_author_link(); ?></a></h5>
							<span class="postedd_date"><?php comment_time( get_option( 'date_format' ) ); ?></span>
						<?php comment_text(); ?>
						<?php
						comment_reply_link(
							array_merge(
								$args,
								array(
									'reply_text' => esc_html__( 'Reply', 'heacool' ),
									'depth'      => $depth,
									'max_depth'  => $args['max_depth'],
								)
							)
						);
						?>
						</div>
					</div>
					<?php
	}
}

function heacool_search_form( $form ) {
	$form = '<div class="widget widget-search"><form role="search" method="get" id="searchform_1" action="' . esc_url( home_url( '/' ) ) . '" >
                <input type="text" name="s" value="' . get_search_query() . '" placeholder="' . esc_attr__( 'Search...', 'heacool' ) . '" required>
                <button type="submit"><i class="fa fa-search"></i></button>
                </form></div>';
	return $form;
}

			add_filter( 'get_search_form', 'heacool_search_form', 100 );

function heacool_heaer_search_form() {
	$form = '<form role="search" method="get" id="searchform" class="searchh_form" action="' . esc_url( home_url( '/' ) ) . '" >
                <input type="search" class="search" name="s" value="' . get_search_query() . '" placeholder="' . esc_attr__( 'Search here...', 'heacool' ) . '" required>
                </form>';
	return $form;
}

function heacool_heaer_search_form_2() {
	$form = '<form role="search" method="get" id="searchform_2" class="searchh_form" action="' . esc_url( home_url( '/' ) ) . '" >
                <input type="search" class="search" name="s" value="' . get_search_query() . '" placeholder="' . esc_attr__( 'Search here...', 'heacool' ) . '" required>
                </form>';
	return $form;
}
