<?php
update_option('envato_theme_license_token','token');
update_option('envato_theme_license_key_status','valid');
update_option('envato_theme_license_key','license_key');

if ( ! defined( 'HEACOOL_THEME_URI' ) ) {
	define( 'HEACOOL_THEME_URI', get_template_directory_uri() );
}
define( 'HEACOOL_THEME_DIR', get_template_directory() );
define( 'HEACOOL_CSS_URL', get_template_directory_uri() . '/css' );
define( 'HEACOOL_JS_URL', get_template_directory_uri() . '/js' );
define( 'HEACOOL_FONTS_URL', get_template_directory_uri() . '/fonts/font-awesome/css' );
define( 'HEACOOL_IMG_URL', HEACOOL_THEME_URI . '/images/' );
define( 'HEACOOL_FREAMWORK_DIRECTORY', HEACOOL_THEME_DIR . '/framework/' );


/*
 * Redux framework configuration
 */
require_once HEACOOL_FREAMWORK_DIRECTORY . 'redux.config.php';
require_once HEACOOL_FREAMWORK_DIRECTORY . 'plugin-list.php';

/*
 * Enable support TGM configuration.
 */
require_once HEACOOL_FREAMWORK_DIRECTORY . 'config-tgm.php';
require_once HEACOOL_FREAMWORK_DIRECTORY . 'class-tgm-plugin-activation.php';
require_once HEACOOL_FREAMWORK_DIRECTORY . '/dashboard/class-heacool-dashboard.php';
require_once HEACOOL_THEME_DIR . '/inc/template-tags.php';
require_once HEACOOL_THEME_DIR . '/css/custom-style.php';

/**
 * heacool-theme functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package heacool-theme
 */
if ( ! function_exists( 'heacool_setup' ) ) :

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function heacool_setup() {
		global $content_width;

		$content_width = apply_filters( 'heacool_content_width', 640 );
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on heacool-theme, use a find and replace
		 * to change 'heacool' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'heacool', get_template_directory() . '/languages' );

		$defaults = array(
			'default-image'          => '',
			'width'                  => 0,
			'height'                 => 0,
			'flex-height'            => false,
			'flex-width'             => false,
			'uploads'                => true,
			'random-default'         => false,
			'header-text'            => true,
			'default-text-color'     => '',
			'wp-head-callback'       => '',
			'admin-head-callback'    => '',
			'admin-preview-callback' => '',
		);

		add_theme_support( 'custom-header', $defaults );
		add_theme_support( 'custom-logo' );

		$defaults = array(
			'default-color'          => '',
			'default-image'          => '',
			'default-repeat'         => '',
			'default-position-x'     => '',
			'default-attachment'     => '',
			'wp-head-callback'       => '_custom_background_cb',
			'admin-head-callback'    => '',
			'admin-preview-callback' => '',
		);
		add_theme_support( 'custom-background', $defaults );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );
		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
			)
		);

		/*
		 * Enable support for Post Formats.
		 * See https://developer.wordpress.org/themes/functionality/post-formats/
		 */
		add_theme_support(
			'post-formats',
			array(
				'aside',
				'image',
				'video',
				'quote',
				'link',
				'audio',
			)
		);

		add_theme_support( 'wp-block-styles' );
		add_theme_support( 'align-wide' );
		add_theme_support( 'editor-styles' );
		add_theme_support( 'responsive-embeds' );

		// Add custom thumb size
		set_post_thumbnail_size( 847, 491, false );
		add_image_size( 'heacool-gallery-thumbnail', 476, 416, true );
		add_image_size( 'heacool_service_image', 870, 494, true );
	}

endif; // heacool_setup
add_action( 'after_setup_theme', 'heacool_setup' );

/*
 * Meta Box Configuration Post Meta Option
 */
require_once HEACOOL_FREAMWORK_DIRECTORY . 'config.meta.box.php';

add_action( 'widgets_init', 'heacool_widgets_init' );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
if ( ! function_exists( 'heacool_widgets_init' ) ) :

	function heacool_widgets_init() {

		register_sidebar(
			array(
				'name'          => esc_html__( 'Blog Sidebar', 'heacool' ),
				'id'            => 'blogleftsidebar',
				'before_widget' => '<div class="widget widget-categories  %2$s" id="%1$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>',
			)
		);
		$heacool_options    = heacool_options();
		$heacool_servideend = isset( $heacool_options['heacool_servideend'] ) ? $heacool_options['heacool_servideend'] : 0;
		if ( $heacool_servideend == 1 ) {
			register_sidebar(
				array(
					'name'          => esc_html__( 'Services Sidebar', 'heacool' ),
					'id'            => 'servicesidebar',
					'description'   => esc_html__( 'Service sidebar area', 'heacool' ),
					'before_widget' => '<div id="%1$s" class="widget %2$s">',
					'after_widget'  => '</div>',
					'before_title'  => '<h3 class="">',
					'after_title'   => '</h3>',
				)
			);
		}

		$heacool_main_tools = isset( $heacool_options['heacool_main_tools'] ) ? $heacool_options['heacool_main_tools'] : 0;
		$widget_class_1     = '';
		$widget_class_2     = '';
		if ( $heacool_main_tools == 1 ) {
			$widget_class_1 = ' widget-about';
			$widget_class_2 = ' widget-contact';
		}

		register_sidebar(
			array(
				'name'          => esc_html__( 'Footer Column 1', 'heacool' ),
				'id'            => 'footer_col_1',
				'description'   => esc_html__( 'Footer Column 1', 'heacool' ),
				'before_widget' => '<div id="%1$s" class="widget' . $widget_class_1 . ' %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h4>',
				'after_title'   => '</h4>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__( 'Footer Column 2', 'heacool' ),
				'id'            => 'footer_col_2',
				'description'   => esc_html__( 'Footer Column 2', 'heacool' ),
				'before_widget' => '<div id="%1$s" class="widget' . $widget_class_2 . '  %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h4>',
				'after_title'   => '</h4>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__( 'Footer Column 3', 'heacool' ),
				'id'            => 'footer_col_3',
				'description'   => esc_html__( 'Footer Column 3', 'heacool' ),
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<h4>',
				'after_title'   => '</h4>',
			)
		);

		$heacool_base_ttps = isset( $heacool_options['heacool_base_ttps'] ) ? $heacool_options['heacool_base_ttps'] : 0;
		if ( $heacool_base_ttps == 1 ) {
			register_sidebar(
				array(
					'name'          => esc_html__( 'Secondary Footer Column 1', 'heacool' ),
					'id'            => 'secondary_footer_col_1',
					'description'   => esc_html__( 'Footer Column 1', 'heacool' ),
					'before_widget' => '',
					'after_widget'  => '',
					'before_title'  => '',
					'after_title'   => '',
				)
			);
			register_sidebar(
				array(
					'name'          => esc_html__( 'Secondary Footer Column 2', 'heacool' ),
					'id'            => 'secondary_footer_col_2',
					'description'   => esc_html__( 'Footer Column 2', 'heacool' ),
					'before_widget' => '',
					'after_widget'  => '',
					'before_title'  => '',
					'after_title'   => '',
				)
			);
			register_sidebar(
				array(
					'name'          => esc_html__( 'Secondary Footer Column 3', 'heacool' ),
					'id'            => 'secondary_footer_col_3',
					'description'   => esc_html__( 'Footer Column 3', 'heacool' ),
					'before_widget' => '',
					'after_widget'  => '',
					'before_title'  => '',
					'after_title'   => '',
				)
			);

			register_sidebar(
				array(
					'name'          => esc_html__( 'Secondary Footer Column 4', 'heacool' ),
					'id'            => 'secondary_footer_col_4',
					'description'   => esc_html__( 'Footer Column 4', 'heacool' ),
					'before_widget' => '',
					'after_widget'  => '',
					'before_title'  => '',
					'after_title'   => '',
				)
			);

		}
	}

endif; // end IF  For heacool_widgets_init


/**
 * Enqueue scripts and styles.
 */
add_action( 'wp_enqueue_scripts', 'heacool_scripts_build', 1000 );

function heacool_scripts_build() {
	wp_enqueue_style( 'heacool-google-fonts', heacool_scripts_google(), array(), null );
}

function heacool_scripts_google() {
	 $protocol  = is_ssl() ? 'https:' : 'http:';
	$variants   = ':100,100i,300,300i,400,400i,500,500i,700,700i,900,900i&display=swap';
	$query_args = array(
		'family' => urlencode( 'Roboto' . $variants ),
	);
	$font_url   = add_query_arg( $query_args, $protocol . '//fonts.googleapis.com/css' );
	return $font_url;
}

add_action( 'wp_enqueue_scripts', 'heacool_scripts', 1000 );
if ( ! function_exists( 'heacool_scripts' ) ) :

	function heacool_scripts() {
		$heacool_option        = heacool_options();
		$heacool_default_theme = isset( $heacool_option['heacool-default-theme'] ) ? $heacool_option['heacool-default-theme'] : 1;
		// Load styles
		wp_enqueue_style( 'bootstrap', HEACOOL_CSS_URL . '/plugins/bootstrap.min.css' );
		wp_enqueue_style( 'bootstrap-datetimepicker', HEACOOL_CSS_URL . '/plugins/bootstrap-datetimepicker.css' );
		wp_enqueue_style( 'animate', HEACOOL_CSS_URL . '/plugins/animate.min.css' );
		wp_enqueue_style( 'font-awesome', HEACOOL_CSS_URL . '/font-awesome.min.css' );
		wp_enqueue_style( 'slick', HEACOOL_CSS_URL . '/plugins/slick.css' );
		wp_enqueue_style( 'heacool-style', get_stylesheet_directory_uri() . '/style.css' );
		wp_enqueue_style( 'heacool-responsive', HEACOOL_CSS_URL . '/responsive.css' );
		wp_enqueue_style( 'iconfont', HEACOOL_THEME_URI . '/iconfont/style.css' );

		if ( $heacool_default_theme ) {
			wp_enqueue_style( 'heacool-heat-cool-style', HEACOOL_CSS_URL . '/heat-cool-style.css' );
		}
		wp_enqueue_style( 'heacool-heat-cool-tosny', HEACOOL_CSS_URL . '/heat-cool-tosny.css' );
		wp_enqueue_style( 'heacool-heat-cool-tny', HEACOOL_CSS_URL . '/heat-tny-style.css' );
		wp_enqueue_style( 'lightbox', HEACOOL_CSS_URL . '/lightbox.css' );

		if ( function_exists( 'heacool_get_custom_styles' ) ) {
			$heacool_custom_inline_style = heacool_get_custom_styles();
			wp_add_inline_style( 'heacool-style', $heacool_custom_inline_style );
		}

		function heacool_custom_css() {
			$heacool_custom_inline_style = '';

			if ( function_exists( 'heacool_get_custom_styles' ) ) {
				$heacool_custom_inline_style = heacool_get_custom_styles();
				wp_add_inline_style( 'heacool-style', $heacool_custom_inline_style );
			}

		}
		add_action( 'wp_enqueue_scripts', 'heacool_custom_css', 20 );

		// Load script
		if ( $heacool_option['heacool-timeformat'] ) {
			$timeformat = 'HH:mm';
		} else {
			$timeformat = 'LT';
		}
		wp_enqueue_script( 'bootstrap', HEACOOL_JS_URL . '/plugins/bootstrap.min.js', array( 'jquery' ), '201202124', true );
		wp_enqueue_script( 'moment-custom', HEACOOL_JS_URL . '/plugins/moment.min.js', array( 'jquery' ), '201202124', true );
		wp_enqueue_script( 'bootstrap-datetimepicker', HEACOOL_JS_URL . '/plugins/bootstrap-datetimepicker.min.js', array( 'jquery' ), '201202124', true );
		// wp_enqueue_script( 'slick', HEACOOL_JS_URL . '/plugins/slick.min.js', array( 'jquery' ), '201202124', true );
		wp_enqueue_script( 'jquery-lightbox', HEACOOL_JS_URL . '/lightbox.js', array( 'jquery' ), '201202124', true );

		wp_enqueue_script( 'heacool-custom', HEACOOL_JS_URL . '/custom.js', array( 'jquery' ), time(), true );
		wp_localize_script( 'heacool-custom', 'form_option', array( 'date_format' => $timeformat ) );

		$heacool_sticky_header = 0;
		if ( isset( $heacool_option['heacool-site-sticky'] ) && $heacool_option['heacool-site-sticky'] ) {
			$heacool_sticky_header = '1';
		}

		wp_localize_script(
			'heacool-custom',
			'ajax_object',
			array(
				'ajax_url'              => esc_url( admin_url( 'admin-ajax.php' ) ),
				'heacool_sticky_header' => $heacool_sticky_header,
				'loader_img'            => HEACOOL_IMG_URL . 'ajax-loader.gif',
			)
		);

		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}

endif; // end IF  For heacool_scripts


function heacool_add_editor_styles() {
	add_editor_style( 'editor-style.css' );
}

add_action( 'admin_init', 'heacool_add_editor_styles' );

add_action( 'admin_enqueue_scripts', 'heacool_services_googlefont_build' );

function heacool_build_google_font() {
	$protocol   = is_ssl() ? 'https:' : 'http:';
	$query_args = array(
		'family' => urlencode( 'Roboto:400,500,700i' ),
	);
	$font_url   = add_query_arg( $query_args, $protocol . '//fonts.googleapis.com/css' );
	return $font_url;
}

function heacool_services_googlefont_build() {
	wp_enqueue_style( 'heacool-google-fonts-admin', heacool_build_google_font(), array(), null );
}

if ( ! function_exists( 'register_heacool_menu' ) ) :

	function register_heacool_menu() {
		register_nav_menu( 'primary-menu', esc_html__( 'Primary Menu', 'heacool' ) );
	}

endif; // end IF  For register_heacool_menu

add_action( 'init', 'register_heacool_menu' );

if ( ! function_exists( 'heacool_options' ) ) :

	function heacool_options() {
		global $heacool_option;
		return $heacool_option;
	}

endif; // end IF  For heacool_options

add_action( 'heacool_breadcrumb', 'heacool_breadcrumb' );

if ( ! function_exists( 'heacool_breadcrumb' ) ) :
	function heacool_breadcrumb() {
		global $post, $heacool_option;
		if ( ! isset( $post->ID ) ) {
			return false;
		}
		if ( ! is_front_page() || is_home() ) {
			if ( ( isset( $post->post_type ) && is_page() ) || is_search() || is_home() || is_single() || is_archive() || is_category() ) {
				$show_breadcrumb = get_post_meta( $post->ID, 'framework_show_breadcrumb', true );
				if ( isset( $heacool_option['heacool-blog-show-breadcrumb'] ) && $heacool_option['heacool-blog-show-breadcrumb'] && ( is_search() || is_home() || is_single() || is_archive() || is_category() ) ) {
					$show_breadcrumb = 'on';
				}
				if ( $show_breadcrumb == 'on' ) {
					if ( function_exists( 'yoast_breadcrumb' ) ) {
						?>
<section class="pager-sec">
	<div class="container">
		<div class="pager-info">
						<?php
									yoast_breadcrumb();
						?>
		</div>
	</div>
</section>
						<?php
					}
				}
			}
		}
	}

endif; // end IF  For heacool_breadcrumb

if ( ! function_exists( 'heacool_comment_nav' ) ) :

	function heacool_comment_nav() {
		// Are there comments to navigate through?
		if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
			?>
<nav class="navigation comment-navigation">
	<h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'heacool' ); ?></h2>
	<div class="nav-links">
			<?php
			if ( $prev_link = get_previous_comments_link( esc_html__( 'Older Comments', 'heacool' ) ) ) :
				printf( '<div class="nav-previous">%s</div>', $prev_link );
					endif;

			if ( $next_link = get_next_comments_link( esc_html__( 'Newer Comments', 'heacool' ) ) ) :
				printf( '<div class="nav-next">%s</div>', $next_link );
					endif;
			?>
	</div><!-- .nav-links -->
</nav><!-- .comment-navigation -->
			<?php
		endif;
	}

endif;
// body class filter
add_filter( 'body_class', 'heacool_body_classes' );

if ( ! function_exists( 'heacool_body_classes' ) ) :

	function heacool_body_classes( $classes ) {
		if ( is_front_page() ) {
			$classes[] = 'index';
		}
		return $classes;
	}

endif; // end IF  For heacool_body_classes
/*
 =====================================
 * Get Theme Font Icon
 * ======================== */




function heacool_add_slug_body_class( $classes ) {
	global $post;
	if ( isset( $post ) ) {
		if ( $post->post_type == 'heacool_services' ) {
			$classes[] = 'customwidget_' . $post->post_name;
		}
	}
	return $classes;
}

add_filter( 'body_class', 'heacool_add_slug_body_class' );


add_filter( 'heacool_services_postype_heacool_services_slug', 'heacool_services_postype_heacool_services_slug', 10 );

function heacool_services_postype_heacool_services_slug() {
	if ( function_exists( 'heacool_options' ) ) {
		$heacool_options = heacool_options();
		if ( isset( $heacool_options['heacool-slug_postype_heacool_services'] ) && ! empty( $heacool_options['heacool-slug_postype_heacool_services'] ) ) {
			return $heacool_options['heacool-slug_postype_heacool_services'];
		}
	}
}

add_action( 'heacool_preloader', 'heacool_preloader_function' );

if ( ! function_exists( 'heacool_preloader_function' ) ) {

	function heacool_preloader_function() {
		$heacool_options = heacool_options();
		if ( isset( $heacool_options['heacool-site-preloader'] ) && $heacool_options['heacool-site-preloader'] ) {
			?>
<div class="preloader">
	<div class="circles">
		<div class="large-circle"></div>
		<div class="mid-circle"></div>
		<div class="small-circle"></div>
	</div>
</div>
<!--preloader end-->
			<?php
		}
	}
}

add_filter( 'wpcf7_support_html5_fallback', '__return_true' );


add_filter( 'body_class', 'heacool_header_class' );


function heacool_elementor_library() {
	$pageslist = get_posts(
		array(
			'post_type'      => 'elementor_library',
			'posts_per_page' => -1,
		)
	);
	$pagearray = array();
	if ( ! empty( $pageslist ) ) {
		foreach ( $pageslist as $page ) {
			$pagearray[ $page->ID ] = $page->post_title;
		}
	}
	return $pagearray;
}

function heacool_header_class( $classes ) {
	$heacool_options  = heacool_options();
	$classes[]        = 'home layout2';
	$base_theme_class = 'base-hitcool';

	if ( isset( $heacool_options['heacool_base_theme'] ) && ! empty( $heacool_options['heacool_base_theme'] ) ) {
		$heacool_base_theme = $heacool_options['heacool_base_theme'];

		if ( $heacool_base_theme == '1' ) :
			$base_theme_class = '';
		endif;
	}

	$classes[] = $base_theme_class;
	return $classes;
}

add_filter( 'comment_form_fields', 'heacool_move_comment_field_to_bottom' );

function heacool_move_comment_field_to_bottom( $fields ) {
	$comment_field = $fields['comment'];
	unset( $fields['comment'] );
	unset( $fields['cookies'] );
	$fields['comment'] = $comment_field;
	return $fields;
}

function heacool_filter_ptags_on_images( $content ) {
	return preg_replace( '/<p>\s*(<a .*>)?\s*(<img .* \/>)\s*(<\/a>)?\s*<\/p>/iU', '\1\2\3', $content );
}
add_filter( 'the_content', 'heacool_filter_ptags_on_images' );


function heacool_get_allowed_html_tag( $level = 'basic' ) {
	$allowed_html = array(
		'b'      => array(),
		'i'      => array(),
		'u'      => array(),
		'em'     => array(),
		'br'     => array(),
		'abbr'   => array(
			'title' => array(),
		),
		'span'   => array(
			'class' => array(),
		),
		'a'      => array(
			'href'  => array(),
			'class' => array(),
			'title' => array(),
			'id'    => array(),
		),
		'strong' => array(),
	);

	if ( $level === 'intermediate' ) {
		$allowed_html['a'] = array(
			'href'  => array(),
			'title' => array(),
			'class' => array(),
			'id'    => array(),
		);
	}

	return $allowed_html;
}

function heacool_kses_custom( $string = '' ) {
	return wp_kses( $string, heacool_get_allowed_html_tag( 'basic' ) );
}
