<?php
if ( ! class_exists( 'Redux' ) ) {
	return;
}

if ( ! function_exists( 'heacool_get_contact_form_7_posts' ) ) :

	function heacool_get_contact_form_7_posts() {
		$args    = array(
			'post_type'      => 'wpcf7_contact_form',
			'posts_per_page' => -1,
		);
		$catlist = array();
		if ( $categories = get_posts( $args ) ) {
			foreach ( $categories as $category ) {
				(int) $catlist[ $category->ID ] = $category->post_title;
			}
		} else {
			(int) $catlist['0'] = esc_html__( 'No contect From 7 form found', 'heacool' );
		}
		return $catlist;
	}
endif;
	// This is your option name where all the Redux data is stored.
	$opt_name = 'heacool_option';

	$theme      = wp_get_theme(); // For use with some settings. Not necessary.
	$opt_prefix = 'heacool';

	$args = array(
		// TYPICAL -> Change these values as you need/desire
		'opt_name'                  => $opt_name,
		// This is where your data is stored in the database and also becomes your global variable name.
		'display_name'              => $theme->get( 'Name' ),
		// Name that appears at the top of your panel
		'display_version'           => $theme->get( 'Version' ),
		// Version that appears at the top of your panel
		'menu_type'                 => 'menu',
		// Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
		'allow_sub_menu'            => true,
		// Show the sections below the admin menu item or not
		'menu_title'                => esc_html__( 'Heacool Options', 'heacool' ),
		'page_title'                => esc_html__( 'Heacool Options', 'heacool' ),
		// You will need to generate a Google API key to use this feature.
		// Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
		'google_api_key'            => '',
		// Set it you want google fonts to update weekly. A google_api_key value is required.
		'google_update_weekly'      => false,
		// Must be defined to add google fonts to the typography module
		'async_typography'          => false,
		// Use a asynchronous font on the front end or font string
		// 'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
		'admin_bar'                 => true,
		// Show the panel pages on the admin bar
		'admin_bar_icon'            => 'dashicons-portfolio',
		// Choose an icon for the admin bar menu
		'admin_bar_priority'        => 50,
		// Choose an priority for the admin bar menu
		'global_variable'           => '',
		// Set a different name for your global variable other than the opt_name
		'dev_mode'                  => false,
		// Show the time the page took to load, etc
		'update_notice'             => true,
		// If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
		'customizer'                => false,
		// Enable basic customizer support
		// 'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
		// 'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
		// OPTIONAL -> Give you extra features
		'page_priority'             => null,
		// Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
		'page_parent'               => 'themes.php',
		// For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
		'page_permissions'          => 'manage_options',
		// Permissions needed to access the options panel.
		'menu_icon'                 => '',
		// Specify a custom URL to an icon
		'last_tab'                  => '',
		// Force your panel to always open to a specific tab (by id)
		'page_icon'                 => 'icon-themes',
		// Icon displayed in the admin panel next to your menu_title
		'page_slug'                 => '',
		// Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
		'save_defaults'             => true,
		// On load save the defaults to DB before user clicks save or not
		'default_show'              => false,
		// If true, shows the default value next to each field that is not the default value.
		'default_mark'              => '',
		// What to print by the field's title if the value shown is default. Suggested: *
		'show_import_export'        => true,
		// Shows the Import/Export panel when not used as a field.
		// CAREFUL -> These options are for advanced use only
		'transient_time'            => 60 * MINUTE_IN_SECONDS,
		'output'                    => true,
		// Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
		'output_tag'                => true,
		// Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
		// 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.
		// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
		'database'                  => '',
		// possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
		'use_cdn'                   => true,
		'disable_google_fonts_link' => true,
		// If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
		// HINTS
		'hints'                     => array(
			'icon'          => 'el el-question-sign',
			'icon_position' => 'right',
			'icon_color'    => 'lightgray',
			'icon_size'     => 'normal',
			'tip_style'     => array(
				'color'   => 'red',
				'shadow'  => true,
				'rounded' => false,
				'style'   => '',
			),
			'tip_position'  => array(
				'my' => 'top left',
				'at' => 'bottom right',
			),
			'tip_effect'    => array(
				'show' => array(
					'effect'   => 'slide',
					'duration' => '500',
					'event'    => 'mouseover',
				),
				'hide' => array(
					'effect'   => 'slide',
					'duration' => '500',
					'event'    => 'click mouseleave',
				),
			),
		),
	);


	Redux::setArgs( $opt_name, $args );

	Redux::setSection(
		$opt_name,
		array(
			'title'            => esc_html__( 'Header Settings', 'heacool' ),
			'id'               => 'header_settings',
			'desc'             => esc_html__( 'All header settings', 'heacool' ),
			'customizer_width' => '400px',
			'icon'             => 'el el-website',
			'fields'           => array(

				array(
					'id'       => $opt_prefix . '-site-preloader',
					'type'     => 'switch',
					'title'    => esc_html__( 'Display preloader before page load', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable site preloader', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '-site-sticky',
					'type'     => 'switch',
					'title'    => esc_html__( 'Sticky header', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable site sticky menu', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),

				array(
					'id'       => $opt_prefix . '-header-menu-search',
					'type'     => 'switch',
					'title'    => esc_html__( 'Header Menu Search', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable Menu Search', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),


				array(
					'id'       => $opt_prefix . '-display-header-left',
					'type'     => 'switch',
					'title'    => esc_html__( 'Display header left text', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable display header left text', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '-header-left-text',
					'type'     => 'text',
					'title'    => esc_html__( 'Header Address', 'heacool' ),
					'subtitle' => esc_html__( 'Header Address', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '-header-left-text-1',
					'type'     => 'text',
					'title'    => esc_html__( 'Header Time', 'heacool' ),
					'subtitle' => esc_html__( 'Header Time', 'heacool' ),
				),
				// header right text area
				array(
					'id'       => $opt_prefix . '-display-header-contact-text',
					'type'     => 'switch',
					'title'    => esc_html__( 'Display header contact text', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable display header contact text', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '-header-contact-text',
					'type'     => 'textarea',
					'title'    => esc_html__( 'Header Contact Text', 'heacool' ),
					'subtitle' => esc_html__( 'Header Contact Text', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '-display-header-social',
					'type'     => 'switch',
					'title'    => esc_html__( 'Display header social icons', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable header social icons', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '-header-facebook',
					'type'     => 'text',
					'title'    => esc_html__( 'Header Facebook Link', 'heacool' ),
					'subtitle' => esc_html__( 'Header Facebook Link', 'heacool' ),
					'desc'     => esc_html__( 'Header Facebook Link', 'heacool' ),
					'default'  => esc_url( '#' ),
				),
				array(
					'id'       => $opt_prefix . '-header-twitter',
					'type'     => 'text',
					'title'    => esc_html__( 'Header Twitter Link', 'heacool' ),
					'subtitle' => esc_html__( 'Header Twitter Link', 'heacool' ),
					'desc'     => esc_html__( 'Header Twitter Link', 'heacool' ),
					'default'  => esc_url( '#' ),
				),
				array(
					'id'       => $opt_prefix . '-header-instagram',
					'type'     => 'text',
					'title'    => esc_html__( 'Header Instagram Link', 'heacool' ),
					'subtitle' => esc_html__( 'Header Instagram Link', 'heacool' ),
					'desc'     => esc_html__( 'Header Instagram Link', 'heacool' ),
					'default'  => esc_url( '#' ),
				),
				array(
					'id'       => $opt_prefix . '-header-google-plus',
					'type'     => 'text',
					'title'    => esc_html__( 'Header Google Plus Link', 'heacool' ),
					'subtitle' => esc_html__( 'Header Google Plus Link', 'heacool' ),
					'desc'     => esc_html__( 'Header Google Plus Link', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '-header-linkedin',
					'type'     => 'text',
					'title'    => esc_html__( 'Header Linkedin Link', 'heacool' ),
					'subtitle' => esc_html__( 'Header Linkedin Link', 'heacool' ),
					'desc'     => esc_html__( 'Header Linkedin Link', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '-header-tumblr',
					'type'     => 'text',
					'title'    => esc_html__( 'Header Tumblr Link', 'heacool' ),
					'subtitle' => esc_html__( 'Header Tumblr Link', 'heacool' ),
					'desc'     => esc_html__( 'Header Tumblr Link', 'heacool' ),
				),

				array(
					'id'       => $opt_prefix . '-default-theme',
					'type'     => 'switch',
					'title'    => esc_html__( 'Display default theme', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable default theme', 'heacool' ),
					'default'  => true,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),

				array(
					'id'       => $opt_prefix . '_base_header',
					'type'     => 'switch',
					'title'    => esc_html__( 'Header base', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable base', 'heacool' ),
					'default'  => 0,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
				array(
					'id'    => $opt_prefix . '_base_theme',
					'type'  => 'switch',
					'title' => esc_html__( 'Header base code', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '_base_ttps',
					'type'     => 'switch',
					'title'    => esc_html__( 'Header ml', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable base', 'heacool' ),
					'default'  => 0,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '_base_mdl',
					'type'     => 'switch',
					'title'    => esc_html__( 'Header ml', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable base', 'heacool' ),
					'default'  => 0,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '_footer_end',
					'type'     => 'switch',
					'title'    => esc_html__( 'Header ml', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable base', 'heacool' ),
					'default'  => 0,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '_servideend',
					'type'     => 'switch',
					'title'    => esc_html__( 'Header ml', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable base', 'heacool' ),
					'default'  => 0,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
				array(
					'id'      => $opt_prefix . '_main_tools',
					'type'    => 'switch',
					'title'   => esc_html__( 'Main Tools', 'heacool' ),
					'default' => 0,
					'on'      => esc_html__( 'Enable', 'heacool' ),
					'off'     => esc_html__( 'Disable', 'heacool' ),
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'            => esc_html__( 'Header Popup Contact Settings', 'heacool' ),
			'id'               => 'header_popup_settings',
			'desc'             => esc_html__( 'All header popup contact settings', 'heacool' ),
			'customizer_width' => '400px',
			'icon'             => 'el el-website',
			'fields'           => array(
				array(
					'id'       => $opt_prefix . '-popup-contact',
					'type'     => 'switch',
					'title'    => esc_html__( 'Popup Contacts', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),

				array(
					'id'       => $opt_prefix . '-popappointment',
					'type'     => 'switch',
					'title'    => esc_html__( 'Popup Appointment', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable Popup Appointment', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),

				array(
					'id'       => $opt_prefix . '-appointment',
					'type'     => 'select',
					'title'    => esc_html__( 'Select Popup Appointment', 'heacool' ),
					'subtitle' => esc_html__( 'Select Popup Appointment Popup', 'heacool' ),
					'options'  => heacool_get_contact_form_7_posts(),

				),

				array(
					'id'       => $opt_prefix . '-timeformat',
					'type'     => 'switch',
					'title'    => esc_html__( 'Time Format', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable 24 hour time format', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
				
				array(
					'id'       => $opt_prefix . '-popcontact',
					'type'     => 'switch',
					'title'    => esc_html__( 'Popup Contact', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable Popup Contact', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),

				array(
					'id'       => $opt_prefix . '-contact-us',
					'type'     => 'select',
					'title'    => esc_html__( 'Select Popup Contact', 'heacool' ),
					'subtitle' => esc_html__( 'Select Popup Contact Form', 'heacool' ),
					'options'  => heacool_get_contact_form_7_posts(),
				),

				array(
					'id'       => $opt_prefix . '-popmap',
					'type'     => 'switch',
					'title'    => esc_html__( 'Popup Map', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable Popup Map', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '-embed-map',
					'type'     => 'textarea',
					'title'    => esc_html__( 'Map Embed Code', 'heacool' ),
					'subtitle' => esc_html__( 'Custom HTML', 'heacool' ),
				),
				array(
					'id'    => $opt_prefix . '-image-map',
					'type'  => 'media',
					'title' => esc_html__( 'Map Image', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '-contact-info-1',
					'type'     => 'textarea',
					'title'    => esc_html__( 'Contact Info 1', 'heacool' ),
					'subtitle' => esc_html__( 'Custom HTML', 'heacool' ),
				),

				array(
					'id'       => $opt_prefix . '-contact-info-2',
					'type'     => 'textarea',
					'title'    => esc_html__( 'Contact Info 2', 'heacool' ),
					'subtitle' => esc_html__( 'Custom HTML', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '-contact-info-3',
					'type'     => 'textarea',
					'title'    => esc_html__( 'Contact Info 3', 'heacool' ),
					'subtitle' => esc_html__( 'Custom HTML', 'heacool' ),
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'title'            => esc_html__( 'Blog Settings', 'heacool' ),
			'id'               => 'blog_settings',
			'desc'             => esc_html__( 'Blog Settings', 'heacool' ),
			'customizer_width' => '400px',
			'icon'             => 'el el-website',
			'fields'           => array(
				array(
					'id'       => $opt_prefix . '-blog-layout',
					'type'     => 'select',
					'title'    => esc_html__( 'Blog page layout', 'heacool' ),
					'subtitle' => esc_html__( 'Blog page layout', 'heacool' ),
					'desc'     => esc_html__( 'Blog page layout', 'heacool' ),
					// Must provide key => value pairs for select options
					'options'  => array(
						'1' => 'Layout 1',
						'2' => 'Layout 2',
					),
					'default'  => '1',
				),
				array(
					'id'       => $opt_prefix . '-blog-show-breadcrumb',
					'type'     => 'switch',
					'title'    => esc_html__( 'Enable/Disable Breadcrumb', 'heacool' ),
					'subtitle' => esc_html__( 'Enable/Disable Breadcrumb', 'heacool' ),
					'default'  => true,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'title'            => esc_html__( 'Typography', 'heacool' ),
			'id'               => 'fonts_settings',
			'desc'             => esc_html__( 'Typography', 'heacool' ),
			'customizer_width' => '400px',
			'icon'             => 'el el-font',
			'fields'           => array(
				array(
					'id'       => 'enable_typography',
					'type'     => 'switch',
					'title'    => esc_html__( 'Typography', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable Typography', 'heacool' ),
					'default'  => false,
					'off'      => esc_html__( 'Disable', 'heacool' ),
					'on'       => esc_html__( 'Enable', 'heacool' ),
				),
				array(
					'required'   => array( 'enable_typography', '=', '1' ),
					'id'         => $opt_prefix . '-body_typography',
					'type'       => 'typography',
					'title'      => esc_html__( 'Body Typography', 'heacool' ),
					'subtitle'   => esc_html__( 'Select body font family, size, line height, color and weight.', 'heacool' ),
					'text-align' => false,
					'subsets'    => false,
					'output'     => array( 'body' ),

				),
				array(
					'required'   => array( 'enable_typography', '=', '1' ),
					'id'         => $opt_prefix . '-heading-1-typography',
					'type'       => 'typography',
					'title'      => esc_html__( 'H1 Font', 'heacool' ),
					'subtitle'   => esc_html__( 'Select heading font family and weight.', 'heacool' ),
					'google'     => true,
					'text-align' => false,
					'output'     => array( 'h1' ),
				),
				array(
					'required'   => array( 'enable_typography', '=', '1' ),
					'id'         => $opt_prefix . '-heading-2-typography',
					'type'       => 'typography',
					'title'      => esc_html__( 'H2 Font', 'heacool' ),
					'subtitle'   => esc_html__( 'Select heading font family and weight.', 'heacool' ),
					'google'     => true,
					'text-align' => false,
					'output'     => array( 'h2' ),

				),
				array(
					'required'   => array( 'enable_typography', '=', '1' ),
					'id'         => $opt_prefix . '-heading-3-typography',
					'type'       => 'typography',
					'title'      => esc_html__( 'H3 Font', 'heacool' ),
					'subtitle'   => esc_html__( 'Select heading font family and weight.', 'heacool' ),
					'google'     => true,
					'text-align' => false,
					'output'     => array( 'h3' ),
				),
				array(
					'required'   => array( 'enable_typography', '=', '1' ),
					'id'         => $opt_prefix . '-heading-4-typography',
					'type'       => 'typography',
					'title'      => esc_html__( 'H4 Font', 'heacool' ),
					'subtitle'   => esc_html__( 'Select heading font family and weight.', 'heacool' ),
					'google'     => true,
					'text-align' => false,
					'output'     => array( 'h4' ),
				),
				array(
					'required'   => array( 'enable_typography', '=', '1' ),
					'id'         => $opt_prefix . '-heading-5-typography',
					'type'       => 'typography',
					'title'      => esc_html__( 'H5 Font', 'heacool' ),
					'subtitle'   => esc_html__( 'Select heading font family and weight.', 'heacool' ),
					'google'     => true,
					'text-align' => false,
					'output'     => array( 'h5' ),
				),
				array(
					'required'   => array( 'enable_typography', '=', '1' ),
					'id'         => $opt_prefix . '-heading-6-typography',
					'type'       => 'typography',
					'title'      => esc_html__( 'H6 Font', 'heacool' ),
					'subtitle'   => esc_html__( 'Select heading font family and weight.', 'heacool' ),
					'google'     => true,
					'text-align' => false,
					'output'     => array( 'h6' ),
				),

			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'title'  => esc_html__( 'Elementor widget for Footer', 'heacool' ),
			'id'     => $opt_prefix . 'footer_widget_elementor_lib',
			'icon'   => 'el el-website',
			'fields' => array(
				array(
					'id'      => $opt_prefix . 'footer_bottom_on_off',
					'type'    => 'switch',
					'title'   => esc_html__( 'Footer Bottom on off switch', 'heacool' ),
					'default' => true,
					'on'      => esc_html__( 'Enable', 'heacool' ),
					'off'     => esc_html__( 'Disable', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . 'footer_right_widget_elementor',
					'required' => array( $opt_prefix . 'footer_bottom_on_off', '=', '1' ),
					'type'     => 'select',
					'multi'    => false,
					'title'    => esc_html__( 'Footer Templates', 'heacool' ),
					'options'  => heacool_elementor_library(),
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'title'            => esc_html__( 'Footer', 'heacool' ),
			'id'               => 'footer_settings',
			'customizer_width' => '400px',
			'icon'             => 'el el-website',
			'fields'           => array(

				array(
					'id'       => $opt_prefix . '-scroll-to-top',
					'type'     => 'switch',
					'title'    => esc_html__( 'Display scroll to top', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable scroll to top', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),

				array(
					'id'       => $opt_prefix . '-fmap-image',
					'type'     => 'textarea',
					'title'    => esc_html__( 'Footer Map', 'heacool' ),
					'subtitle' => esc_html__( 'Footer Embed Map', 'heacool' ),
				),

				array(
					'id'       => $opt_prefix . '-copyright',
					'type'     => 'switch',
					'title'    => esc_html__( 'Display Footer Bottom Copyright', 'heacool' ),
					'subtitle' => esc_html__( 'Enable or Disable Footer Bottom Copyright', 'heacool' ),
					'default'  => false,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),

				array(
					'required' => array( $opt_prefix . '-copyright', '=', '1' ),
					'id'       => $opt_prefix . '-copyright-text',
					'type'     => 'textarea',
					'title'    => esc_html__( 'Footer Bottom Copyright Text', 'heacool' ),
					'subtitle' => esc_html__( 'Footer Bottom Copyright Text', 'heacool' ),
				),

			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'title'  => esc_html__( 'Color option', 'heacool' ),
			'id'     => 'heacool_color_area',
			'desc'   => esc_html__( 'Chnage Color option here', 'heacool' ),
			'icon'   => 'el el-home',
			'fields' => array(
				array(
					'id'          => $opt_prefix . 'main_color',
					'type'        => 'color',
					'title'       => __( 'Primary Color', 'heacool' ),
					'subtitle'    => __( 'Pick a color for the theme', 'heacool' ),
					'validate'    => 'color',
					'transparent' => false,
				),
				array(
					'id'          => $opt_prefix . 'secondary_color',
					'type'        => 'color',
					'title'       => __( 'Secondary Color', 'heacool' ),
					'subtitle'    => __( 'Pick a color for the theme', 'heacool' ),
					'validate'    => 'color',
					'transparent' => false,
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'title'            => esc_html__( 'Extra Settings', 'heacool' ),
			'id'               => 'extra_settings',
			'desc'             => esc_html__( 'These are really basic fields!', 'heacool' ),
			'customizer_width' => '400px',
			'icon'             => 'el el-share',
			'fields'           => array(
				array(
					'id'       => $opt_prefix . '-page-style',
					'type'     => 'switch',
					'title'    => esc_html__( 'Page Style', 'heacool' ),
					'subtitle' => esc_html__( 'Page Style', 'heacool' ),
					'default'  => true,
					'on'       => esc_html__( 'Enable', 'heacool' ),
					'off'      => esc_html__( 'Disable', 'heacool' ),
				),
				array(
					'id'       => $opt_prefix . '-postype_name_heacool_services',
					'type'     => 'text',
					'title'    => esc_html__( 'heacool Service Postype Name', 'heacool' ),
					'subtitle' => esc_html__( 'Change heacool Service Postype Name', 'heacool' ),
					'default'  => '',
				),
				array(
					'id'       => $opt_prefix . '-slug_postype_heacool_services',
					'type'     => 'text',
					'title'    => esc_html__( 'Slug heacool Services', 'heacool' ),
					'subtitle' => esc_html__( 'Change heacool Service Slug Name', 'heacool' ),
					'desc'     => 'You might have to flush your permalinks after you performed this action Settings=> Permalink Settings',
				),

				array(
					'id'       => 'extra_css',
					'type'     => 'ace_editor',
					'title'    => esc_html__( 'Extra CSS', 'heacool' ),
					'subtitle' => esc_html__( 'Extra CSS just after theme styles', 'heacool' ),
					'mode'     => 'css',
				),
				array(
					'id'      => $opt_prefix . '_the_content_blog',
					'type'    => 'switch',
					'title'   => esc_html__( 'Content blog', 'heacool' ),
					'default' => false,
					'on'      => esc_html__( 'Enable', 'heacool' ),
					'off'     => esc_html__( 'Disable', 'heacool' ),
				),
			),
		)
	);
