<?php

add_filter('rwmb_meta_boxes', 'heacool_register_post_meta_box');

/**
 * Register meta boxes
 *
 * Remember to change "your_prefix" to actual prefix in your project
 *
 * @return void
 */
function heacool_register_post_meta_box($meta_boxes) {
    global $wp_registered_sidebars;
    //$heacool_option = heacool_get_options();
    /**
     * prefix of meta keys (optional)
     * Use underscore (_) at the beginning to make keys hidden
     * Alt.: You also can make prefix empty to disable it
     */
    // Better has an underscore as last sign
    $prefix = 'heacool';
    $sidebars = array();
    foreach ($wp_registered_sidebars as $key => $value) {
        $sidebars[$key] = $value['name'];
    }

    $opacities = array();
    for ($o = 0.0, $n = 0; $o <= 1.0; $o += 0.1, $n++) {
        $opacities[$n] = $o;
    }

    $meta_boxes[] = array(
        'id' => 'framework-meta-box-post-format-quote',
        'title' => esc_html__('Post Format Data', 'heacool'),
        'pages' => array(
            'post',
        ),
        'context' => 'normal',
        'priority' => 'high',
        'tab_style' => 'left',
        'fields' => array(
            array(
                'name' => esc_html__('Quote Text', 'heacool'),
                'desc' => esc_html__('Insert Quote Text.', 'heacool'),
                'id' => "{$prefix}-quote",
                'type' => 'textarea',
            ),
    ));


    $meta_boxes[] = array(
        'id' => 'framework-meta-box-post-format-video',
        'title' => esc_html__('Post Format Data', 'heacool'),
        'pages' => array(
            'post',
        ),
        'context' => 'normal',
        'priority' => 'high',
        'tab_style' => 'left',
        'fields' => array(
            array(
                'name' => esc_html__('Video Markup', 'heacool'),
                'desc' => esc_html__('Put embed src of video. i.e. youtube, vimeo', 'heacool'),
                'id' => "{$prefix}-video-markup",
                'type' => 'textarea',
                'cols' => 20,
                'rows' => 3,                  
            ),
    ));

    $meta_boxes[] = array(
        'id' => 'framework-meta-box-post-format-audio',
        'title' => esc_html__('Post Format Data', 'heacool'),
        'pages' => array(
            'post',
        ),
        'context' => 'normal',
        'priority' => 'high',
        'tab_style' => 'left',
        'fields' => array(
            array(
                'name' => esc_html__('Audio Markup', 'heacool'),
                'desc' => esc_html__('Put embed src of video. i.e. youtube, vimeo', 'heacool'),
                'id' => "{$prefix}-audio-markup",
                'type' => 'textarea',
                'cols' => 20,
                'rows' => 3,                     
            ),
    ));

    $meta_boxes[] = array(
        'id' => 'framework-meta-box-post-format-link',
        'title' => esc_html__('Post Format Data', 'heacool'),
        'pages' => array(
            'post',
        ),
        'context' => 'normal',
        'priority' => 'high',
        'tab_style' => 'left',
        'fields' => array(
            array(
                'name' => esc_html__('Link', 'heacool'),
                'desc' => esc_html__('Works with link post format.', 'heacool'),
                'id' => "{$prefix}-link",
                'type' => 'text',
            ),
            array(
                'name' => esc_html__('Link title', 'heacool'),
                'desc' => esc_html__('Works with link post format.', 'heacool'),
                'id' => "{$prefix}-link-title",
                'type' => 'text',
            ),
    ));

    $meta_boxes[] = array(
        'id' => 'framework-meta-box-post-format-image',
        'title' => esc_html__('Post Format Data', 'heacool'),
        'pages' => array(
            'post',
        ),
        'context' => 'normal',
        'priority' => 'high',
        'tab_style' => 'left',
        'fields' => array(
            array(
                'name' => esc_html__('Upload Gallery Images', 'heacool'),
                'id' => "{$prefix}-image",
                'desc' => '',
                'type' => 'image_advanced',
                'max_file_uploads' => 24,
            ),
    ));

    $posts_page = get_option('page_for_posts');

    if (!isset($_GET['post']) || intval($_GET['post']) != $posts_page) {
        $meta_boxes[] = array(
            'id' => 'framework_page_meta_box',
            'title' => esc_html__('Page Design Settings', 'heacool'),
            'pages' => array(
                'page',
            ),
            'context' => 'normal',
            'priority' => 'core',
            'fields' => array(
                array(
                    'id' => "framework_show_page_title",
                    'name' => esc_html__('Show page titlebar', 'heacool'),
                    'desc' => '',
                    'type' => 'radio',
                    'std' => "on",
                    'options' => array('on' => 'Yes', 'off' => 'No'),
                ),
                array(
                    'id' => "framework_show_breadcrumb",
                    'name' => esc_html__('Show Breadcrumb', 'heacool'),
                    'desc' => '',
                    'type' => 'radio',
                    'std' => "on",
                    'options' => array('on' => 'Yes', 'off' => 'No'),
                )
            )
        );
    }
    return $meta_boxes;
}
