<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package heacool
 */
/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if (post_password_required()) {
	return;
}
// You can start editing here -- including this comment!
?>
<div class="comments-section">
    <?php
    if (have_comments()) :
       ?>
   <h3>
      <?php
      $heacool_comment_count = get_comments_number();
      if ('1' === $heacool_comment_count) {
         printf(
            /* translators: 1: title. */
            esc_html__('One Comment', 'heacool')
            );
     } else {
                    printf(// WPCS: XSS OK.
                    	/* translators: 1: comment count number, 2: title. */
                    	esc_html(_nx('Comment (%1$s)', 'Comments (%1$s)', $heacool_comment_count, 'comments title', 'heacool'), 'heacool'), number_format_i18n($heacool_comment_count)
                    	);
                }
                ?>
            </h3>
            <ul class="comments-list">
            	<?php
            	wp_list_comments(array(
            		'style' => 'ul',
            		'callback' => 'heacool_comments',
            		'avatar_size' => 80,
            		'short_ping' => true,
            		));
            		?>
            	</ul><!--comments-list end-->
            	<?php the_comments_navigation();
                endif;
                ?>
            </div><!--comments-section end-->
<?php
//You can start editing here -- including this comment!
echo '<div class="comment_form">';
$user = wp_get_current_user();
$heacool_user_identity = $user->display_name;
$req = get_option('require_name_email');
$aria_req = $req ? " aria-required='true'" : '';
$formargs = array(
    'id_form' => 'contactform',
    'id_submit' => 'submit',
    'class_form' => 'form-default',
    'title_reply' => esc_html__('Add Your Comment', 'heacool'),
    'title_reply_to' => esc_html__('Leave a Reply to %s', 'heacool'),
    'cancel_reply_link' => esc_html__('Cancel Reply', 'heacool'),
    'label_submit' => esc_html__('ADD COMMENT', 'heacool'),
    'submit_button' => '<div class="row"><div class="col-lg-12">
										<div class="submit_btn"><button type="submit" name="%1$s" id="%2$s" class="%3$s button read-more mt-10">%4$s </button></div></div></div>',
    'comment_field' => '<div class="row"><div class="col-lg-12">
										<div class="input_field"><textarea placeholder="' . esc_attr__('Your comment', 'heacool') . '" id="comment" name="comment" aria-required="true">' .
    '</textarea></div></div></div>',
    'must_log_in' => '<div>' .
    sprintf(
            wp_kses(__('You must be <a href="%s">logged in</a> to post a comment.', 'heacool'), array('a' => array('href' => array()))), wp_login_url(apply_filters('the_permalink', get_permalink()))
    ) . '</div>',
    'logged_in_as' => '<div class="logged-in-as">' .
    sprintf(
            wp_kses(__('Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="%4$s">Log out?</a>', 'heacool'), array('a' => array('href' => array()))), esc_url(admin_url('profile.php')), $heacool_user_identity, wp_logout_url(apply_filters('the_permalink', get_permalink())), esc_attr__('Log out of this account', 'heacool')
    ) . '</div>',
    'comment_notes_before' => '<p>' .
    esc_html__('Your email address will not be published.', 'heacool') . ( $req ? '<span class="required">*</span>' : '' ) .
    '</p>',
    'comment_notes_after' => '',
    'fields' => apply_filters('comment_form_default_fields', array(
        'author' =>
        '<div class="row"><div class="col-lg-12"><div class="input_field">'
        . '<input id="author" name="author" placeholder="' . esc_attr__('Your name', 'heacool') . '" type="text" value="' . esc_attr($commenter['comment_author']) .
        '" size="30"' . $aria_req . ' /></div></div>',
        'email' =>
        '<div class="col-lg-6 col-md-6 col-sm-6">
										<div class="input_field">'
        . '<input id="email" name="email" type="text"  placeholder="' . esc_attr__('Your Email', 'heacool') . '" value="' . esc_attr($commenter['comment_author_email']) .
        '"' . $aria_req . ' /></div></div>',
        'phone' =>
        '<div class="col-lg-6 col-md-6 col-sm-6">
										<div class="input_field">'
        . '<input id="phone" name="phone" type="text"  placeholder="' . esc_attr__('Your phone', 'heacool') . '" value=""' . $aria_req . ' /></div></div></div>',
        
            )
    ),
);
comment_form($formargs);
echo '</div>';