<?php
add_action('widgets_init', 'heacool_sidebar_recent_post');

function heacool_sidebar_recent_post() {
    register_widget('HeacoolRecentPost');
}

class HeacoolRecentPost extends WP_Widget {

    private $defaults = array();

    function __construct() {
        $this->defaults = array(
            'title' => esc_html__('Recent Post', 'Heacool-core'),
            'number' => 3,
        );
        parent::__construct('posts-widget', esc_html__('Heacool Sidebar Recent Posts', 'Heacool-core'));
    }

    function update($new_instance, $old_instance) {
        $defaults = $this->defaults;
        $instance = $old_instance;
        $instance['title'] = esc_attr($new_instance['title']);
        $instance['number'] = intval($new_instance['number']);
        return $instance;
    }

    function form($instance) {
        $instance = wp_parse_args((array) $instance, $this->defaults);
        $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'Heacool-core'); ?></label>
            <input type="text" name="<?php echo esc_attr($this->get_field_name('title')); ?>"  value="<?php echo esc_attr($title); ?>" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" />
        </p>
        <p>
            <label for="<?php print esc_attr($this->get_field_id('number')); ?>"><?php esc_html_e('Number of posts:', 'Heacool-core'); ?>
                <input class="widefat" id="<?php print esc_attr($this->get_field_id('number')); ?>" name="<?php echo esc_attr($this->get_field_name('number')); ?>" type="text" value="<?php echo isset($instance['number']) ? esc_attr($instance['number']) : ''; ?>" />
            </label>
        </p>
        <?php
    }

    function widget($args, $instance) {
        $instance = wp_parse_args((array) $instance, $this->defaults);
        extract($args);
        $number = isset($instance['number']) ? $instance['number'] : 3;
        echo $args['before_widget'];
        ?>
        <?php
        $query_args = array(
            'posts_per_page' => $number,
            'no_found_rows' => true,
            'post_status' => 'publish',
            'ignore_sticky_posts' => true
        );
        $query = new WP_Query($query_args);
        if ($query->have_posts()) {
            echo '<div class="widget widget-recent-posts">
                                    <h3 class="widget-title">'. $instance['title'] .'</h3>
                                    <ul class="widget-posts">';
            while ($query->have_posts()) :
                $query->the_post();
                $heacool_featured_image_url = get_the_post_thumbnail_url(get_the_ID());
                ?>
                    <li>
                        <div class="recent-post">
                            <div class="recent-post-img">
                                <?php the_post_thumbnail(array(70, 70));?>
                            </div>
                            <div class="recent-post-info">
                                <span><?php echo get_the_date('d F'); ?></span>
                                <h3 class="post_title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                            </div>
                        </div><!--recent-post end-->
                    </li>
                <?php
            endwhile;
            echo '</ul></div>';
            wp_reset_query();
            echo $args['after_widget'];
        }
    }
}