<?php

class SmartContactBox extends WP_Widget {

    public $defaults;

    public function __construct() {
        $this->defaults = array(
            'title' => esc_html__('Our Contacts', 'heacool-core'),
            'address' => '1531 Moonlight Drive, Maple Shade, NJ',
            'hours' => 'Monday-Friday <br> 8:00 am - 8:00 pm',
            'phone' => __('24/7 Emergency Service: 609-123-4567', 'heacool-core'),
            );

        parent::__construct(
                'smart_contact_box', // Base ID  
                esc_html__('Service Contact Box', 'heacool-core'), // Name  
                array(
                    'description' => esc_html__('Side Bar Contact Box.', 'heacool-core')
                    )
                );
    }

    function form($instance) {
        $instance = wp_parse_args((array) $instance, $this->defaults);
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                <strong><?php esc_html_e('Title', 'heacool-core') ?>:</strong><br /><input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" value="<?php echo esc_attr($instance['title']); ?>" />
            </label>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('address')); ?>"><?php esc_html_e('Address', 'heacool-core') ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('address')); ?>" name="<?php echo esc_attr($this->get_field_name('address')); ?>"><?php echo wp_kses_post($instance['address']); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('hours')); ?>"><?php esc_html_e('Work Time', 'heacool-core') ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('hours')); ?>" name="<?php echo esc_attr($this->get_field_name('hours')); ?>"><?php echo wp_kses_post($instance['hours']); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('phone')); ?>"><?php esc_html_e('Phone', 'heacool-core') ?></label>
            <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('phone')); ?>" name="<?php echo esc_attr($this->get_field_name('phone')); ?>"><?php echo wp_kses_post($instance['phone']); ?></textarea>
        </p>
        <?php
    }

    function widget($args, $instance) {
        extract($args);
        echo wp_kses_post($before_widget);
        ?>
        <div class="contact_wd">
            <h3><?php echo wp_kses_post($instance['title']); ?></h3>
            <ul>
                <li>
                    <span><i class="fa fa-map-marker"></i></span>
                    <h4><?php echo wp_kses_post($instance['address']); ?></h4>
                </li>
                <li>
                    <span><i class="fa fa-clock-o"></i></span>
                    <h4><?php echo wp_kses_post($instance['hours']); ?></h4>
                </li>
                <li>
                    <span><i class="fa fa-phone"></i></span>
                    <h4><?php echo wp_kses_post($instance['phone']); ?></h4> 
                </li>
            </ul>
        </div>
        <?php
        echo wp_kses_post($after_widget);
    }
    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['phone'] = $new_instance['phone'];
        $instance['address'] = $new_instance['address'];
        $instance['hours'] = $new_instance['hours'];
        return $instance;
    }
}
function electrician_contact_address_widget() {
    register_widget( 'SmartContactBox' );
}
add_action( 'widgets_init', 'electrician_contact_address_widget' );