<?php

class FooterGoogleMap extends WP_Widget {

    public $defaults;

    public function __construct() {
        $this->defaults = array(
            'title' => '',
            'google_map_image '=>'off',
            'map_url' => '',
        );
        parent::__construct(
                'footer_map', // Base ID  
                esc_html__('Heacool Footer Map', 'heacool-core'), // Name  
                array(
            'description' => esc_html__('Footer Google Map.', 'heacool-core')
                )
        );
    }

    function form($instance) {
        $instance = wp_parse_args((array) $instance, $this->defaults);
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                <strong><?php esc_html_e('Title', 'heacool-core') ?>:</strong><br /><input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" value="<?php echo esc_attr($instance['title']); ?>" />
            </label>
        </p> 
        <p>
    <input class="checkbox" type="checkbox" <?php checked( $instance[ 'google_map_image' ], 'on' ); ?> id="<?php echo $this->get_field_id( 'google_map_image' ); ?>" name="<?php echo $this->get_field_name( 'google_map_image' ); ?>" /> 
        <label for="<?php echo $this->get_field_id( 'google_map_image' ); ?>"><?php esc_html_e( 'Show Google map as image', 'car-repair-services-core' );?></label>
    </p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('map_url')); ?>">
            <label for="<?php echo esc_attr($this->get_field_id('map_url')); ?>">
                <strong><?php esc_html_e('Map Image Url', 'heacool-core') ?>:</strong><br /><input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('map_url')); ?>" name="<?php echo esc_attr($this->get_field_name('map_url')); ?>" value="<?php echo esc_attr($instance['map_url']); ?>" />
            </label>
        </p> 

        <?php
    }

    function widget($args, $instance) {

        extract($args);
        echo wp_kses_post($before_widget);
        $google_map_image = isset($instance[ 'google_map_image' ]) ? 'true' : 'false';

        if (!empty($instance['title'])) {
            $title = empty($instance['title']) ? ' ' : apply_filters('widget_title', $instance['title']);
            echo wp_kses_post($before_title . $title . $after_title);
        };

        if(isset($google_map_image)&&($google_map_image=='true')){
            echo '<img class="footer_map_img" src="'.$instance['map_url'].'" alt="img">';
        }
    
        echo wp_kses_post($after_widget);
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance[ 'google_map_image' ] = $new_instance[ 'google_map_image' ];
        $instance[ 'map_url' ] = $new_instance[ 'map_url' ];

        // ...
        return $instance;
    }

}

function heacool_FooterGoogleMap() {
    register_widget('FooterGoogleMap');
}

add_action('widgets_init', 'heacool_FooterGoogleMap');
