<?php

// Register Custom Post Type
function heacool_services_post_type() {

    $postype_name_heacool_services = 'Services';

    if (function_exists('heacool_options')) {
        $heacool_options = heacool_options();
        if (isset($heacool_options['heacool-postype_name_heacool_services']) && !empty($heacool_options['heacool-postype_name_heacool_services'])) {
            $postype_name_heacool_services = $heacool_options['heacool-postype_name_heacool_services'];
        }
    }

    $labels = array(
        'name' => _x($postype_name_heacool_services, 'Post Type General Name', 'heacool-core'),
        'singular_name' => _x('Service', 'Post Type Singular Name', 'heacool-core'),
        'menu_name' => __('Services', 'heacool-core'),
        'name_admin_bar' => __('Service', 'heacool-core'),
        'archives' => __('Item Archives', 'heacool-core'),
        'parent_item_colon' => __('Parent Item:', 'heacool-core'),
        'all_items' => __('All Services', 'heacool-core'),
        'add_new_item' => __('Add New Service', 'heacool-core'),
        'add_new' => __('Add New Service', 'heacool-core'),
        'new_item' => __('New Service Item', 'heacool-core'),
        'edit_item' => __('Edit Service Item', 'heacool-core'),
        'update_item' => __('Update Service Item', 'heacool-core'),
        'view_item' => __('View Service Item', 'heacool-core'),
        'search_items' => __('Search Item', 'heacool-core'),
        'not_found' => __('Not found', 'heacool-core'),
        'not_found_in_trash' => __('Not found in Trash', 'heacool-core'),
        'featured_image' => __('Featured Image', 'heacool-core'),
        'set_featured_image' => __('Set featured image', 'heacool-core'),
        'remove_featured_image' => __('Remove featured image', 'heacool-core'),
        'use_featured_image' => __('Use as featured image', 'heacool-core'),
        'insert_into_item' => __('Insert into item', 'heacool-core'),
        'uploaded_to_this_item' => __('Uploaded to this item', 'heacool-core'),
        'items_list' => __('Items list', 'heacool-core'),
        'items_list_navigation' => __('Items list navigation', 'heacool-core'),
        'filter_items_list' => __('Filter items list', 'heacool-core'),
    );

    $slug_postype_heacool_services = 'heacool-services';

    $args = array(
        'labels' => $labels,
        'description' => __('Description.', 'heacool-core'),
        'public' => true,
        'publicly_queryable' => true,
        'taxonomies' => array('taxonomy_service'),
        'show_ui' => true,
        'show_in_menu' => true,
        'query_var' => true,
        'rewrite' => array('slug' => apply_filters('heacool_services_postype_heacool_services_slug', $slug_postype_heacool_services)),
        'capability_type' => 'post',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'supports' => array('title', 'editor', 'excerpt', 'thumbnail'),
    );

    register_post_type('heacool_services', $args);
    
    
$labels = array(
    'name' => _x('Service Type', 'taxonomy general name', 'heacool-core'),
    'singular_name' => _x('Service Type', 'taxonomy singular name', 'heacool-core'),
    'search_items' => __('Search Service', 'heacool-core'),
    'all_items' => __('All Type', 'heacool-core'),
    'parent_item' => __('Parent Type', 'heacool-core'),
    'parent_item_colon' => __('Parent Type:', 'heacool-core'),
    'edit_item' => __('Edit Type', 'heacool-core'),
    'update_item' => __('Update Type', 'heacool-core'),
    'add_new_item' => __('Add New Service Type', 'heacool-core'),
    'new_item_name' => __('New Service Type Name', 'heacool-core'),
    'menu_name' => __('Service Type', 'heacool-core'),
);

$args = array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'rewrite' => array('slug' => 'service_type'),
);

register_taxonomy('service_type', array('heacool_services'), $args);

}

add_action('init', 'heacool_services_post_type', 0);
