<?php
add_action('init', 'register_heacool_gallery_postype');

function register_heacool_gallery_postype()
{

    $labels = array(
        'name' => __('Gallery', 'heacool-core'),
        'singular_name' => __('Gallery', 'heacool-core'),
        'add_new' => __('Add New', 'heacool-core'),
        'add_new_item' => __('Add New Gallery', 'heacool-core'),
        'edit_item' => __('Edit Gallery', 'heacool-core'),
        'new_item' => __('New Gallery', 'heacool-core'),
        'view_item' => __('View Gallery', 'heacool-core'),
        'search_items' => __('Search Gallery', 'heacool-core'),
        'not_found' => __('No Gallery found', 'heacool-core'),
        'not_found_in_trash' => __('No Gallery found in Trash', 'heacool-core'),
        'parent_item_colon' => ''
    );

    register_post_type('gallery', array(
        'labels' => $labels,
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'query_var' => true,
        'rewrite' => true,
        'capability_type' => 'post',
        'hierarchical' => false,
        'menu_position' => 10,
        'supports' => array('title', 'editor', 'thumbnail'),
        'rewrite' => array('slug' => 'gallery')
    ));

    $labels = array(
        'name'              => _x( 'Gallery Categories', 'portfolio categories','heacool-core' ),
        'singular_name'     => _x( 'Gallery Category', 'portfolio category','heacool-core' ),
        'search_items'      => __('Search Gallery Categories' ,'heacool-core'),
        'all_items'         => __('All Gallery Categories' ,'heacool-core'),
        'parent_item'       => __('Parent Gallery Category' ,'heacool-core'),
        'parent_item_colon' => __('Parent Gallery Category:' ,'heacool-core'),
        'edit_item'         => __('Edit Gallery Category' ,'heacool-core'),
        'update_item'       => __('Update Gallery Category' ,'heacool-core'),
        'add_new_item'      => __('Add New Gallery Category' ,'heacool-core'),
        'new_item_name'     => __('New Gallery Category Name' ,'heacool-core'),
        'menu_name'         => __('Gallery Category' ,'heacool-core'),
    );

    $args = array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'rewrite'           => array( 'slug' => 'gallery-cat' ),
    );
    register_taxonomy( 'gallery-cat', array( 'gallery' ), $args );  
}