<?php

add_filter('rwmb_meta_boxes', 'heacool_register_framework_post_meta_box');

/**
 * Register meta boxes
 *
 * Remember to change "your_prefix" to actual prefix in your project
 *
 * @return void
 */
function heacool_register_framework_post_meta_box($meta_boxes) {
    global $wp_registered_sidebars;
    /**
     * prefix of meta keys (optional)
     * Use underscore (_) at the beginning to make keys hidden
     * Alt.: You also can make prefix empty to disable it
     */
    // Better has an underscore as last sign

    $sidebars = array();
    foreach ($wp_registered_sidebars as $key => $value) {
        $sidebars[$key] = $value['name'];
    }

  $meta_boxes[] = array(
        'id' => 'framework-heacool_services',
        'title' => esc_html__('Custom Post Data', 'heacool-core'),
        'pages' => array(
            'heacool_services',
        ),
        'context' => 'normal',
        'priority' => 'high',
        'tab_style' => 'left',
        'fields' => array(
            array(
                'name' => esc_html__('Image', 'heacool-core'),
                'id' => "section_page_image",
                'desc' => '',
                'type' => 'image_advanced',
                'max_file_uploads' => 1,
            ),
          
    ));

    return $meta_boxes;
}
