<?php
/*
Plugin Name: Heacool Core
Plugin URI: https://smartdata.tonytemplates.com/heacool/
Description: heacool Core theme functions and library files.
Version: 1.4
Author: smartdatasoft
Author URI: http://smartdatasoft.com/
License: GPLv2 or later
Text Domain: heacool-core
Domain Path: /languages/
 */

/**
 * Load plugin textdomain.
 *
 * @since 1.0.0
 */
function heacool_core_load_textdomain() {
	load_plugin_textdomain( 'heacool-core', false, dirname( __FILE__ ) . '/languages' );
}

add_action( 'plugins_loaded', 'heacool_core_load_textdomain' );

function heacool_core_admin_enqueue( $hook ) {
	if ( $hook != 'edit.php' && $hook != 'post.php' && $hook != 'post-new.php' && $hook != 'widgets.php' ) {
		return;
	}
	wp_enqueue_script( 'custom-js', plugin_dir_url( __FILE__ ) . '/js/admin.js' );
	if ( $hook == 'widgets.php' ) {
		wp_enqueue_media();
		wp_enqueue_script( 'heacool-media-widget-js', plugin_dir_url( __FILE__ ) . '/widgets/js/media-gallery.js', array( 'jquery' ), '1.0', 1 );
	}
}

add_action( 'admin_enqueue_scripts', 'heacool_core_admin_enqueue' );

define( 'PLUGIN_DIR', dirname( __FILE__ ) . '/' );

require_once PLUGIN_DIR . 'heacool-addons/heacool-addons.php';

$classesDir = array(
	PLUGIN_DIR . 'widget/',
	PLUGIN_DIR . 'widgets/',
	PLUGIN_DIR . 'post_type/',
	PLUGIN_DIR . 'lib/',
);

function __autoloadCustomFolder() {
	global $classesDir;
	if ( is_array( $classesDir ) || is_object( $classesDir ) ) {
		foreach ( $classesDir as $directory ) {
			foreach ( glob( $directory . '*.php' ) as $filename ) {
				if ( file_exists( $filename ) ) {
					include_once $filename;
				}
			}
		}
	}
}

__autoloadCustomFolder();

if ( ! function_exists( 'get_contact_form_7_posts' ) ) :

	function get_contact_form_7_posts() {

		$args = array(
			'post_type'      => 'wpcf7_contact_form',
			'posts_per_page' => -1,
		);

		$catlist = array();

		if ( $categories = get_posts( $args ) ) {
			foreach ( $categories as $category ) {
				(int) $catlist[ $category->ID ] = $category->post_title;
			}
		} else {
			(int) $catlist['0'] = esc_html__( 'No contect From 7 form found', 'void' );
		}
		return $catlist;
	}

endif;

add_action(
	'elementor/frontend/after_enqueue_scripts',
	function () {
		wp_dequeue_script( 'lightbox' );
	}
);

register_activation_hook( __FILE__, 'heacool_activation_func' );
function heacool_activation_func() {
	file_put_contents( __DIR__ . '/my-loggg.txt', ob_get_contents() );
}

remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );
add_action(
	'shutdown',
	function () {
		while ( @ob_end_flush() );
	}
);
