<?php

namespace HeacoolAddons\Widgets;

if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;

class Elec_Why_Choose_Us extends Widget_Base {

    public function get_name() {
        return 'elec-why-choose-us.php';
    }

    public function get_title() {
        return __('Why Choose Us', 'heacool-core');
    }

    public function get_icon() {
        return 'eicon-banner';
    }

    public function get_categories() {
        return ['heacool'];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'image_section', [
                'label' => __('Image', 'heacool-core'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => __('Background Image', 'heacool-core'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .fixed-bg.bg3',
            ]
        );

        $this->add_control(
            'image', [
                'label' => __('Mobile Footer', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section', [
                'label' => __('Content', 'heacool-core'),
            ]
        );

        $this->add_control(
            'title_1', [
                'label' => __('Title 1 and 2', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('We are the best in our specialty', 'heacool-core'),
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );
        $this->add_control(
            'title_2', [
                'label' => __('Title 2', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Why <span>Choose Us</span>', 'heacool-core'),
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();
        /*$repeater->add_control(
        'image', [
        'label' => __('Image', 'heacool-core'),
        'type' => \Elementor\Controls_Manager::MEDIA,
        'default' => [
        'url' => \Elementor\Utils::get_placeholder_image_src(),
        ],
        ]
        );*/

        $repeater->add_control(
            'svg_text', [
                'label' => __('SVG Text', 'heacool-core'),
                'label_block' => true,
                'description' => __('If Not Use SVG Icons', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $repeater->add_control(
            'svg_icons',
            [
                'label' => __('SVG Icons', 'text-domain'),
                'description' => __('If Not Use SVG Text', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::ICONS,

            ]
        );

        $repeater->add_control(
            'title_1', [
                'label' => __('Title', 'heacool-core'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );
        $repeater->add_control(
            'title_2', [
                'label' => __('Content', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Type your title here', 'heacool-core'),
            ]
        );

        $this->add_control(
            'item_list', [
                'label' => __('Item List', 'heacool-core'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title_1' => __('We Believe in Maintaining Solid Core Values', 'heacool-core'),
                        'title_2' => __('We base our business on honesty, integrity, teamwork, and accountability, and that’s what our customers expect from us.', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('We Treat Every Customer Like Family', 'heacool-core'),
                        'title_2' => __('We base our business on honesty, integrity, teamwork, and accountability, and that’s what our customers expect from us.', 'heacool-core'),
                    ],
                    [
                        'title_1' => __('We Believe in Setting the Standard Higher', 'heacool-core'),
                        'title_2' => __('We base our business on honesty, integrity, teamwork, and accountability, and that’s what our customers expect from us.', 'heacool-core'),
                    ],
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $image_alt = get_post_meta($settings['image']['id'], '_wp_attachment_image_alt', true);
        $image_url = ($settings['image']['id'] != '') ? wp_get_attachment_url($settings['image']['id']) : $settings['image']['url'];
        ?>
<section class="block block less-gap rem_pb_0 why-chose-nes">
  <div class="fixed-bg bg3"></div>
  <div class="container">
    <div class="why_us_sec">
      <div class="row">
        <div class="col-lg-6 col-md-4 col-sm-4"></div>
        <div class="col-lg-6 col-md-8 col-sm-8">
          <div class="why_us">
            <h4><?php
echo wp_kses_post($settings['title_1']);
        ?></h4>
            <h3 class="sc-title"><?php
echo wp_kses_post($settings['title_2']);
        ?>
            </h3>
            <ul class="proptz_list">
              <?php
if (!empty($settings['item_list'])) {
            foreach ($settings['item_list'] as $item) {
                ?>
              <li>
                <div class="proptz_feature">
                  <div class="ppt">
                    <span class="ppt_icon">
                      <?php
if (!empty($item['svg_text'])) {
                    echo $item['svg_text'];
                } else {
                    if (!empty($item['svg_icons']['value']['url'])) {
                        $image_url = $item['svg_icons']['value']['url'];
                        echo '<img class="why_chose_us" width="40px" height="30px" style="margin-bottom: 16px;" src="' . $image_url . '">';
                    }
                }
                ?>
                    </span>
                  </div>
                  <!--ppt_icon end-->
                  <div class="ptz_info">
                    <h3><?php echo esc_html($item['title_1']); ?></h3>
                    <p><?php echo esc_html($item['title_2']); ?></p>
                  </div>
                  <!--ptz_info end-->
                </div>
                <!--proptz_feature end-->
              </li>
              <?php
}
        }
        ?>
            </ul>
          </div>
          <!--why_us end-->
        </div>
      </div>
    </div>
    <!--why_us_sec end-->
  </div>

  <img src="<?php echo esc_url($image_url); ?>" class="btm_bg" alt="<?php echo esc_url($image_alt); ?>">

</section>
<!-- Begin statements -->
<!-- End statements -->
<?php
}

}